import * as ts from "typescript/lib/tsserverlibrary"

import type {AreTypesMutuallyAssignableResponse, GetElementTypeResponse, GetSymbolTypeResponse, Range} from "./protocol"
import {ReverseMapper} from "./ide-get-element-type"
import {IdeProjectService} from "./ide-project-service"

declare global {
  type RegularMap<K, V> = Map<K, V>

  interface Error {
    isOperationCancelledError?: boolean
    isFileOutsideOfImportGraphError?: boolean
  }
}

declare module "typescript/lib/tsserverlibrary" {

  interface TypeChecker {
    webStormCacheInfo?: {
      ideTypeCheckerId: number,
      ideProjectId: number,
      requestedTypeIds: Set<number>,
      seenTypeIds: RegularMap<number, Type>,
      seenSymbolIds: RegularMap<number, Symbol>,
    }
  }

  interface Type {
    id: number | undefined // internal
  }

  interface LanguageService {

    ideProjectId: number

    webStormGetElementType(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      fileName: string,
      startOffset: number,
      endOffset: number,
      forceReturnType: boolean,
      cancellationToken: ts.HostCancellationToken,
      reverseMapper?: ReverseMapper,
    ): GetElementTypeResponse

    webStormGetSymbolType(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      symbolId: number,
      cancellationToken: ts.HostCancellationToken,
      reverseMapper?: ReverseMapper,
    ): GetSymbolTypeResponse

    webStormGetTypeProperties(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      typeId: number,
      cancellationToken: ts.HostCancellationToken,
      reverseMapper?: ReverseMapper,
    ): GetElementTypeResponse

    webStormAreTypesMutuallyAssignable(
      ts: typeof import("typescript/lib/tsserverlibrary"),
      type1Id: number,
      type2Id: number,
      cancellationToken: ts.HostCancellationToken,
    ): AreTypesMutuallyAssignableResponse
  }

  namespace server {
    interface ProjectService {
      ideProjectService: IdeProjectService
    }
    interface Project {
      ideProjectId: number
    }
  }
}

export = ts;