/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.repel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.SystemTime;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.DoubleCircle;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.DoubleVectorExtensions;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.TransformedRectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0004GHIJB\u009b\u0001\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0004\u0012\u0006\u0010\u0012\u001a\u00020\t\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020-H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0016\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u001eJ\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001c07J\u0010\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tH\u0002J\u0018\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-H\u0002J\u0016\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020-H\u0002J\u0018\u0010B\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010C\u001a\u00020\u001eH\u0002J\u0010\u0010D\u001a\u0002022\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0010\u0010E\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001cH\u0002J\u0010\u0010F\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001cH\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout;", "", "boxes", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "circles", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/DoubleCircle;", "hjust", "", "vjust", "boxPaddings", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "maxOverlaps", "seed", "", "maxIter", "maxTime", "direction", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;ILjava/lang/Long;IDLorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;)V", "getBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getDirection", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;", "labelItems", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$LabelItem;", "layoutItems", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$LayoutItem;", "getMaxIter", "()I", "getMaxOverlaps", "getMaxTime", "()D", "rnd", "Lkotlin/random/Random;", "getSeed", "()Ljava/lang/Long;", "Ljava/lang/Long;", "systemTime", "Lorg/jetbrains/letsPlot/commons/SystemTime;", "aggregateForces", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "labelItem", "applyDirection", "force", "clampToBounds", "", "distance", "n1", "n2", "doLayout", "", "easeOutQuint", "x", "normalizedNonZeroDirection", "from", "to", "perpendicularVectorFromSegment", "p", "segment", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "randomVector", "repulsion", "otherItem", "resolveSegmentIntersection", "selfAttraction", "selfRepulsion", "Direction", "LabelItem", "LayoutItem", "PointItem", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLabelForceLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelForceLayout.kt\norg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n215#2,2:347\n215#2,2:349\n1855#3,2:351\n*S KotlinDebug\n*F\n+ 1 LabelForceLayout.kt\norg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout\n*L\n47#1:347,2\n62#1:349,2\n78#1:351,2\n*E\n"})
public final class LabelForceLayout {
    @NotNull
    private final DoubleRectangle bounds;
    private final int maxOverlaps;
    @Nullable
    private final Long seed;
    private final int maxIter;
    private final double maxTime;
    @NotNull
    private final Direction direction;
    @NotNull
    private final SystemTime systemTime;
    @NotNull
    private final List<LabelItem> labelItems;
    @NotNull
    private final List<LayoutItem> layoutItems;
    @NotNull
    private final Random rnd;

    public LabelForceLayout(@NotNull Map<Integer, TransformedRectangle> boxes, @NotNull Map<Integer, DoubleCircle> circles, @NotNull Map<Integer, Double> hjust, @NotNull Map<Integer, Double> vjust, @NotNull Map<Integer, Double> boxPaddings, @NotNull DoubleRectangle bounds, int maxOverlaps, @Nullable Long seed, int maxIter, double maxTime, @NotNull Direction direction) {
        int dpIndex;
        Map.Entry<Integer, TransformedRectangle> entry;
        Map.Entry<Integer, Object> element$iv;
        Intrinsics.checkNotNullParameter(boxes, (String)"boxes");
        Intrinsics.checkNotNullParameter(circles, (String)"circles");
        Intrinsics.checkNotNullParameter(hjust, (String)"hjust");
        Intrinsics.checkNotNullParameter(vjust, (String)"vjust");
        Intrinsics.checkNotNullParameter(boxPaddings, (String)"boxPaddings");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.bounds = bounds;
        this.maxOverlaps = maxOverlaps;
        this.seed = seed;
        this.maxIter = maxIter;
        this.maxTime = maxTime;
        this.direction = direction;
        this.systemTime = new SystemTime();
        this.labelItems = new ArrayList();
        this.layoutItems = new ArrayList();
        this.rnd = this.seed == null ? (Random)Random.Default : RandomKt.Random((long)this.seed);
        Map<Integer, Object> $this$forEach$iv = boxes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            dpIndex = ((Number)entry.getKey()).intValue();
            TransformedRectangle box = entry.getValue();
            Double d = boxPaddings.get(dpIndex);
            double d2 = d != null ? d : 0.0;
            Double d3 = hjust.get(dpIndex);
            double d4 = d3 != null ? d3 : 0.5;
            Double d5 = vjust.get(dpIndex);
            double d6 = d5 != null ? d5 : 0.5;
            DoubleCircle doubleCircle = circles.get(dpIndex);
            Intrinsics.checkNotNull((Object)doubleCircle);
            DoubleVector doubleVector = doubleCircle.getCenter();
            DoubleCircle doubleCircle2 = circles.get(dpIndex);
            Intrinsics.checkNotNull((Object)doubleCircle2);
            LabelItem label2 = new LabelItem(dpIndex, box, d2, d4, d6, doubleVector, doubleCircle2.getRadius());
            this.labelItems.add(label2);
            this.layoutItems.add(label2);
        }
        $this$forEach$iv = circles;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            dpIndex = ((Number)entry.getKey()).intValue();
            DoubleCircle circle = (DoubleCircle)((Object)entry.getValue());
            if (!(circle.getRadius() > 0.0)) continue;
            this.layoutItems.add(new PointItem(dpIndex, circle));
        }
    }

    @NotNull
    public final DoubleRectangle getBounds() {
        return this.bounds;
    }

    public final int getMaxOverlaps() {
        return this.maxOverlaps;
    }

    @Nullable
    public final Long getSeed() {
        return this.seed;
    }

    public final int getMaxIter() {
        return this.maxIter;
    }

    public final double getMaxTime() {
        return this.maxTime;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @NotNull
    public final List<LabelItem> doLayout() {
        long start2 = this.systemTime.getTimeMs();
        boolean pauseIter = false;
        int firstRepulsionIter = 1;
        int hideLineIter = 2;
        int n = this.maxIter;
        for (int iter = 0; iter < n; ++iter) {
            DoubleVector force;
            if (iter <= 0) continue;
            if (iter == firstRepulsionIter) {
                Iterable $this$forEach$iv = this.labelItems;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LabelItem label2 = (LabelItem)element$iv;
                    boolean bl = false;
                    force = this.selfRepulsion(label2);
                    label2.setForce(force);
                }
                continue;
            }
            double easeFactor = this.easeOutQuint(1.0 - (double)iter / (double)this.maxIter);
            int overlapsCount = 0;
            for (LabelItem label2 : this.labelItems) {
                if (label2.getHidden()) continue;
                if (iter % 10 == 0) {
                    this.resolveSegmentIntersection(label2);
                }
                Pair<DoubleVector, Integer> pair2 = this.aggregateForces(label2);
                force = (DoubleVector)pair2.component1();
                int overlaps = ((Number)pair2.component2()).intValue();
                if (iter == hideLineIter && this.maxOverlaps >= 0 && overlaps > this.maxOverlaps) {
                    label2.setHidden(true);
                    continue;
                }
                if (overlaps == 0) {
                    force = this.selfAttraction(label2);
                }
                label2.setForce(force.mul(easeFactor));
                this.clampToBounds(label2);
                overlapsCount += overlaps;
            }
            if (overlapsCount == 0 || this.maxTime > 0.0 && (double)(this.systemTime.getTimeMs() - start2) > this.maxTime) break;
        }
        return this.labelItems;
    }

    private final Pair<DoubleVector, Integer> aggregateForces(LabelItem labelItem) {
        DoubleVector force = DoubleVector.Companion.getZERO();
        int overlaps = 0;
        for (LayoutItem other : this.layoutItems) {
            DoubleSegment labelSegment;
            if (Intrinsics.areEqual((Object)labelItem, (Object)other) || other.getHidden()) continue;
            if (labelItem.intersects(other)) {
                ++overlaps;
                force = force.add(this.repulsion(labelItem, other));
                continue;
            }
            if (!(other instanceof LabelItem)) continue;
            DoubleSegment otherSegment = ((LabelItem)other).segment();
            if (otherSegment != null && labelItem.getBox().intersects(otherSegment)) {
                DoubleVector delta = TransformedRectangle.Companion.savedNormalize(this.perpendicularVectorFromSegment(labelItem.getPosition(), otherSegment));
                force = force.add(this.applyDirection(delta));
                ++overlaps;
            }
            if ((labelSegment = labelItem.segment()) == null || !((LabelItem)other).getBox().intersects(labelSegment)) continue;
            DoubleVector delta = TransformedRectangle.Companion.savedNormalize(this.perpendicularVectorFromSegment(((LabelItem)other).getPosition(), labelSegment));
            force = force.add(this.applyDirection(delta.negate()));
            ++overlaps;
        }
        return TuplesKt.to((Object)force, (Object)overlaps);
    }

    private final DoubleVector repulsion(LabelItem labelItem, LayoutItem otherItem) {
        DoubleVector dir = this.normalizedNonZeroDirection(labelItem.getPosition(), otherItem.getPosition());
        double dnl = labelItem.getDLength() + otherItem.getDLength();
        double d = this.distance(labelItem, otherItem);
        double forceValue = dnl / (dnl + d);
        if (labelItem.getDpIndex() == otherItem.getDpIndex()) {
            forceValue *= (double)2;
        }
        return this.applyDirection(dir.negate().mul(forceValue));
    }

    private final DoubleVector selfAttraction(LabelItem labelItem) {
        DoubleVector dir = this.normalizedNonZeroDirection(labelItem.getPosition(), labelItem.getPoint());
        double d = labelItem.getPoint().subtract(labelItem.getPosition()).length();
        double dnl = labelItem.getDLength() + labelItem.getPointRadius();
        double forceValue = d / dnl;
        return this.applyDirection(dir.mul(forceValue));
    }

    private final DoubleVector selfRepulsion(LabelItem labelItem) {
        if (labelItem.getPointRadius() == 0.0) {
            return DoubleVector.Companion.getZERO();
        }
        return this.applyDirection(this.randomVector().mul(8.0));
    }

    private final DoubleVector applyDirection(DoubleVector force) {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: {
                doubleVector = DoubleVectorExtensions.INSTANCE.getXVector(force);
                break;
            }
            case 2: {
                doubleVector = DoubleVectorExtensions.INSTANCE.getYVector(force);
                break;
            }
            case 3: {
                doubleVector = force;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    private final void clampToBounds(LabelItem labelItem) {
        DoubleRectangle bbox2 = labelItem.getBox().getBbox();
        double dx = bbox2.getLeft() < this.bounds.getLeft() ? this.bounds.getLeft() - bbox2.getLeft() : (bbox2.getRight() > this.bounds.getRight() ? this.bounds.getRight() - bbox2.getRight() : 0.0);
        double dy = bbox2.getTop() < this.bounds.getTop() ? this.bounds.getTop() - bbox2.getTop() : (bbox2.getBottom() > this.bounds.getBottom() ? this.bounds.getBottom() - bbox2.getBottom() : 0.0);
        DoubleVector shift = new DoubleVector(dx, dy);
        if (Intrinsics.areEqual((Object)shift, (Object)DoubleVector.Companion.getZERO())) {
            labelItem.setClamped(false);
        } else {
            if (labelItem.getClamped()) {
                DoubleVector additional = DoubleVectorExtensions.INSTANCE.hadamard(DoubleVectorExtensions.INSTANCE.sign(shift), bbox2.getDimension());
                labelItem.updatePosition(this.applyDirection(shift.add(additional)));
            }
            labelItem.updatePosition(this.applyDirection(shift));
            labelItem.setClamped(true);
        }
    }

    private final void resolveSegmentIntersection(LabelItem labelItem) {
        for (LabelItem otherItem : this.labelItems) {
            DoubleSegment otherSegment;
            DoubleSegment labelSegment;
            if (Intrinsics.areEqual((Object)labelItem, (Object)otherItem) || otherItem.getHidden() || Intrinsics.areEqual((Object)labelItem.getPoint(), (Object)otherItem.getPoint()) || (labelSegment = new DoubleSegment(labelItem.getPoint(), labelItem.getPosition())).intersection(otherSegment = new DoubleSegment(otherItem.getPoint(), otherItem.getPosition())) == null) continue;
            DoubleVector delta = otherItem.getPosition().subtract(labelItem.getPosition());
            labelItem.updatePosition(delta);
            otherItem.updatePosition(delta.mul(-1.0));
        }
    }

    @NotNull
    public final DoubleVector perpendicularVectorFromSegment(@NotNull DoubleVector p, @NotNull DoubleSegment segment2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)segment2, (String)"segment");
        DoubleVector ab = segment2.getEnd().subtract(segment2.getStart());
        DoubleVector ap = p.subtract(segment2.getStart());
        double abLengthSquared = ab.dotProduct(ab);
        if (abLengthSquared == 0.0) {
            return segment2.getStart().subtract(p);
        }
        double t = RangesKt.coerceIn((double)(ap.dotProduct(ab) / abLengthSquared), (double)0.0, (double)1.0);
        DoubleVector projection = segment2.getStart().add(ab.mul(t));
        return p.subtract(projection);
    }

    public final double distance(@NotNull LayoutItem n1, @NotNull LayoutItem n2) {
        Intrinsics.checkNotNullParameter((Object)n1, (String)"n1");
        Intrinsics.checkNotNullParameter((Object)n2, (String)"n2");
        return n1.getPosition().subtract(n2.getPosition()).length();
    }

    private final DoubleVector normalizedNonZeroDirection(DoubleVector from2, DoubleVector to) {
        DoubleVector dir = TransformedRectangle.Companion.savedNormalize(to.subtract(from2));
        return Intrinsics.areEqual((Object)dir, (Object)DoubleVector.Companion.getZERO()) ? this.randomVector() : dir;
    }

    private final DoubleVector randomVector() {
        double angle = this.rnd.nextDouble() * (double)2 * Math.PI;
        return new DoubleVector(Math.cos(angle), Math.sin(angle));
    }

    private final double easeOutQuint(double x2) {
        return 1.0 - Math.pow(1.0 - x2, 5);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;", "", "(Ljava/lang/String;I)V", "BOTH", "X", "Y", "plot-base"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction BOTH = new Direction();
        public static final /* enum */ Direction X = new Direction();
        public static final /* enum */ Direction Y = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.BOTH, Direction.X, Direction.Y};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u000e\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0001J\b\u00102\u001a\u0004\u0018\u000103J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000bJ\u000e\u00107\u001a\u0002052\u0006\u00108\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u000e\u0010\u001f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0015\"\u0004\b\"\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u0014\u0010$\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001aR\u001a\u0010*\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010(\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001a\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$LabelItem;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$LayoutItem;", "dpIndex", "", "box", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "padding", "", "hjust", "vjust", "point", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "pointRadius", "(ILorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;DDDLorg/jetbrains/letsPlot/commons/geometry/DoubleVector;D)V", "getBox", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "setBox", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;)V", "clamped", "", "getClamped", "()Z", "setClamped", "(Z)V", "dLength", "getDLength", "()D", "getDpIndex", "()I", "expanded", "getExpanded", "friction", "hidden", "getHidden", "setHidden", "getHjust", "hypot", "getHypot", "getPadding", "getPoint", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getPointRadius", "position", "getPosition", "setPosition", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "velocity", "getVjust", "intersects", "other", "segment", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "setForce", "", "force", "updatePosition", "delta", "plot-base"})
    public static final class LabelItem
    implements LayoutItem {
        private final int dpIndex;
        @NotNull
        private TransformedRectangle box;
        private final double padding;
        private final double hjust;
        private final double vjust;
        @NotNull
        private final DoubleVector point;
        private final double pointRadius;
        private final double hypot;
        @NotNull
        private DoubleVector position;
        private boolean hidden;
        private boolean clamped;
        @NotNull
        private DoubleVector velocity;
        private final double friction;

        public LabelItem(int dpIndex, @NotNull TransformedRectangle box, double padding, double hjust, double vjust, @NotNull DoubleVector point2, double pointRadius) {
            Intrinsics.checkNotNullParameter((Object)box, (String)"box");
            Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
            this.dpIndex = dpIndex;
            this.box = box;
            this.padding = padding;
            this.hjust = hjust;
            this.vjust = vjust;
            this.point = point2;
            this.pointRadius = pointRadius;
            this.hypot = this.box.getHypot();
            this.position = DoubleVector.Companion.getZERO();
            this.velocity = DoubleVector.Companion.getZERO();
            this.friction = 0.7;
            this.setPosition(this.box.anchor(this.hjust, this.vjust));
        }

        @Override
        public int getDpIndex() {
            return this.dpIndex;
        }

        @NotNull
        public final TransformedRectangle getBox() {
            return this.box;
        }

        public final void setBox(@NotNull TransformedRectangle transformedRectangle) {
            Intrinsics.checkNotNullParameter((Object)transformedRectangle, (String)"<set-?>");
            this.box = transformedRectangle;
        }

        public final double getPadding() {
            return this.padding;
        }

        public final double getHjust() {
            return this.hjust;
        }

        public final double getVjust() {
            return this.vjust;
        }

        @NotNull
        public final DoubleVector getPoint() {
            return this.point;
        }

        public final double getPointRadius() {
            return this.pointRadius;
        }

        @Override
        public double getHypot() {
            return this.hypot;
        }

        @Override
        @NotNull
        public DoubleVector getPosition() {
            return this.position;
        }

        public void setPosition(@NotNull DoubleVector doubleVector) {
            Intrinsics.checkNotNullParameter((Object)doubleVector, (String)"<set-?>");
            this.position = doubleVector;
        }

        @Override
        public boolean getHidden() {
            return this.hidden;
        }

        @Override
        public void setHidden(boolean bl) {
            this.hidden = bl;
        }

        @Override
        public double getDLength() {
            return this.box.getHypot() / (double)2;
        }

        @NotNull
        public final TransformedRectangle getExpanded() {
            return this.box.expand(this.padding / (double)2);
        }

        public final boolean getClamped() {
            return this.clamped;
        }

        public final void setClamped(boolean bl) {
            this.clamped = bl;
        }

        public final void setForce(@NotNull DoubleVector force) {
            Intrinsics.checkNotNullParameter((Object)force, (String)"force");
            this.velocity = this.velocity.mul(this.friction).add(force);
            this.updatePosition(this.velocity);
        }

        @Nullable
        public final DoubleSegment segment() {
            return this.box.shortestSegmentToRectangleEdgeCenter(this.point);
        }

        public final boolean intersects(@NotNull LayoutItem other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (other instanceof LabelItem) {
                return this.getExpanded().intersects(((LabelItem)other).getExpanded());
            }
            if (other instanceof PointItem) {
                return this.box.intersects(((PointItem)other).getCircle());
            }
            return false;
        }

        public final void updatePosition(@NotNull DoubleVector delta) {
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            this.setPosition(this.getPosition().add(delta));
            this.box = this.box.add(delta);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$LayoutItem;", "", "dLength", "", "getDLength", "()D", "dpIndex", "", "getDpIndex", "()I", "hidden", "", "getHidden", "()Z", "setHidden", "(Z)V", "hypot", "getHypot", "position", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getPosition", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static interface LayoutItem {
        public int getDpIndex();

        public double getHypot();

        @NotNull
        public DoubleVector getPosition();

        public boolean getHidden();

        public void setHidden(boolean var1);

        public double getDLength();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$PointItem;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$LayoutItem;", "dpIndex", "", "circle", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/DoubleCircle;", "(ILorg/jetbrains/letsPlot/core/plot/base/geom/repel/DoubleCircle;)V", "getCircle", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/DoubleCircle;", "dLength", "", "getDLength", "()D", "getDpIndex", "()I", "hidden", "", "getHidden", "()Z", "setHidden", "(Z)V", "hypot", "getHypot", "position", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getPosition", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static final class PointItem
    implements LayoutItem {
        private final int dpIndex;
        @NotNull
        private final DoubleCircle circle;
        private final double hypot;
        @NotNull
        private final DoubleVector position;
        private boolean hidden;

        public PointItem(int dpIndex, @NotNull DoubleCircle circle) {
            Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
            this.dpIndex = dpIndex;
            this.circle = circle;
            this.hypot = (double)2 * this.circle.getRadius();
            this.position = this.circle.getCenter();
        }

        @Override
        public int getDpIndex() {
            return this.dpIndex;
        }

        @NotNull
        public final DoubleCircle getCircle() {
            return this.circle;
        }

        @Override
        public double getHypot() {
            return this.hypot;
        }

        @Override
        @NotNull
        public DoubleVector getPosition() {
            return this.position;
        }

        @Override
        public boolean getHidden() {
            return this.hidden;
        }

        @Override
        public void setHidden(boolean bl) {
            this.hidden = bl;
        }

        @Override
        public double getDLength() {
            return this.circle.getRadius();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.BOTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

