/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.service;

import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.config.DataSourceInfo;
import com.intellij.jpa.jpb.model.config.JpbDataSourceConfig;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.ds.CustomDataSourceHandler;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.service.DataStoreManagerExtension;
import com.intellij.jpa.jpb.model.ui.dialog.DbConnectionEditorDialog;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J%\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jpa/jpb/model/service/JpaDataStoreManagerExtension;", "Lcom/intellij/jpa/jpb/model/service/DataStoreManagerExtension;", "<init>", "()V", "createDataStore", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "project", "Lcom/intellij/openapi/project/Project;", "templateDataStore", "Lcom/intellij/jpa/jpb/model/model/CustomDataStore;", "saveDataStore", "", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "editDataStore", "deleteDataStore", "applyInitialCredentials", "dbProperties", "", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;)V", "updateDbConnection", "oldUrl", "", "newDataStore", "isExistDbConnection", "", "url", "CreateDataStoreDialog", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDataStoreManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStoreManager.kt\ncom/intellij/jpa/jpb/model/service/JpaDataStoreManagerExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1#2:161\n1761#3,3:162\n*S KotlinDebug\n*F\n+ 1 DataStoreManager.kt\ncom/intellij/jpa/jpb/model/service/JpaDataStoreManagerExtension\n*L\n151#1:162,3\n*E\n"})
public final class JpaDataStoreManagerExtension
implements DataStoreManagerExtension {
    @Override
    @Nullable
    public DataStore createDataStore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DbConnectionEditorDialog dataStoreEditor = new DbConnectionEditorDialog(project);
        if (dataStoreEditor.showAndGet()) {
            CustomDataStore customDataStore = dataStoreEditor.getDataStore();
            Intrinsics.checkNotNullExpressionValue((Object)customDataStore, (String)"getDataStore(...)");
            CustomDataStore dataStore = customDataStore;
            this.saveDataStore(project, dataStore);
            return dataStore;
        }
        return null;
    }

    @Override
    @Nullable
    public DataStore createDataStore(@NotNull Project project, @NotNull CustomDataStore templateDataStore) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)templateDataStore, (String)"templateDataStore");
        CreateDataStoreDialog dataStoreEditor = new CreateDataStoreDialog(project, templateDataStore);
        if (!dataStoreEditor.showAndGet()) {
            return null;
        }
        CustomDataStore customDataStore = dataStoreEditor.getDataStore();
        Intrinsics.checkNotNullExpressionValue((Object)customDataStore, (String)"getDataStore(...)");
        CustomDataStore editedDataStore = customDataStore;
        this.saveDataStore(project, editedDataStore);
        return editedDataStore;
    }

    private final void saveDataStore(Project project, AbstractRdbmsStore dataStore) {
        JpbDataSourceConfig jpbDataSourceConfig = JpbDataSourceConfig.getInstance(project);
        jpbDataSourceConfig.customDataSources.add(new DataSourceInfo(dataStore));
        DataSourceLoader.Companion.getInstance(project).saveCredentials(dataStore);
        ((CustomDataSourceHandler)project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
    }

    @Override
    public void editDataStore(@NotNull Project project, @NotNull CustomDataStore dataStore) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        DbConnectionEditorDialog dataStoreEditor = new DbConnectionEditorDialog(project, dataStore);
        if (dataStoreEditor.showAndGet()) {
            Object v1;
            block3: {
                JpbDataSourceConfig jpbDataSourceConfig = JpbDataSourceConfig.getInstance(project);
                List<DataSourceInfo> list = jpbDataSourceConfig.customDataSources;
                Intrinsics.checkNotNullExpressionValue(list, (String)"customDataSources");
                Iterable iterable = list;
                for (Object t : iterable) {
                    DataSourceInfo it = (DataSourceInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)dataStore.getId())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            DataSourceInfo foundDataSourceInfo = v1;
            if (foundDataSourceInfo == null) {
                throw new IllegalStateException("Custom DB connection with id '" + dataStore.getId() + "' not found");
            }
            CustomDataStore customDataStore = dataStoreEditor.getDataStore();
            Intrinsics.checkNotNullExpressionValue((Object)customDataStore, (String)"getDataStore(...)");
            CustomDataStore editedDataStore = customDataStore;
            foundDataSourceInfo.copyFrom(editedDataStore);
            DataSourceLoader.Companion.getInstance(project).saveCredentials(dataStore);
            ((CustomDataSourceHandler)project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
        }
    }

    @Override
    public void deleteDataStore(@NotNull Project project, @NotNull CustomDataStore dataStore) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        Object[] objectArray = new Object[]{dataStore.getName()};
        int toDelete = Messages.showYesNoDialog((Project)project, (String)JpaModelBundle.message("delete.db.connection", objectArray), (String)JpaModelBundle.message("db.connection.delete", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (toDelete == 0) {
            JpbDataSourceConfig jpbDataSourceConfig = JpbDataSourceConfig.getInstance(project);
            jpbDataSourceConfig.customDataSources.removeIf(arg_0 -> JpaDataStoreManagerExtension.deleteDataStore$lambda$1(arg_0 -> JpaDataStoreManagerExtension.deleteDataStore$lambda$0(dataStore, arg_0), arg_0));
            DataSourceLoader.Companion.getInstance(project).removeCredentials(dataStore);
            ((CustomDataSourceHandler)project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
            Object[] objectArray2 = new Object[]{dataStore.getName()};
            HNotificationManager.getInstance(project).showNotification(JpaModelBundle.message("db.connection.was.deleted", objectArray2));
        }
    }

    @Override
    public void applyInitialCredentials(@NotNull Project project, @NotNull DbProperties[] dbProperties) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
    }

    @Override
    public void updateDbConnection(@NotNull Project project, @NotNull String oldUrl, @NotNull AbstractRdbmsStore newDataStore) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)oldUrl, (String)"oldUrl");
            Intrinsics.checkNotNullParameter((Object)newDataStore, (String)"newDataStore");
            JpbDataSourceConfig jpbDataSourceConfig = JpbDataSourceConfig.getInstance(project);
            List<DataSourceInfo> list = jpbDataSourceConfig.customDataSources;
            Intrinsics.checkNotNullExpressionValue(list, (String)"customDataSources");
            Iterable iterable = list;
            for (Object t : iterable) {
                DataSourceInfo it = (DataSourceInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)oldUrl)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        DataSourceInfo dataSourceInfo = v1;
        if (dataSourceInfo == null) {
            return;
        }
        DataSourceInfo foundDataSourceInfo = dataSourceInfo;
        CustomDataStore dbConnection = new CustomDataStore(project, foundDataSourceInfo);
        foundDataSourceInfo.copyFrom(newDataStore);
        dbConnection.setDbProperties(newDataStore.getDbProperties());
        DataSourceLoader dataSourceLoader = DataSourceLoader.Companion.getInstance(project);
        dataSourceLoader.saveCredentials(dbConnection);
        ((CustomDataSourceHandler)project.getMessageBus().syncPublisher(CustomDataSourceHandler.TOPIC)).dataSourcesChanged();
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)JpaModelBundle.message("open.db.connection", new Object[0]), () -> JpaDataStoreManagerExtension.updateDbConnection$lambda$1(this, project, dbConnection));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        NotificationAction openDbConnectionAction = notificationAction;
        Object[] objectArray = new Object[]{dbConnection.getName()};
        String string = JpaModelBundle.message("db.connection.updated", objectArray);
        objectArray = new NotificationAction[]{openDbConnectionAction};
        HNotificationManager.getInstance(project).showNotification(null, null, string, NotificationType.INFORMATION, true, (NotificationAction[])objectArray);
    }

    @Override
    public boolean isExistDbConnection(@NotNull Project project, @NotNull String url) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            List<DataSourceInfo> list = JpbDataSourceConfig.getInstance((Project)project).customDataSources;
            Intrinsics.checkNotNullExpressionValue(list, (String)"customDataSources");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataSourceInfo it = (DataSourceInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean deleteDataStore$lambda$0(CustomDataStore $dataStore, DataSourceInfo it) {
        return Intrinsics.areEqual((Object)it.getId(), (Object)$dataStore.getId());
    }

    private static final boolean deleteDataStore$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void updateDbConnection$lambda$1(JpaDataStoreManagerExtension this$0, Project $project, CustomDataStore $dbConnection) {
        this$0.editDataStore($project, $dbConnection);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/service/JpaDataStoreManagerExtension$CreateDataStoreDialog;", "Lcom/intellij/jpa/jpb/model/ui/dialog/DbConnectionEditorDialog;", "project", "Lcom/intellij/openapi/project/Project;", "selectedDataStore", "Lcom/intellij/jpa/jpb/model/model/CustomDataStore;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/model/CustomDataStore;)V", "intellij.javaee.jpa.jpb.model"})
    public static final class CreateDataStoreDialog
    extends DbConnectionEditorDialog {
        public CreateDataStoreDialog(@NotNull Project project, @Nullable CustomDataStore selectedDataStore) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, selectedDataStore);
            this.myOKAction.putValue("Name", JpaModelBundle.message("db.connection.save", new Object[0]));
        }
    }
}

