/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.model.xml.FormLogin;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.model.xml.Logout;
import com.intellij.spring.security.references.SpringSecurityUrlPathReferenceSet;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityWebPathProvider
extends PathReferenceProviderBase {
    private static final ElementPattern<? extends PsiElement> scriptSrcPattern = XmlPatterns.xmlAttributeValue((ElementPattern)XmlPatterns.xmlAttribute((String)"src").withParent((ElementPattern)XmlPatterns.xmlTag().withLocalName("script")));
    private static final String LOGIN_DEFAULT_3_X = "/j_spring_security_check";
    private static final String LOGOUT_DEFAULT_3_X = "/j_spring_security_logout";
    private static final String LOGIN_DEFAULT_4_X = "/login";
    private static final String LOGOUT_DEFAULT_4_X = "/logout";

    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<? super PsiReference> references, boolean soft) {
        if (psiElement == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(0);
        }
        if (references == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiElement.getContainingFile()) || SpringSecurityWebPathProvider.isUnsupportedPlaces(psiElement)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.core.Authentication") == null) {
            return true;
        }
        references.addAll(new SpringSecurityUrlPathReferenceSet(UrlPathContextKt.chopLeadingEmptyBlock((UrlPath)UrlPath.fromExactString((String)text)), psiElement, offset).getReferences());
        return true;
    }

    private static boolean isUnsupportedPlaces(@NotNull PsiElement element) {
        if (element == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(2);
        }
        return scriptSrcPattern.accepts((Object)element);
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(4);
        }
        return null;
    }

    public static List<String> getSpringSecurityURLs(Module module) {
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            SmartList customLogins = new SmartList();
            SmartList customLogouts = new SmartList();
            SpringSecurityWebPathProvider.collectHttpCustomUrls(module, (List<String>)customLogins, (List<String>)customLogouts);
            SpringSecurityWebPathProvider.collectSecurityConfigurerUrls(module, (List<String>)customLogins, (List<String>)customLogouts);
            if (customLogins.isEmpty()) {
                customLogins.add(SpringSecurityUtil.isAtLeastVersion(module, SpringSecurityVersion.V_4_0_4) ? LOGIN_DEFAULT_4_X : LOGIN_DEFAULT_3_X);
            }
            if (customLogouts.isEmpty()) {
                customLogouts.add(SpringSecurityUtil.isAtLeastVersion(module, SpringSecurityVersion.V_4_0_4) ? LOGOUT_DEFAULT_4_X : LOGOUT_DEFAULT_3_X);
            }
            return CachedValueProvider.Result.create((Object)ContainerUtil.concat((List)customLogins, (List)customLogouts), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies()});
        });
    }

    private static void collectSecurityConfigurerUrls(@NotNull Module module, @NotNull List<String> customLogins, @NotNull List<String> customLogouts) {
        PsiClass webSecurityConfigurer;
        if (module == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(5);
        }
        if (customLogins == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(6);
        }
        if (customLogouts == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(7);
        }
        if ((webSecurityConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter")) != null) {
            PsiClass logoutConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.config.annotation.web.configurers.LogoutConfigurer");
            PsiClass loginFormConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer");
            if (logoutConfigurer == null && loginFormConfigurer == null) {
                return;
            }
            SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)webSecurityConfigurer))) {
                CommonSpringBean springBean = bean.getSpringBean();
                if (!(springBean instanceof JamPsiClassSpringBean)) continue;
                PsiClass psiClass = ((JamPsiClassSpringBean)springBean).getPsiElement();
                for (PsiMethod configure : psiClass.findMethodsByName("configure", false)) {
                    LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)configure);
                    customLogouts.addAll(SpringSecurityWebPathProvider.getConfiguredUrls(logoutConfigurer, "logoutUrl", localSearchScope));
                    customLogins.addAll(SpringSecurityWebPathProvider.getConfiguredUrls(loginFormConfigurer, "loginPage", localSearchScope));
                }
            }
        }
    }

    private static void collectHttpCustomUrls(@NotNull Module module, @NotNull List<String> customLogins, @NotNull List<String> customLogouts) {
        PsiClass httpConfigurer;
        if (module == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(8);
        }
        if (customLogins == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(9);
        }
        if (customLogouts == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(10);
        }
        if ((httpConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.web.FilterChainProxy")) != null) {
            SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            for (LocalXmlModel localXmlModel : SpringModelVisitorUtils.getLocalXmlModels((CommonSpringModel)model)) {
                for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)localXmlModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)httpConfigurer))) {
                    CommonSpringBean springBean = bean.getSpringBean();
                    if (!(springBean instanceof Http)) continue;
                    Http http = (Http)springBean;
                    for (FormLogin login : http.getFormLogins()) {
                        String loginUrl = login.getLoginProcessingUrl().getStringValue();
                        if (!StringUtil.isNotEmpty((String)loginUrl)) continue;
                        customLogins.add(loginUrl);
                    }
                    for (Logout logout : http.getLogouts()) {
                        String logoutUrl = logout.getLogoutUrl().getStringValue();
                        if (!StringUtil.isNotEmpty((String)logoutUrl)) continue;
                        customLogouts.add(logoutUrl);
                    }
                }
            }
        }
    }

    @NotNull
    private static Set<String> getConfiguredUrls(@Nullable PsiClass logoutConfigurer, String methodName, LocalSearchScope localSearchScope) {
        PsiMethod[] logoutUrls;
        HashSet<String> urls = new HashSet<String>();
        if (logoutConfigurer != null && (logoutUrls = logoutConfigurer.findMethodsByName(methodName, false)).length == 1 && logoutUrls[0] != null) {
            for (Pair pair : StringExpressionHelper.searchStringExpressions((PsiMethod)logoutUrls[0], (SearchScope)localSearchScope, (int)0)) {
                ContainerUtil.addIfNotNull(urls, (Object)((String)pair.getSecond()));
            }
        }
        HashSet<String> hashSet = urls;
        if (hashSet == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLogins";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLogouts";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityWebPathProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityWebPathProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnsupportedPlaces";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectSecurityConfigurerUrls";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectHttpCustomUrls";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

