/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.xml.converters;

import com.intellij.javaee.ejb.model.EjbWithHome;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.xml.Method;
import com.intellij.javaee.ejb.model.xml.MethodIntf;
import com.intellij.javaee.ejb.model.xml.MethodParams;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbMethodResolveConverter
extends AbstractMethodResolveConverter<Method> {
    public EjbMethodResolveConverter() {
        super(Method.class);
    }

    @NotNull
    protected Collection<PsiClass> getPsiClasses(Method parent, ConvertContext context) {
        Collection<PsiClass> collection = EjbMethodResolveConverter.getTargetClasses((EnterpriseBean)parent.getEnterpriseBean().getValue(), (MethodIntf)((Object)parent.getMethodIntf().getValue()), true);
        if (collection == null) {
            EjbMethodResolveConverter.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public static Collection<PsiClass> getTargetClasses(@Nullable EnterpriseBean ejb, @Nullable MethodIntf methodIntf, boolean includeEjbClass) {
        HashSet<PsiClass> targetClasses = new HashSet<PsiClass>();
        boolean allInterfaces = false;
        MethodIntf curMethodIntf = methodIntf;
        if (methodIntf == null) {
            allInterfaces = true;
            curMethodIntf = MethodIntf.HOME;
            if (includeEjbClass && ejb != null) {
                targetClasses.add((PsiClass)ejb.getEjbClass().getValue());
            }
        }
        switch (curMethodIntf) {
            case HOME: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((EjbWithHome)ejb).getHome().getValue()));
                }
                if (!allInterfaces) break;
            }
            case LOCAL_HOME: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((EjbWithHome)ejb).getLocalHome().getValue()));
                }
                if (!allInterfaces) break;
            }
            case REMOTE: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((EjbWithHome)ejb).getRemote().getValue()));
                }
                if (ejb instanceof SessionBean) {
                    for (GenericValue<PsiClass> genericValue : ((SessionBean)ejb).getBusinessRemotes()) {
                        ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)genericValue.getValue()));
                    }
                }
                if (!allInterfaces) break;
            }
            case LOCAL: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((EjbWithHome)ejb).getLocal().getValue()));
                }
                if (ejb instanceof SessionBean) {
                    for (GenericValue<PsiClass> genericValue : ((SessionBean)ejb).getBusinessLocals()) {
                        ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)genericValue.getValue()));
                    }
                } else if (ejb instanceof MessageDrivenBean) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue()));
                }
                if (!allInterfaces) break;
            }
            case SERVICE_ENDPOINT: {
                if (ejb instanceof SessionBean) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((SessionBean)ejb).getServiceEndpoint().getValue()));
                }
                if (!allInterfaces) break;
            }
            case MESSAGE_ENDPOINT: {
                if (ejb instanceof MessageDrivenBean) {
                    ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue()));
                }
                if (!allInterfaces) break;
            }
            case TIMER: {
                if (allInterfaces || ejb == null) break;
                ContainerUtil.addIfNotNull(targetClasses, (Object)((PsiClass)ejb.getEjbClass().getValue()));
            }
        }
        return targetClasses;
    }

    @NotNull
    protected MethodParams getMethodParams(@NotNull Method parent) {
        if (parent == null) {
            EjbMethodResolveConverter.$$$reportNull$$$0(1);
        }
        MethodParams methodParams = parent.getMethodParams();
        if (methodParams == null) {
            EjbMethodResolveConverter.$$$reportNull$$$0(2);
        }
        return methodParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/xml/converters/EjbMethodResolveConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/xml/converters/EjbMethodResolveConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodParams";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMethodParams";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

