/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.maven;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.MavenCommandLineInspectionProjectConfigurator;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaActivityKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/jvm/maven/QodanaMavenJdkProvider;", "Lorg/jetbrains/idea/maven/project/MavenImportListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "importFinished", "", "importedProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "newModules", "", "Lcom/intellij/openapi/module/Module;", "intellij.qodana.jvm.maven"})
public final class QodanaMavenJdkProvider
implements MavenImportListener {
    @NotNull
    private final Project project;

    public QodanaMavenJdkProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
        Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
        Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
        TrackingUtil.trackActivityBlocking((Project)this.project, (ActivityKey)QodanaActivityKey.INSTANCE, () -> QodanaMavenJdkProvider.importFinished$lambda$0(this, importedProjects));
    }

    private static final Unit importFinished$lambda$0(QodanaMavenJdkProvider this$0, Collection $importedProjects) {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return Unit.INSTANCE;
        }
        if (!PlatformUtils.isQodana()) {
            return Unit.INSTANCE;
        }
        if (ProjectRootManager.getInstance((Project)this$0.project).getProjectSdk() != null) {
            return Unit.INSTANCE;
        }
        CompletableFuture future = new MavenCommandLineInspectionProjectConfigurator().setupJdkWithSuitableVersion(CollectionsKt.toList((Iterable)$importedProjects), (ProgressIndicator)new EmptyProgressIndicator());
        ApplicationManager.getApplication().executeOnPooledThread(() -> QodanaMavenJdkProvider.importFinished$lambda$0$0(future, this$0));
        return Unit.INSTANCE;
    }

    private static final void importFinished$lambda$0$0(CompletableFuture $future, QodanaMavenJdkProvider this$0) {
        Sdk sdk = (Sdk)$future.join();
        if (sdk == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> QodanaMavenJdkProvider.importFinished$lambda$0$0$0(this$0, sdk));
    }

    private static final void importFinished$lambda$0$0$0(QodanaMavenJdkProvider this$0, Sdk $sdk) {
        ActionsKt.runWriteAction(() -> QodanaMavenJdkProvider.importFinished$lambda$0$0$0$0(this$0, $sdk));
    }

    private static final Unit importFinished$lambda$0$0$0$0(QodanaMavenJdkProvider this$0, Sdk $sdk) {
        ProjectRootManager.getInstance((Project)this$0.project).setProjectSdk($sdk);
        return Unit.INSTANCE;
    }
}

