/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDumpDialogGridAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        DumpSource<?> source;
        if (e == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(1);
        }
        DumpSource<?> dumpSource = source = (grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null ? null : ShowDumpDialogGridAction.getDumpSource(grid, e);
        if (source == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(GridHelper.get(grid).isDumpEnabled(source));
        e.getPresentation().setText(DataGridBundle.message((String)"ShowDumpDialogAction.text", (Object[])new Object[0]));
        e.getPresentation().setText(DataGridBundle.message((String)"ShowDumpDialogAction.DatabaseViewText", (Object[])new Object[]{DumpSource.getSize(source)}), true);
        e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
    }

    @Nullable
    private static DumpSource<?> getDumpSource(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        if (grid == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(3);
        }
        return GridHelper.get(grid).createDumpSource(grid, e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(4);
        }
        final Project project = e.getProject();
        final DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null) {
            return;
        }
        final DumpSource<?> source = ShowDumpDialogGridAction.getDumpSource(grid, e);
        if (project != null && source != null) {
            new DumpDataDialog(this, project, source, (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)){

                @Override
                protected void exportToFile(@NotNull DataExtractorFactory factory, @NotNull File file) {
                    if (factory == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ShowDumpDialogGridAction.export(project, grid, source, factory, new ExtractionHelper.FileExtractionHelper(file), this.myForm.getExtractorConfig());
                }

                @Override
                protected void exportToClipboard(@NotNull DataExtractorFactory factory) {
                    if (factory == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ShowDumpDialogGridAction.export(project, grid, source, factory, new ExtractionHelper.ClipboardExtractionHelper(), this.myForm.getExtractorConfig());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "factory";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dump/ShowDumpDialogGridAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "exportToFile";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "exportToClipboard";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.show();
        }
    }

    private static void export(@NotNull Project project, @NotNull DataGrid grid, @NotNull DumpSource<?> source, @NotNull DataExtractorFactory factory, @NotNull ExtractionHelper helper, @NotNull ExtractionConfig config) {
        if (project == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(6);
        }
        if (source == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(7);
        }
        if (factory == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(8);
        }
        if (helper == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(9);
        }
        if (config == null) {
            ShowDumpDialogGridAction.$$$reportNull$$$0(10);
        }
        GridHelper.get(grid).createDumpHandler(source, helper, factory, config).performDump(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/ShowDumpDialogGridAction";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/ShowDumpDialogGridAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDumpSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

