/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgGraftCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCherryPicker
extends VcsCherryPicker {
    @NotNull
    private final Project myProject;

    public HgCherryPicker(@NotNull Project project) {
        if (project == null) {
            HgCherryPicker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            HgCherryPicker.$$$reportNull$$$0(1);
        }
        return vcsKey;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getActionTitle() {
        String string = HgBundle.message("graft", new Object[0]);
        if (string == null) {
            HgCherryPicker.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean cherryPick(@NotNull List<? extends VcsCommitMetadata> commits) {
        if (commits == null) {
            HgCherryPicker.$$$reportNull$$$0(3);
        }
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots((RepositoryManager)HgUtil.getRepositoryManager(this.myProject), commits);
        IntRef commitsGrafted = new IntRef(0);
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            HgCherryPicker.processGrafting((HgRepository)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), commitDetails -> ((Hash)commitDetails.getId()).asString()), commitsGrafted);
        }
        return commitsGrafted.get() == commits.size();
    }

    private static void processGrafting(@NotNull HgRepository repository, @NotNull List<String> hashes, @NotNull IntRef totalCommitsGrafted) {
        if (repository == null) {
            HgCherryPicker.$$$reportNull$$$0(4);
        }
        if (hashes == null) {
            HgCherryPicker.$$$reportNull$$$0(5);
        }
        if (totalCommitsGrafted == null) {
            HgCherryPicker.$$$reportNull$$$0(6);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        HgGraftCommand command = new HgGraftCommand(project, repository);
        HgCommandResult result = command.startGrafting(hashes);
        boolean hasConflicts = HgConflictResolver.hasConflicts(project, root);
        if (!hasConflicts && HgErrorUtil.isCommandExecutionFailed(result)) {
            new HgCommandResultNotifier(project).notifyError("hg.graft.error", result, HgBundle.message("hg4idea.hg.error", new Object[0]), HgBundle.message("action.hg4idea.Graft.error", new Object[0]));
            return;
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        while (hasConflicts) {
            new HgConflictResolver(project, updatedFiles).resolve(root);
            hasConflicts = HgConflictResolver.hasConflicts(project, root);
            if (!hasConflicts) {
                result = command.continueGrafting();
                hasConflicts = HgConflictResolver.hasConflicts(project, root);
                continue;
            }
            new HgCommandResultNotifier(project).notifyError("hg.graft.continue.error", result, HgBundle.message("hg4idea.hg.error", new Object[0]), HgBundle.message("action.hg4idea.Graft.continue.error", new Object[0]));
            break;
        }
        if (!HgErrorUtil.isCommandExecutionFailed(result)) {
            totalCommitsGrafted.inc();
        }
        repository.update();
        root.refresh(true, true);
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            HgCherryPicker.$$$reportNull$$$0(7);
        }
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(this.myProject);
        return roots.stream().allMatch(r -> hgRepositoryManager.getRepositoryForRootQuick((VirtualFile)r) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/cherrypick/HgCherryPicker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "totalCommitsGrafted";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/cherrypick/HgCherryPicker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processGrafting";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canHandleForRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

