/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.collections.visualizer.jvm;

import com.intellij.debugger.collections.visualizer.core.backend.XCollectionAccessor;
import com.intellij.debugger.collections.visualizer.jvm.JvmArrayAccessor;
import com.intellij.debugger.collections.visualizer.jvm.JvmCollectionAccessorProvider;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/collections/visualizer/jvm/JvmArrayAccessorProvider;", "Lcom/intellij/debugger/collections/visualizer/jvm/JvmCollectionAccessorProvider;", "<init>", "()V", "isAcceptableType", "", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "createModelAccessor", "Lcom/intellij/debugger/collections/visualizer/core/backend/XCollectionAccessor;", "context", "intellij.debugger.collections.visualizer.jvm"})
public final class JvmArrayAccessorProvider
extends JvmCollectionAccessorProvider {
    @Override
    public boolean isAcceptableType(@NotNull EvaluationContextImpl evaluationContext, @NotNull ValueDescriptorImpl descriptor) {
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!descriptor.isArray()) {
            return false;
        }
        Value value = descriptor.getValue();
        ArrayReference arrayReference = value instanceof ArrayReference ? (ArrayReference)value : null;
        if (arrayReference == null) {
            return false;
        }
        ArrayReference value2 = arrayReference;
        return value2.length() > 0;
    }

    @Override
    @NotNull
    public XCollectionAccessor createModelAccessor(@NotNull EvaluationContextImpl context, @NotNull ValueDescriptorImpl descriptor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new JvmArrayAccessor(context, descriptor, null, 4, null);
    }
}

