/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.ErrorCode;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDiscoveryTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastDiscoveryTest.class);
    InetAddress sourceIaddress;
    int sourcePort;
    String stunServer;
    int stunServerPort;
    int timeoutInitValue = 300;
    MappedAddress ma = null;
    ChangedAddress ca = null;
    boolean nodeNatted = true;
    DatagramSocket socketTest1 = null;
    DiscoveryInfo di = null;
    static final int UNINITIALIZED = -1;
    static final int ERROR = 0;
    static final int CONNECTION_ESTABLISHED_NO_ERROR = 1;
    static final int CONNECTION_TIMEOUT = 2;

    public FastDiscoveryTest(InetAddress sourceIaddress, int sourcePort, String stunServer, int stunServerPort) {
        this.sourceIaddress = sourceIaddress;
        this.sourcePort = sourcePort;
        this.stunServer = stunServer;
        this.stunServerPort = stunServerPort;
    }

    public DiscoveryInfo test() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        this.ma = null;
        this.ca = null;
        this.nodeNatted = true;
        this.socketTest1 = null;
        this.di = new DiscoveryInfo(this.sourceIaddress);
        int returnTest2 = -1;
        int returnTest3 = -1;
        Test1Thread t1t = new Test1Thread(this);
        t1t.start();
        Test2Thread t2t = new Test2Thread(this);
        t2t.start();
        while (t1t.isAlive() || t2t.isAlive()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        boolean returnTest1 = t1t.getReturnTest1();
        if (returnTest1) {
            returnTest2 = this.test2();
            if (returnTest2 != -1) {
                if (returnTest2 == 1 && !this.nodeNatted) {
                    this.di.setOpenAccess();
                }
                if (returnTest2 == 1 && this.nodeNatted) {
                    this.di.setFullCone();
                }
                if (returnTest2 == 2 && !this.nodeNatted) {
                    this.di.setSymmetricUDPFirewall();
                }
            }
            if (returnTest2 == 2 && this.nodeNatted) {
                Test1RedoThread t1rt = new Test1RedoThread(this);
                t1rt.start();
                Test3Thread t3t = new Test3Thread(this);
                t3t.start();
                while (t1rt.isAlive() || t3t.isAlive()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (t1rt.getReturnTest1Redo() && (returnTest3 = t3t.getReturnTest3()) != -1) {
                    if (returnTest3 == 1 && this.nodeNatted) {
                        this.di.setRestrictedCone();
                    }
                    if (returnTest3 == 2) {
                        this.di.setPortRestrictedCone();
                    }
                }
            }
        }
        this.socketTest1.close();
        return this.di;
    }

    private boolean test1() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                this.socketTest1 = new DatagramSocket(new InetSocketAddress(this.sourceIaddress, this.sourcePort));
                this.socketTest1.setReuseAddress(true);
                this.socketTest1.connect(InetAddress.getByName(this.stunServer), this.stunServerPort);
                this.socketTest1.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                this.socketTest1.send(send);
                LOGGER.debug("Test 1: Binding Request sent.");
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    this.socketTest1.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                    receiveMH.parseAttributes(receive.getData());
                }
                this.ma = (MappedAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
                this.ca = (ChangedAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ChangedAddress);
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    LOGGER.debug("Message header contains an Errorcode message attribute.");
                    return false;
                }
                if (this.ma == null || this.ca == null) {
                    this.di.setError(700, "The server is sending an incomplete response (Mapped Address and Changed Address message attributes are missing). The client should not retry.");
                    LOGGER.debug("Response does not contain a Mapped Address or Changed Address message attribute.");
                    return false;
                }
                this.di.setPublicIP(this.ma.getAddress().getInetAddress());
                this.di.setPublicPort(this.ma.getPort());
                if (this.ma.getPort() == this.socketTest1.getLocalPort() && this.ma.getAddress().getInetAddress().equals(this.socketTest1.getLocalAddress())) {
                    LOGGER.debug("Node is not natted.");
                    this.nodeNatted = false;
                } else {
                    LOGGER.debug("Node is natted.");
                }
                return true;
            }
            catch (SocketTimeoutException ste) {
                if (timeSinceFirstTransmission < 300) {
                    LOGGER.debug("Test 1: Socket timeout while receiving the response.");
                    timeSinceFirstTransmission += timeout;
                    continue;
                }
                LOGGER.debug("Test 1: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                this.di.setBlockedUDP();
                LOGGER.debug("Node is not capable of UDP communication.");
                return false;
            }
            break;
        }
    }

    private int test2() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                DatagramSocket sendSocket = new DatagramSocket(new InetSocketAddress(this.sourceIaddress, this.sourcePort));
                sendSocket.connect(InetAddress.getByName(this.stunServer), this.stunServerPort);
                sendSocket.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                changeRequest.setChangeIP();
                changeRequest.setChangePort();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                sendSocket.send(send);
                LOGGER.debug("Test 2: Binding Request sent.");
                int localPort = sendSocket.getLocalPort();
                InetAddress localAddress = sendSocket.getLocalAddress();
                sendSocket.close();
                DatagramSocket receiveSocket = new DatagramSocket(localPort, localAddress);
                receiveSocket.connect(this.ca.getAddress().getInetAddress(), this.ca.getPort());
                receiveSocket.setSoTimeout(timeout);
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    receiveSocket.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                    receiveMH.parseAttributes(receive.getData());
                }
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    LOGGER.debug("Message header contains an Errorcode message attribute.");
                    return 0;
                }
                return 1;
            }
            catch (SocketTimeoutException ste) {
                if (timeSinceFirstTransmission < 300) {
                    LOGGER.debug("Test 2: Socket timeout while receiving the response.");
                    timeSinceFirstTransmission += timeout;
                    continue;
                }
                LOGGER.debug("Test 2: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                return 2;
            }
            break;
        }
    }

    private boolean test1Redo() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                this.socketTest1.connect(this.ca.getAddress().getInetAddress(), this.ca.getPort());
                this.socketTest1.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                this.socketTest1.send(send);
                LOGGER.debug("Test 1 redo with changed address: Binding Request sent.");
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    this.socketTest1.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                    receiveMH.parseAttributes(receive.getData());
                }
                MappedAddress ma2 = (MappedAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    LOGGER.debug("Message header contains an Errorcode message attribute.");
                    return false;
                }
                if (ma2 == null) {
                    this.di.setError(700, "The server is sending an incomplete response (Mapped Address message attribute is missing). The client should not retry.");
                    LOGGER.debug("Response does not contain a Mapped Address message attribute.");
                    return false;
                }
                if (this.ma.getPort() != ma2.getPort() || !this.ma.getAddress().getInetAddress().equals(ma2.getAddress().getInetAddress())) {
                    this.di.setSymmetric();
                    LOGGER.debug("Node is behind a symmetric NAT.");
                    return false;
                }
                return true;
            }
            catch (SocketTimeoutException ste2) {
                if (timeSinceFirstTransmission < 300) {
                    LOGGER.debug("Test 1 redo with changed address: Socket timeout while receiving the response.");
                    timeSinceFirstTransmission += timeout;
                    continue;
                }
                LOGGER.debug("Test 1 redo with changed address: Socket timeout while receiving the response.  Maximum retry limit exceed. Give up.");
                return false;
            }
            break;
        }
    }

    private int test3() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                DatagramSocket sendSocket = new DatagramSocket(new InetSocketAddress(this.sourceIaddress, this.sourcePort));
                sendSocket.connect(InetAddress.getByName(this.stunServer), this.stunServerPort);
                sendSocket.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                changeRequest.setChangePort();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                sendSocket.send(send);
                LOGGER.debug("Test 3: Binding Request sent.");
                int localPort = sendSocket.getLocalPort();
                InetAddress localAddress = sendSocket.getLocalAddress();
                sendSocket.close();
                DatagramSocket receiveSocket = new DatagramSocket(localPort, localAddress);
                receiveSocket.connect(InetAddress.getByName(this.stunServer), this.ca.getPort());
                receiveSocket.setSoTimeout(timeout);
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    receiveSocket.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                    receiveMH.parseAttributes(receive.getData());
                }
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    LOGGER.debug("Message header contains an Errorcode message attribute.");
                    return 0;
                }
                return 1;
            }
            catch (SocketTimeoutException ste) {
                if (timeSinceFirstTransmission < 300) {
                    LOGGER.debug("Test 3: Socket timeout while receiving the response.");
                    timeSinceFirstTransmission += timeout;
                    continue;
                }
                LOGGER.debug("Test 3: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                return 2;
            }
            break;
        }
    }

    public class Test3Thread
    extends Thread {
        private FastDiscoveryTest fdt;
        private int returnTest3;

        public Test3Thread(FastDiscoveryTest fdt) {
            this.fdt = fdt;
        }

        @Override
        public void run() {
            try {
                this.returnTest3 = this.fdt.test3();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getReturnTest3() {
            return this.returnTest3;
        }
    }

    public class Test1RedoThread
    extends Thread {
        private FastDiscoveryTest fdt;
        private boolean returnTest1Redo;

        public Test1RedoThread(FastDiscoveryTest fdt) {
            this.fdt = fdt;
        }

        @Override
        public void run() {
            try {
                this.returnTest1Redo = this.fdt.test1Redo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean getReturnTest1Redo() {
            return this.returnTest1Redo;
        }
    }

    public class Test2Thread
    extends Thread {
        private FastDiscoveryTest fdt;
        private int returnTest2;

        public Test2Thread(FastDiscoveryTest fdt) {
            this.fdt = fdt;
        }

        @Override
        public void run() {
            try {
                this.returnTest2 = this.fdt.test2();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getReturnTest2() {
            return this.returnTest2;
        }
    }

    public class Test1Thread
    extends Thread {
        private FastDiscoveryTest fdt;
        private boolean returnTest1;

        public Test1Thread(FastDiscoveryTest fdt) {
            this.fdt = fdt;
        }

        @Override
        public void run() {
            try {
                this.returnTest1 = this.fdt.test1();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean getReturnTest1() {
            return this.returnTest1;
        }
    }
}

