/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.lsp.TypeScriptGoEmbeddedService;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNodePackageWrapper {
    public static final String BUNDLED = "Bundled";
    public static final String TS_GO_FORK = "TS-Go JetBrains Fork";
    @NotNull
    private final NodeJsInterpreterField myInterpreterField;
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final NodePackageField myField;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeScriptNodePackageDescriptor myDescriptor;

    @NotNull
    public static TypeScriptNodePackageDescriptor createDescriptor(@Nullable Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(0);
        }
        String libVersion = TypeScriptLibraryProvider.getVersion((Project)project);
        NodePackage bundledVersion = TypeScriptNodePackageWrapper.createBundledVersion(project, libVersion);
        TypeScriptCompilerSettings.TypeScriptCompilerVersionType type2 = settings.getVersionType();
        String customPackagePath = type2 == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY ? TypeScriptNodePackageWrapper.removeExactLibPrefix(settings.getTypeScriptServiceDirectory()) : null;
        return new TypeScriptNodePackageDescriptor(bundledVersion, customPackagePath);
    }

    @NotNull
    public static NodePackage createBundledVersion(Project project, String libVersion) {
        String path2 = TypeScriptCompilerSettings.getSettings(project).getDefaultTypeScriptServiceDirectory();
        return new EmbeddedTypeScriptNodePackage(path2, libVersion);
    }

    @NotNull
    public static NodePackage createBundledTsGoFork() {
        return new EmbeddedTypeScriptGoNodePackage();
    }

    @NotNull
    public NodePackageField getField() {
        NodePackageField nodePackageField = this.myField;
        if (nodePackageField == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(1);
        }
        return nodePackageField;
    }

    public TypeScriptNodePackageWrapper(@NotNull Project project, @NotNull NodeJsInterpreterField interpreterField2, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(2);
        }
        if (interpreterField2 == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(4);
        }
        this.myDescriptor = TypeScriptNodePackageWrapper.createDescriptor(project, settings);
        this.myField = new NodePackageField(interpreterField2, this.myDescriptor, null);
        this.myProject = project;
        this.myInterpreterField = interpreterField2;
        this.mySettings = settings;
    }

    public boolean isModified() {
        return !TypeScriptNodePackageWrapper.getPackageFromSettings(this.myProject, this.myDescriptor, this.mySettings, this.myInterpreterField.getInterpreter()).equals(this.myField.getSelected());
    }

    public void reset() {
        this.myField.setSelected(TypeScriptNodePackageWrapper.getPackageFromSettings(this.myProject, this.myDescriptor, this.mySettings, this.myInterpreterField.getInterpreter()));
    }

    public void apply() throws ConfigurationException {
        NodePackage selected = this.myField.getSelected();
        if (!selected.isValid()) {
            throw new ConfigurationException(JavaScriptBundle.message((String)"dialog.message.incorrect.path.to.typescript.package", (Object[])new Object[0]));
        }
        NodePackage firstPackage = this.myDescriptor.getDefaultPackage(this.myProject);
        if (selected.equals(firstPackage)) {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED_OR_DETECTED);
            this.mySettings.setTypeScriptServiceDirectory(null);
        } else if (selected instanceof EmbeddedTypeScriptNodePackage) {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED);
            this.mySettings.setTypeScriptServiceDirectory(null);
        } else if (selected instanceof EmbeddedTypeScriptGoNodePackage) {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED_TS_GO);
            this.mySettings.setTypeScriptServiceDirectory(null);
        } else {
            this.mySettings.setVersionType(TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY);
            this.mySettings.setTypeScriptServiceDirectory(selected.getSystemIndependentPath());
        }
    }

    @NotNull
    public static NodePackage getPackageFromSettings(@NotNull Project project, @NotNull NodePackageDescriptor descriptor, @NotNull TypeScriptCompilerSettings settings, @Nullable NodeJsInterpreter interpreter2) {
        TypeScriptCompilerSettings.TypeScriptCompilerVersionType type2;
        if (project == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(7);
        }
        if ((type2 = settings.getVersionType()) == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED) {
            NodePackage nodePackage = descriptor.createPackage(BUNDLED);
            if (nodePackage == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(8);
            }
            return nodePackage;
        }
        if (type2 == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED_TS_GO) {
            NodePackage nodePackage = descriptor.createPackage(TS_GO_FORK);
            if (nodePackage == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(9);
            }
            return nodePackage;
        }
        if (type2 == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.SERVICE_DIRECTORY) {
            NodePackage nodePackage = descriptor.createPackage(TypeScriptNodePackageWrapper.removeExactLibPrefix(settings.getTypeScriptServiceDirectory()));
            if (nodePackage == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(10);
            }
            return nodePackage;
        }
        AccessToken ignore = SlowOperations.knownIssue((String)"WEB-69425");
        NodePackage nodePackage = descriptor.findFirstDirectDependencyPackage(project, interpreter2, null);
        NodePackage nodePackage2 = nodePackage;
        if (nodePackage2 == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(11);
        }
        return nodePackage2;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    @NotNull
    private static String removeExactLibPrefix(@Nullable String path2) {
        if (path2 == null) {
            return "";
        }
        String fixedPath = StringUtil.trimEnd((String)path2, (String)"/");
        String fileName = PathUtil.getFileName((String)fixedPath);
        if ("lib".equals(fileName)) {
            String string = StringUtil.notNullize((String)PathUtil.getParentPath((String)path2));
            if (string == null) {
                TypeScriptNodePackageWrapper.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = fixedPath;
        if (string == null) {
            TypeScriptNodePackageWrapper.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getField";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFromSettings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeExactLibPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFromSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static final class TypeScriptNodePackageDescriptor
    extends NodePackageDescriptor {
        @Nullable
        private final String myCustomPackagePath;
        @NotNull
        private final NodePackage myBundledVersion;
        @NotNull
        private final NodePackage myBundledTsGoFork;

        private TypeScriptNodePackageDescriptor(@NotNull NodePackage bundledVersion, @Nullable String customPackagePath) {
            String[] stringArray;
            if (bundledVersion == null) {
                TypeScriptNodePackageDescriptor.$$$reportNull$$$0(0);
            }
            if (TypeScriptGoPackageInfoKt.isTypeScriptGoEnabled()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "typescript";
                stringArray = stringArray2;
                stringArray2[1] = "@typescript/native-preview";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "typescript";
            }
            super(stringArray);
            this.myBundledTsGoFork = TypeScriptNodePackageWrapper.createBundledTsGoFork();
            this.myCustomPackagePath = customPackagePath;
            this.myBundledVersion = bundledVersion;
        }

        @Override
        @NotNull
        public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
            if (project == null) {
                TypeScriptNodePackageDescriptor.$$$reportNull$$$0(1);
            }
            LinkedHashSet<NodePackage> results = new LinkedHashSet<NodePackage>();
            if (this.myCustomPackagePath != null) {
                results.add(this.createPackage(this.myCustomPackagePath));
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                NodeJsInterpreter forSearchingGlobalPackages = !directDependenciesInsideProject ? interpreter2 : null;
                results.addAll(super.listAvailable(project, forSearchingGlobalPackages, contextFileOrDirectory, directDependenciesInsideProject));
            }
            results.add(this.myBundledVersion);
            results.add(this.myBundledTsGoFork);
            return new ArrayList<NodePackage>(results);
        }

        @NotNull
        public NodePackage getDefaultPackage(@NotNull Project project) {
            List<NodePackage> packages;
            NodePackage defaultPackage;
            if (project == null) {
                TypeScriptNodePackageDescriptor.$$$reportNull$$$0(2);
            }
            NodePackage nodePackage = (defaultPackage = (NodePackage)ContainerUtil.getFirstItem(packages = super.listAvailable(project, null, null, true))) == null ? this.myBundledVersion : defaultPackage;
            if (nodePackage == null) {
                TypeScriptNodePackageDescriptor.$$$reportNull$$$0(3);
            }
            return nodePackage;
        }

        @Override
        @NotNull
        public NodePackage createPackage(@NotNull String path2) {
            if (path2 == null) {
                TypeScriptNodePackageDescriptor.$$$reportNull$$$0(4);
            }
            if (TypeScriptNodePackageWrapper.BUNDLED.equals(path2)) {
                NodePackage nodePackage = this.myBundledVersion;
                if (nodePackage == null) {
                    TypeScriptNodePackageDescriptor.$$$reportNull$$$0(5);
                }
                return nodePackage;
            }
            if (TypeScriptNodePackageWrapper.TS_GO_FORK.equals(path2)) {
                NodePackage nodePackage = this.myBundledTsGoFork;
                if (nodePackage == null) {
                    TypeScriptNodePackageDescriptor.$$$reportNull$$$0(6);
                }
                return nodePackage;
            }
            NodePackage nodePackage = super.createPackage(path2);
            if (nodePackage == null) {
                TypeScriptNodePackageDescriptor.$$$reportNull$$$0(7);
            }
            return nodePackage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundledVersion";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$TypeScriptNodePackageDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$TypeScriptNodePackageDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultPackage";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "listAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultPackage";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createPackage";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class EmbeddedTypeScriptNodePackage
    extends NodePackage {
        private final String myVersion;

        EmbeddedTypeScriptNodePackage(@NotNull String libDirectory, @NotNull String libVersion) {
            if (libDirectory == null) {
                EmbeddedTypeScriptNodePackage.$$$reportNull$$$0(0);
            }
            if (libVersion == null) {
                EmbeddedTypeScriptNodePackage.$$$reportNull$$$0(1);
            }
            super(libDirectory);
            this.myVersion = libVersion;
        }

        @Override
        @NotNull
        public String getPresentablePath() {
            String string = JavaScriptBundle.message((String)"typescript.compiler.configurable.options.version.bundled", (Object[])new Object[0]);
            if (string == null) {
                EmbeddedTypeScriptNodePackage.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public SemVer getVersion() {
            return SemVer.parseFromText((String)this.myVersion);
        }

        @Override
        public boolean isBundled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libVersion";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$EmbeddedTypeScriptNodePackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$EmbeddedTypeScriptNodePackage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class EmbeddedTypeScriptGoNodePackage
    extends NodePackage {
        private EmbeddedTypeScriptGoNodePackage() {
            super(TypeScriptGoEmbeddedService.Companion.get().getEmbeddedTSGoTargetPath(true));
        }

        @Override
        @NotNull
        public String getPresentablePath() {
            String string = JavaScriptBundle.message((String)"typescript.compiler.configurable.options.version.bundled.tsGoFork", (Object[])new Object[0]);
            if (string == null) {
                EmbeddedTypeScriptGoNodePackage.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public SemVer getVersion() {
            return SemVer.parseFromText((String)TypeScriptGoEmbeddedService.Companion.get().getEmbeddedTSGoVersion());
        }

        @Override
        public boolean isBundled() {
            return true;
        }

        public void download(Project project) throws IOException {
            TypeScriptGoEmbeddedService.Companion.get().downloadEmbeddedTSGo(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptNodePackageWrapper$EmbeddedTypeScriptGoNodePackage", "getPresentablePath"));
        }
    }
}

