/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.history.VcsLogFileHistoryUiProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\u001a\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u001a2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a8\u0006\u0012"}, d2={"isNewHistoryEnabled", "", "isNewFileHistoryAvailable", "project", "Lcom/intellij/openapi/project/Project;", "logProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "selectRowWhenOpen", "", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "firstTime", "intellij.platform.vcs.log.impl"})
public final class VcsLogFileHistoryUiProviderKt {
    @ApiStatus.Internal
    public static final boolean isNewHistoryEnabled() {
        return Registry.Companion.is("vcs.new.history");
    }

    @ApiStatus.Internal
    public static final boolean isNewFileHistoryAvailable(@NotNull Project project, @Nullable VcsLogProvider logProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VcsLogProvider vcsLogProvider = logProvider;
        return (vcsLogProvider != null ? vcsLogProvider.getDiffHandler() : null) != null && logProvider.getFileHistoryHandler(project) != null;
    }

    private static final void selectRowWhenOpen(VcsLogManager logManager, Hash hash, VirtualFile root, VcsLogUiEx ui, boolean firstTime) {
        if (hash != null) {
            VcsLogFileHistoryUiProvider.Companion.jumpToNearestCommit(ui, logManager.getDataManager().getStorage(), hash, root, true);
        } else if (firstTime) {
            VcsLogNavigationUtil.jumpToGraphRow(ui, 0, true, true);
        }
    }

    public static final /* synthetic */ void access$selectRowWhenOpen(VcsLogManager logManager, Hash hash, VirtualFile root, VcsLogUiEx ui, boolean firstTime) {
        VcsLogFileHistoryUiProviderKt.selectRowWhenOpen(logManager, hash, root, ui, firstTime);
    }
}

