/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.detection.DocumentChangeKindDetector;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.dev.ProvenanceDevRegistry;
import com.intellij.code.provenance.dev.listeners.UnknownEventStackTraceListener;
import com.intellij.code.provenance.dev.listeners.UnknownEventStackTraceListenerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/code/provenance/dev/listeners/UnknownEventStackTraceListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorTypeSupported", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.code.provenance.dev"})
public final class UnknownEventStackTraceListener
implements EditorFactoryListener {
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Project project;
        Editor editor;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled() || !ProvenanceDevRegistry.INSTANCE.getEnabledDevModule()) {
                    return;
                }
                if (!ProvenanceDevRegistry.INSTANCE.getShouldGenerateStackTraceForUnknownEvents()) {
                    return;
                }
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                editor = editor2;
                project = editor.getProject();
                if (project == null || editor.isDisposed() || !this.editorTypeSupported(editor) && !ApplicationKt.getApplication().isUnitTestMode()) break block6;
                Project project2 = editor.getProject();
                if (project2 != null ? !project2.isDisposed() : false) break block7;
            }
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        Object object = virtualFile;
        if (object == null || (object = object.getPath()) == null) {
            object = "Unknown";
        }
        Object filePath = object;
        Disposable disposable = UtilsKt.newEditorDisposable((Editor)editor, null);
        editor.getDocument().addDocumentListener((DocumentListener)new BulkAwareDocumentListener(project, editor, virtualFile, (String)filePath){
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ String $filePath;
            {
                this.$project = $project;
                this.$editor = $editor;
                this.$virtualFile = $virtualFile;
                this.$filePath = $filePath;
            }

            public void documentChanged(DocumentEvent documentEvent) {
                Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
                if (!ProvenanceDevRegistry.INSTANCE.getShouldGenerateStackTraceForUnknownEvents()) {
                    return;
                }
                DocumentChangesKind kind = DocumentChangeKindDetector.INSTANCE.detect(this.$project, this.$editor, this.$virtualFile, documentEvent);
                if (kind == DocumentChangesKind.UNKNOWN) {
                    Object[] stackTrace = Thread.currentThread().getStackTrace();
                    Intrinsics.checkNotNull((Object)stackTrace);
                    String stackTraceString = ArraysKt.joinToString$default((Object[])stackTrace, (CharSequence)"\n", null, null, (int)0, null, editorCreated.1::documentChanged$lambda$0, (int)30, null);
                    Logger logger = UnknownEventStackTraceListenerKt.access$getLOG$p();
                    int n = documentEvent.getOffset();
                    int n2 = documentEvent.getOldLength();
                    CharSequence charSequence = documentEvent.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    logger.warn(StringsKt.trimMargin$default((String)("\n            |Unknown document change event detected:\n            |  File: " + this.$filePath + "\n            |  Offset: " + n + "\n            |  Old length: " + n2 + "\n            |  New fragment: " + StringsKt.take((CharSequence)charSequence, (int)100) + (documentEvent.getNewFragment().length() > 100 ? "..." : "") + "\n            |Stack trace:\n            |" + stackTraceString + "\n          "), null, (int)1, null));
                }
            }

            private static final CharSequence documentChanged$lambda$0(StackTraceElement it) {
                return "  at " + it;
            }
        }, disposable);
    }

    private final boolean editorTypeSupported(Editor editor) {
        return editor.getEditorKind() == EditorKind.MAIN_EDITOR;
    }
}

