/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.action;

import com.intellij.flyway.FlywayCreator;
import com.intellij.flyway.FlywayHelper;
import com.intellij.flyway.action.FlywayAction;
import com.intellij.flyway.action.FlywayVersionedCreationDialog;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jpa.jpb.model.action.ActionUtilsKt;
import com.intellij.jpa.jpb.model.action.StructureKeys;
import com.intellij.jpa.jpb.model.action.creation.EventDataProviderEP;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.liquibase.common.util.SqlActionUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PsiNavigateUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/flyway/action/CreateFlywayVersionedAction;", "Lcom/intellij/flyway/action/FlywayAction;", "<init>", "()V", "doActionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "flywayActionUpdate", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.flyway"})
public class CreateFlywayVersionedAction
extends FlywayAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "CreateFlywayVersioned";

    protected void doActionPerformed(@NotNull AnActionEvent e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FlywayVersionedCreationDialog dialog2 = new FlywayVersionedCreationDialog(project, FlywayHelper.Companion.getInstance(project).generateChangelogDirPath(e), this.getSelectedDirectory(e));
        if (!dialog2.showAndGet()) {
            return;
        }
        String fileName = dialog2.getFileNameWithoutExt();
        FlywayCreator flywayCreator = FlywayCreator.Companion.getInstance(project);
        PsiDirectory psiDirectory = dialog2.getDirectory();
        Intrinsics.checkNotNull((Object)psiDirectory);
        PsiFile dbChangeLogFile = FlywayCreator.createMigrationFile$default(flywayCreator, psiDirectory, fileName, null, 4, null);
        if (dbChangeLogFile != null) {
            PsiNavigateUtil.navigate((PsiElement)((PsiElement)dbChangeLogFile));
        }
    }

    @Override
    public void flywayActionUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        Object entities;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabledAndVisible(false);
        if (this.isActionInPlace(e, "DatabaseViewPopup")) {
            e.getPresentation().setEnabledAndVisible(FlywayHelper.Companion.isFlywaySupported(project) && EventDataProviderEP.Companion.getAGGREGATOR_NOT_DEFAULT().getRdbmsDataStore(e) != null && OrmUtil.INSTANCE.isAnyEntityInProject(project));
            return;
        }
        if (EventDataProviderEP.Companion.getAGGREGATOR().isGlobalActionPlace(e) || this.isActionInPlaces(e, stringArray = new String[]{"EditorToolbar"})) {
            presentation2.setEnabledAndVisible(OrmUtil.INSTANCE.isAnyEntityInProject(project));
            return;
        }
        if (!FlywayHelper.Companion.isFlywaySupported(project)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        stringArray = new String[]{"ICON_NAVIGATION_SECONDARY_BUTTON", "ICON_NAVIGATION"};
        if (this.isActionInPlaces(e, stringArray)) {
            entities = ActionUtilsKt.getActionOrmEntities((AnActionEvent)e, (List)OrmDiffModelProvider.Companion.getSupportedFrameworks(project), (boolean)true);
            e.getPresentation().setEnabledAndVisible(OrmUtil.INSTANCE.hasPersistentEntity((Iterable)entities));
            return;
        }
        entities = new String[]{"GoToAction", "EditorToolbar", "IntentionMenu", "ToolwindowTitle"};
        if (this.isActionInPlaces(e, (String[])entities)) {
            entities = ActionUtilsKt.getActionOrmEntities$default((AnActionEvent)e, (List)OrmDiffModelProvider.Companion.getSupportedFrameworks(project), (boolean)false, (int)4, null);
            e.getPresentation().setEnabledAndVisible(OrmUtil.INSTANCE.hasPersistentEntity((Iterable)entities));
            return;
        }
        if (ActionUtilsKt.isEntitiesSelectedInTree((AnActionEvent)e)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        OrmFramework ormFramework = (OrmFramework)e.getData(StructureKeys.ORM_FRAMEWORK);
        if (ormFramework != null) {
            e.getPresentation().setEnabledAndVisible(OrmDiffModelProvider.Companion.findForFramework(ormFramework) != null);
            return;
        }
        NodeDescriptor nodeDescriptor = (NodeDescriptor)e.getData(StructureKeys.STRUCTURE_NODE);
        if (nodeDescriptor != null) {
            NodeDescriptor it = nodeDescriptor;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(SqlActionUtils.INSTANCE.isLiquibaseStructureNode(it) && OrmUtil.INSTANCE.isAnyEntityInProject(project));
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null) {
            JpsModuleSourceRootType[] jpsModuleSourceRootTypeArray = new JpsModuleSourceRootType[2];
            Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.RESOURCE, (String)"RESOURCE");
            Intrinsics.checkNotNullExpressionValue((Object)JavaResourceRootType.TEST_RESOURCE, (String)"TEST_RESOURCE");
            presentation2.setEnabledAndVisible(ActionUtilsKt.isUnderSourceRootOfType((AnActionEvent)e, (JpsModuleSourceRootType[])jpsModuleSourceRootTypeArray) && FlywayHelper.Companion.isFlywaySupported(project) && OrmUtil.INSTANCE.isAnyEntityInProject(project));
        }
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/flyway/action/CreateFlywayVersionedAction$Companion;", "", "<init>", "()V", "ID", "", "intellij.flyway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

