/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.impl.SharedIndexInfrastructure;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexVersionInfo;
import com.intellij.util.indexing.IndexInfrastructureVersionBase;
import com.intellij.util.indexing.TodoIndexId;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedIndexInfrastructureVersion
extends IndexInfrastructureVersionBase {
    public static final String SHARED_INDEXES_VERSIONS_FORMAT_VERSION = String.valueOf(SharedIndexInfrastructure.SHARED_INDEX_INFRASTRUCTURE_VERSION);
    private final SortedMap<IndexInfrastructureCapability, Map<String, String>> myCapabilities;
    private final SortedSet<IndexInfrastructureOs> mySupportedOs;
    private final SortedMap<String, String> myHashProviderVersions;
    private static final Set<String> outDatedIndexNames = ContainerUtil.newHashSet((Object[])new String[]{TodoIndexId.INSTANCE.getName().getName(), FilenameIndex.NAME.getName()});

    public SharedIndexInfrastructureVersion(@NotNull Map<IndexInfrastructureCapability, Map<String, String>> capabilities, @NotNull Set<IndexInfrastructureOs> supportedOs, @NotNull Map<String, String> baseIndexes, @NotNull Map<String, FileBasedIndexVersionInfo> fileBasedIndexVersions, @NotNull Map<String, String> stubIndexVersions, @NotNull Map<String, String> stubFileElementTypeVersions, @NotNull Map<String, String> compositeBinaryStubFileBuilderVersions, @NotNull Map<String, String> hashProviderVersions) {
        if (capabilities == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(0);
        }
        if (supportedOs == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(1);
        }
        if (baseIndexes == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(2);
        }
        if (fileBasedIndexVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(3);
        }
        if (stubIndexVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(4);
        }
        if (stubFileElementTypeVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(5);
        }
        if (compositeBinaryStubFileBuilderVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(6);
        }
        if (hashProviderVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(7);
        }
        super(baseIndexes, fileBasedIndexVersions, stubIndexVersions, stubFileElementTypeVersions, compositeBinaryStubFileBuilderVersions);
        this.mySupportedOs = ImmutableSortedSet.copyOf(supportedOs);
        this.myHashProviderVersions = ImmutableSortedMap.copyOf(hashProviderVersions);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<IndexInfrastructureCapability, Map<String, String>> entry : capabilities.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableSortedMap.copyOf(entry.getValue()));
        }
        this.myCapabilities = builder.build();
    }

    @NotNull
    public static SharedIndexInfrastructureVersion getIdeVersion() {
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = new IdeSharedIndexesState().getIndexVersion();
        if (sharedIndexInfrastructureVersion == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(8);
        }
        return sharedIndexInfrastructureVersion;
    }

    public String toString() {
        return "IndexInfrastructureVersion{base=" + String.valueOf(this.myBaseIndexes) + ", capabilities=" + String.valueOf(this.myCapabilities) + ", fileIndex=" + String.valueOf(this.myFileBasedIndexVersions) + ", stubIndex=" + String.valueOf(this.myStubIndexVersions) + ", stubFilesElementTypeVersions=" + String.valueOf(this.myStubFileElementTypeVersions) + ", compositeBinaryStubFileBuilderVersions=" + String.valueOf(this.myCompositeBinaryStubFileBuilderVersions) + ", supportedOs=" + String.valueOf(this.mySupportedOs) + "}";
    }

    @NotNull
    public String getWeakVersionHash() {
        return SharedIndexInfrastructureVersion.computeWeakHash(Arrays.asList(this.getBaseIndexes(), this.getFileBasedIndexVersions(), this.getStubIndexVersions(), this.getStubFileElementTypeVersions(), this.getCompositeBinaryStubFileBuilderVersions()));
    }

    @NotNull
    private static String computeWeakHash(@NotNull List<Map<String, String>> maps) {
        if (maps == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(9);
        }
        Hasher hasher = Hashing.sha256().newHasher();
        for (Map<String, String> versions : maps) {
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(versions).entrySet()) {
                hasher.putString((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)entry.getValue(), StandardCharsets.UTF_8);
            }
        }
        String string = StringUtil.first((String)hasher.hash().toString(), (int)12, (boolean)false);
        if (string == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getBaseIndexes() {
        SortedMap sortedMap = this.myBaseIndexes;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(11);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getFileBasedIndexVersions() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry e : this.myFileBasedIndexVersions.entrySet()) {
            builder.put((Object)((String)e.getKey()), (Object)((FileBasedIndexVersionInfo)e.getValue()).getVersion());
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(12);
        }
        return immutableSortedMap;
    }

    @NotNull
    public Map<String, Boolean> getFileBasedIndexThatNeedsForwardIndex() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry e : this.myFileBasedIndexVersions.entrySet()) {
            builder.put((Object)((String)e.getKey()), (Object)((FileBasedIndexVersionInfo)e.getValue()).getNeedsForwardIndex());
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(13);
        }
        return immutableSortedMap;
    }

    @NotNull
    public Map<String, FileBasedIndexVersionInfo> getFileBasedIndexVersionInfos() {
        SortedMap sortedMap = this.myFileBasedIndexVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(14);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getStubIndexVersions() {
        SortedMap sortedMap = this.myStubIndexVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(15);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getStubFileElementTypeVersions() {
        SortedMap sortedMap = this.myStubFileElementTypeVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(16);
        }
        return sortedMap;
    }

    @NotNull
    public SortedMap<String, String> getCompositeBinaryStubFileBuilderVersions() {
        SortedMap sortedMap = this.myCompositeBinaryStubFileBuilderVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(17);
        }
        return sortedMap;
    }

    @NotNull
    public Map<IndexInfrastructureCapability, Map<String, String>> getCapabilities() {
        SortedMap<IndexInfrastructureCapability, Map<String, String>> sortedMap = this.myCapabilities;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(18);
        }
        return sortedMap;
    }

    @NotNull
    public Set<IndexInfrastructureOs> getSupportedOs() {
        SortedSet<IndexInfrastructureOs> sortedSet = this.mySupportedOs;
        if (sortedSet == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(19);
        }
        return sortedSet;
    }

    @NotNull
    public Map<String, String> getHashProviderVersions() {
        SortedMap<String, String> sortedMap = this.myHashProviderVersions;
        if (sortedMap == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(20);
        }
        return sortedMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SharedIndexInfrastructureVersion version = (SharedIndexInfrastructureVersion)((Object)o);
        return this.myBaseIndexes.equals(version.myBaseIndexes) && this.myFileBasedIndexVersions.equals(version.myFileBasedIndexVersions) && this.myStubIndexVersions.equals(version.myStubIndexVersions) && this.myStubFileElementTypeVersions.equals(version.myStubFileElementTypeVersions) && this.myCompositeBinaryStubFileBuilderVersions.equals(version.myCompositeBinaryStubFileBuilderVersions) && this.myCapabilities.equals(version.myCapabilities) && this.mySupportedOs.equals(version.mySupportedOs);
    }

    public int hashCode() {
        return Objects.hash(this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myCapabilities, this.mySupportedOs, this.myStubFileElementTypeVersions, this.myCompositeBinaryStubFileBuilderVersions);
    }

    public boolean isSuitableMetadata(@NotNull SharedIndexMetadata metadata) {
        if (metadata == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(21);
        }
        return this.pickBestSuitableMetadata(Collections.singletonList(metadata)) == metadata;
    }

    @Nullable
    public SharedIndexMetadata pickBestSuitableMetadata(@NotNull Collection<SharedIndexMetadata> metadataCollection) {
        if (metadataCollection == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(22);
        }
        long bestSameWeakHashScore = -1L;
        SharedIndexMetadata bestSameWeakHashMetadata = null;
        long bestScore = -1L;
        SharedIndexMetadata bestMetadata = null;
        for (SharedIndexMetadata metadata : metadataCollection) {
            long versionScore;
            SharedIndexInfrastructureVersion version = metadata.getIndexInfrastructureVersion();
            if (!version.getSupportedOs().containsAll(this.getSupportedOs()) || !version.getBaseIndexes().equals(this.getBaseIndexes())) continue;
            if (version.getWeakVersionHash().equals(this.getWeakVersionHash())) {
                versionScore = SharedIndexInfrastructureVersion.isTurbochargedProjectIndex(metadata) ? metadata.getGenerationTime().toEpochSecond() : (long)this.calculateIndexedFileScore(metadata);
                if (bestSameWeakHashScore >= versionScore) continue;
                bestSameWeakHashScore = versionScore;
                bestSameWeakHashMetadata = metadata;
                continue;
            }
            if (!SharedIndexInfrastructureVersion.hasEnoughIntersection(this.getFileBasedIndexVersions(), version.getFileBasedIndexVersions()) || !SharedIndexInfrastructureVersion.hasEnoughIntersection(this.getStubIndexVersions(), version.getStubIndexVersions()) || !SharedIndexInfrastructureVersion.hasEnoughIntersection(this.getStubFileElementTypeVersions(), version.getStubFileElementTypeVersions()) || bestScore >= (versionScore = SharedIndexInfrastructureVersion.isTurbochargedProjectIndex(metadata) ? metadata.getGenerationTime().toEpochSecond() : (long)this.calculateIndexedFileScore(metadata))) continue;
            bestScore = versionScore;
            bestMetadata = metadata;
        }
        return bestSameWeakHashMetadata != null ? bestSameWeakHashMetadata : bestMetadata;
    }

    private static boolean isTurbochargedProjectIndex(@NotNull SharedIndexMetadata metadata) {
        if (metadata == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(23);
        }
        return "project-turbocharged".equals(metadata.getIndexKind());
    }

    private static boolean hasEnoughIntersection(@NotNull Map<String, String> current, @NotNull Map<String, String> other) {
        int common;
        if (current == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(24);
        }
        if (other == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(25);
        }
        return (common = Sets.intersection(other.entrySet(), current.entrySet()).size()) > Math.max(3, current.size() / 4);
    }

    private int calculateIndexedFileScore(@NotNull SharedIndexMetadata metadata) {
        if (metadata == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(26);
        }
        SharedIndexInfrastructureVersion version = metadata.getIndexInfrastructureVersion();
        int stubFileElementsScore = 0;
        for (Map.Entry<String, String> entry : this.getStubFileElementTypeVersions().entrySet()) {
            stubFileElementsScore += SharedIndexInfrastructureVersion.calculateIndexedFileScore(entry, version.getStubFileElementTypeVersions(), metadata.getGenerationStatistics().getStubFileElementTypeUsages());
        }
        int fileBasedIndexScore = 0;
        for (Map.Entry<String, String> entry : this.getFileBasedIndexVersions().entrySet()) {
            if (outDatedIndexNames.contains(entry.getKey())) continue;
            fileBasedIndexScore += SharedIndexInfrastructureVersion.calculateIndexedFileScore(entry, version.getFileBasedIndexVersions(), metadata.getGenerationStatistics().getFileBasedIndexUsages());
        }
        return fileBasedIndexScore + stubFileElementsScore;
    }

    private static int calculateIndexedFileScore(@NotNull Map.Entry<String, String> indexAndVersion, @NotNull Map<String, String> otherVersions, @NotNull Map<String, Integer> otherUsages) {
        String otherVersion;
        if (indexAndVersion == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(27);
        }
        if (otherVersions == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(28);
        }
        if (otherUsages == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(29);
        }
        String name = indexAndVersion.getKey();
        String currentVersion = indexAndVersion.getValue();
        if (!currentVersion.equals(otherVersion = otherVersions.get(name))) {
            return 0;
        }
        return otherUsages.getOrDefault(name, 0);
    }

    public boolean isStubIndexVersionMatch(@NotNull SharedIndexInfrastructureVersion version) {
        boolean hasMismatchingStubIndexVersions;
        if (version == null) {
            SharedIndexInfrastructureVersion.$$$reportNull$$$0(30);
        }
        boolean bl = hasMismatchingStubIndexVersions = !Maps.difference(version.getStubIndexVersions(), this.getStubIndexVersions()).entriesDiffering().isEmpty();
        return !hasMismatchingStubIndexVersions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilities";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedOs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndexes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexVersions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexVersions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubFileElementTypeVersions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeBinaryStubFileBuilderVersions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashProviderVersions";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maps";
                break;
            }
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataCollection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexAndVersion";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherVersions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherUsages";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWeakHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndexes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexThatNeedsForwardIndex";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersionInfos";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndexVersions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeVersions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeBinaryStubFileBuilderVersions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOs";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashProviderVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeWeakHash";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableMetadata";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "pickBestSuitableMetadata";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTurbochargedProjectIndex";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasEnoughIntersection";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexedFileScore";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isStubIndexVersionMatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

