/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.inspections.UpdateMavenWrapper;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.MavenWrapper;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\r\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/UpdateMavenWrapper;", "Lcom/intellij/codeInspection/LocalQuickFix;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "version", "", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/lang/String;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getVersion", "()Ljava/lang/String;", "getName", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "createTempProject", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "applyFix", "", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "copyFromTempDir", "from", "to", "removeTempDirSafely", "tempDir", "createDummyPomContent", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenNewModelVersionInOldMavenInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenNewModelVersionInOldMavenInspection.kt\norg/jetbrains/idea/maven/dom/inspections/UpdateMavenWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class UpdateMavenWrapper
implements LocalQuickFix {
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private final String version;

    public UpdateMavenWrapper(@NotNull MavenProject mavenProject, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.mavenProject = mavenProject;
        this.version = version;
    }

    @NotNull
    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.version};
        String string = SyncBundle.message("maven.sync.quickfixes.update.maven.version", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    private final Path createTempProject(Project project) {
        Path tmp = EelPathUtils.createTemporaryDirectory$default((Project)project, (String)"mvn-wrapper-update", null, (boolean)true, (int)4, null);
        Path path = tmp.resolve("pom.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PathsKt.writeText$default((Path)path, (CharSequence)this.createDummyPomContent(), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return tmp;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Cloneable it;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        VirtualFile workingDir = this.mavenProject.getDirectoryFile();
        Path tempDir = this.createTempProject(project);
        Cloneable cloneable = new MavenRunnerParameters(true, ((Object)tempDir).toString(), null, (List<String>)CollectionsKt.listOf((Object)"wrapper:wrapper"), null);
        MavenRunnerParameters mavenRunnerParameters = cloneable;
        Project project2 = project;
        boolean bl = false;
        ((MavenRunnerParameters)it).setCmdOptions("-N");
        MavenRunnerParameters mavenRunnerParameters2 = cloneable;
        it = cloneable = new MavenRunnerSettings();
        MavenGeneralSettings mavenGeneralSettings = null;
        MavenRunnerParameters mavenRunnerParameters3 = mavenRunnerParameters2;
        boolean bl2 = false;
        ((MavenRunnerSettings)it).setVmOptions("-Dmaven=" + this.version);
        Unit unit = Unit.INSTANCE;
        MavenRunConfigurationType.runConfiguration(project2, mavenRunnerParameters3, mavenGeneralSettings, (MavenRunnerSettings)cloneable, arg_0 -> UpdateMavenWrapper.applyFix$lambda$2(this, tempDir, workingDir, project, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyFromTempDir(Path from, Path to) {
        AutoCloseable autoCloseable = Files.walk(from, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.forEach(arg_0 -> UpdateMavenWrapper.copyFromTempDir$lambda$0$1(arg_0 -> UpdateMavenWrapper.copyFromTempDir$lambda$0$0(from, to, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void removeTempDirSafely(Path tempDir) {
        try {
            PathsKt.deleteRecursively((Path)tempDir);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final String createDummyPomContent() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n\n<modelVersion>4.0.0</modelVersion>\n<groupId>" + this.mavenProject.getMavenId().getGroupId() + "</groupId>\n<artifactId>" + this.mavenProject.getMavenId().getArtifactId() + "</artifactId>\n<version>" + this.mavenProject.getMavenId().getVersion() + "</version>\n</project>\n    ";
    }

    private static final void applyFix$lambda$2(UpdateMavenWrapper this$0, Path $tempDir, VirtualFile $workingDir, Project $project, RunContentDescriptor it) {
        block0: {
            ProcessHandler processHandler = it.getProcessHandler();
            if (processHandler == null) break block0;
            processHandler.addProcessListener(new ProcessListener(this$0, $tempDir, $workingDir, $project){
                final /* synthetic */ UpdateMavenWrapper this$0;
                final /* synthetic */ Path $tempDir;
                final /* synthetic */ VirtualFile $workingDir;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$tempDir = $tempDir;
                    this.$workingDir = $workingDir;
                    this.$project = $project;
                }

                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.getExitCode() == 0) {
                        Path path = this.$workingDir.toNioPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                        UpdateMavenWrapper.access$copyFromTempDir(this.this$0, this.$tempDir, path);
                        this.$workingDir.refresh(true, true, () -> applyFix.3.1.processTerminated$lambda$0(this.$project));
                    }
                    UpdateMavenWrapper.access$removeTempDirSafely(this.this$0, this.$tempDir);
                }

                private static final void processTerminated$lambda$0(Project $project) {
                    MavenWorkspaceSettingsComponent.getInstance($project).getSettings().getGeneralSettings().setMavenHomeType(MavenWrapper.INSTANCE);
                    MavenDistributionsCache.getInstance($project).cleanCaches();
                    MavenServerManager.Companion.getInstance().shutdownMavenConnectors($project, applyFix.3.1::processTerminated$lambda$0$0);
                    MavenProjectsManager.getInstance($project).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }

                private static final boolean processTerminated$lambda$0$0(MavenServerConnector it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return true;
                }
            });
        }
    }

    private static final Unit copyFromTempDir$lambda$0$0(Path $from, Path $to, Path file2) {
        Path relative = $from.relativize(file2);
        if (!(((CharSequence)((Object)relative).toString()).length() == 0)) {
            Intrinsics.checkNotNull((Object)file2);
            if (!StringsKt.equals((String)PathsKt.getName((Path)file2), (String)"pom.xml", (boolean)true)) {
                Path newFile = $to.resolve(relative);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    try {
                        Path path = Files.createDirectory(newFile, new FileAttribute[0]);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        Unit unit = Unit.INSTANCE;
                    }
                } else {
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(file2, newFile, copyOptionArray);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void copyFromTempDir$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$copyFromTempDir(UpdateMavenWrapper $this, Path from, Path to) {
        $this.copyFromTempDir(from, to);
    }

    public static final /* synthetic */ void access$removeTempDirSafely(UpdateMavenWrapper $this, Path tempDir) {
        $this.removeTempDirSafely(tempDir);
    }
}

