/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.maven.resolver.ArtifactorySonatypeResolversHelper;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.internal.DefaultArtifactResolver;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.DefaultRepositorySystemSession;

@Named
@Component(role=ArtifactorySonatypeArtifactResolver.class)
public class ArtifactorySonatypeArtifactResolver
extends DefaultArtifactResolver {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactorySonatypeResolversHelper helper;

    public void initResolutionRepositories(RepositorySystemSession session) {
        this.helper.getResolutionRepositories(session);
    }

    private void enforceResolutionRepositories(RepositorySystemSession session, ArtifactRequest request) {
        List<RemoteRepository> repositories = this.helper.getResolutionRepositories(session);
        if (repositories != null && !repositories.isEmpty()) {
            request.setRepositories(repositories);
        }
    }

    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        if (session instanceof DefaultRepositorySystemSession) {
            DefaultRepositorySystemSession defRepoSession = (DefaultRepositorySystemSession)session;
            defRepoSession.setNotFoundCachingEnabled(false);
            defRepoSession.setTransferErrorCachingEnabled(false);
        }
        for (ArtifactRequest artifactRequest : requests) {
            this.enforceResolutionRepositories(session, artifactRequest);
        }
        return super.resolveArtifacts(session, requests);
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        return this.helper.getSnapshotRepository(session);
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        return this.helper.getReleaseRepository(session);
    }
}

