#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1220
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 134
#define ALIAS_COUNT 0
#define TOKEN_COUNT 74
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 39

enum {
  anon_sym_COLON = 1,
  anon_sym_SLASHdts_DASHv1_SLASH = 2,
  anon_sym_SEMI = 3,
  anon_sym_SLASHplugin_SLASH = 4,
  anon_sym_SLASHmemreserve_SLASH = 5,
  sym_comment = 6,
  sym__label_name = 7,
  sym__node_path = 8,
  sym__node_or_property = 9,
  sym__property_with_hash = 10,
  sym__property_starts_with_number = 11,
  sym_unit_address = 12,
  anon_sym_AMP = 13,
  anon_sym_AMP_LBRACE = 14,
  anon_sym_AT = 15,
  anon_sym_RBRACE = 16,
  anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH = 17,
  anon_sym_LBRACE = 18,
  anon_sym_SLASHbits_SLASH = 19,
  anon_sym_EQ = 20,
  anon_sym_COMMA = 21,
  anon_sym_SLASHdelete_DASHnode_SLASH = 22,
  anon_sym_SLASHdelete_DASHproperty_SLASH = 23,
  anon_sym_SLASHincbin_SLASH = 24,
  anon_sym_LPAREN = 25,
  anon_sym_RPAREN = 26,
  anon_sym_LT = 27,
  anon_sym_GT = 28,
  anon_sym_DQUOTE = 29,
  aux_sym_string_literal_token1 = 30,
  sym_escape_sequence = 31,
  sym_system_lib_string = 32,
  anon_sym_LBRACK = 33,
  anon_sym_RBRACK = 34,
  sym__byte_string_item = 35,
  sym_integer_literal = 36,
  sym_identifier = 37,
  anon_sym_QMARK = 38,
  anon_sym_BANG = 39,
  anon_sym_TILDE = 40,
  anon_sym_DASH = 41,
  anon_sym_PLUS = 42,
  anon_sym_STAR = 43,
  anon_sym_SLASH = 44,
  anon_sym_PERCENT = 45,
  anon_sym_PIPE_PIPE = 46,
  anon_sym_AMP_AMP = 47,
  anon_sym_PIPE = 48,
  anon_sym_CARET = 49,
  anon_sym_EQ_EQ = 50,
  anon_sym_BANG_EQ = 51,
  anon_sym_GT_EQ = 52,
  anon_sym_LT_EQ = 53,
  anon_sym_LT_LT = 54,
  anon_sym_GT_GT = 55,
  anon_sym_SLASHinclude_SLASH = 56,
  aux_sym_preproc_include_token1 = 57,
  aux_sym_preproc_include_token2 = 58,
  aux_sym_preproc_def_token1 = 59,
  anon_sym_LPAREN2 = 60,
  anon_sym_DOT_DOT_DOT = 61,
  aux_sym_preproc_undef_token1 = 62,
  sym_preproc_arg = 63,
  aux_sym_preproc_if_token1 = 64,
  anon_sym_LF = 65,
  aux_sym_preproc_if_token2 = 66,
  aux_sym_preproc_ifdef_token1 = 67,
  aux_sym_preproc_ifdef_token2 = 68,
  aux_sym_preproc_else_token1 = 69,
  aux_sym_preproc_elif_token1 = 70,
  aux_sym_preproc_elifdef_token1 = 71,
  aux_sym_preproc_elifdef_token2 = 72,
  anon_sym_defined = 73,
  sym_document = 74,
  sym__top_level_item = 75,
  sym__label = 76,
  sym_file_version = 77,
  sym_plugin = 78,
  sym_memory_reservation = 79,
  sym_reference = 80,
  sym__label_reference = 81,
  sym__node_reference = 82,
  sym_omit_if_no_ref = 83,
  sym_node = 84,
  sym__bits = 85,
  sym_property = 86,
  sym__node_members = 87,
  sym_delete_node = 88,
  sym_delete_property = 89,
  sym_incbin = 90,
  sym__property_value = 91,
  sym_integer_cells = 92,
  sym__integer_cell_items = 93,
  sym_string_literal = 94,
  sym_byte_string_literal = 95,
  sym__expression = 96,
  sym_call_expression = 97,
  sym_argument_list = 98,
  sym_conditional_expression = 99,
  sym_unary_expression = 100,
  sym_binary_expression = 101,
  sym_dtsi_include = 102,
  sym_preproc_include = 103,
  sym_preproc_def = 104,
  sym_preproc_function_def = 105,
  sym_preproc_params = 106,
  sym_preproc_undef = 107,
  sym_preproc_if = 108,
  sym_preproc_ifdef = 109,
  sym_preproc_else = 110,
  sym_preproc_elif = 111,
  sym_preproc_elifdef = 112,
  sym_preproc_if_in_node = 113,
  sym_preproc_ifdef_in_node = 114,
  sym_preproc_else_in_node = 115,
  sym_preproc_elif_in_node = 116,
  sym__preproc_expression = 117,
  sym_preproc_parenthesized_expression = 118,
  sym_preproc_defined = 119,
  sym_preproc_unary_expression = 120,
  sym_preproc_call_expression = 121,
  sym_preproc_argument_list = 122,
  sym_preproc_binary_expression = 123,
  aux_sym_document_repeat1 = 124,
  aux_sym_memory_reservation_repeat1 = 125,
  aux_sym_node_repeat1 = 126,
  aux_sym_property_repeat1 = 127,
  aux_sym_integer_cells_repeat1 = 128,
  aux_sym_string_literal_repeat1 = 129,
  aux_sym_byte_string_literal_repeat1 = 130,
  aux_sym_argument_list_repeat1 = 131,
  aux_sym_preproc_params_repeat1 = 132,
  aux_sym_preproc_argument_list_repeat1 = 133,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_COLON] = ":",
  [anon_sym_SLASHdts_DASHv1_SLASH] = "/dts-v1/",
  [anon_sym_SEMI] = ";",
  [anon_sym_SLASHplugin_SLASH] = "/plugin/",
  [anon_sym_SLASHmemreserve_SLASH] = "/memreserve/",
  [sym_comment] = "comment",
  [sym__label_name] = "identifier",
  [sym__node_path] = "identifier",
  [sym__node_or_property] = "identifier",
  [sym__property_with_hash] = "identifier",
  [sym__property_starts_with_number] = "identifier",
  [sym_unit_address] = "unit_address",
  [anon_sym_AMP] = "&",
  [anon_sym_AMP_LBRACE] = "&{",
  [anon_sym_AT] = "@",
  [anon_sym_RBRACE] = "}",
  [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = "/omit-if-no-ref/",
  [anon_sym_LBRACE] = "{",
  [anon_sym_SLASHbits_SLASH] = "/bits/",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_SLASHdelete_DASHnode_SLASH] = "/delete-node/",
  [anon_sym_SLASHdelete_DASHproperty_SLASH] = "/delete-property/",
  [anon_sym_SLASHincbin_SLASH] = "/incbin/",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__byte_string_item] = "_byte_string_item",
  [sym_integer_literal] = "integer_literal",
  [sym_identifier] = "identifier",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SLASHinclude_SLASH] = "/include/",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [aux_sym_preproc_undef_token1] = "#undef",
  [sym_preproc_arg] = "preproc_arg",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [anon_sym_defined] = "defined",
  [sym_document] = "document",
  [sym__top_level_item] = "_top_level_item",
  [sym__label] = "_label",
  [sym_file_version] = "file_version",
  [sym_plugin] = "plugin",
  [sym_memory_reservation] = "memory_reservation",
  [sym_reference] = "reference",
  [sym__label_reference] = "_label_reference",
  [sym__node_reference] = "_node_reference",
  [sym_omit_if_no_ref] = "omit_if_no_ref",
  [sym_node] = "node",
  [sym__bits] = "_bits",
  [sym_property] = "property",
  [sym__node_members] = "_node_members",
  [sym_delete_node] = "delete_node",
  [sym_delete_property] = "delete_property",
  [sym_incbin] = "incbin",
  [sym__property_value] = "_property_value",
  [sym_integer_cells] = "integer_cells",
  [sym__integer_cell_items] = "_integer_cell_items",
  [sym_string_literal] = "string_literal",
  [sym_byte_string_literal] = "byte_string_literal",
  [sym__expression] = "_expression",
  [sym_call_expression] = "call_expression",
  [sym_argument_list] = "argument_list",
  [sym_conditional_expression] = "conditional_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_dtsi_include] = "dtsi_include",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_undef] = "preproc_undef",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_node] = "preproc_if",
  [sym_preproc_ifdef_in_node] = "preproc_ifdef",
  [sym_preproc_else_in_node] = "preproc_else",
  [sym_preproc_elif_in_node] = "preproc_elif",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_memory_reservation_repeat1] = "memory_reservation_repeat1",
  [aux_sym_node_repeat1] = "node_repeat1",
  [aux_sym_property_repeat1] = "property_repeat1",
  [aux_sym_integer_cells_repeat1] = "integer_cells_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_byte_string_literal_repeat1] = "byte_string_literal_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SLASHdts_DASHv1_SLASH] = anon_sym_SLASHdts_DASHv1_SLASH,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_SLASHplugin_SLASH] = anon_sym_SLASHplugin_SLASH,
  [anon_sym_SLASHmemreserve_SLASH] = anon_sym_SLASHmemreserve_SLASH,
  [sym_comment] = sym_comment,
  [sym__label_name] = sym_identifier,
  [sym__node_path] = sym_identifier,
  [sym__node_or_property] = sym_identifier,
  [sym__property_with_hash] = sym_identifier,
  [sym__property_starts_with_number] = sym_identifier,
  [sym_unit_address] = sym_unit_address,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_AMP_LBRACE] = anon_sym_AMP_LBRACE,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_SLASHbits_SLASH] = anon_sym_SLASHbits_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SLASHdelete_DASHnode_SLASH] = anon_sym_SLASHdelete_DASHnode_SLASH,
  [anon_sym_SLASHdelete_DASHproperty_SLASH] = anon_sym_SLASHdelete_DASHproperty_SLASH,
  [anon_sym_SLASHincbin_SLASH] = anon_sym_SLASHincbin_SLASH,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__byte_string_item] = sym__byte_string_item,
  [sym_integer_literal] = sym_integer_literal,
  [sym_identifier] = sym_identifier,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SLASHinclude_SLASH] = anon_sym_SLASHinclude_SLASH,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [aux_sym_preproc_undef_token1] = aux_sym_preproc_undef_token1,
  [sym_preproc_arg] = sym_preproc_arg,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [anon_sym_defined] = anon_sym_defined,
  [sym_document] = sym_document,
  [sym__top_level_item] = sym__top_level_item,
  [sym__label] = sym__label,
  [sym_file_version] = sym_file_version,
  [sym_plugin] = sym_plugin,
  [sym_memory_reservation] = sym_memory_reservation,
  [sym_reference] = sym_reference,
  [sym__label_reference] = sym__label_reference,
  [sym__node_reference] = sym__node_reference,
  [sym_omit_if_no_ref] = sym_omit_if_no_ref,
  [sym_node] = sym_node,
  [sym__bits] = sym__bits,
  [sym_property] = sym_property,
  [sym__node_members] = sym__node_members,
  [sym_delete_node] = sym_delete_node,
  [sym_delete_property] = sym_delete_property,
  [sym_incbin] = sym_incbin,
  [sym__property_value] = sym__property_value,
  [sym_integer_cells] = sym_integer_cells,
  [sym__integer_cell_items] = sym__integer_cell_items,
  [sym_string_literal] = sym_string_literal,
  [sym_byte_string_literal] = sym_byte_string_literal,
  [sym__expression] = sym__expression,
  [sym_call_expression] = sym_call_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_dtsi_include] = sym_dtsi_include,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_undef] = sym_preproc_undef,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_node] = sym_preproc_if,
  [sym_preproc_ifdef_in_node] = sym_preproc_ifdef,
  [sym_preproc_else_in_node] = sym_preproc_else,
  [sym_preproc_elif_in_node] = sym_preproc_elif,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_preproc_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_memory_reservation_repeat1] = aux_sym_memory_reservation_repeat1,
  [aux_sym_node_repeat1] = aux_sym_node_repeat1,
  [aux_sym_property_repeat1] = aux_sym_property_repeat1,
  [aux_sym_integer_cells_repeat1] = aux_sym_integer_cells_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_byte_string_literal_repeat1] = aux_sym_byte_string_literal_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHdts_DASHv1_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHplugin_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHmemreserve_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__label_name] = {
    .visible = true,
    .named = true,
  },
  [sym__node_path] = {
    .visible = true,
    .named = true,
  },
  [sym__node_or_property] = {
    .visible = true,
    .named = true,
  },
  [sym__property_with_hash] = {
    .visible = true,
    .named = true,
  },
  [sym__property_starts_with_number] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_address] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHbits_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHdelete_DASHnode_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHdelete_DASHproperty_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHincbin_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__byte_string_item] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASHinclude_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_undef_token1] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_item] = {
    .visible = false,
    .named = true,
  },
  [sym__label] = {
    .visible = false,
    .named = true,
  },
  [sym_file_version] = {
    .visible = true,
    .named = true,
  },
  [sym_plugin] = {
    .visible = true,
    .named = true,
  },
  [sym_memory_reservation] = {
    .visible = true,
    .named = true,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__label_reference] = {
    .visible = false,
    .named = true,
  },
  [sym__node_reference] = {
    .visible = false,
    .named = true,
  },
  [sym_omit_if_no_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_node] = {
    .visible = true,
    .named = true,
  },
  [sym__bits] = {
    .visible = false,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym__node_members] = {
    .visible = false,
    .named = true,
  },
  [sym_delete_node] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_property] = {
    .visible = true,
    .named = true,
  },
  [sym_incbin] = {
    .visible = true,
    .named = true,
  },
  [sym__property_value] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_cells] = {
    .visible = true,
    .named = true,
  },
  [sym__integer_cell_items] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_byte_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dtsi_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_undef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_node] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_memory_reservation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_node_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_cells_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_byte_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_address = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_bits = 5,
  field_condition = 6,
  field_consequence = 7,
  field_filename = 8,
  field_function = 9,
  field_label = 10,
  field_left = 11,
  field_length = 12,
  field_name = 13,
  field_offset = 14,
  field_operator = 15,
  field_parameters = 16,
  field_path = 17,
  field_right = 18,
  field_size = 19,
  field_value = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_address] = "address",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_bits] = "bits",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_filename] = "filename",
  [field_function] = "function",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_name] = "name",
  [field_offset] = "offset",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_right] = "right",
  [field_size] = "size",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 2},
  [10] = {.index = 13, .length = 2},
  [11] = {.index = 15, .length = 1},
  [12] = {.index = 16, .length = 2},
  [13] = {.index = 18, .length = 2},
  [14] = {.index = 20, .length = 3},
  [15] = {.index = 23, .length = 1},
  [16] = {.index = 24, .length = 2},
  [17] = {.index = 26, .length = 2},
  [18] = {.index = 28, .length = 3},
  [19] = {.index = 31, .length = 3},
  [20] = {.index = 34, .length = 2},
  [21] = {.index = 36, .length = 2},
  [22] = {.index = 38, .length = 3},
  [23] = {.index = 41, .length = 3},
  [24] = {.index = 44, .length = 2},
  [25] = {.index = 46, .length = 2},
  [26] = {.index = 48, .length = 2},
  [27] = {.index = 50, .length = 3},
  [28] = {.index = 53, .length = 3},
  [29] = {.index = 56, .length = 3},
  [30] = {.index = 59, .length = 3},
  [31] = {.index = 62, .length = 4},
  [32] = {.index = 66, .length = 1},
  [33] = {.index = 67, .length = 4},
  [34] = {.index = 71, .length = 4},
  [35] = {.index = 75, .length = 4},
  [36] = {.index = 79, .length = 5},
  [37] = {.index = 84, .length = 3},
  [38] = {.index = 87, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_label, 0, .inherited = true},
  [1] =
    {field_address, 0, .inherited = true},
    {field_path, 0, .inherited = true},
  [3] =
    {field_label, 0},
  [4] =
    {field_label, 1},
  [5] =
    {field_path, 1},
  [6] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [8] =
    {field_name, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_argument, 1},
    {field_operator, 0},
  [13] =
    {field_address, 1},
    {field_length, 2},
  [15] =
    {field_name, 0},
  [16] =
    {field_name, 1},
    {field_value, 2},
  [18] =
    {field_name, 1},
    {field_parameters, 2},
  [20] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [23] =
    {field_condition, 1},
  [24] =
    {field_alternative, 2},
    {field_name, 1},
  [26] =
    {field_label, 0, .inherited = true},
    {field_name, 1},
  [28] =
    {field_address, 2},
    {field_address, 3},
    {field_path, 1},
  [31] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [34] =
    {field_alternative, 3},
    {field_condition, 1},
  [36] =
    {field_alternative, 3},
    {field_name, 1},
  [38] =
    {field_address, 2},
    {field_label, 0, .inherited = true},
    {field_length, 3},
  [41] =
    {field_address, 1},
    {field_address, 2},
    {field_name, 0},
  [44] =
    {field_bits, 2},
    {field_name, 0},
  [46] =
    {field_name, 0},
    {field_value, 2},
  [48] =
    {field_alternative, 4},
    {field_condition, 1},
  [50] =
    {field_bits, 2},
    {field_name, 0},
    {field_value, 3},
  [53] =
    {field_name, 0},
    {field_value, 2},
    {field_value, 3},
  [56] =
    {field_bits, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
  [59] =
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3},
  [62] =
    {field_address, 2},
    {field_address, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
  [66] =
    {field_filename, 2},
  [67] =
    {field_bits, 2},
    {field_name, 0},
    {field_value, 3},
    {field_value, 4},
  [71] =
    {field_bits, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 4},
  [75] =
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3},
    {field_value, 4},
  [79] =
    {field_bits, 3},
    {field_label, 0, .inherited = true},
    {field_name, 1},
    {field_value, 4},
    {field_value, 5},
  [84] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [87] =
    {field_filename, 2},
    {field_offset, 4},
    {field_size, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 6,
  [7] = 6,
  [8] = 8,
  [9] = 8,
  [10] = 6,
  [11] = 8,
  [12] = 6,
  [13] = 8,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 16,
  [19] = 19,
  [20] = 20,
  [21] = 17,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 25,
  [27] = 24,
  [28] = 28,
  [29] = 24,
  [30] = 24,
  [31] = 25,
  [32] = 32,
  [33] = 25,
  [34] = 14,
  [35] = 28,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 40,
  [50] = 50,
  [51] = 41,
  [52] = 39,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 42,
  [61] = 39,
  [62] = 43,
  [63] = 44,
  [64] = 45,
  [65] = 48,
  [66] = 46,
  [67] = 47,
  [68] = 42,
  [69] = 48,
  [70] = 53,
  [71] = 40,
  [72] = 50,
  [73] = 41,
  [74] = 54,
  [75] = 50,
  [76] = 39,
  [77] = 41,
  [78] = 59,
  [79] = 53,
  [80] = 50,
  [81] = 54,
  [82] = 55,
  [83] = 56,
  [84] = 57,
  [85] = 58,
  [86] = 59,
  [87] = 42,
  [88] = 28,
  [89] = 43,
  [90] = 44,
  [91] = 58,
  [92] = 92,
  [93] = 55,
  [94] = 45,
  [95] = 46,
  [96] = 47,
  [97] = 57,
  [98] = 48,
  [99] = 40,
  [100] = 47,
  [101] = 50,
  [102] = 46,
  [103] = 41,
  [104] = 45,
  [105] = 44,
  [106] = 39,
  [107] = 56,
  [108] = 43,
  [109] = 53,
  [110] = 54,
  [111] = 53,
  [112] = 55,
  [113] = 56,
  [114] = 54,
  [115] = 55,
  [116] = 57,
  [117] = 58,
  [118] = 59,
  [119] = 42,
  [120] = 55,
  [121] = 28,
  [122] = 43,
  [123] = 40,
  [124] = 44,
  [125] = 45,
  [126] = 46,
  [127] = 59,
  [128] = 54,
  [129] = 47,
  [130] = 53,
  [131] = 131,
  [132] = 39,
  [133] = 48,
  [134] = 41,
  [135] = 50,
  [136] = 40,
  [137] = 48,
  [138] = 47,
  [139] = 46,
  [140] = 45,
  [141] = 56,
  [142] = 44,
  [143] = 57,
  [144] = 43,
  [145] = 58,
  [146] = 42,
  [147] = 59,
  [148] = 58,
  [149] = 57,
  [150] = 56,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 193,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 210,
  [236] = 196,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 202,
  [246] = 197,
  [247] = 199,
  [248] = 203,
  [249] = 190,
  [250] = 198,
  [251] = 195,
  [252] = 209,
  [253] = 253,
  [254] = 205,
  [255] = 208,
  [256] = 191,
  [257] = 257,
  [258] = 189,
  [259] = 188,
  [260] = 187,
  [261] = 261,
  [262] = 159,
  [263] = 263,
  [264] = 182,
  [265] = 265,
  [266] = 179,
  [267] = 180,
  [268] = 268,
  [269] = 181,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 163,
  [278] = 278,
  [279] = 162,
  [280] = 280,
  [281] = 186,
  [282] = 280,
  [283] = 283,
  [284] = 284,
  [285] = 184,
  [286] = 185,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 239,
  [310] = 292,
  [311] = 221,
  [312] = 222,
  [313] = 223,
  [314] = 224,
  [315] = 202,
  [316] = 226,
  [317] = 227,
  [318] = 228,
  [319] = 229,
  [320] = 230,
  [321] = 197,
  [322] = 231,
  [323] = 199,
  [324] = 232,
  [325] = 203,
  [326] = 233,
  [327] = 234,
  [328] = 186,
  [329] = 237,
  [330] = 238,
  [331] = 198,
  [332] = 240,
  [333] = 241,
  [334] = 242,
  [335] = 185,
  [336] = 196,
  [337] = 243,
  [338] = 244,
  [339] = 219,
  [340] = 340,
  [341] = 218,
  [342] = 155,
  [343] = 343,
  [344] = 210,
  [345] = 257,
  [346] = 217,
  [347] = 216,
  [348] = 215,
  [349] = 156,
  [350] = 214,
  [351] = 253,
  [352] = 261,
  [353] = 184,
  [354] = 294,
  [355] = 181,
  [356] = 213,
  [357] = 180,
  [358] = 263,
  [359] = 179,
  [360] = 265,
  [361] = 295,
  [362] = 296,
  [363] = 363,
  [364] = 297,
  [365] = 298,
  [366] = 299,
  [367] = 290,
  [368] = 301,
  [369] = 270,
  [370] = 271,
  [371] = 363,
  [372] = 272,
  [373] = 212,
  [374] = 273,
  [375] = 302,
  [376] = 291,
  [377] = 274,
  [378] = 220,
  [379] = 275,
  [380] = 303,
  [381] = 340,
  [382] = 308,
  [383] = 304,
  [384] = 276,
  [385] = 278,
  [386] = 204,
  [387] = 160,
  [388] = 166,
  [389] = 305,
  [390] = 343,
  [391] = 283,
  [392] = 284,
  [393] = 162,
  [394] = 194,
  [395] = 192,
  [396] = 182,
  [397] = 397,
  [398] = 187,
  [399] = 188,
  [400] = 189,
  [401] = 191,
  [402] = 208,
  [403] = 205,
  [404] = 190,
  [405] = 195,
  [406] = 209,
  [407] = 159,
  [408] = 193,
  [409] = 409,
  [410] = 164,
  [411] = 161,
  [412] = 167,
  [413] = 196,
  [414] = 198,
  [415] = 210,
  [416] = 202,
  [417] = 197,
  [418] = 199,
  [419] = 203,
  [420] = 186,
  [421] = 185,
  [422] = 184,
  [423] = 200,
  [424] = 201,
  [425] = 206,
  [426] = 207,
  [427] = 181,
  [428] = 180,
  [429] = 179,
  [430] = 162,
  [431] = 182,
  [432] = 187,
  [433] = 188,
  [434] = 189,
  [435] = 340,
  [436] = 191,
  [437] = 211,
  [438] = 340,
  [439] = 208,
  [440] = 205,
  [441] = 293,
  [442] = 190,
  [443] = 307,
  [444] = 195,
  [445] = 306,
  [446] = 209,
  [447] = 159,
  [448] = 193,
  [449] = 214,
  [450] = 450,
  [451] = 188,
  [452] = 189,
  [453] = 162,
  [454] = 209,
  [455] = 159,
  [456] = 193,
  [457] = 196,
  [458] = 198,
  [459] = 193,
  [460] = 159,
  [461] = 209,
  [462] = 195,
  [463] = 190,
  [464] = 205,
  [465] = 208,
  [466] = 191,
  [467] = 189,
  [468] = 188,
  [469] = 187,
  [470] = 210,
  [471] = 202,
  [472] = 197,
  [473] = 199,
  [474] = 203,
  [475] = 182,
  [476] = 450,
  [477] = 477,
  [478] = 478,
  [479] = 182,
  [480] = 191,
  [481] = 481,
  [482] = 162,
  [483] = 190,
  [484] = 195,
  [485] = 208,
  [486] = 205,
  [487] = 278,
  [488] = 186,
  [489] = 185,
  [490] = 184,
  [491] = 244,
  [492] = 284,
  [493] = 283,
  [494] = 278,
  [495] = 276,
  [496] = 275,
  [497] = 284,
  [498] = 283,
  [499] = 274,
  [500] = 276,
  [501] = 181,
  [502] = 180,
  [503] = 179,
  [504] = 504,
  [505] = 273,
  [506] = 212,
  [507] = 187,
  [508] = 481,
  [509] = 478,
  [510] = 275,
  [511] = 477,
  [512] = 450,
  [513] = 274,
  [514] = 273,
  [515] = 272,
  [516] = 212,
  [517] = 271,
  [518] = 272,
  [519] = 270,
  [520] = 271,
  [521] = 270,
  [522] = 265,
  [523] = 265,
  [524] = 263,
  [525] = 263,
  [526] = 213,
  [527] = 504,
  [528] = 213,
  [529] = 243,
  [530] = 504,
  [531] = 242,
  [532] = 504,
  [533] = 241,
  [534] = 257,
  [535] = 481,
  [536] = 478,
  [537] = 477,
  [538] = 450,
  [539] = 198,
  [540] = 261,
  [541] = 253,
  [542] = 214,
  [543] = 240,
  [544] = 481,
  [545] = 239,
  [546] = 261,
  [547] = 215,
  [548] = 253,
  [549] = 216,
  [550] = 478,
  [551] = 215,
  [552] = 238,
  [553] = 216,
  [554] = 477,
  [555] = 217,
  [556] = 237,
  [557] = 218,
  [558] = 196,
  [559] = 219,
  [560] = 220,
  [561] = 217,
  [562] = 221,
  [563] = 222,
  [564] = 218,
  [565] = 223,
  [566] = 219,
  [567] = 220,
  [568] = 224,
  [569] = 179,
  [570] = 180,
  [571] = 181,
  [572] = 184,
  [573] = 221,
  [574] = 185,
  [575] = 186,
  [576] = 203,
  [577] = 199,
  [578] = 222,
  [579] = 223,
  [580] = 224,
  [581] = 210,
  [582] = 234,
  [583] = 233,
  [584] = 202,
  [585] = 232,
  [586] = 226,
  [587] = 227,
  [588] = 226,
  [589] = 228,
  [590] = 229,
  [591] = 257,
  [592] = 227,
  [593] = 230,
  [594] = 231,
  [595] = 228,
  [596] = 244,
  [597] = 243,
  [598] = 242,
  [599] = 241,
  [600] = 240,
  [601] = 239,
  [602] = 238,
  [603] = 237,
  [604] = 232,
  [605] = 233,
  [606] = 229,
  [607] = 234,
  [608] = 230,
  [609] = 231,
  [610] = 197,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 612,
  [615] = 615,
  [616] = 616,
  [617] = 616,
  [618] = 611,
  [619] = 612,
  [620] = 620,
  [621] = 615,
  [622] = 613,
  [623] = 615,
  [624] = 612,
  [625] = 611,
  [626] = 616,
  [627] = 620,
  [628] = 615,
  [629] = 613,
  [630] = 616,
  [631] = 613,
  [632] = 611,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 637,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 640,
  [647] = 647,
  [648] = 648,
  [649] = 636,
  [650] = 650,
  [651] = 651,
  [652] = 634,
  [653] = 636,
  [654] = 654,
  [655] = 636,
  [656] = 641,
  [657] = 657,
  [658] = 638,
  [659] = 651,
  [660] = 650,
  [661] = 648,
  [662] = 645,
  [663] = 644,
  [664] = 633,
  [665] = 643,
  [666] = 657,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 672,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 672,
  [689] = 672,
  [690] = 690,
  [691] = 691,
  [692] = 691,
  [693] = 693,
  [694] = 691,
  [695] = 691,
  [696] = 691,
  [697] = 691,
  [698] = 693,
  [699] = 699,
  [700] = 700,
  [701] = 699,
  [702] = 699,
  [703] = 699,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 699,
  [708] = 708,
  [709] = 699,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 713,
  [716] = 714,
  [717] = 717,
  [718] = 714,
  [719] = 714,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 713,
  [724] = 722,
  [725] = 721,
  [726] = 726,
  [727] = 727,
  [728] = 727,
  [729] = 727,
  [730] = 726,
  [731] = 726,
  [732] = 727,
  [733] = 721,
  [734] = 726,
  [735] = 722,
  [736] = 736,
  [737] = 736,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 740,
  [743] = 736,
  [744] = 739,
  [745] = 736,
  [746] = 741,
  [747] = 747,
  [748] = 747,
  [749] = 740,
  [750] = 741,
  [751] = 736,
  [752] = 739,
  [753] = 753,
  [754] = 741,
  [755] = 747,
  [756] = 741,
  [757] = 738,
  [758] = 739,
  [759] = 741,
  [760] = 753,
  [761] = 761,
  [762] = 740,
  [763] = 753,
  [764] = 736,
  [765] = 738,
  [766] = 753,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 767,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 768,
  [786] = 786,
  [787] = 768,
  [788] = 780,
  [789] = 778,
  [790] = 775,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 770,
  [795] = 795,
  [796] = 796,
  [797] = 769,
  [798] = 771,
  [799] = 773,
  [800] = 774,
  [801] = 777,
  [802] = 779,
  [803] = 782,
  [804] = 804,
  [805] = 805,
  [806] = 791,
  [807] = 792,
  [808] = 793,
  [809] = 805,
  [810] = 810,
  [811] = 784,
  [812] = 791,
  [813] = 795,
  [814] = 783,
  [815] = 791,
  [816] = 810,
  [817] = 768,
  [818] = 818,
  [819] = 810,
  [820] = 820,
  [821] = 805,
  [822] = 793,
  [823] = 792,
  [824] = 776,
  [825] = 825,
  [826] = 767,
  [827] = 791,
  [828] = 795,
  [829] = 795,
  [830] = 791,
  [831] = 782,
  [832] = 779,
  [833] = 777,
  [834] = 774,
  [835] = 835,
  [836] = 795,
  [837] = 783,
  [838] = 773,
  [839] = 839,
  [840] = 791,
  [841] = 795,
  [842] = 784,
  [843] = 771,
  [844] = 769,
  [845] = 796,
  [846] = 780,
  [847] = 783,
  [848] = 784,
  [849] = 849,
  [850] = 778,
  [851] = 770,
  [852] = 775,
  [853] = 796,
  [854] = 767,
  [855] = 780,
  [856] = 856,
  [857] = 778,
  [858] = 810,
  [859] = 775,
  [860] = 860,
  [861] = 805,
  [862] = 795,
  [863] = 770,
  [864] = 791,
  [865] = 796,
  [866] = 769,
  [867] = 771,
  [868] = 773,
  [869] = 774,
  [870] = 777,
  [871] = 779,
  [872] = 782,
  [873] = 795,
  [874] = 793,
  [875] = 875,
  [876] = 792,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 877,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 887,
  [890] = 877,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 887,
  [896] = 881,
  [897] = 880,
  [898] = 886,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 880,
  [904] = 886,
  [905] = 905,
  [906] = 894,
  [907] = 907,
  [908] = 886,
  [909] = 877,
  [910] = 880,
  [911] = 881,
  [912] = 912,
  [913] = 881,
  [914] = 912,
  [915] = 877,
  [916] = 916,
  [917] = 881,
  [918] = 877,
  [919] = 919,
  [920] = 887,
  [921] = 881,
  [922] = 919,
  [923] = 893,
  [924] = 892,
  [925] = 919,
  [926] = 893,
  [927] = 892,
  [928] = 919,
  [929] = 893,
  [930] = 892,
  [931] = 931,
  [932] = 919,
  [933] = 893,
  [934] = 892,
  [935] = 919,
  [936] = 893,
  [937] = 892,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 938,
  [969] = 960,
  [970] = 956,
  [971] = 954,
  [972] = 953,
  [973] = 943,
  [974] = 942,
  [975] = 941,
  [976] = 946,
  [977] = 947,
  [978] = 948,
  [979] = 938,
  [980] = 955,
  [981] = 955,
  [982] = 957,
  [983] = 957,
  [984] = 958,
  [985] = 959,
  [986] = 963,
  [987] = 961,
  [988] = 962,
  [989] = 963,
  [990] = 964,
  [991] = 965,
  [992] = 966,
  [993] = 967,
  [994] = 964,
  [995] = 960,
  [996] = 956,
  [997] = 954,
  [998] = 953,
  [999] = 943,
  [1000] = 942,
  [1001] = 941,
  [1002] = 946,
  [1003] = 947,
  [1004] = 948,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 938,
  [1014] = 960,
  [1015] = 1015,
  [1016] = 956,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 945,
  [1021] = 962,
  [1022] = 944,
  [1023] = 1023,
  [1024] = 954,
  [1025] = 1025,
  [1026] = 961,
  [1027] = 967,
  [1028] = 966,
  [1029] = 953,
  [1030] = 965,
  [1031] = 939,
  [1032] = 1032,
  [1033] = 964,
  [1034] = 963,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 962,
  [1038] = 946,
  [1039] = 1039,
  [1040] = 1006,
  [1041] = 1007,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1015,
  [1046] = 939,
  [1047] = 1047,
  [1048] = 1019,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 952,
  [1052] = 950,
  [1053] = 1032,
  [1054] = 958,
  [1055] = 959,
  [1056] = 958,
  [1057] = 959,
  [1058] = 957,
  [1059] = 955,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1018,
  [1063] = 943,
  [1064] = 948,
  [1065] = 947,
  [1066] = 965,
  [1067] = 942,
  [1068] = 1006,
  [1069] = 1007,
  [1070] = 959,
  [1071] = 941,
  [1072] = 940,
  [1073] = 1015,
  [1074] = 941,
  [1075] = 942,
  [1076] = 943,
  [1077] = 1032,
  [1078] = 1078,
  [1079] = 961,
  [1080] = 1015,
  [1081] = 950,
  [1082] = 1082,
  [1083] = 940,
  [1084] = 958,
  [1085] = 952,
  [1086] = 953,
  [1087] = 954,
  [1088] = 1088,
  [1089] = 1039,
  [1090] = 956,
  [1091] = 1091,
  [1092] = 960,
  [1093] = 938,
  [1094] = 961,
  [1095] = 962,
  [1096] = 1006,
  [1097] = 1007,
  [1098] = 1012,
  [1099] = 965,
  [1100] = 1100,
  [1101] = 944,
  [1102] = 966,
  [1103] = 1017,
  [1104] = 957,
  [1105] = 1044,
  [1106] = 955,
  [1107] = 967,
  [1108] = 1108,
  [1109] = 966,
  [1110] = 965,
  [1111] = 946,
  [1112] = 1112,
  [1113] = 947,
  [1114] = 1009,
  [1115] = 948,
  [1116] = 964,
  [1117] = 963,
  [1118] = 962,
  [1119] = 1006,
  [1120] = 1007,
  [1121] = 1121,
  [1122] = 961,
  [1123] = 1123,
  [1124] = 1010,
  [1125] = 1125,
  [1126] = 1008,
  [1127] = 1035,
  [1128] = 1007,
  [1129] = 1006,
  [1130] = 963,
  [1131] = 967,
  [1132] = 939,
  [1133] = 1032,
  [1134] = 1134,
  [1135] = 1049,
  [1136] = 959,
  [1137] = 1137,
  [1138] = 949,
  [1139] = 958,
  [1140] = 957,
  [1141] = 1137,
  [1142] = 955,
  [1143] = 948,
  [1144] = 1144,
  [1145] = 1123,
  [1146] = 947,
  [1147] = 1100,
  [1148] = 946,
  [1149] = 940,
  [1150] = 941,
  [1151] = 1091,
  [1152] = 1088,
  [1153] = 1153,
  [1154] = 951,
  [1155] = 1023,
  [1156] = 1082,
  [1157] = 942,
  [1158] = 1123,
  [1159] = 943,
  [1160] = 950,
  [1161] = 952,
  [1162] = 1091,
  [1163] = 1088,
  [1164] = 953,
  [1165] = 951,
  [1166] = 1023,
  [1167] = 1082,
  [1168] = 954,
  [1169] = 1123,
  [1170] = 1170,
  [1171] = 956,
  [1172] = 960,
  [1173] = 1091,
  [1174] = 1088,
  [1175] = 938,
  [1176] = 951,
  [1177] = 1023,
  [1178] = 1082,
  [1179] = 1005,
  [1180] = 1123,
  [1181] = 155,
  [1182] = 1182,
  [1183] = 944,
  [1184] = 1091,
  [1185] = 1088,
  [1186] = 951,
  [1187] = 1023,
  [1188] = 1082,
  [1189] = 964,
  [1190] = 1123,
  [1191] = 156,
  [1192] = 967,
  [1193] = 966,
  [1194] = 1091,
  [1195] = 1088,
  [1196] = 951,
  [1197] = 1023,
  [1198] = 1082,
  [1199] = 1035,
  [1200] = 1112,
  [1201] = 1047,
  [1202] = 1042,
  [1203] = 1036,
  [1204] = 1112,
  [1205] = 1047,
  [1206] = 1042,
  [1207] = 1036,
  [1208] = 1112,
  [1209] = 1047,
  [1210] = 1042,
  [1211] = 1036,
  [1212] = 1112,
  [1213] = 1047,
  [1214] = 1042,
  [1215] = 1036,
  [1216] = 1112,
  [1217] = 1047,
  [1218] = 1042,
  [1219] = 1036,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(135);
      if (lookahead == '!') ADVANCE(322);
      if (lookahead == '"') ADVANCE(291);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '%') ADVANCE(328);
      if (lookahead == '&') ADVANCE(272);
      if (lookahead == '(') ADVANCE(343);
      if (lookahead == ')') ADVANCE(287);
      if (lookahead == '*') ADVANCE(326);
      if (lookahead == '+') ADVANCE(325);
      if (lookahead == ',') ADVANCE(282);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(327);
      if (lookahead == '0') ADVANCE(263);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(289);
      if (lookahead == '=') ADVANCE(281);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(320);
      if (lookahead == '@') ADVANCE(275);
      if (lookahead == '[') ADVANCE(303);
      if (lookahead == '\\') SKIP(130)
      if (lookahead == ']') ADVANCE(304);
      if (lookahead == '^') ADVANCE(332);
      if (lookahead == 'd') ADVANCE(305);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(331);
      if (lookahead == '}') ADVANCE(276);
      if (lookahead == '~') ADVANCE(323);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(133)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= '_') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(45)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(45)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(50)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(50)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(48)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(48)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(41)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(41)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(11)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(361);
      if (lookahead == '!') ADVANCE(66);
      if (lookahead == '%') ADVANCE(328);
      if (lookahead == '&') ADVANCE(271);
      if (lookahead == '(') ADVANCE(286);
      if (lookahead == '*') ADVANCE(326);
      if (lookahead == '+') ADVANCE(325);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '/') ADVANCE(327);
      if (lookahead == '<') ADVANCE(289);
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '^') ADVANCE(332);
      if (lookahead == '|') ADVANCE(331);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(42)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(42)
      if (lookahead == '\r') SKIP(12)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(43)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(43)
      if (lookahead == '\r') SKIP(14)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(52)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(52)
      if (lookahead == '\r') SKIP(16)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(44)
      if (lookahead == '"') ADVANCE(291);
      if (lookahead == '/') ADVANCE(292);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(295);
      if (lookahead != 0) ADVANCE(296);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(298);
      if (lookahead == '\r') ADVANCE(297);
      if (lookahead == 'U') ADVANCE(127);
      if (lookahead == 'u') ADVANCE(123);
      if (lookahead == 'x') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(300);
      if (lookahead != 0) ADVANCE(297);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '\r') ADVANCE(348);
      if (lookahead == '(') ADVANCE(343);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '\r') ADVANCE(348);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '\r') ADVANCE(23);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(24)
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(62)
      if (lookahead == '\r') SKIP(25)
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(63)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(63)
      if (lookahead == '\r') SKIP(27)
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(64)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(64)
      if (lookahead == '\r') SKIP(29)
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(65)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(46)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(46)
      if (lookahead == '\r') SKIP(33)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(53)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(53)
      if (lookahead == '\r') SKIP(35)
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(49)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(49)
      if (lookahead == '\r') SKIP(37)
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(51)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(51)
      if (lookahead == '\r') SKIP(39)
      END_STATE();
    case 41:
      if (lookahead == '!') ADVANCE(66);
      if (lookahead == '%') ADVANCE(328);
      if (lookahead == '&') ADVANCE(272);
      if (lookahead == '(') ADVANCE(286);
      if (lookahead == ')') ADVANCE(287);
      if (lookahead == '*') ADVANCE(326);
      if (lookahead == '+') ADVANCE(325);
      if (lookahead == ',') ADVANCE(282);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(327);
      if (lookahead == '0') ADVANCE(310);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(289);
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(320);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '^') ADVANCE(332);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(331);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 42:
      if (lookahead == '!') ADVANCE(321);
      if (lookahead == '"') ADVANCE(291);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '(') ADVANCE(286);
      if (lookahead == ')') ADVANCE(287);
      if (lookahead == '+') ADVANCE(325);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == '0') ADVANCE(310);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(288);
      if (lookahead == '[') ADVANCE(303);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == 'd') ADVANCE(315);
      if (lookahead == '~') ADVANCE(323);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 43:
      if (lookahead == '!') ADVANCE(321);
      if (lookahead == '"') ADVANCE(291);
      if (lookahead == '(') ADVANCE(286);
      if (lookahead == ')') ADVANCE(287);
      if (lookahead == '+') ADVANCE(325);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '0') ADVANCE(310);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '~') ADVANCE(323);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 44:
      if (lookahead == '"') ADVANCE(291);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(149);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '\\') SKIP(34)
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(46)
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(149);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(261);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(225);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == '}') ADVANCE(276);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(149);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(223);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\\') SKIP(38)
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(149);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(224);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\\') SKIP(40)
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(149);
      END_STATE();
    case 52:
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == '_') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 53:
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\\') SKIP(36)
      if (lookahead == '_') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 54:
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 55:
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'b') ADVANCE(101);
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 56:
      if (lookahead == '*') ADVANCE(56);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead != 0) ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == '*') ADVANCE(56);
      if (lookahead != 0) ADVANCE(57);
      END_STATE();
    case 58:
      if (lookahead == '.') ADVANCE(344);
      END_STATE();
    case 59:
      if (lookahead == '.') ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == '/') ADVANCE(279);
      END_STATE();
    case 61:
      if (lookahead == '/') ADVANCE(285);
      END_STATE();
    case 62:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(26)
      if (lookahead == ']') ADVANCE(304);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 63:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 64:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(30)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(270);
      END_STATE();
    case 65:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(151);
      END_STATE();
    case 66:
      if (lookahead == '=') ADVANCE(334);
      END_STATE();
    case 67:
      if (lookahead == '=') ADVANCE(333);
      END_STATE();
    case 68:
      if (lookahead == '>') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 69:
      if (lookahead == '>') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == 'b') ADVANCE(105);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(70);
      END_STATE();
    case 73:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(73);
      END_STATE();
    case 74:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(74);
      END_STATE();
    case 75:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'e') ADVANCE(109);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(82);
      if (lookahead == 'i') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(85);
      END_STATE();
    case 79:
      if (lookahead == 'd') ADVANCE(87);
      END_STATE();
    case 80:
      if (lookahead == 'd') ADVANCE(88);
      END_STATE();
    case 81:
      if (lookahead == 'd') ADVANCE(90);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(365);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(342);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 91:
      if (lookahead == 'f') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 92:
      if (lookahead == 'f') ADVANCE(102);
      END_STATE();
    case 93:
      if (lookahead == 'f') ADVANCE(367);
      END_STATE();
    case 94:
      if (lookahead == 'f') ADVANCE(362);
      END_STATE();
    case 95:
      if (lookahead == 'f') ADVANCE(363);
      END_STATE();
    case 96:
      if (lookahead == 'f') ADVANCE(345);
      END_STATE();
    case 97:
      if (lookahead == 'f') ADVANCE(364);
      END_STATE();
    case 98:
      if (lookahead == 'f') ADVANCE(369);
      END_STATE();
    case 99:
      if (lookahead == 'f') ADVANCE(370);
      END_STATE();
    case 100:
      if (lookahead == 'f') ADVANCE(366);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(93);
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 104:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(100);
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(103);
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(106);
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 110:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 112:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(61);
      END_STATE();
    case 114:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 115:
      if (lookahead == 's') ADVANCE(60);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 117:
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(312);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(297);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(124);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 128:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(144);
      if (lookahead == '\r') ADVANCE(146);
      END_STATE();
    case 129:
      if (eof) ADVANCE(135);
      if (lookahead == '\n') SKIP(133)
      END_STATE();
    case 130:
      if (eof) ADVANCE(135);
      if (lookahead == '\n') SKIP(133)
      if (lookahead == '\r') SKIP(129)
      END_STATE();
    case 131:
      if (eof) ADVANCE(135);
      if (lookahead == '\n') SKIP(134)
      END_STATE();
    case 132:
      if (eof) ADVANCE(135);
      if (lookahead == '\n') SKIP(134)
      if (lookahead == '\r') SKIP(131)
      END_STATE();
    case 133:
      if (eof) ADVANCE(135);
      if (lookahead == '!') ADVANCE(322);
      if (lookahead == '"') ADVANCE(291);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '%') ADVANCE(328);
      if (lookahead == '&') ADVANCE(272);
      if (lookahead == '(') ADVANCE(286);
      if (lookahead == ')') ADVANCE(287);
      if (lookahead == '*') ADVANCE(326);
      if (lookahead == '+') ADVANCE(325);
      if (lookahead == ',') ADVANCE(282);
      if (lookahead == '-') ADVANCE(324);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(327);
      if (lookahead == '0') ADVANCE(263);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(289);
      if (lookahead == '=') ADVANCE(281);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(320);
      if (lookahead == '@') ADVANCE(275);
      if (lookahead == '[') ADVANCE(303);
      if (lookahead == '\\') SKIP(130)
      if (lookahead == ']') ADVANCE(304);
      if (lookahead == '^') ADVANCE(332);
      if (lookahead == 'd') ADVANCE(305);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '|') ADVANCE(331);
      if (lookahead == '}') ADVANCE(276);
      if (lookahead == '~') ADVANCE(323);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(133)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= '_') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 134:
      if (eof) ADVANCE(135);
      if (lookahead == '#') ADVANCE(73);
      if (lookahead == '&') ADVANCE(273);
      if (lookahead == '(') ADVANCE(286);
      if (lookahead == ')') ADVANCE(287);
      if (lookahead == ',') ADVANCE(282);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '0') ADVANCE(310);
      if (lookahead == ':') ADVANCE(136);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '=') ADVANCE(280);
      if (lookahead == '@') ADVANCE(275);
      if (lookahead == '\\') SKIP(132)
      if (lookahead == '_') ADVANCE(151);
      if (lookahead == '{') ADVANCE(278);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(134)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_SLASHdts_DASHv1_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_SLASHplugin_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SLASHmemreserve_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\r') ADVANCE(145);
      if (lookahead == '\\') ADVANCE(356);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(145);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(128);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(128);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(356);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(144);
      if (lookahead == '\\') ADVANCE(128);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(145);
      if (lookahead == '\\') ADVANCE(356);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym__label_name);
      if (lookahead == '#') ADVANCE(261);
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym__label_name);
      if (lookahead == '#') ADVANCE(261);
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym__label_name);
      if (('+' <= lookahead && lookahead <= '.')) ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym__label_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'i') ADVANCE(194);
      if (lookahead == 'm') ADVANCE(172);
      if (lookahead == 'o') ADVANCE(192);
      if (lookahead == 'p') ADVANCE(189);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == 'd') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(192);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == 'm') ADVANCE(172);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(143);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(215);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(197);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(195);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(186);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '-') ADVANCE(206);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(137);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(139);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(339);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(140);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(277);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(283);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '/') ADVANCE(284);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == '1') ADVANCE(161);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'c') ADVANCE(190);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'd') ADVANCE(178);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'd') ADVANCE(182);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(193);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(191);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(208);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(203);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(184);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(212);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(163);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(205);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(164);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(157);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'e') ADVANCE(166);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'f') ADVANCE(158);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'f') ADVANCE(165);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'g') ADVANCE(188);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'i') ADVANCE(183);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'i') ADVANCE(211);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'i') ADVANCE(196);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(213);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(214);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'l') ADVANCE(177);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'm') ADVANCE(187);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'm') ADVANCE(202);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(169);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(199);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(162);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == 'p') ADVANCE(204);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'o') ADVANCE(201);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'o') ADVANCE(160);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'o') ADVANCE(171);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'p') ADVANCE(179);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(174);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(216);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(198);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(210);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'r') ADVANCE(176);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 's') ADVANCE(156);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 's') ADVANCE(175);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(207);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(217);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(159);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 't') ADVANCE(181);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'u') ADVANCE(185);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'u') ADVANCE(170);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'v') ADVANCE(168);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'v') ADVANCE(180);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym__node_path);
      if (lookahead == 'y') ADVANCE(167);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym__node_path);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym__node_or_property);
      if (lookahead == '#') ADVANCE(261);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym__node_or_property);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'c') ADVANCE(255);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(234);
      if (lookahead == 'e') ADVANCE(254);
      if (lookahead == 'i') ADVANCE(248);
      if (lookahead == 'u') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(73);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(234);
      if (lookahead == 'e') ADVANCE(257);
      if (lookahead == 'i') ADVANCE(248);
      if (lookahead == 'u') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(74);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(234);
      if (lookahead == 'e') ADVANCE(256);
      if (lookahead == 'i') ADVANCE(248);
      if (lookahead == 'u') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(75);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(234);
      if (lookahead == 'i') ADVANCE(248);
      if (lookahead == 'u') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(76);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(252);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(233);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(236);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(237);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'd') ADVANCE(239);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(365);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(342);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(340);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(246);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(241);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(242);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(243);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(244);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(245);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(362);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(363);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(345);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(364);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(369);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(370);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(250);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(366);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(360);
      if (lookahead == 'n') ADVANCE(221);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'f') ADVANCE(368);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'i') ADVANCE(259);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'i') ADVANCE(249);
      if (lookahead == 's') ADVANCE(231);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'i') ADVANCE(240);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'i') ADVANCE(247);
      if (lookahead == 's') ADVANCE(231);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'l') ADVANCE(251);
      if (lookahead == 'n') ADVANCE(226);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'l') ADVANCE(260);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'l') ADVANCE(253);
      if (lookahead == 'n') ADVANCE(226);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(226);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(228);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(232);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == 'u') ADVANCE(227);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym__property_with_hash);
      if (lookahead == '#') ADVANCE(261);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(261);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (lookahead == '#') ADVANCE(261);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(266);
      if (lookahead == 'x') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (lookahead == '\'') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (lookahead == '\'') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(265);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(265);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(268);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym__property_starts_with_number);
      if (lookahead == '#' ||
          ('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(269);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_unit_address);
      if (('+' <= lookahead && lookahead <= '.') ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(270);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(330);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(330);
      if (lookahead == '{') ADVANCE(274);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '{') ADVANCE(274);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_AMP_LBRACE);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_SLASHbits_SLASH);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(333);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_SLASHdelete_DASHnode_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_SLASHdelete_DASHproperty_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_SLASHincbin_SLASH);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(337);
      if (lookahead == '=') ADVANCE(336);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(335);
      if (lookahead == '>') ADVANCE(338);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(294);
      if (lookahead == '/') ADVANCE(296);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(296);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(293);
      if (lookahead == '/') ADVANCE(296);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(294);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(293);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(294);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(292);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(295);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(296);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(296);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(19);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(297);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(299);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_system_lib_string);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_system_lib_string);
      if (lookahead == '>') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == 'e') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == 'f') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (lookahead == 'i') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(308);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym__byte_string_item);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(118);
      if (lookahead == 'x') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '\'') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '\'') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(334);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(57);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(329);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_SLASHinclude_SLASH);
      if (('+' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(218);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(aux_sym_preproc_undef_token1);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(57);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(354);
      if (lookahead != 0) ADVANCE(347);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(57);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '\\') ADVANCE(354);
      if (lookahead != 0) ADVANCE(347);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(341);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(351);
      if (lookahead == '\r') ADVANCE(350);
      if (lookahead == '\\') ADVANCE(355);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(351);
      if (lookahead == '\\') ADVANCE(355);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(24)
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == '/') ADVANCE(145);
      if (lookahead == '\\') ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(353);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\\') ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(353);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '*' &&
          lookahead != '\\') ADVANCE(347);
      if (lookahead == '\r') ADVANCE(357);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '\\') ADVANCE(354);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(353);
      if (lookahead == '\r') ADVANCE(358);
      if (lookahead == '\\') ADVANCE(355);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(145);
      if (lookahead == '\r') ADVANCE(147);
      if (lookahead == '\\') ADVANCE(142);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '\\') ADVANCE(347);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '\\') ADVANCE(354);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(353);
      if (lookahead == '\\') ADVANCE(355);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(86);
      if (lookahead == 'n') ADVANCE(80);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(235);
      if (lookahead == 'n') ADVANCE(229);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(361);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_defined);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(319);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 134},
  [2] = {.lex_state = 134},
  [3] = {.lex_state = 134},
  [4] = {.lex_state = 134},
  [5] = {.lex_state = 134},
  [6] = {.lex_state = 45},
  [7] = {.lex_state = 45},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 45},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 45},
  [14] = {.lex_state = 134},
  [15] = {.lex_state = 50},
  [16] = {.lex_state = 50},
  [17] = {.lex_state = 50},
  [18] = {.lex_state = 50},
  [19] = {.lex_state = 50},
  [20] = {.lex_state = 50},
  [21] = {.lex_state = 50},
  [22] = {.lex_state = 50},
  [23] = {.lex_state = 51},
  [24] = {.lex_state = 51},
  [25] = {.lex_state = 51},
  [26] = {.lex_state = 51},
  [27] = {.lex_state = 51},
  [28] = {.lex_state = 45},
  [29] = {.lex_state = 51},
  [30] = {.lex_state = 51},
  [31] = {.lex_state = 51},
  [32] = {.lex_state = 51},
  [33] = {.lex_state = 51},
  [34] = {.lex_state = 50},
  [35] = {.lex_state = 51},
  [36] = {.lex_state = 134},
  [37] = {.lex_state = 134},
  [38] = {.lex_state = 134},
  [39] = {.lex_state = 48},
  [40] = {.lex_state = 48},
  [41] = {.lex_state = 48},
  [42] = {.lex_state = 48},
  [43] = {.lex_state = 48},
  [44] = {.lex_state = 48},
  [45] = {.lex_state = 48},
  [46] = {.lex_state = 48},
  [47] = {.lex_state = 48},
  [48] = {.lex_state = 48},
  [49] = {.lex_state = 48},
  [50] = {.lex_state = 48},
  [51] = {.lex_state = 48},
  [52] = {.lex_state = 48},
  [53] = {.lex_state = 48},
  [54] = {.lex_state = 48},
  [55] = {.lex_state = 48},
  [56] = {.lex_state = 48},
  [57] = {.lex_state = 48},
  [58] = {.lex_state = 48},
  [59] = {.lex_state = 48},
  [60] = {.lex_state = 48},
  [61] = {.lex_state = 48},
  [62] = {.lex_state = 48},
  [63] = {.lex_state = 48},
  [64] = {.lex_state = 48},
  [65] = {.lex_state = 48},
  [66] = {.lex_state = 48},
  [67] = {.lex_state = 48},
  [68] = {.lex_state = 48},
  [69] = {.lex_state = 48},
  [70] = {.lex_state = 48},
  [71] = {.lex_state = 48},
  [72] = {.lex_state = 48},
  [73] = {.lex_state = 48},
  [74] = {.lex_state = 48},
  [75] = {.lex_state = 48},
  [76] = {.lex_state = 48},
  [77] = {.lex_state = 48},
  [78] = {.lex_state = 48},
  [79] = {.lex_state = 48},
  [80] = {.lex_state = 48},
  [81] = {.lex_state = 48},
  [82] = {.lex_state = 48},
  [83] = {.lex_state = 48},
  [84] = {.lex_state = 48},
  [85] = {.lex_state = 48},
  [86] = {.lex_state = 48},
  [87] = {.lex_state = 48},
  [88] = {.lex_state = 49},
  [89] = {.lex_state = 48},
  [90] = {.lex_state = 48},
  [91] = {.lex_state = 48},
  [92] = {.lex_state = 49},
  [93] = {.lex_state = 48},
  [94] = {.lex_state = 48},
  [95] = {.lex_state = 48},
  [96] = {.lex_state = 48},
  [97] = {.lex_state = 48},
  [98] = {.lex_state = 48},
  [99] = {.lex_state = 48},
  [100] = {.lex_state = 48},
  [101] = {.lex_state = 48},
  [102] = {.lex_state = 48},
  [103] = {.lex_state = 48},
  [104] = {.lex_state = 48},
  [105] = {.lex_state = 48},
  [106] = {.lex_state = 48},
  [107] = {.lex_state = 48},
  [108] = {.lex_state = 48},
  [109] = {.lex_state = 48},
  [110] = {.lex_state = 48},
  [111] = {.lex_state = 48},
  [112] = {.lex_state = 48},
  [113] = {.lex_state = 48},
  [114] = {.lex_state = 48},
  [115] = {.lex_state = 48},
  [116] = {.lex_state = 48},
  [117] = {.lex_state = 48},
  [118] = {.lex_state = 48},
  [119] = {.lex_state = 48},
  [120] = {.lex_state = 48},
  [121] = {.lex_state = 48},
  [122] = {.lex_state = 48},
  [123] = {.lex_state = 48},
  [124] = {.lex_state = 48},
  [125] = {.lex_state = 48},
  [126] = {.lex_state = 48},
  [127] = {.lex_state = 48},
  [128] = {.lex_state = 48},
  [129] = {.lex_state = 48},
  [130] = {.lex_state = 48},
  [131] = {.lex_state = 49},
  [132] = {.lex_state = 48},
  [133] = {.lex_state = 48},
  [134] = {.lex_state = 48},
  [135] = {.lex_state = 48},
  [136] = {.lex_state = 48},
  [137] = {.lex_state = 48},
  [138] = {.lex_state = 48},
  [139] = {.lex_state = 48},
  [140] = {.lex_state = 48},
  [141] = {.lex_state = 48},
  [142] = {.lex_state = 48},
  [143] = {.lex_state = 48},
  [144] = {.lex_state = 48},
  [145] = {.lex_state = 48},
  [146] = {.lex_state = 48},
  [147] = {.lex_state = 48},
  [148] = {.lex_state = 48},
  [149] = {.lex_state = 48},
  [150] = {.lex_state = 48},
  [151] = {.lex_state = 41},
  [152] = {.lex_state = 41},
  [153] = {.lex_state = 41},
  [154] = {.lex_state = 41},
  [155] = {.lex_state = 134},
  [156] = {.lex_state = 134},
  [157] = {.lex_state = 41},
  [158] = {.lex_state = 41},
  [159] = {.lex_state = 134},
  [160] = {.lex_state = 134},
  [161] = {.lex_state = 134},
  [162] = {.lex_state = 134},
  [163] = {.lex_state = 41},
  [164] = {.lex_state = 134},
  [165] = {.lex_state = 41},
  [166] = {.lex_state = 134},
  [167] = {.lex_state = 134},
  [168] = {.lex_state = 41},
  [169] = {.lex_state = 41},
  [170] = {.lex_state = 41},
  [171] = {.lex_state = 41},
  [172] = {.lex_state = 41},
  [173] = {.lex_state = 41},
  [174] = {.lex_state = 41},
  [175] = {.lex_state = 41},
  [176] = {.lex_state = 41},
  [177] = {.lex_state = 41},
  [178] = {.lex_state = 41},
  [179] = {.lex_state = 134},
  [180] = {.lex_state = 134},
  [181] = {.lex_state = 134},
  [182] = {.lex_state = 134},
  [183] = {.lex_state = 41},
  [184] = {.lex_state = 134},
  [185] = {.lex_state = 134},
  [186] = {.lex_state = 134},
  [187] = {.lex_state = 134},
  [188] = {.lex_state = 134},
  [189] = {.lex_state = 134},
  [190] = {.lex_state = 134},
  [191] = {.lex_state = 134},
  [192] = {.lex_state = 134},
  [193] = {.lex_state = 134},
  [194] = {.lex_state = 134},
  [195] = {.lex_state = 134},
  [196] = {.lex_state = 134},
  [197] = {.lex_state = 134},
  [198] = {.lex_state = 134},
  [199] = {.lex_state = 134},
  [200] = {.lex_state = 134},
  [201] = {.lex_state = 134},
  [202] = {.lex_state = 134},
  [203] = {.lex_state = 134},
  [204] = {.lex_state = 134},
  [205] = {.lex_state = 134},
  [206] = {.lex_state = 134},
  [207] = {.lex_state = 134},
  [208] = {.lex_state = 134},
  [209] = {.lex_state = 134},
  [210] = {.lex_state = 134},
  [211] = {.lex_state = 134},
  [212] = {.lex_state = 45},
  [213] = {.lex_state = 45},
  [214] = {.lex_state = 45},
  [215] = {.lex_state = 45},
  [216] = {.lex_state = 45},
  [217] = {.lex_state = 45},
  [218] = {.lex_state = 45},
  [219] = {.lex_state = 45},
  [220] = {.lex_state = 45},
  [221] = {.lex_state = 45},
  [222] = {.lex_state = 45},
  [223] = {.lex_state = 45},
  [224] = {.lex_state = 45},
  [225] = {.lex_state = 45},
  [226] = {.lex_state = 45},
  [227] = {.lex_state = 45},
  [228] = {.lex_state = 45},
  [229] = {.lex_state = 45},
  [230] = {.lex_state = 45},
  [231] = {.lex_state = 45},
  [232] = {.lex_state = 45},
  [233] = {.lex_state = 45},
  [234] = {.lex_state = 45},
  [235] = {.lex_state = 45},
  [236] = {.lex_state = 45},
  [237] = {.lex_state = 45},
  [238] = {.lex_state = 45},
  [239] = {.lex_state = 45},
  [240] = {.lex_state = 45},
  [241] = {.lex_state = 45},
  [242] = {.lex_state = 45},
  [243] = {.lex_state = 45},
  [244] = {.lex_state = 45},
  [245] = {.lex_state = 45},
  [246] = {.lex_state = 45},
  [247] = {.lex_state = 45},
  [248] = {.lex_state = 45},
  [249] = {.lex_state = 45},
  [250] = {.lex_state = 45},
  [251] = {.lex_state = 45},
  [252] = {.lex_state = 45},
  [253] = {.lex_state = 45},
  [254] = {.lex_state = 45},
  [255] = {.lex_state = 45},
  [256] = {.lex_state = 45},
  [257] = {.lex_state = 45},
  [258] = {.lex_state = 45},
  [259] = {.lex_state = 45},
  [260] = {.lex_state = 45},
  [261] = {.lex_state = 45},
  [262] = {.lex_state = 45},
  [263] = {.lex_state = 45},
  [264] = {.lex_state = 45},
  [265] = {.lex_state = 45},
  [266] = {.lex_state = 45},
  [267] = {.lex_state = 45},
  [268] = {.lex_state = 41},
  [269] = {.lex_state = 45},
  [270] = {.lex_state = 45},
  [271] = {.lex_state = 45},
  [272] = {.lex_state = 45},
  [273] = {.lex_state = 45},
  [274] = {.lex_state = 45},
  [275] = {.lex_state = 45},
  [276] = {.lex_state = 45},
  [277] = {.lex_state = 11},
  [278] = {.lex_state = 45},
  [279] = {.lex_state = 45},
  [280] = {.lex_state = 41},
  [281] = {.lex_state = 45},
  [282] = {.lex_state = 41},
  [283] = {.lex_state = 45},
  [284] = {.lex_state = 45},
  [285] = {.lex_state = 45},
  [286] = {.lex_state = 45},
  [287] = {.lex_state = 41},
  [288] = {.lex_state = 41},
  [289] = {.lex_state = 41},
  [290] = {.lex_state = 41},
  [291] = {.lex_state = 41},
  [292] = {.lex_state = 41},
  [293] = {.lex_state = 41},
  [294] = {.lex_state = 41},
  [295] = {.lex_state = 41},
  [296] = {.lex_state = 41},
  [297] = {.lex_state = 41},
  [298] = {.lex_state = 41},
  [299] = {.lex_state = 41},
  [300] = {.lex_state = 41},
  [301] = {.lex_state = 41},
  [302] = {.lex_state = 41},
  [303] = {.lex_state = 41},
  [304] = {.lex_state = 41},
  [305] = {.lex_state = 41},
  [306] = {.lex_state = 41},
  [307] = {.lex_state = 41},
  [308] = {.lex_state = 41},
  [309] = {.lex_state = 51},
  [310] = {.lex_state = 11},
  [311] = {.lex_state = 51},
  [312] = {.lex_state = 51},
  [313] = {.lex_state = 51},
  [314] = {.lex_state = 51},
  [315] = {.lex_state = 50},
  [316] = {.lex_state = 51},
  [317] = {.lex_state = 51},
  [318] = {.lex_state = 51},
  [319] = {.lex_state = 51},
  [320] = {.lex_state = 51},
  [321] = {.lex_state = 50},
  [322] = {.lex_state = 51},
  [323] = {.lex_state = 50},
  [324] = {.lex_state = 51},
  [325] = {.lex_state = 50},
  [326] = {.lex_state = 51},
  [327] = {.lex_state = 51},
  [328] = {.lex_state = 50},
  [329] = {.lex_state = 51},
  [330] = {.lex_state = 51},
  [331] = {.lex_state = 50},
  [332] = {.lex_state = 51},
  [333] = {.lex_state = 51},
  [334] = {.lex_state = 51},
  [335] = {.lex_state = 50},
  [336] = {.lex_state = 50},
  [337] = {.lex_state = 51},
  [338] = {.lex_state = 51},
  [339] = {.lex_state = 51},
  [340] = {.lex_state = 11},
  [341] = {.lex_state = 51},
  [342] = {.lex_state = 50},
  [343] = {.lex_state = 11},
  [344] = {.lex_state = 50},
  [345] = {.lex_state = 51},
  [346] = {.lex_state = 51},
  [347] = {.lex_state = 51},
  [348] = {.lex_state = 51},
  [349] = {.lex_state = 50},
  [350] = {.lex_state = 51},
  [351] = {.lex_state = 51},
  [352] = {.lex_state = 51},
  [353] = {.lex_state = 50},
  [354] = {.lex_state = 11},
  [355] = {.lex_state = 50},
  [356] = {.lex_state = 51},
  [357] = {.lex_state = 50},
  [358] = {.lex_state = 51},
  [359] = {.lex_state = 50},
  [360] = {.lex_state = 51},
  [361] = {.lex_state = 11},
  [362] = {.lex_state = 11},
  [363] = {.lex_state = 41},
  [364] = {.lex_state = 11},
  [365] = {.lex_state = 11},
  [366] = {.lex_state = 11},
  [367] = {.lex_state = 11},
  [368] = {.lex_state = 11},
  [369] = {.lex_state = 51},
  [370] = {.lex_state = 51},
  [371] = {.lex_state = 41},
  [372] = {.lex_state = 51},
  [373] = {.lex_state = 51},
  [374] = {.lex_state = 51},
  [375] = {.lex_state = 11},
  [376] = {.lex_state = 11},
  [377] = {.lex_state = 51},
  [378] = {.lex_state = 51},
  [379] = {.lex_state = 51},
  [380] = {.lex_state = 11},
  [381] = {.lex_state = 11},
  [382] = {.lex_state = 11},
  [383] = {.lex_state = 11},
  [384] = {.lex_state = 51},
  [385] = {.lex_state = 51},
  [386] = {.lex_state = 50},
  [387] = {.lex_state = 50},
  [388] = {.lex_state = 50},
  [389] = {.lex_state = 11},
  [390] = {.lex_state = 11},
  [391] = {.lex_state = 51},
  [392] = {.lex_state = 51},
  [393] = {.lex_state = 51},
  [394] = {.lex_state = 50},
  [395] = {.lex_state = 50},
  [396] = {.lex_state = 51},
  [397] = {.lex_state = 11},
  [398] = {.lex_state = 51},
  [399] = {.lex_state = 51},
  [400] = {.lex_state = 51},
  [401] = {.lex_state = 51},
  [402] = {.lex_state = 51},
  [403] = {.lex_state = 51},
  [404] = {.lex_state = 51},
  [405] = {.lex_state = 51},
  [406] = {.lex_state = 51},
  [407] = {.lex_state = 51},
  [408] = {.lex_state = 51},
  [409] = {.lex_state = 11},
  [410] = {.lex_state = 50},
  [411] = {.lex_state = 50},
  [412] = {.lex_state = 50},
  [413] = {.lex_state = 51},
  [414] = {.lex_state = 51},
  [415] = {.lex_state = 51},
  [416] = {.lex_state = 51},
  [417] = {.lex_state = 51},
  [418] = {.lex_state = 51},
  [419] = {.lex_state = 51},
  [420] = {.lex_state = 51},
  [421] = {.lex_state = 51},
  [422] = {.lex_state = 51},
  [423] = {.lex_state = 50},
  [424] = {.lex_state = 50},
  [425] = {.lex_state = 50},
  [426] = {.lex_state = 50},
  [427] = {.lex_state = 51},
  [428] = {.lex_state = 51},
  [429] = {.lex_state = 51},
  [430] = {.lex_state = 50},
  [431] = {.lex_state = 50},
  [432] = {.lex_state = 50},
  [433] = {.lex_state = 50},
  [434] = {.lex_state = 50},
  [435] = {.lex_state = 11},
  [436] = {.lex_state = 50},
  [437] = {.lex_state = 50},
  [438] = {.lex_state = 11},
  [439] = {.lex_state = 50},
  [440] = {.lex_state = 50},
  [441] = {.lex_state = 11},
  [442] = {.lex_state = 50},
  [443] = {.lex_state = 11},
  [444] = {.lex_state = 50},
  [445] = {.lex_state = 11},
  [446] = {.lex_state = 50},
  [447] = {.lex_state = 50},
  [448] = {.lex_state = 50},
  [449] = {.lex_state = 48},
  [450] = {.lex_state = 42},
  [451] = {.lex_state = 48},
  [452] = {.lex_state = 48},
  [453] = {.lex_state = 48},
  [454] = {.lex_state = 48},
  [455] = {.lex_state = 48},
  [456] = {.lex_state = 48},
  [457] = {.lex_state = 48},
  [458] = {.lex_state = 48},
  [459] = {.lex_state = 49},
  [460] = {.lex_state = 49},
  [461] = {.lex_state = 49},
  [462] = {.lex_state = 49},
  [463] = {.lex_state = 49},
  [464] = {.lex_state = 49},
  [465] = {.lex_state = 49},
  [466] = {.lex_state = 49},
  [467] = {.lex_state = 49},
  [468] = {.lex_state = 49},
  [469] = {.lex_state = 49},
  [470] = {.lex_state = 48},
  [471] = {.lex_state = 48},
  [472] = {.lex_state = 48},
  [473] = {.lex_state = 48},
  [474] = {.lex_state = 48},
  [475] = {.lex_state = 49},
  [476] = {.lex_state = 42},
  [477] = {.lex_state = 42},
  [478] = {.lex_state = 42},
  [479] = {.lex_state = 48},
  [480] = {.lex_state = 48},
  [481] = {.lex_state = 42},
  [482] = {.lex_state = 49},
  [483] = {.lex_state = 48},
  [484] = {.lex_state = 48},
  [485] = {.lex_state = 48},
  [486] = {.lex_state = 48},
  [487] = {.lex_state = 48},
  [488] = {.lex_state = 48},
  [489] = {.lex_state = 48},
  [490] = {.lex_state = 48},
  [491] = {.lex_state = 48},
  [492] = {.lex_state = 49},
  [493] = {.lex_state = 49},
  [494] = {.lex_state = 49},
  [495] = {.lex_state = 49},
  [496] = {.lex_state = 49},
  [497] = {.lex_state = 48},
  [498] = {.lex_state = 48},
  [499] = {.lex_state = 49},
  [500] = {.lex_state = 48},
  [501] = {.lex_state = 48},
  [502] = {.lex_state = 48},
  [503] = {.lex_state = 48},
  [504] = {.lex_state = 42},
  [505] = {.lex_state = 49},
  [506] = {.lex_state = 49},
  [507] = {.lex_state = 48},
  [508] = {.lex_state = 42},
  [509] = {.lex_state = 42},
  [510] = {.lex_state = 48},
  [511] = {.lex_state = 42},
  [512] = {.lex_state = 42},
  [513] = {.lex_state = 48},
  [514] = {.lex_state = 48},
  [515] = {.lex_state = 49},
  [516] = {.lex_state = 48},
  [517] = {.lex_state = 49},
  [518] = {.lex_state = 48},
  [519] = {.lex_state = 49},
  [520] = {.lex_state = 48},
  [521] = {.lex_state = 48},
  [522] = {.lex_state = 49},
  [523] = {.lex_state = 48},
  [524] = {.lex_state = 49},
  [525] = {.lex_state = 48},
  [526] = {.lex_state = 48},
  [527] = {.lex_state = 42},
  [528] = {.lex_state = 49},
  [529] = {.lex_state = 48},
  [530] = {.lex_state = 42},
  [531] = {.lex_state = 48},
  [532] = {.lex_state = 42},
  [533] = {.lex_state = 48},
  [534] = {.lex_state = 48},
  [535] = {.lex_state = 42},
  [536] = {.lex_state = 42},
  [537] = {.lex_state = 42},
  [538] = {.lex_state = 42},
  [539] = {.lex_state = 49},
  [540] = {.lex_state = 49},
  [541] = {.lex_state = 49},
  [542] = {.lex_state = 49},
  [543] = {.lex_state = 48},
  [544] = {.lex_state = 42},
  [545] = {.lex_state = 48},
  [546] = {.lex_state = 48},
  [547] = {.lex_state = 49},
  [548] = {.lex_state = 48},
  [549] = {.lex_state = 49},
  [550] = {.lex_state = 42},
  [551] = {.lex_state = 48},
  [552] = {.lex_state = 48},
  [553] = {.lex_state = 48},
  [554] = {.lex_state = 42},
  [555] = {.lex_state = 48},
  [556] = {.lex_state = 48},
  [557] = {.lex_state = 48},
  [558] = {.lex_state = 49},
  [559] = {.lex_state = 48},
  [560] = {.lex_state = 48},
  [561] = {.lex_state = 49},
  [562] = {.lex_state = 48},
  [563] = {.lex_state = 48},
  [564] = {.lex_state = 49},
  [565] = {.lex_state = 48},
  [566] = {.lex_state = 49},
  [567] = {.lex_state = 49},
  [568] = {.lex_state = 48},
  [569] = {.lex_state = 49},
  [570] = {.lex_state = 49},
  [571] = {.lex_state = 49},
  [572] = {.lex_state = 49},
  [573] = {.lex_state = 49},
  [574] = {.lex_state = 49},
  [575] = {.lex_state = 49},
  [576] = {.lex_state = 49},
  [577] = {.lex_state = 49},
  [578] = {.lex_state = 49},
  [579] = {.lex_state = 49},
  [580] = {.lex_state = 49},
  [581] = {.lex_state = 49},
  [582] = {.lex_state = 48},
  [583] = {.lex_state = 48},
  [584] = {.lex_state = 49},
  [585] = {.lex_state = 48},
  [586] = {.lex_state = 49},
  [587] = {.lex_state = 49},
  [588] = {.lex_state = 48},
  [589] = {.lex_state = 49},
  [590] = {.lex_state = 49},
  [591] = {.lex_state = 49},
  [592] = {.lex_state = 48},
  [593] = {.lex_state = 49},
  [594] = {.lex_state = 49},
  [595] = {.lex_state = 48},
  [596] = {.lex_state = 49},
  [597] = {.lex_state = 49},
  [598] = {.lex_state = 49},
  [599] = {.lex_state = 49},
  [600] = {.lex_state = 49},
  [601] = {.lex_state = 49},
  [602] = {.lex_state = 49},
  [603] = {.lex_state = 49},
  [604] = {.lex_state = 49},
  [605] = {.lex_state = 49},
  [606] = {.lex_state = 48},
  [607] = {.lex_state = 49},
  [608] = {.lex_state = 48},
  [609] = {.lex_state = 48},
  [610] = {.lex_state = 49},
  [611] = {.lex_state = 42},
  [612] = {.lex_state = 42},
  [613] = {.lex_state = 42},
  [614] = {.lex_state = 42},
  [615] = {.lex_state = 42},
  [616] = {.lex_state = 42},
  [617] = {.lex_state = 42},
  [618] = {.lex_state = 42},
  [619] = {.lex_state = 42},
  [620] = {.lex_state = 42},
  [621] = {.lex_state = 42},
  [622] = {.lex_state = 42},
  [623] = {.lex_state = 42},
  [624] = {.lex_state = 42},
  [625] = {.lex_state = 42},
  [626] = {.lex_state = 42},
  [627] = {.lex_state = 42},
  [628] = {.lex_state = 42},
  [629] = {.lex_state = 42},
  [630] = {.lex_state = 42},
  [631] = {.lex_state = 42},
  [632] = {.lex_state = 42},
  [633] = {.lex_state = 42},
  [634] = {.lex_state = 42},
  [635] = {.lex_state = 42},
  [636] = {.lex_state = 42},
  [637] = {.lex_state = 42},
  [638] = {.lex_state = 42},
  [639] = {.lex_state = 42},
  [640] = {.lex_state = 42},
  [641] = {.lex_state = 42},
  [642] = {.lex_state = 42},
  [643] = {.lex_state = 42},
  [644] = {.lex_state = 42},
  [645] = {.lex_state = 42},
  [646] = {.lex_state = 42},
  [647] = {.lex_state = 42},
  [648] = {.lex_state = 42},
  [649] = {.lex_state = 42},
  [650] = {.lex_state = 42},
  [651] = {.lex_state = 42},
  [652] = {.lex_state = 42},
  [653] = {.lex_state = 42},
  [654] = {.lex_state = 42},
  [655] = {.lex_state = 42},
  [656] = {.lex_state = 42},
  [657] = {.lex_state = 42},
  [658] = {.lex_state = 42},
  [659] = {.lex_state = 42},
  [660] = {.lex_state = 42},
  [661] = {.lex_state = 42},
  [662] = {.lex_state = 42},
  [663] = {.lex_state = 42},
  [664] = {.lex_state = 42},
  [665] = {.lex_state = 42},
  [666] = {.lex_state = 42},
  [667] = {.lex_state = 43},
  [668] = {.lex_state = 43},
  [669] = {.lex_state = 43},
  [670] = {.lex_state = 43},
  [671] = {.lex_state = 43},
  [672] = {.lex_state = 46},
  [673] = {.lex_state = 43},
  [674] = {.lex_state = 43},
  [675] = {.lex_state = 43},
  [676] = {.lex_state = 43},
  [677] = {.lex_state = 43},
  [678] = {.lex_state = 43},
  [679] = {.lex_state = 43},
  [680] = {.lex_state = 43},
  [681] = {.lex_state = 43},
  [682] = {.lex_state = 41},
  [683] = {.lex_state = 46},
  [684] = {.lex_state = 43},
  [685] = {.lex_state = 43},
  [686] = {.lex_state = 41},
  [687] = {.lex_state = 43},
  [688] = {.lex_state = 46},
  [689] = {.lex_state = 46},
  [690] = {.lex_state = 41},
  [691] = {.lex_state = 52},
  [692] = {.lex_state = 52},
  [693] = {.lex_state = 53},
  [694] = {.lex_state = 52},
  [695] = {.lex_state = 52},
  [696] = {.lex_state = 52},
  [697] = {.lex_state = 52},
  [698] = {.lex_state = 53},
  [699] = {.lex_state = 52},
  [700] = {.lex_state = 41},
  [701] = {.lex_state = 52},
  [702] = {.lex_state = 52},
  [703] = {.lex_state = 52},
  [704] = {.lex_state = 41},
  [705] = {.lex_state = 41},
  [706] = {.lex_state = 41},
  [707] = {.lex_state = 52},
  [708] = {.lex_state = 41},
  [709] = {.lex_state = 52},
  [710] = {.lex_state = 41},
  [711] = {.lex_state = 41},
  [712] = {.lex_state = 41},
  [713] = {.lex_state = 46},
  [714] = {.lex_state = 52},
  [715] = {.lex_state = 53},
  [716] = {.lex_state = 52},
  [717] = {.lex_state = 41},
  [718] = {.lex_state = 52},
  [719] = {.lex_state = 52},
  [720] = {.lex_state = 42},
  [721] = {.lex_state = 46},
  [722] = {.lex_state = 46},
  [723] = {.lex_state = 52},
  [724] = {.lex_state = 53},
  [725] = {.lex_state = 53},
  [726] = {.lex_state = 134},
  [727] = {.lex_state = 134},
  [728] = {.lex_state = 134},
  [729] = {.lex_state = 134},
  [730] = {.lex_state = 134},
  [731] = {.lex_state = 134},
  [732] = {.lex_state = 134},
  [733] = {.lex_state = 52},
  [734] = {.lex_state = 134},
  [735] = {.lex_state = 52},
  [736] = {.lex_state = 43},
  [737] = {.lex_state = 43},
  [738] = {.lex_state = 18},
  [739] = {.lex_state = 134},
  [740] = {.lex_state = 134},
  [741] = {.lex_state = 20},
  [742] = {.lex_state = 134},
  [743] = {.lex_state = 43},
  [744] = {.lex_state = 134},
  [745] = {.lex_state = 43},
  [746] = {.lex_state = 20},
  [747] = {.lex_state = 18},
  [748] = {.lex_state = 18},
  [749] = {.lex_state = 134},
  [750] = {.lex_state = 20},
  [751] = {.lex_state = 43},
  [752] = {.lex_state = 134},
  [753] = {.lex_state = 46},
  [754] = {.lex_state = 20},
  [755] = {.lex_state = 18},
  [756] = {.lex_state = 20},
  [757] = {.lex_state = 18},
  [758] = {.lex_state = 134},
  [759] = {.lex_state = 20},
  [760] = {.lex_state = 46},
  [761] = {.lex_state = 18},
  [762] = {.lex_state = 134},
  [763] = {.lex_state = 46},
  [764] = {.lex_state = 43},
  [765] = {.lex_state = 18},
  [766] = {.lex_state = 46},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 52},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 62},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 62},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 62},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 41},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 21},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 134},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 21},
  [883] = {.lex_state = 41},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 21},
  [886] = {.lex_state = 134},
  [887] = {.lex_state = 134},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 134},
  [890] = {.lex_state = 21},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 41},
  [895] = {.lex_state = 134},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 134},
  [898] = {.lex_state = 134},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 134},
  [904] = {.lex_state = 134},
  [905] = {.lex_state = 21},
  [906] = {.lex_state = 41},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 134},
  [909] = {.lex_state = 21},
  [910] = {.lex_state = 134},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 21},
  [916] = {.lex_state = 21},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 21},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 134},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 22},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 22},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 22},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 22},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 22},
  [981] = {.lex_state = 22},
  [982] = {.lex_state = 22},
  [983] = {.lex_state = 22},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 22},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 22},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 41},
  [1007] = {.lex_state = 41},
  [1008] = {.lex_state = 41},
  [1009] = {.lex_state = 134},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 41},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 41},
  [1019] = {.lex_state = 134},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 22},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 64},
  [1037] = {.lex_state = 22},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 41},
  [1041] = {.lex_state = 41},
  [1042] = {.lex_state = 64},
  [1043] = {.lex_state = 134},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 41},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 64},
  [1048] = {.lex_state = 134},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 41},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 22},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 22},
  [1058] = {.lex_state = 22},
  [1059] = {.lex_state = 22},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 41},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 41},
  [1069] = {.lex_state = 41},
  [1070] = {.lex_state = 22},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 41},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 64},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 41},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 22},
  [1096] = {.lex_state = 41},
  [1097] = {.lex_state = 41},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 134},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 22},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 22},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 64},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 134},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 22},
  [1119] = {.lex_state = 41},
  [1120] = {.lex_state = 41},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 41},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 41},
  [1129] = {.lex_state = 41},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 65},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 22},
  [1137] = {.lex_state = 134},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 22},
  [1141] = {.lex_state = 134},
  [1142] = {.lex_state = 22},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 134},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 22},
  [1182] = {.lex_state = 134},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 22},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 64},
  [1201] = {.lex_state = 64},
  [1202] = {.lex_state = 64},
  [1203] = {.lex_state = 64},
  [1204] = {.lex_state = 64},
  [1205] = {.lex_state = 64},
  [1206] = {.lex_state = 64},
  [1207] = {.lex_state = 64},
  [1208] = {.lex_state = 64},
  [1209] = {.lex_state = 64},
  [1210] = {.lex_state = 64},
  [1211] = {.lex_state = 64},
  [1212] = {.lex_state = 64},
  [1213] = {.lex_state = 64},
  [1214] = {.lex_state = 64},
  [1215] = {.lex_state = 64},
  [1216] = {.lex_state = 64},
  [1217] = {.lex_state = 64},
  [1218] = {.lex_state = 64},
  [1219] = {.lex_state = 64},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__property_starts_with_number] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_AMP_LBRACE] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym__byte_string_item] = ACTIONS(1),
    [sym_integer_literal] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [aux_sym_preproc_include_token1] = ACTIONS(1),
    [aux_sym_preproc_def_token1] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [aux_sym_preproc_undef_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token1] = ACTIONS(1),
    [aux_sym_preproc_if_token2] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(1),
    [aux_sym_preproc_else_token1] = ACTIONS(1),
    [aux_sym_preproc_elif_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token1] = ACTIONS(1),
    [aux_sym_preproc_elifdef_token2] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(1125),
    [sym__top_level_item] = STATE(36),
    [sym__label] = STATE(725),
    [sym_file_version] = STATE(36),
    [sym_plugin] = STATE(36),
    [sym_memory_reservation] = STATE(36),
    [sym_reference] = STATE(1123),
    [sym__label_reference] = STATE(711),
    [sym__node_reference] = STATE(708),
    [sym_omit_if_no_ref] = STATE(36),
    [sym_node] = STATE(36),
    [sym_dtsi_include] = STATE(36),
    [sym_preproc_include] = STATE(36),
    [sym_preproc_def] = STATE(36),
    [sym_preproc_function_def] = STATE(36),
    [sym_preproc_undef] = STATE(36),
    [sym_preproc_if] = STATE(36),
    [sym_preproc_ifdef] = STATE(36),
    [aux_sym_document_repeat1] = STATE(36),
    [aux_sym_memory_reservation_repeat1] = STATE(698),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SLASHdts_DASHv1_SLASH] = ACTIONS(7),
    [anon_sym_SLASHplugin_SLASH] = ACTIONS(9),
    [anon_sym_SLASHmemreserve_SLASH] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [sym__label_name] = ACTIONS(13),
    [sym__node_path] = ACTIONS(15),
    [sym__node_or_property] = ACTIONS(15),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_AMP_LBRACE] = ACTIONS(19),
    [anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH] = ACTIONS(21),
    [anon_sym_SLASHinclude_SLASH] = ACTIONS(23),
    [aux_sym_preproc_include_token1] = ACTIONS(25),
    [aux_sym_preproc_def_token1] = ACTIONS(27),
    [aux_sym_preproc_undef_token1] = ACTIONS(29),
    [aux_sym_preproc_if_token1] = ACTIONS(31),
    [aux_sym_preproc_ifdef_token1] = ACTIONS(33),
    [aux_sym_preproc_ifdef_token2] = ACTIONS(33),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(35), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(39), 1,
      aux_sym_preproc_elif_token1,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1049), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(3), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [97] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(39), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(43), 1,
      aux_sym_preproc_if_token2,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1044), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(14), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [194] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(39), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(45), 1,
      aux_sym_preproc_if_token2,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1135), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(5), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [291] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(39), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(47), 1,
      aux_sym_preproc_if_token2,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(1105), 3,
      sym_preproc_else,
      sym_preproc_elif,
      sym_preproc_elifdef,
    STATE(14), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [388] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(71), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1183), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(13), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [484] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(79), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1022), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(8), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [580] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(81), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(950), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(28), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [676] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(83), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1081), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(28), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [772] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(85), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(944), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(11), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [868] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(87), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1052), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(28), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [964] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(89), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1101), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(9), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1060] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(49), 1,
      sym__label_name,
    ACTIONS(51), 1,
      sym__node_path,
    ACTIONS(53), 1,
      sym__node_or_property,
    ACTIONS(57), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(59), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(61), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(63), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(65), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(67), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(69), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(77), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(91), 1,
      aux_sym_preproc_if_token2,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(41), 2,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(55), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(73), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1160), 3,
      sym_preproc_elifdef,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(28), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [1156] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(98), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(101), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(104), 1,
      sym__label_name,
    ACTIONS(110), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(116), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(119), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(122), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(125), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(128), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(131), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(137), 1,
      aux_sym_preproc_elif_token1,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(107), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(134), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(93), 5,
      ts_builtin_sym_end,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(14), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1245] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(161), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1061), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(34), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1337] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(167), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1179), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(34), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1429] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(169), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1103), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(16), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1521] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(171), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1005), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(34), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1613] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(173), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1060), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(22), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1705] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(175), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1011), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(15), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1797] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(177), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1017), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(18), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1889] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(37), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(139), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(141), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(143), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(145), 1,
      sym__label_name,
    ACTIONS(149), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(151), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(153), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(155), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(157), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(159), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(165), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(179), 1,
      aux_sym_preproc_if_token2,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(163), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1108), 2,
      sym_preproc_else,
      sym_preproc_elif,
    STATE(34), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [1981] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(203), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1121), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(32), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2072] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(209), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1161), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(26), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2163] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(211), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1072), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(35), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2254] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(213), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1149), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(35), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2345] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(215), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1051), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(31), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2436] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      sym__label_name,
    ACTIONS(220), 1,
      sym__node_path,
    ACTIONS(223), 1,
      sym__node_or_property,
    ACTIONS(229), 1,
      anon_sym_AMP,
    ACTIONS(232), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(235), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(238), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(241), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(244), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(247), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(250), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(253), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(261), 1,
      aux_sym_preproc_elif_token1,
    STATE(688), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1169), 1,
      sym_reference,
    ACTIONS(226), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(258), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(256), 4,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    STATE(28), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2523] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(263), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(952), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(33), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2614] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(265), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1085), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(25), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2705] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(267), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1083), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(35), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2796] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(269), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(1153), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(35), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2887] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(75), 1,
      aux_sym_preproc_else_token1,
    ACTIONS(181), 1,
      sym__label_name,
    ACTIONS(183), 1,
      sym__node_path,
    ACTIONS(185), 1,
      sym__node_or_property,
    ACTIONS(189), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(191), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(193), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(195), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(197), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(199), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(201), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(207), 1,
      aux_sym_preproc_elif_token1,
    ACTIONS(271), 1,
      aux_sym_preproc_if_token2,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(187), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(205), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(940), 2,
      sym_preproc_else_in_node,
      sym_preproc_elif_in_node,
    STATE(35), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [2978] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(110), 1,
      anon_sym_AMP,
    ACTIONS(113), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(273), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(276), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(279), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(282), 1,
      sym__label_name,
    ACTIONS(288), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(291), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(294), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(297), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(300), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(303), 1,
      aux_sym_preproc_if_token1,
    STATE(693), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1158), 1,
      sym_reference,
    ACTIONS(285), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(306), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(93), 3,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    STATE(34), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3062] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      anon_sym_AMP,
    ACTIONS(232), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(309), 1,
      sym__label_name,
    ACTIONS(312), 1,
      sym__node_path,
    ACTIONS(315), 1,
      sym__node_or_property,
    ACTIONS(321), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(324), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(327), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(330), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(333), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(336), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(339), 1,
      aux_sym_preproc_if_token1,
    STATE(672), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1180), 1,
      sym_reference,
    ACTIONS(318), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(342), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(256), 3,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    STATE(35), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3145] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(345), 1,
      ts_builtin_sym_end,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(14), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3227] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(347), 1,
      aux_sym_preproc_if_token2,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(14), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3309] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASHdts_DASHv1_SLASH,
    ACTIONS(9), 1,
      anon_sym_SLASHplugin_SLASH,
    ACTIONS(11), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(13), 1,
      sym__label_name,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(21), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(23), 1,
      anon_sym_SLASHinclude_SLASH,
    ACTIONS(25), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(27), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(29), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(31), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(349), 1,
      aux_sym_preproc_if_token2,
    STATE(698), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(725), 1,
      sym__label,
    STATE(1123), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
    ACTIONS(33), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(37), 14,
      sym__top_level_item,
      sym_file_version,
      sym_plugin,
      sym_memory_reservation,
      sym_omit_if_no_ref,
      sym_node,
      sym_dtsi_include,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if,
      sym_preproc_ifdef,
      aux_sym_document_repeat1,
  [3391] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(359), 1,
      anon_sym_RBRACE,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3472] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(377), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(65), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3553] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(379), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3634] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(381), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3715] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(383), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(107), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3796] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(385), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(97), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3877] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(387), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(91), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [3958] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(389), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(127), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4039] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(391), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(42), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4120] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(393), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4201] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(395), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(48), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4282] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(397), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4363] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(399), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4444] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(401), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4525] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(403), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(50), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4606] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(405), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(51), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4687] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(407), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(52), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4768] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(409), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4849] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(411), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [4930] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(413), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5011] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(415), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5092] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(417), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5173] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(419), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5254] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(421), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(56), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5335] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(423), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(57), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5416] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(425), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(58), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5497] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(427), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5578] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(429), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(59), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5659] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(431), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(60), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5740] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(433), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5821] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(435), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5902] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(437), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(80), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [5983] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(439), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(69), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6064] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(441), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6145] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(443), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6226] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(445), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(41), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6307] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(447), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6388] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(449), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6469] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(451), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6550] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(453), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6631] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(455), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(72), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6712] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(457), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6793] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(459), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(73), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6874] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(461), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(76), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [6955] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(463), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7036] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(465), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7117] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(467), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7198] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(469), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7279] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(471), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7360] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      anon_sym_AMP,
    ACTIONS(232), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(256), 1,
      aux_sym_preproc_if_token2,
    ACTIONS(473), 1,
      sym__label_name,
    ACTIONS(476), 1,
      sym__node_path,
    ACTIONS(479), 1,
      sym__node_or_property,
    ACTIONS(485), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(488), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(491), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(494), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(497), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(500), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(503), 1,
      aux_sym_preproc_if_token1,
    STATE(683), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1190), 1,
      sym_reference,
    ACTIONS(482), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(506), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(88), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7441] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(509), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(83), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7522] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(511), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(84), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7603] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(513), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7684] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(515), 1,
      sym__label_name,
    ACTIONS(517), 1,
      sym__node_path,
    ACTIONS(519), 1,
      sym__node_or_property,
    ACTIONS(523), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(525), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(527), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(529), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(531), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(533), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(535), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(537), 1,
      aux_sym_preproc_if_token2,
    STATE(683), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1190), 1,
      sym_reference,
    ACTIONS(521), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(539), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(88), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7765] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(541), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(61), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7846] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(543), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(85), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [7927] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(545), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(86), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8008] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(547), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(87), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8089] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8170] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(551), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8251] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(553), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(98), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8332] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(555), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(68), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8413] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(557), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8494] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(559), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(78), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8575] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(561), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8656] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(563), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(145), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8737] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(565), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(143), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8818] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(567), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8899] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(569), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [8980] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(571), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(141), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9061] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(101), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9142] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(575), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(103), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9223] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(75), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9304] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(579), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(106), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9385] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(581), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9466] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(583), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(77), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9547] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(585), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(132), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9628] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(587), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9709] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9790] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9871] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(593), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [9952] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(595), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(39), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10033] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      anon_sym_AMP,
    ACTIONS(232), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(256), 1,
      anon_sym_RBRACE,
    ACTIONS(597), 1,
      sym__label_name,
    ACTIONS(600), 1,
      sym__node_path,
    ACTIONS(603), 1,
      sym__node_or_property,
    ACTIONS(609), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(612), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(615), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(618), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(621), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(624), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(627), 1,
      aux_sym_preproc_if_token1,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(606), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(630), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10114] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(113), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10195] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(635), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(133), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10276] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(637), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(116), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10357] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(639), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(117), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10438] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(641), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(118), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10519] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(643), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10600] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(134), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10681] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(647), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(119), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10762] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(649), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(135), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10843] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(515), 1,
      sym__label_name,
    ACTIONS(517), 1,
      sym__node_path,
    ACTIONS(519), 1,
      sym__node_or_property,
    ACTIONS(523), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(525), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(527), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(529), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(531), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(533), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(535), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(651), 1,
      aux_sym_preproc_if_token2,
    STATE(683), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1190), 1,
      sym_reference,
    ACTIONS(521), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(539), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(92), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [10924] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(653), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11005] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11086] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(657), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11167] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(659), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11248] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(661), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(137), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11329] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(663), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11410] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(665), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(146), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11491] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(667), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(147), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11572] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(669), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(148), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11653] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(671), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11734] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(673), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(149), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11815] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(675), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11896] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(677), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(150), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [11977] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(679), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12058] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(681), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12139] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(683), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12220] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(685), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12301] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(687), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12382] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(351), 1,
      sym__label_name,
    ACTIONS(353), 1,
      sym__node_path,
    ACTIONS(355), 1,
      sym__node_or_property,
    ACTIONS(361), 1,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
    ACTIONS(363), 1,
      anon_sym_SLASHdelete_DASHnode_SLASH,
    ACTIONS(365), 1,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
    ACTIONS(367), 1,
      aux_sym_preproc_include_token1,
    ACTIONS(369), 1,
      aux_sym_preproc_def_token1,
    ACTIONS(371), 1,
      aux_sym_preproc_undef_token1,
    ACTIONS(373), 1,
      aux_sym_preproc_if_token1,
    ACTIONS(689), 1,
      anon_sym_RBRACE,
    STATE(689), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(721), 1,
      sym__label,
    STATE(1145), 1,
      sym_reference,
    ACTIONS(357), 2,
      sym__property_with_hash,
      sym__property_starts_with_number,
    ACTIONS(375), 2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    STATE(121), 13,
      sym_omit_if_no_ref,
      sym_node,
      sym_property,
      sym__node_members,
      sym_delete_node,
      sym_delete_property,
      sym_preproc_include,
      sym_preproc_def,
      sym_preproc_function_def,
      sym_preproc_undef,
      sym_preproc_if_in_node,
      sym_preproc_ifdef_in_node,
      aux_sym_node_repeat1,
  [12463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(691), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(695), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(699), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(703), 21,
      anon_sym_COLON,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_integer_literal,
      sym_identifier,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(709), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(707), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [12632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(713), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(711), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
  [12665] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 1,
      anon_sym_LPAREN,
    STATE(152), 1,
      sym_argument_list,
    ACTIONS(717), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(715), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12701] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(723), 1,
      anon_sym_COMMA,
    ACTIONS(725), 1,
      anon_sym_RPAREN,
    ACTIONS(729), 1,
      anon_sym_QMARK,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(737), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    STATE(804), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [12789] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(757), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [12819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(761), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [12849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(765), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [12879] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(771), 1,
      anon_sym_LPAREN,
    STATE(290), 1,
      sym_preproc_argument_list,
    ACTIONS(767), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(769), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [12913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(775), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [12943] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(729), 1,
      anon_sym_QMARK,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(737), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(777), 3,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12997] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(781), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(785), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13057] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(789), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(787), 13,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13093] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(789), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(787), 9,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [13135] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(789), 1,
      anon_sym_PIPE,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(787), 7,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [13181] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(789), 1,
      anon_sym_PIPE,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(787), 6,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [13229] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(787), 6,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [13277] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(787), 5,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
  [13327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(787), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13357] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(789), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(787), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13391] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(789), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(787), 11,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13429] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(789), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(787), 7,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [13473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(791), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(797), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13533] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(797), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(797), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(801), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(805), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(803), 17,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [13653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(809), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(809), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(809), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(813), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(817), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(821), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(825), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(829), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(833), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13953] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(837), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [13983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(841), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14013] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(849), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14103] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(853), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(857), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(861), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14253] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(865), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14283] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(869), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(873), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(877), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(881), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14433] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 11,
      ts_builtin_sym_end,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(885), 11,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(887), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(891), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(895), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(899), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(895), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14638] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(899), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(895), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14696] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(899), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(903), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(907), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(911), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(915), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(919), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(923), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14928] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(923), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(923), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [14986] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(923), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(927), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(931), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(935), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(939), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(943), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(947), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(947), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(947), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(947), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15334] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(951), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(955), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(959), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(963), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(845), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(861), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15566] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(825), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(849), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(841), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(899), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(869), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15740] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(881), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(829), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(967), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(821), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(817), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(813), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(895), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(753), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [15972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(971), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(801), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(887), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(797), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16088] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(797), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16117] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(729), 1,
      anon_sym_QMARK,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(737), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(975), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(797), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(977), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(887), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(977), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16286] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(977), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(887), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(977), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(981), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16402] = 5,
    ACTIONS(769), 1,
      anon_sym_LF,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(987), 1,
      anon_sym_LPAREN,
    STATE(367), 1,
      sym_preproc_argument_list,
    ACTIONS(767), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(981), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16464] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(765), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16493] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(993), 1,
      anon_sym_RPAREN,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1003), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1005), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    STATE(776), 1,
      aux_sym_preproc_argument_list_repeat1,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(809), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16577] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1003), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1005), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(1017), 1,
      anon_sym_RPAREN,
    STATE(824), 1,
      aux_sym_preproc_argument_list_repeat1,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(981), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(981), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(809), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 10,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elifdef_token1,
      aux_sym_preproc_elifdef_token2,
    ACTIONS(809), 11,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
      aux_sym_preproc_elif_token1,
  [16748] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(729), 1,
      anon_sym_QMARK,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(737), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(1019), 1,
      anon_sym_COLON,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16800] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(729), 1,
      anon_sym_QMARK,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(737), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(1021), 1,
      anon_sym_RPAREN,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16852] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1003), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1005), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1023), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1027), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1031), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1033), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1035), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [16986] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1039), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1043), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17042] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(1047), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [17084] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(1047), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [17120] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1045), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(1047), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1047), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17180] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1005), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1047), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
  [17228] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_AMP,
    ACTIONS(729), 1,
      anon_sym_QMARK,
    ACTIONS(735), 1,
      anon_sym_SLASH,
    ACTIONS(737), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(739), 1,
      anon_sym_AMP_AMP,
    ACTIONS(741), 1,
      anon_sym_PIPE,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(1049), 1,
      anon_sym_RPAREN,
    ACTIONS(727), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(733), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(745), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(747), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(749), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17280] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1047), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [17326] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(1045), 1,
      anon_sym_PIPE,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1047), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
  [17372] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1045), 1,
      anon_sym_PIPE,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1047), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
  [17416] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(1047), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17456] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1045), 4,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(1047), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1053), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17518] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1057), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17546] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 5,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_PIPE,
    ACTIONS(1061), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17601] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1035), 1,
      anon_sym_LF,
    ACTIONS(1033), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [17628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(907), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17655] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(911), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(915), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(919), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17736] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [17763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(927), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [17925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(931), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [17952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [17979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(935), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(861), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(939), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(943), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(809), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18114] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(849), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(951), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(955), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(809), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18330] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(959), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(963), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18411] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1083), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(707), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(709), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18510] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1085), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(967), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(711), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(713), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18717] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(809), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18825] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1043), 1,
      anon_sym_LF,
    ACTIONS(1041), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [18852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(797), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(891), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(797), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(971), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [18960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(797), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [18987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19014] = 8,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1045), 5,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [19051] = 6,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1045), 11,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19084] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1003), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1005), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(1087), 1,
      anon_sym_RPAREN,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19133] = 4,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1045), 15,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19162] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1045), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19189] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1045), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19234] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_LF,
    ACTIONS(1025), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19261] = 11,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1045), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19358] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_AMP,
    ACTIONS(1001), 1,
      anon_sym_SLASH,
    ACTIONS(1003), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1005), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1007), 1,
      anon_sym_PIPE,
    ACTIONS(1009), 1,
      anon_sym_CARET,
    ACTIONS(1089), 1,
      anon_sym_RPAREN,
    ACTIONS(995), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(999), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(1011), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1013), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1015), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19461] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19488] = 10,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1045), 3,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19529] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1031), 1,
      anon_sym_LF,
    ACTIONS(1029), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19556] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19583] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(903), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19637] = 9,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1045), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19676] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1091), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19721] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_LF,
    ACTIONS(1059), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19748] = 7,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(1045), 7,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [19837] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(865), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(757), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(781), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [19918] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1045), 13,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [19949] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1093), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [19994] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(765), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(837), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(833), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(801), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20156] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1095), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(813), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(817), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(821), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(829), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(881), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(869), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(825), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20390] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(841), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20444] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20498] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1097), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [20543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(775), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(759), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(761), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(785), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(849), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(861), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [20894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(853), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(855), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(857), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(873), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [20975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(877), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(765), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(801), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(813), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(817), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(821), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21218] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1099), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [21263] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(829), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(885), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21317] = 12,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_AMP,
    ACTIONS(1071), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1073), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
    ACTIONS(1077), 1,
      anon_sym_CARET,
    ACTIONS(1101), 1,
      anon_sym_LF,
    ACTIONS(1067), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1079), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1081), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1069), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(1065), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [21362] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(881), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(869), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21416] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1039), 1,
      anon_sym_LF,
    ACTIONS(1037), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [21443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(825), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21470] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1057), 1,
      anon_sym_LF,
    ACTIONS(1055), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [21497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(841), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21524] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_LF,
    ACTIONS(1051), 18,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [21551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 9,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
      aux_sym_preproc_else_token1,
      aux_sym_preproc_elif_token1,
    ACTIONS(753), 10,
      anon_sym_SLASHdts_DASHv1_SLASH,
      anon_sym_SLASHplugin_SLASH,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHinclude_SLASH,
      aux_sym_preproc_if_token1,
  [21632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21657] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1103), 1,
      anon_sym_SEMI,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    STATE(618), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(852), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [21702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(817), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(821), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(765), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(849), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [21977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(841), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(825), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(869), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(881), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(829), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(821), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(817), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(813), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(861), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(801), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22327] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1115), 1,
      anon_sym_SEMI,
    STATE(611), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(790), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22372] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1117), 1,
      anon_sym_SEMI,
    STATE(617), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(789), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22417] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1119), 1,
      anon_sym_SEMI,
    STATE(619), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(788), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(801), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(829), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22512] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1121), 1,
      anon_sym_SEMI,
    STATE(613), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(787), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [22557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(765), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(825), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(841), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(881), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22657] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(867), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(869), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(963), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [22982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(981), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23107] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1123), 1,
      anon_sym_SEMI,
    STATE(621), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(767), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(813), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23227] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1125), 1,
      anon_sym_SEMI,
    STATE(622), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(768), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23272] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1127), 1,
      anon_sym_SEMI,
    STATE(624), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(855), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23342] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1129), 1,
      anon_sym_SEMI,
    STATE(626), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(857), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23387] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1131), 1,
      anon_sym_SEMI,
    STATE(625), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(859), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23482] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(977), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23657] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(889), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(887), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(971), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(971), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(891), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23782] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1133), 1,
      anon_sym_SEMI,
    STATE(615), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(772), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(891), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(959), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23877] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1135), 1,
      anon_sym_SEMI,
    STATE(623), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(854), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23922] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(955), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [23947] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1137), 1,
      anon_sym_SEMI,
    STATE(628), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(826), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [23992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(951), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(967), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24042] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1139), 1,
      anon_sym_SEMI,
    STATE(629), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(785), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24087] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1141), 1,
      anon_sym_SEMI,
    STATE(612), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(780), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24132] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1143), 1,
      anon_sym_SEMI,
    STATE(630), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(778), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24177] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1145), 1,
      anon_sym_SEMI,
    STATE(632), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(775), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(849), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24297] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24322] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24347] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1147), 1,
      anon_sym_SEMI,
    STATE(631), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(817), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24517] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1149), 1,
      anon_sym_SEMI,
    STATE(614), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(846), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24562] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24637] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_SLASHbits_SLASH,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1151), 1,
      anon_sym_SEMI,
    STATE(616), 1,
      sym__bits,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(850), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [24682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(753), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(903), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(907), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(911), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(895), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(915), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(899), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [24982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(903), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(919), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(797), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(907), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(809), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(861), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(911), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(915), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(919), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(943), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(939), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(935), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25482] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(969), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(967), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(927), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25657] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(931), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(963), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(959), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(955), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(951), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25807] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(949), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(947), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(935), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25932] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(939), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(925), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(923), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [25982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(943), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [26007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(927), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [26032] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_RBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(931), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [26057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 7,
      anon_sym_AMP_LBRACE,
      aux_sym_preproc_include_token1,
      aux_sym_preproc_def_token1,
      aux_sym_preproc_undef_token1,
      aux_sym_preproc_if_token2,
      aux_sym_preproc_ifdef_token1,
      aux_sym_preproc_ifdef_token2,
    ACTIONS(845), 10,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_with_hash,
      sym__property_starts_with_number,
      anon_sym_AMP,
      anon_sym_SLASHomit_DASHif_DASHno_DASHref_SLASH,
      anon_sym_SLASHdelete_DASHnode_SLASH,
      anon_sym_SLASHdelete_DASHproperty_SLASH,
      aux_sym_preproc_if_token1,
  [26082] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1153), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(802), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26121] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1155), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(771), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26160] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1157), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(796), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26199] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1159), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(843), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26238] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1161), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(783), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26277] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1163), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(834), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26316] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1165), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(800), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26355] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1167), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(832), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26394] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1169), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(798), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26433] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1173), 1,
      anon_sym_RPAREN,
    ACTIONS(1175), 1,
      sym_integer_literal,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(280), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [26466] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1183), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(847), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26505] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1185), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(865), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26544] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1187), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(837), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26583] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1189), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(867), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26622] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1191), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(871), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26661] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1193), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(869), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26700] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1195), 1,
      anon_sym_RPAREN,
    ACTIONS(1197), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(282), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [26733] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1199), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(814), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26772] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1201), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(853), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26811] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1203), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(774), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26850] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1205), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(845), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26889] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    ACTIONS(1207), 1,
      anon_sym_SEMI,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(779), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [26928] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1211), 1,
      sym_integer_literal,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(362), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [26958] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1219), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(303), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [26988] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1221), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(289), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27018] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1223), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(435), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27048] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1225), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(376), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27078] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1227), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(371), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27108] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1229), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(409), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27138] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1231), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(390), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27168] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1233), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(389), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27198] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1235), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(291), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27228] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1237), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(361), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27258] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1239), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(364), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27288] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1241), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(365), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27318] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1243), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(343), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27348] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_SLASHincbin_SLASH,
    ACTIONS(1109), 1,
      anon_sym_LT,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1113), 1,
      anon_sym_LBRACK,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(888), 6,
      sym_reference,
      sym_incbin,
      sym__property_value,
      sym_integer_cells,
      sym_string_literal,
      sym_byte_string_literal,
  [27384] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1245), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(366), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27414] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1247), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(438), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27444] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1249), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(368), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27474] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1251), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(375), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27504] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1253), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(380), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27534] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1255), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(381), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27564] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1257), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(397), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27594] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1259), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(340), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27624] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1261), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(305), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27654] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1263), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(304), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27684] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1265), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(363), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27714] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1267), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(302), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27744] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1269), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(301), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27774] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1271), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(299), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27804] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1273), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(298), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27834] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1275), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(297), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27864] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1277), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(296), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27894] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_defined,
    ACTIONS(1279), 1,
      sym_integer_literal,
    ACTIONS(1179), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(295), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27924] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_defined,
    ACTIONS(1281), 1,
      sym_integer_literal,
    ACTIONS(1215), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(383), 6,
      sym__preproc_expression,
      sym_preproc_parenthesized_expression,
      sym_preproc_defined,
      sym_preproc_unary_expression,
      sym_preproc_call_expression,
      sym_preproc_binary_expression,
  [27954] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1285), 1,
      anon_sym_RPAREN,
    ACTIONS(1287), 1,
      sym_integer_literal,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(158), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [27983] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1293), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(170), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28009] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1295), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(165), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28035] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(171), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28061] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(172), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28087] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1301), 1,
      sym__label_name,
    ACTIONS(1303), 1,
      sym__node_path,
    ACTIONS(1305), 1,
      sym__node_or_property,
    ACTIONS(1307), 1,
      sym__property_with_hash,
    ACTIONS(1309), 1,
      sym__property_starts_with_number,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(713), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(721), 1,
      sym__label,
    STATE(1184), 1,
      sym_reference,
  [28127] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1311), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(173), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28153] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1313), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(174), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28179] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1315), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(175), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28205] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1317), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(287), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28231] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1319), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(168), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28257] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1321), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(176), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28283] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1323), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(300), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28309] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1325), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(183), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28335] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1327), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(177), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28361] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      anon_sym_AMP,
    ACTIONS(1332), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1335), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      anon_sym_GT,
    ACTIONS(1340), 1,
      sym_integer_literal,
    ACTIONS(1343), 1,
      sym_identifier,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(682), 4,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
      aux_sym_integer_cells_repeat1,
  [28395] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1346), 1,
      sym__label_name,
    ACTIONS(1348), 1,
      sym__node_path,
    ACTIONS(1350), 1,
      sym__node_or_property,
    ACTIONS(1352), 1,
      sym__property_with_hash,
    ACTIONS(1354), 1,
      sym__property_starts_with_number,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(713), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(721), 1,
      sym__label,
    STATE(1194), 1,
      sym_reference,
  [28435] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1356), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(288), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28461] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1358), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(169), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28487] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1360), 1,
      anon_sym_LPAREN,
    ACTIONS(1362), 1,
      anon_sym_GT,
    ACTIONS(1364), 1,
      sym_integer_literal,
    ACTIONS(1366), 1,
      sym_identifier,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(690), 4,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
      aux_sym_integer_cells_repeat1,
  [28521] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1368), 1,
      sym_integer_literal,
    ACTIONS(1291), 4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(268), 5,
      sym__expression,
      sym_call_expression,
      sym_conditional_expression,
      sym_unary_expression,
      sym_binary_expression,
  [28547] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1370), 1,
      sym__label_name,
    ACTIONS(1372), 1,
      sym__node_path,
    ACTIONS(1374), 1,
      sym__node_or_property,
    ACTIONS(1376), 1,
      sym__property_with_hash,
    ACTIONS(1378), 1,
      sym__property_starts_with_number,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(713), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(721), 1,
      sym__label,
    STATE(1173), 1,
      sym_reference,
  [28587] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1380), 1,
      sym__label_name,
    ACTIONS(1382), 1,
      sym__node_path,
    ACTIONS(1384), 1,
      sym__node_or_property,
    ACTIONS(1386), 1,
      sym__property_with_hash,
    ACTIONS(1388), 1,
      sym__property_starts_with_number,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(713), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(721), 1,
      sym__label,
    STATE(1151), 1,
      sym_reference,
  [28627] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1360), 1,
      anon_sym_LPAREN,
    ACTIONS(1366), 1,
      sym_identifier,
    ACTIONS(1390), 1,
      anon_sym_GT,
    ACTIONS(1392), 1,
      sym_integer_literal,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(682), 4,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
      aux_sym_integer_cells_repeat1,
  [28661] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1394), 1,
      sym__label_name,
    STATE(482), 1,
      sym_node,
    STATE(708), 1,
      sym__node_reference,
    STATE(709), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(711), 1,
      sym__label_reference,
    STATE(733), 1,
      sym__label,
    STATE(911), 1,
      sym_reference,
    ACTIONS(517), 2,
      sym__node_path,
      sym__node_or_property,
  [28696] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1396), 1,
      sym__label_name,
    STATE(162), 1,
      sym_node,
    STATE(699), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(733), 1,
      sym__label,
    STATE(896), 1,
      sym_reference,
    ACTIONS(15), 2,
      sym__node_path,
      sym__node_or_property,
  [28731] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1398), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(1400), 1,
      sym__label_name,
    ACTIONS(1402), 1,
      sym__node_path,
    ACTIONS(1404), 1,
      sym__node_or_property,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(715), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(725), 1,
      sym__label,
    STATE(1162), 1,
      sym_reference,
  [28768] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1406), 1,
      sym__label_name,
    STATE(279), 1,
      sym_node,
    STATE(703), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(733), 1,
      sym__label,
    STATE(881), 1,
      sym_reference,
    ACTIONS(51), 2,
      sym__node_path,
      sym__node_or_property,
  [28803] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1408), 1,
      sym__label_name,
    STATE(453), 1,
      sym_node,
    STATE(701), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(733), 1,
      sym__label,
    STATE(913), 1,
      sym_reference,
    ACTIONS(353), 2,
      sym__node_path,
      sym__node_or_property,
  [28838] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1410), 1,
      sym__label_name,
    STATE(430), 1,
      sym_node,
    STATE(702), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(733), 1,
      sym__label,
    STATE(921), 1,
      sym_reference,
    ACTIONS(147), 2,
      sym__node_path,
      sym__node_or_property,
  [28873] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1412), 1,
      sym__label_name,
    STATE(393), 1,
      sym_node,
    STATE(707), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(733), 1,
      sym__label,
    STATE(917), 1,
      sym_reference,
    ACTIONS(183), 2,
      sym__node_path,
      sym__node_or_property,
  [28908] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1414), 1,
      anon_sym_SLASHmemreserve_SLASH,
    ACTIONS(1416), 1,
      sym__label_name,
    ACTIONS(1418), 1,
      sym__node_path,
    ACTIONS(1420), 1,
      sym__node_or_property,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(715), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(725), 1,
      sym__label,
    STATE(1091), 1,
      sym_reference,
  [28945] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1418), 1,
      sym__node_path,
    ACTIONS(1420), 1,
      sym__node_or_property,
    ACTIONS(1422), 1,
      sym__label_name,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    STATE(1091), 1,
      sym_reference,
  [28979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_AMP,
    ACTIONS(1424), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [28997] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1382), 1,
      sym__node_path,
    ACTIONS(1428), 1,
      sym__label_name,
    ACTIONS(1430), 1,
      sym__node_or_property,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    STATE(1151), 1,
      sym_reference,
  [29031] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1402), 1,
      sym__node_path,
    ACTIONS(1404), 1,
      sym__node_or_property,
    ACTIONS(1432), 1,
      sym__label_name,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    STATE(1162), 1,
      sym_reference,
  [29065] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1372), 1,
      sym__node_path,
    ACTIONS(1434), 1,
      sym__label_name,
    ACTIONS(1436), 1,
      sym__node_or_property,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    STATE(1173), 1,
      sym_reference,
  [29099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1440), 1,
      anon_sym_AMP,
    ACTIONS(1438), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29117] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1360), 1,
      anon_sym_LPAREN,
    ACTIONS(1366), 1,
      sym_identifier,
    ACTIONS(1442), 1,
      sym_integer_literal,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(1144), 3,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
  [29147] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1360), 1,
      anon_sym_LPAREN,
    ACTIONS(1366), 1,
      sym_identifier,
    ACTIONS(1444), 1,
      sym_integer_literal,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(1170), 3,
      sym_reference,
      sym__integer_cell_items,
      sym_call_expression,
  [29177] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1303), 1,
      sym__node_path,
    ACTIONS(1446), 1,
      sym__label_name,
    ACTIONS(1448), 1,
      sym__node_or_property,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    STATE(1184), 1,
      sym_reference,
  [29211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      anon_sym_AMP,
    ACTIONS(1450), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29229] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1348), 1,
      sym__node_path,
    ACTIONS(1454), 1,
      sym__label_name,
    ACTIONS(1456), 1,
      sym__node_or_property,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    STATE(1194), 1,
      sym_reference,
  [29263] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1460), 1,
      anon_sym_AMP,
    ACTIONS(1458), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_AMP,
    ACTIONS(1462), 9,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29299] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 1,
      anon_sym_LPAREN,
    ACTIONS(1466), 1,
      anon_sym_AMP,
    STATE(152), 1,
      sym_argument_list,
    ACTIONS(1468), 6,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29320] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1470), 1,
      sym__label_name,
    STATE(713), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(721), 1,
      sym__label,
    ACTIONS(1475), 2,
      sym__property_with_hash,
      anon_sym_AMP_LBRACE,
    ACTIONS(1473), 4,
      sym__node_path,
      sym__node_or_property,
      sym__property_starts_with_number,
      anon_sym_AMP,
  [29343] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(1032), 1,
      sym_reference,
    ACTIONS(1477), 3,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
  [29367] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1475), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1479), 1,
      sym__label_name,
    STATE(715), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(725), 1,
      sym__label,
    ACTIONS(1473), 4,
      anon_sym_SLASHmemreserve_SLASH,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
  [29389] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(1077), 1,
      sym_reference,
    ACTIONS(1482), 3,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
  [29413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1484), 1,
      anon_sym_AMP,
    ACTIONS(1486), 7,
      anon_sym_AMP_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_GT,
      sym_integer_literal,
      sym_identifier,
  [29429] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(1053), 1,
      sym_reference,
    ACTIONS(1488), 3,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
  [29453] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(19), 1,
      anon_sym_AMP_LBRACE,
    STATE(708), 1,
      sym__node_reference,
    STATE(711), 1,
      sym__label_reference,
    STATE(1133), 1,
      sym_reference,
    ACTIONS(1490), 3,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
  [29477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1494), 1,
      anon_sym_AMP,
    ACTIONS(1492), 6,
      anon_sym_SEMI,
      anon_sym_AMP_LBRACE,
      anon_sym_SLASHincbin_SLASH,
      anon_sym_LT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
  [29492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1498), 2,
      sym__property_with_hash,
      anon_sym_AMP_LBRACE,
    ACTIONS(1496), 5,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_starts_with_number,
      anon_sym_AMP,
  [29507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1502), 2,
      sym__property_with_hash,
      anon_sym_AMP_LBRACE,
    ACTIONS(1500), 5,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      sym__property_starts_with_number,
      anon_sym_AMP,
  [29522] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1475), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1504), 1,
      sym__label_name,
    STATE(723), 1,
      aux_sym_memory_reservation_repeat1,
    STATE(733), 1,
      sym__label,
    ACTIONS(1473), 3,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
  [29543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1502), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1500), 5,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
  [29557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1498), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1496), 5,
      anon_sym_SLASHmemreserve_SLASH,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
  [29571] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1509), 1,
      anon_sym_SEMI,
    ACTIONS(1511), 1,
      anon_sym_AT,
    ACTIONS(1513), 1,
      anon_sym_LBRACE,
    ACTIONS(1515), 1,
      anon_sym_EQ,
  [29590] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1517), 1,
      anon_sym_SEMI,
    ACTIONS(1519), 1,
      anon_sym_AT,
    ACTIONS(1521), 1,
      anon_sym_LBRACE,
    ACTIONS(1523), 1,
      anon_sym_EQ,
  [29609] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1525), 1,
      anon_sym_SEMI,
    ACTIONS(1527), 1,
      anon_sym_AT,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
    ACTIONS(1531), 1,
      anon_sym_EQ,
  [29628] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1533), 1,
      anon_sym_SEMI,
    ACTIONS(1535), 1,
      anon_sym_AT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
    ACTIONS(1539), 1,
      anon_sym_EQ,
  [29647] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1541), 1,
      anon_sym_SEMI,
    ACTIONS(1543), 1,
      anon_sym_AT,
    ACTIONS(1545), 1,
      anon_sym_LBRACE,
    ACTIONS(1547), 1,
      anon_sym_EQ,
  [29666] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1549), 1,
      anon_sym_SEMI,
    ACTIONS(1551), 1,
      anon_sym_AT,
    ACTIONS(1553), 1,
      anon_sym_LBRACE,
    ACTIONS(1555), 1,
      anon_sym_EQ,
  [29685] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1557), 1,
      anon_sym_SEMI,
    ACTIONS(1559), 1,
      anon_sym_AT,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
    ACTIONS(1563), 1,
      anon_sym_EQ,
  [29704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1498), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1496), 4,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
  [29717] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
    ACTIONS(1565), 1,
      anon_sym_SEMI,
    ACTIONS(1567), 1,
      anon_sym_AT,
    ACTIONS(1569), 1,
      anon_sym_LBRACE,
    ACTIONS(1571), 1,
      anon_sym_EQ,
  [29736] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1502), 1,
      anon_sym_AMP_LBRACE,
    ACTIONS(1500), 4,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
      anon_sym_AMP,
  [29749] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
    STATE(980), 1,
      sym_string_literal,
    ACTIONS(1575), 2,
      sym_system_lib_string,
      sym_identifier,
  [29763] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
    STATE(981), 1,
      sym_string_literal,
    ACTIONS(1577), 2,
      sym_system_lib_string,
      sym_identifier,
  [29777] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1579), 1,
      anon_sym_DQUOTE,
    ACTIONS(1581), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1583), 1,
      sym_escape_sequence,
    STATE(761), 1,
      aux_sym_string_literal_repeat1,
  [29793] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_SEMI,
    ACTIONS(1519), 1,
      anon_sym_AT,
    ACTIONS(1521), 1,
      anon_sym_LBRACE,
    ACTIONS(1523), 1,
      anon_sym_EQ,
  [29809] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1585), 1,
      anon_sym_SEMI,
    ACTIONS(1587), 1,
      anon_sym_AT,
    ACTIONS(1589), 1,
      anon_sym_LBRACE,
    ACTIONS(1591), 1,
      anon_sym_EQ,
  [29825] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1593), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1595), 1,
      anon_sym_LPAREN2,
    ACTIONS(1597), 1,
      sym_preproc_arg,
    STATE(890), 1,
      sym_preproc_params,
  [29841] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1599), 1,
      anon_sym_SEMI,
    ACTIONS(1601), 1,
      anon_sym_AT,
    ACTIONS(1603), 1,
      anon_sym_LBRACE,
    ACTIONS(1605), 1,
      anon_sym_EQ,
  [29857] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
    STATE(1106), 1,
      sym_string_literal,
    ACTIONS(1607), 2,
      sym_system_lib_string,
      sym_identifier,
  [29871] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 1,
      anon_sym_SEMI,
    ACTIONS(1527), 1,
      anon_sym_AT,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
    ACTIONS(1531), 1,
      anon_sym_EQ,
  [29887] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
    STATE(1142), 1,
      sym_string_literal,
    ACTIONS(1609), 2,
      sym_system_lib_string,
      sym_identifier,
  [29901] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_LPAREN2,
    ACTIONS(1611), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1613), 1,
      sym_preproc_arg,
    STATE(885), 1,
      sym_preproc_params,
  [29917] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1615), 1,
      anon_sym_DQUOTE,
    ACTIONS(1617), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1619), 1,
      sym_escape_sequence,
    STATE(738), 1,
      aux_sym_string_literal_repeat1,
  [29933] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_DQUOTE,
    ACTIONS(1623), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1625), 1,
      sym_escape_sequence,
    STATE(757), 1,
      aux_sym_string_literal_repeat1,
  [29949] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_SEMI,
    ACTIONS(1629), 1,
      anon_sym_AT,
    ACTIONS(1631), 1,
      anon_sym_LBRACE,
    ACTIONS(1633), 1,
      anon_sym_EQ,
  [29965] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_LPAREN2,
    ACTIONS(1635), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1637), 1,
      sym_preproc_arg,
    STATE(877), 1,
      sym_preproc_params,
  [29981] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
    STATE(955), 1,
      sym_string_literal,
    ACTIONS(1639), 2,
      sym_system_lib_string,
      sym_identifier,
  [29995] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 1,
      anon_sym_SEMI,
    ACTIONS(1535), 1,
      anon_sym_AT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
    ACTIONS(1539), 1,
      anon_sym_EQ,
  [30011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym__property_with_hash,
    ACTIONS(1641), 3,
      sym__label_name,
      sym__node_or_property,
      sym__property_starts_with_number,
  [30023] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_LPAREN2,
    ACTIONS(1645), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1647), 1,
      sym_preproc_arg,
    STATE(915), 1,
      sym_preproc_params,
  [30039] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1649), 1,
      anon_sym_DQUOTE,
    ACTIONS(1651), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1653), 1,
      sym_escape_sequence,
    STATE(765), 1,
      aux_sym_string_literal_repeat1,
  [30055] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_LPAREN2,
    ACTIONS(1655), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1657), 1,
      sym_preproc_arg,
    STATE(909), 1,
      sym_preproc_params,
  [30071] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1581), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1583), 1,
      sym_escape_sequence,
    ACTIONS(1659), 1,
      anon_sym_DQUOTE,
    STATE(761), 1,
      aux_sym_string_literal_repeat1,
  [30087] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_SEMI,
    ACTIONS(1559), 1,
      anon_sym_AT,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
    ACTIONS(1563), 1,
      anon_sym_EQ,
  [30103] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_LPAREN2,
    ACTIONS(1661), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1663), 1,
      sym_preproc_arg,
    STATE(918), 1,
      sym_preproc_params,
  [30119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1667), 1,
      sym__property_with_hash,
    ACTIONS(1665), 3,
      sym__label_name,
      sym__node_or_property,
      sym__property_starts_with_number,
  [30131] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1669), 1,
      anon_sym_DQUOTE,
    ACTIONS(1671), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1674), 1,
      sym_escape_sequence,
    STATE(761), 1,
      aux_sym_string_literal_repeat1,
  [30147] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1677), 1,
      anon_sym_SEMI,
    ACTIONS(1679), 1,
      anon_sym_AT,
    ACTIONS(1681), 1,
      anon_sym_LBRACE,
    ACTIONS(1683), 1,
      anon_sym_EQ,
  [30163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1687), 1,
      sym__property_with_hash,
    ACTIONS(1685), 3,
      sym__label_name,
      sym__node_or_property,
      sym__property_starts_with_number,
  [30175] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_DQUOTE,
    STATE(1059), 1,
      sym_string_literal,
    ACTIONS(1689), 2,
      sym_system_lib_string,
      sym_identifier,
  [30189] = 5,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1581), 1,
      aux_sym_string_literal_token1,
    ACTIONS(1583), 1,
      sym_escape_sequence,
    ACTIONS(1691), 1,
      anon_sym_DQUOTE,
    STATE(761), 1,
      aux_sym_string_literal_repeat1,
  [30205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1695), 1,
      sym__property_with_hash,
    ACTIONS(1693), 3,
      sym__label_name,
      sym__node_or_property,
      sym__property_starts_with_number,
  [30217] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1697), 1,
      anon_sym_SEMI,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    STATE(848), 1,
      aux_sym_property_repeat1,
  [30230] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1701), 1,
      anon_sym_SEMI,
    STATE(866), 1,
      aux_sym_property_repeat1,
  [30243] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1703), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30256] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1705), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30269] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1707), 1,
      anon_sym_SEMI,
    STATE(793), 1,
      aux_sym_property_repeat1,
  [30282] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1709), 1,
      anon_sym_SEMI,
    STATE(784), 1,
      aux_sym_property_repeat1,
  [30295] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1711), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30308] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1713), 1,
      anon_sym_SEMI,
    STATE(805), 1,
      aux_sym_property_repeat1,
  [30321] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1715), 1,
      anon_sym_SEMI,
    STATE(782), 1,
      aux_sym_property_repeat1,
  [30334] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(1717), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      aux_sym_preproc_argument_list_repeat1,
  [30347] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1719), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30360] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1721), 1,
      anon_sym_SEMI,
    STATE(777), 1,
      aux_sym_property_repeat1,
  [30373] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1723), 1,
      anon_sym_SEMI,
    STATE(816), 1,
      aux_sym_property_repeat1,
  [30386] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1725), 1,
      anon_sym_SEMI,
    STATE(773), 1,
      aux_sym_property_repeat1,
  [30399] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_RPAREN,
    ACTIONS(1727), 1,
      anon_sym_COMMA,
    STATE(781), 1,
      aux_sym_argument_list_repeat1,
  [30412] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1730), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30425] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1732), 1,
      anon_sym_SEMI,
    STATE(794), 1,
      aux_sym_property_repeat1,
  [30438] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1734), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30451] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1736), 1,
      anon_sym_SEMI,
    STATE(769), 1,
      aux_sym_property_repeat1,
  [30464] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 1,
      anon_sym_RPAREN,
    ACTIONS(1738), 1,
      anon_sym_COMMA,
    STATE(786), 1,
      aux_sym_preproc_argument_list_repeat1,
  [30477] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1741), 1,
      anon_sym_SEMI,
    STATE(797), 1,
      aux_sym_property_repeat1,
  [30490] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1743), 1,
      anon_sym_SEMI,
    STATE(799), 1,
      aux_sym_property_repeat1,
  [30503] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1745), 1,
      anon_sym_SEMI,
    STATE(801), 1,
      aux_sym_property_repeat1,
  [30516] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1747), 1,
      anon_sym_SEMI,
    STATE(803), 1,
      aux_sym_property_repeat1,
  [30529] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_COLON,
    ACTIONS(1751), 1,
      anon_sym_AT,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [30542] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1755), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30555] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1757), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30568] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1759), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30581] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      anon_sym_COLON,
    ACTIONS(1763), 1,
      anon_sym_AT,
    ACTIONS(1765), 1,
      anon_sym_LBRACE,
  [30594] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1767), 1,
      anon_sym_SEMI,
    STATE(807), 1,
      aux_sym_property_repeat1,
  [30607] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1769), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30620] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1771), 1,
      anon_sym_SEMI,
    STATE(808), 1,
      aux_sym_property_repeat1,
  [30633] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1773), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30646] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1775), 1,
      anon_sym_SEMI,
    STATE(809), 1,
      aux_sym_property_repeat1,
  [30659] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1777), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30672] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1779), 1,
      anon_sym_SEMI,
    STATE(810), 1,
      aux_sym_property_repeat1,
  [30685] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1781), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30698] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(723), 1,
      anon_sym_COMMA,
    ACTIONS(1783), 1,
      anon_sym_RPAREN,
    STATE(781), 1,
      aux_sym_argument_list_repeat1,
  [30711] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1785), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30724] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      anon_sym_COLON,
    ACTIONS(1787), 1,
      anon_sym_AT,
    ACTIONS(1789), 1,
      anon_sym_LBRACE,
  [30737] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1791), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30750] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1793), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30763] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1795), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30776] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1797), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30789] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1799), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30802] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      anon_sym_AT,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [30815] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_AT,
    ACTIONS(1513), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [30828] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1801), 1,
      anon_sym_SEMI,
    STATE(770), 1,
      aux_sym_property_repeat1,
  [30841] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1751), 1,
      anon_sym_AT,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
    ACTIONS(1761), 1,
      anon_sym_COLON,
  [30854] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1803), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30867] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1805), 1,
      anon_sym_SEMI,
    STATE(844), 1,
      aux_sym_property_repeat1,
  [30880] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1807), 3,
      sym__label_name,
      sym__node_path,
      sym__node_or_property,
  [30889] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1809), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30902] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1811), 1,
      anon_sym_COMMA,
    ACTIONS(1813), 1,
      anon_sym_RPAREN,
    STATE(875), 1,
      aux_sym_preproc_params_repeat1,
  [30915] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1815), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30928] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1817), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30941] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1819), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [30954] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_COMMA,
    ACTIONS(1821), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      aux_sym_preproc_argument_list_repeat1,
  [30967] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1811), 1,
      anon_sym_COMMA,
    ACTIONS(1823), 1,
      anon_sym_RPAREN,
    STATE(820), 1,
      aux_sym_preproc_params_repeat1,
  [30980] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1825), 1,
      anon_sym_SEMI,
    STATE(811), 1,
      aux_sym_property_repeat1,
  [30993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1559), 1,
      anon_sym_AT,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [31006] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1543), 1,
      anon_sym_AT,
    ACTIONS(1545), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [31019] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1551), 1,
      anon_sym_AT,
    ACTIONS(1553), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [31032] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1535), 1,
      anon_sym_AT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [31045] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1827), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31058] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1829), 1,
      anon_sym_SEMI,
    STATE(819), 1,
      aux_sym_property_repeat1,
  [31071] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1831), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31084] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1833), 1,
      anon_sym_SEMI,
    STATE(821), 1,
      aux_sym_property_repeat1,
  [31097] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_RBRACK,
    ACTIONS(1837), 1,
      sym__byte_string_item,
    STATE(856), 1,
      aux_sym_byte_string_literal_repeat1,
  [31110] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      anon_sym_COLON,
    ACTIONS(1839), 1,
      anon_sym_AT,
    ACTIONS(1841), 1,
      anon_sym_LBRACE,
  [31123] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1843), 1,
      anon_sym_SEMI,
    STATE(851), 1,
      aux_sym_property_repeat1,
  [31136] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1845), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31149] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1847), 1,
      anon_sym_RBRACK,
    ACTIONS(1849), 1,
      sym__byte_string_item,
    STATE(835), 1,
      aux_sym_byte_string_literal_repeat1,
  [31162] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1519), 1,
      anon_sym_AT,
    ACTIONS(1521), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [31175] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1567), 1,
      anon_sym_AT,
    ACTIONS(1569), 1,
      anon_sym_LBRACE,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [31188] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1851), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31201] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1853), 1,
      anon_sym_SEMI,
    STATE(822), 1,
      aux_sym_property_repeat1,
  [31214] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1855), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31227] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1857), 1,
      anon_sym_SEMI,
    STATE(823), 1,
      aux_sym_property_repeat1,
  [31240] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1859), 1,
      anon_sym_SEMI,
    STATE(838), 1,
      aux_sym_property_repeat1,
  [31253] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1861), 1,
      anon_sym_SEMI,
    STATE(863), 1,
      aux_sym_property_repeat1,
  [31266] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1863), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31279] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1865), 1,
      anon_sym_SEMI,
    ACTIONS(1867), 1,
      anon_sym_COMMA,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31292] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1870), 1,
      anon_sym_SEMI,
    STATE(833), 1,
      aux_sym_property_repeat1,
  [31305] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1872), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31318] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1874), 1,
      anon_sym_SEMI,
    STATE(831), 1,
      aux_sym_property_repeat1,
  [31331] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1876), 1,
      anon_sym_SEMI,
    STATE(792), 1,
      aux_sym_property_repeat1,
  [31344] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1878), 1,
      anon_sym_SEMI,
    STATE(842), 1,
      aux_sym_property_repeat1,
  [31357] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1880), 1,
      anon_sym_SEMI,
    STATE(868), 1,
      aux_sym_property_repeat1,
  [31370] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1882), 1,
      anon_sym_RBRACK,
    ACTIONS(1884), 1,
      sym__byte_string_item,
    STATE(856), 1,
      aux_sym_byte_string_literal_repeat1,
  [31383] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1887), 1,
      anon_sym_SEMI,
    STATE(870), 1,
      aux_sym_property_repeat1,
  [31396] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1889), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31409] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1891), 1,
      anon_sym_SEMI,
    STATE(872), 1,
      aux_sym_property_repeat1,
  [31422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1893), 1,
      anon_sym_RPAREN,
    ACTIONS(1895), 2,
      sym_identifier,
      anon_sym_DOT_DOT_DOT,
  [31433] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1897), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31446] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_COLON,
    ACTIONS(1839), 1,
      anon_sym_AT,
    ACTIONS(1841), 1,
      anon_sym_LBRACE,
  [31459] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1899), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31472] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_COLON,
    ACTIONS(1787), 1,
      anon_sym_AT,
    ACTIONS(1789), 1,
      anon_sym_LBRACE,
  [31485] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1901), 1,
      anon_sym_SEMI,
    STATE(876), 1,
      aux_sym_property_repeat1,
  [31498] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1903), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31511] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1905), 1,
      anon_sym_SEMI,
    STATE(874), 1,
      aux_sym_property_repeat1,
  [31524] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1907), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31537] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1909), 1,
      anon_sym_SEMI,
    STATE(861), 1,
      aux_sym_property_repeat1,
  [31550] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1911), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31563] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1913), 1,
      anon_sym_SEMI,
    STATE(858), 1,
      aux_sym_property_repeat1,
  [31576] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1915), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31589] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_COLON,
    ACTIONS(1763), 1,
      anon_sym_AT,
    ACTIONS(1765), 1,
      anon_sym_LBRACE,
  [31602] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1917), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31615] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1919), 1,
      anon_sym_COMMA,
    ACTIONS(1922), 1,
      anon_sym_RPAREN,
    STATE(875), 1,
      aux_sym_preproc_params_repeat1,
  [31628] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_COMMA,
    ACTIONS(1924), 1,
      anon_sym_SEMI,
    STATE(849), 1,
      aux_sym_property_repeat1,
  [31641] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1926), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1928), 1,
      sym_preproc_arg,
  [31651] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1930), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [31659] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1932), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [31667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1934), 1,
      anon_sym_SEMI,
    ACTIONS(1936), 1,
      anon_sym_EQ,
  [31677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 1,
      anon_sym_LBRACE,
    ACTIONS(1938), 1,
      anon_sym_SEMI,
  [31687] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1940), 2,
      aux_sym_preproc_include_token2,
      sym_preproc_arg,
  [31695] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1942), 2,
      sym_identifier,
      anon_sym_DOT_DOT_DOT,
  [31703] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1922), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [31711] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1944), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1946), 1,
      sym_preproc_arg,
  [31721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1948), 1,
      anon_sym_SEMI,
    ACTIONS(1950), 1,
      anon_sym_EQ,
  [31731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 1,
      anon_sym_SEMI,
    ACTIONS(1531), 1,
      anon_sym_EQ,
  [31741] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1865), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [31749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 1,
      anon_sym_SEMI,
    ACTIONS(1539), 1,
      anon_sym_EQ,
  [31759] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1952), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(1954), 1,
      sym_preproc_arg,
  [31769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1956), 1,
      anon_sym_COMMA,
    ACTIONS(1958), 1,
      anon_sym_RPAREN,
  [31779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1960), 1,
      anon_sym_AT,
    ACTIONS(1962), 1,
      anon_sym_LBRACE,
  [31789] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1964), 1,
      anon_sym_AT,
    ACTIONS(1966), 1,
      anon_sym_LBRACE,
  [31799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1968), 1,
      anon_sym_LPAREN,
    ACTIONS(1970), 1,
      sym_identifier,
  [31809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_SEMI,
    ACTIONS(1523), 1,
      anon_sym_EQ,
  [31819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
    ACTIONS(1972), 1,
      anon_sym_SEMI,
  [31829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1974), 1,
      anon_sym_SEMI,
    ACTIONS(1976), 1,
      anon_sym_EQ,
  [31839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1978), 1,
      anon_sym_SEMI,
    ACTIONS(1980), 1,
      anon_sym_EQ,
  [31849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1982), 1,
      anon_sym_AT,
    ACTIONS(1984), 1,
      anon_sym_RBRACE,
  [31859] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1986), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [31867] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1988), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [31875] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    STATE(891), 1,
      sym_string_literal,
  [31885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1990), 1,
      anon_sym_SEMI,
    ACTIONS(1992), 1,
      anon_sym_EQ,
  [31895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1994), 1,
      anon_sym_SEMI,
    ACTIONS(1996), 1,
      anon_sym_EQ,
  [31905] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(1998), 2,
      aux_sym_preproc_include_token2,
      sym_preproc_arg,
  [31913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2000), 1,
      anon_sym_LPAREN,
    ACTIONS(2002), 1,
      sym_identifier,
  [31923] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2004), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [31931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2006), 1,
      anon_sym_SEMI,
    ACTIONS(2008), 1,
      anon_sym_EQ,
  [31941] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2010), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(2012), 1,
      sym_preproc_arg,
  [31951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2014), 1,
      anon_sym_SEMI,
    ACTIONS(2016), 1,
      anon_sym_EQ,
  [31961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
    ACTIONS(2018), 1,
      anon_sym_SEMI,
  [31971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    STATE(166), 1,
      sym_string_literal,
  [31981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
    ACTIONS(2020), 1,
      anon_sym_SEMI,
  [31991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2022), 1,
      anon_sym_DQUOTE,
    STATE(388), 1,
      sym_string_literal,
  [32001] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2024), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(2026), 1,
      sym_preproc_arg,
  [32011] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2028), 2,
      aux_sym_preproc_include_token2,
      sym_preproc_arg,
  [32019] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
    ACTIONS(2030), 1,
      anon_sym_SEMI,
  [32029] = 3,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2032), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(2034), 1,
      sym_preproc_arg,
  [32039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1751), 1,
      anon_sym_AT,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [32049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_SEMI,
    ACTIONS(1563), 1,
      anon_sym_EQ,
  [32059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1789), 1,
      anon_sym_LBRACE,
    ACTIONS(2036), 1,
      anon_sym_SEMI,
  [32069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1535), 1,
      anon_sym_AT,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
  [32079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2038), 1,
      anon_sym_AT,
    ACTIONS(2040), 1,
      anon_sym_LBRACE,
  [32089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1679), 1,
      anon_sym_AT,
    ACTIONS(1681), 1,
      anon_sym_LBRACE,
  [32099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1787), 1,
      anon_sym_AT,
    ACTIONS(1789), 1,
      anon_sym_LBRACE,
  [32109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2042), 1,
      anon_sym_AT,
    ACTIONS(2044), 1,
      anon_sym_LBRACE,
  [32119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2046), 1,
      anon_sym_AT,
    ACTIONS(2048), 1,
      anon_sym_LBRACE,
  [32129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1519), 1,
      anon_sym_AT,
    ACTIONS(1521), 1,
      anon_sym_LBRACE,
  [32139] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2050), 1,
      anon_sym_AT,
    ACTIONS(2052), 1,
      anon_sym_LBRACE,
  [32149] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1587), 1,
      anon_sym_AT,
    ACTIONS(1589), 1,
      anon_sym_LBRACE,
  [32159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2054), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [32167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1559), 1,
      anon_sym_AT,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
  [32177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2056), 1,
      anon_sym_AT,
    ACTIONS(2058), 1,
      anon_sym_LBRACE,
  [32187] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 1,
      anon_sym_AT,
    ACTIONS(1631), 1,
      anon_sym_LBRACE,
  [32197] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      anon_sym_AT,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
  [32207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2060), 1,
      anon_sym_AT,
    ACTIONS(2062), 1,
      anon_sym_LBRACE,
  [32217] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1601), 1,
      anon_sym_AT,
    ACTIONS(1603), 1,
      anon_sym_LBRACE,
  [32227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2064), 1,
      anon_sym_SEMI,
  [32234] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2066), 1,
      anon_sym_SEMI,
  [32241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2068), 1,
      aux_sym_preproc_if_token2,
  [32248] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2070), 1,
      anon_sym_SEMI,
  [32255] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2072), 1,
      anon_sym_SEMI,
  [32262] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2074), 1,
      anon_sym_SEMI,
  [32269] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2076), 1,
      aux_sym_preproc_if_token2,
  [32276] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2078), 1,
      anon_sym_SEMI,
  [32283] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2080), 1,
      anon_sym_SEMI,
  [32290] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2082), 1,
      anon_sym_SEMI,
  [32297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2084), 1,
      anon_sym_SEMI,
  [32304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2086), 1,
      anon_sym_SEMI,
  [32311] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2088), 1,
      aux_sym_preproc_if_token2,
  [32318] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2090), 1,
      anon_sym_LBRACE,
  [32325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2092), 1,
      aux_sym_preproc_if_token2,
  [32332] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2094), 1,
      anon_sym_SEMI,
  [32339] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2096), 1,
      anon_sym_SEMI,
  [32346] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2098), 1,
      aux_sym_preproc_include_token2,
  [32353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2100), 1,
      anon_sym_SEMI,
  [32360] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2102), 1,
      aux_sym_preproc_include_token2,
  [32367] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2104), 1,
      anon_sym_SEMI,
  [32374] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2106), 1,
      aux_sym_preproc_include_token2,
  [32381] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2108), 1,
      anon_sym_SEMI,
  [32388] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2110), 1,
      anon_sym_SEMI,
  [32395] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2112), 1,
      aux_sym_preproc_include_token2,
  [32402] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2114), 1,
      anon_sym_SEMI,
  [32409] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2116), 1,
      anon_sym_SEMI,
  [32416] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2118), 1,
      anon_sym_SEMI,
  [32423] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2120), 1,
      anon_sym_SEMI,
  [32430] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2122), 1,
      anon_sym_SEMI,
  [32437] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2124), 1,
      anon_sym_SEMI,
  [32444] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2126), 1,
      anon_sym_SEMI,
  [32451] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2128), 1,
      anon_sym_SEMI,
  [32458] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2130), 1,
      anon_sym_SEMI,
  [32465] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2132), 1,
      anon_sym_SEMI,
  [32472] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2134), 1,
      anon_sym_SEMI,
  [32479] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2136), 1,
      anon_sym_SEMI,
  [32486] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2138), 1,
      anon_sym_SEMI,
  [32493] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2140), 1,
      anon_sym_SEMI,
  [32500] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2142), 1,
      anon_sym_SEMI,
  [32507] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2144), 1,
      anon_sym_SEMI,
  [32514] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2146), 1,
      anon_sym_SEMI,
  [32521] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2148), 1,
      aux_sym_preproc_include_token2,
  [32528] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2150), 1,
      aux_sym_preproc_include_token2,
  [32535] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2152), 1,
      aux_sym_preproc_include_token2,
  [32542] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2154), 1,
      aux_sym_preproc_include_token2,
  [32549] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2156), 1,
      anon_sym_SEMI,
  [32556] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2158), 1,
      aux_sym_preproc_include_token2,
  [32563] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2160), 1,
      anon_sym_SEMI,
  [32570] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2162), 1,
      anon_sym_SEMI,
  [32577] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2164), 1,
      aux_sym_preproc_include_token2,
  [32584] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2166), 1,
      anon_sym_SEMI,
  [32591] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2168), 1,
      anon_sym_SEMI,
  [32598] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2170), 1,
      anon_sym_SEMI,
  [32605] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2172), 1,
      anon_sym_SEMI,
  [32612] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2174), 1,
      anon_sym_SEMI,
  [32619] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2176), 1,
      anon_sym_SEMI,
  [32626] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2178), 1,
      anon_sym_SEMI,
  [32633] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2180), 1,
      anon_sym_SEMI,
  [32640] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2182), 1,
      anon_sym_SEMI,
  [32647] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2184), 1,
      anon_sym_SEMI,
  [32654] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2186), 1,
      anon_sym_SEMI,
  [32661] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2188), 1,
      anon_sym_SEMI,
  [32668] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2190), 1,
      anon_sym_SEMI,
  [32675] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2192), 1,
      anon_sym_SEMI,
  [32682] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2194), 1,
      anon_sym_SEMI,
  [32689] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2196), 1,
      anon_sym_SEMI,
  [32696] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2198), 1,
      aux_sym_preproc_if_token2,
  [32703] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2200), 1,
      sym_identifier,
  [32710] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2202), 1,
      sym_identifier,
  [32717] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2204), 1,
      sym_identifier,
  [32724] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2206), 1,
      sym_integer_literal,
  [32731] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2208), 1,
      anon_sym_SEMI,
  [32738] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2210), 1,
      aux_sym_preproc_if_token2,
  [32745] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2212), 1,
      anon_sym_RPAREN,
  [32752] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2214), 1,
      anon_sym_SEMI,
  [32759] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2216), 1,
      anon_sym_SEMI,
  [32766] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2218), 1,
      sym_identifier,
  [32773] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2220), 1,
      anon_sym_SEMI,
  [32780] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2222), 1,
      aux_sym_preproc_if_token2,
  [32787] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2224), 1,
      sym_identifier,
  [32794] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2226), 1,
      sym_integer_literal,
  [32801] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2228), 1,
      anon_sym_SEMI,
  [32808] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2230), 1,
      aux_sym_preproc_include_token2,
  [32815] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2232), 1,
      aux_sym_preproc_if_token2,
  [32822] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2234), 1,
      anon_sym_LBRACE,
  [32829] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2236), 1,
      anon_sym_SEMI,
  [32836] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2238), 1,
      anon_sym_RBRACE,
  [32843] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2240), 1,
      anon_sym_SEMI,
  [32850] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2242), 1,
      anon_sym_SEMI,
  [32857] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2244), 1,
      anon_sym_SEMI,
  [32864] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2246), 1,
      anon_sym_SEMI,
  [32871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2248), 1,
      anon_sym_SEMI,
  [32878] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2250), 1,
      anon_sym_SEMI,
  [32885] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2252), 1,
      anon_sym_SEMI,
  [32892] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2254), 1,
      anon_sym_SEMI,
  [32899] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2256), 1,
      anon_sym_SEMI,
  [32906] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      anon_sym_COLON,
  [32913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2258), 1,
      sym_unit_address,
  [32920] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2260), 1,
      aux_sym_preproc_include_token2,
  [32927] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2262), 1,
      anon_sym_SEMI,
  [32934] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2264), 1,
      anon_sym_SEMI,
  [32941] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2266), 1,
      sym_identifier,
  [32948] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2268), 1,
      sym_identifier,
  [32955] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2270), 1,
      sym_unit_address,
  [32962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2272), 1,
      anon_sym_LPAREN,
  [32969] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2274), 1,
      aux_sym_preproc_if_token2,
  [32976] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2276), 1,
      sym_identifier,
  [32983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2278), 1,
      anon_sym_SEMI,
  [32990] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2280), 1,
      sym_unit_address,
  [32997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2282), 1,
      sym_integer_literal,
  [33004] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2284), 1,
      aux_sym_preproc_if_token2,
  [33011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2286), 1,
      sym_identifier,
  [33018] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2288), 1,
      aux_sym_preproc_if_token2,
  [33025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2290), 1,
      aux_sym_preproc_if_token2,
  [33032] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2292), 1,
      anon_sym_SEMI,
  [33039] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2294), 1,
      anon_sym_SEMI,
  [33046] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2296), 1,
      aux_sym_preproc_include_token2,
  [33053] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2298), 1,
      anon_sym_SEMI,
  [33060] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2300), 1,
      aux_sym_preproc_include_token2,
  [33067] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2302), 1,
      aux_sym_preproc_include_token2,
  [33074] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2304), 1,
      aux_sym_preproc_include_token2,
  [33081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2306), 1,
      aux_sym_preproc_if_token2,
  [33088] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2308), 1,
      aux_sym_preproc_if_token2,
  [33095] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2310), 1,
      sym_identifier,
  [33102] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2312), 1,
      anon_sym_SEMI,
  [33109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2314), 1,
      anon_sym_SEMI,
  [33116] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2316), 1,
      anon_sym_SEMI,
  [33123] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2318), 1,
      anon_sym_SEMI,
  [33130] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2320), 1,
      anon_sym_SEMI,
  [33137] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2322), 1,
      sym_identifier,
  [33144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2324), 1,
      sym_identifier,
  [33151] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2326), 1,
      aux_sym_preproc_include_token2,
  [33158] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2328), 1,
      anon_sym_SEMI,
  [33165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2330), 1,
      aux_sym_preproc_if_token2,
  [33172] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2332), 1,
      sym_identifier,
  [33179] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2334), 1,
      anon_sym_SEMI,
  [33186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2336), 1,
      anon_sym_SEMI,
  [33193] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2338), 1,
      anon_sym_SEMI,
  [33200] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2340), 1,
      anon_sym_SEMI,
  [33207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2342), 1,
      sym_unit_address,
  [33214] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2344), 1,
      anon_sym_SEMI,
  [33221] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2346), 1,
      sym_identifier,
  [33228] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2348), 1,
      aux_sym_preproc_if_token2,
  [33235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2350), 1,
      anon_sym_LBRACE,
  [33242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2352), 1,
      aux_sym_preproc_if_token2,
  [33249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2354), 1,
      anon_sym_SEMI,
  [33256] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2356), 1,
      aux_sym_preproc_if_token2,
  [33263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2358), 1,
      anon_sym_SEMI,
  [33270] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2360), 1,
      anon_sym_SEMI,
  [33277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2362), 1,
      anon_sym_LBRACE,
  [33284] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2364), 1,
      anon_sym_SEMI,
  [33291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2366), 1,
      anon_sym_SEMI,
  [33298] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2368), 1,
      anon_sym_LBRACE,
  [33305] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2370), 1,
      anon_sym_SEMI,
  [33312] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2372), 1,
      anon_sym_SEMI,
  [33319] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2374), 1,
      anon_sym_SEMI,
  [33326] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2376), 1,
      aux_sym_preproc_include_token2,
  [33333] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2378), 1,
      sym_identifier,
  [33340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2380), 1,
      sym_identifier,
  [33347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2382), 1,
      anon_sym_RPAREN,
  [33354] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2384), 1,
      anon_sym_SEMI,
  [33361] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2386), 1,
      sym_integer_literal,
  [33368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2388), 1,
      aux_sym_preproc_if_token2,
  [33375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2390), 1,
      anon_sym_SEMI,
  [33382] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2392), 1,
      aux_sym_preproc_if_token2,
  [33389] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2394), 1,
      aux_sym_preproc_include_token2,
  [33396] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2396), 1,
      aux_sym_preproc_if_token2,
  [33403] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2398), 1,
      aux_sym_preproc_include_token2,
  [33410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2400), 1,
      anon_sym_SEMI,
  [33417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2402), 1,
      aux_sym_preproc_if_token2,
  [33424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2404), 1,
      anon_sym_SEMI,
  [33431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2406), 1,
      anon_sym_SEMI,
  [33438] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2408), 1,
      anon_sym_SEMI,
  [33445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2410), 1,
      sym_unit_address,
  [33452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2412), 1,
      anon_sym_SEMI,
  [33459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2414), 1,
      sym_integer_literal,
  [33466] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2416), 1,
      anon_sym_SEMI,
  [33473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2418), 1,
      anon_sym_SEMI,
  [33480] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2420), 1,
      anon_sym_SEMI,
  [33487] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2422), 1,
      aux_sym_preproc_include_token2,
  [33494] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2424), 1,
      sym_identifier,
  [33501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2426), 1,
      sym_identifier,
  [33508] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2428), 1,
      aux_sym_preproc_if_token2,
  [33515] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2430), 1,
      anon_sym_SEMI,
  [33522] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      anon_sym_LBRACE,
  [33529] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2432), 1,
      anon_sym_SEMI,
  [33536] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2434), 1,
      ts_builtin_sym_end,
  [33543] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2436), 1,
      sym_identifier,
  [33550] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON,
  [33557] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2438), 1,
      sym_identifier,
  [33564] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2440), 1,
      sym_identifier,
  [33571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2442), 1,
      anon_sym_SEMI,
  [33578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2444), 1,
      anon_sym_SEMI,
  [33585] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2446), 1,
      anon_sym_SEMI,
  [33592] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2448), 1,
      anon_sym_SEMI,
  [33599] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2450), 1,
      sym__label_name,
  [33606] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2452), 1,
      aux_sym_preproc_if_token2,
  [33613] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2454), 1,
      aux_sym_preproc_include_token2,
  [33620] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2456), 1,
      sym_integer_literal,
  [33627] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2458), 1,
      anon_sym_SEMI,
  [33634] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2460), 1,
      anon_sym_SEMI,
  [33641] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2462), 1,
      aux_sym_preproc_include_token2,
  [33648] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2464), 1,
      sym_integer_literal,
  [33655] = 2,
    ACTIONS(985), 1,
      sym_comment,
    ACTIONS(2466), 1,
      aux_sym_preproc_include_token2,
  [33662] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2468), 1,
      anon_sym_SEMI,
  [33669] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2470), 1,
      anon_sym_COMMA,
  [33676] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_LBRACE,
  [33683] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2472), 1,
      anon_sym_SEMI,
  [33690] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2474), 1,
      sym_integer_literal,
  [33697] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2476), 1,
      anon_sym_SEMI,
  [33704] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2478), 1,
      aux_sym_preproc_if_token2,
  [33711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2480), 1,
      anon_sym_SEMI,
  [33718] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2482), 1,
      anon_sym_LBRACE,
  [33725] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2484), 1,
      anon_sym_LBRACE,
  [33732] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2486), 1,
      aux_sym_preproc_if_token2,
  [33739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2488), 1,
      anon_sym_LBRACE,
  [33746] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2490), 1,
      anon_sym_LBRACE,
  [33753] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2492), 1,
      anon_sym_LBRACE,
  [33760] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2494), 1,
      anon_sym_SEMI,
  [33767] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1789), 1,
      anon_sym_LBRACE,
  [33774] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2496), 1,
      anon_sym_SEMI,
  [33781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2498), 1,
      aux_sym_preproc_if_token2,
  [33788] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2500), 1,
      aux_sym_preproc_if_token2,
  [33795] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2502), 1,
      anon_sym_LBRACE,
  [33802] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2504), 1,
      anon_sym_LBRACE,
  [33809] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2506), 1,
      anon_sym_SEMI,
  [33816] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2508), 1,
      anon_sym_LBRACE,
  [33823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2510), 1,
      anon_sym_LBRACE,
  [33830] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2512), 1,
      anon_sym_LBRACE,
  [33837] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2514), 1,
      anon_sym_SEMI,
  [33844] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 1,
      anon_sym_LBRACE,
  [33851] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2516), 1,
      anon_sym_RPAREN,
  [33858] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2518), 1,
      anon_sym_SEMI,
  [33865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2520), 1,
      anon_sym_SEMI,
  [33872] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2522), 1,
      anon_sym_LBRACE,
  [33879] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2524), 1,
      anon_sym_LBRACE,
  [33886] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2526), 1,
      anon_sym_SEMI,
  [33893] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2528), 1,
      anon_sym_LBRACE,
  [33900] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2530), 1,
      anon_sym_LBRACE,
  [33907] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2532), 1,
      anon_sym_LBRACE,
  [33914] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2534), 1,
      aux_sym_preproc_if_token2,
  [33921] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1561), 1,
      anon_sym_LBRACE,
  [33928] = 2,
    ACTIONS(707), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(985), 1,
      sym_comment,
  [33935] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2536), 1,
      sym_integer_literal,
  [33942] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2538), 1,
      aux_sym_preproc_if_token2,
  [33949] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2540), 1,
      anon_sym_LBRACE,
  [33956] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2542), 1,
      anon_sym_LBRACE,
  [33963] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2544), 1,
      anon_sym_LBRACE,
  [33970] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2546), 1,
      anon_sym_LBRACE,
  [33977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2548), 1,
      anon_sym_LBRACE,
  [33984] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2550), 1,
      anon_sym_SEMI,
  [33991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
  [33998] = 2,
    ACTIONS(711), 1,
      aux_sym_preproc_include_token2,
    ACTIONS(985), 1,
      sym_comment,
  [34005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2552), 1,
      anon_sym_SEMI,
  [34012] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2554), 1,
      anon_sym_SEMI,
  [34019] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2556), 1,
      anon_sym_LBRACE,
  [34026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2558), 1,
      anon_sym_LBRACE,
  [34033] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2560), 1,
      anon_sym_LBRACE,
  [34040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2562), 1,
      anon_sym_LBRACE,
  [34047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2564), 1,
      anon_sym_LBRACE,
  [34054] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      anon_sym_COLON,
  [34061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2566), 1,
      sym_unit_address,
  [34068] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2568), 1,
      sym_unit_address,
  [34075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2570), 1,
      sym_unit_address,
  [34082] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2572), 1,
      sym_unit_address,
  [34089] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2574), 1,
      sym_unit_address,
  [34096] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2576), 1,
      sym_unit_address,
  [34103] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2578), 1,
      sym_unit_address,
  [34110] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2580), 1,
      sym_unit_address,
  [34117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2582), 1,
      sym_unit_address,
  [34124] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2584), 1,
      sym_unit_address,
  [34131] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2586), 1,
      sym_unit_address,
  [34138] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2588), 1,
      sym_unit_address,
  [34145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2590), 1,
      sym_unit_address,
  [34152] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2592), 1,
      sym_unit_address,
  [34159] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2594), 1,
      sym_unit_address,
  [34166] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2596), 1,
      sym_unit_address,
  [34173] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2598), 1,
      sym_unit_address,
  [34180] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2600), 1,
      sym_unit_address,
  [34187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2602), 1,
      sym_unit_address,
  [34194] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2604), 1,
      sym_unit_address,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 97,
  [SMALL_STATE(4)] = 194,
  [SMALL_STATE(5)] = 291,
  [SMALL_STATE(6)] = 388,
  [SMALL_STATE(7)] = 484,
  [SMALL_STATE(8)] = 580,
  [SMALL_STATE(9)] = 676,
  [SMALL_STATE(10)] = 772,
  [SMALL_STATE(11)] = 868,
  [SMALL_STATE(12)] = 964,
  [SMALL_STATE(13)] = 1060,
  [SMALL_STATE(14)] = 1156,
  [SMALL_STATE(15)] = 1245,
  [SMALL_STATE(16)] = 1337,
  [SMALL_STATE(17)] = 1429,
  [SMALL_STATE(18)] = 1521,
  [SMALL_STATE(19)] = 1613,
  [SMALL_STATE(20)] = 1705,
  [SMALL_STATE(21)] = 1797,
  [SMALL_STATE(22)] = 1889,
  [SMALL_STATE(23)] = 1981,
  [SMALL_STATE(24)] = 2072,
  [SMALL_STATE(25)] = 2163,
  [SMALL_STATE(26)] = 2254,
  [SMALL_STATE(27)] = 2345,
  [SMALL_STATE(28)] = 2436,
  [SMALL_STATE(29)] = 2523,
  [SMALL_STATE(30)] = 2614,
  [SMALL_STATE(31)] = 2705,
  [SMALL_STATE(32)] = 2796,
  [SMALL_STATE(33)] = 2887,
  [SMALL_STATE(34)] = 2978,
  [SMALL_STATE(35)] = 3062,
  [SMALL_STATE(36)] = 3145,
  [SMALL_STATE(37)] = 3227,
  [SMALL_STATE(38)] = 3309,
  [SMALL_STATE(39)] = 3391,
  [SMALL_STATE(40)] = 3472,
  [SMALL_STATE(41)] = 3553,
  [SMALL_STATE(42)] = 3634,
  [SMALL_STATE(43)] = 3715,
  [SMALL_STATE(44)] = 3796,
  [SMALL_STATE(45)] = 3877,
  [SMALL_STATE(46)] = 3958,
  [SMALL_STATE(47)] = 4039,
  [SMALL_STATE(48)] = 4120,
  [SMALL_STATE(49)] = 4201,
  [SMALL_STATE(50)] = 4282,
  [SMALL_STATE(51)] = 4363,
  [SMALL_STATE(52)] = 4444,
  [SMALL_STATE(53)] = 4525,
  [SMALL_STATE(54)] = 4606,
  [SMALL_STATE(55)] = 4687,
  [SMALL_STATE(56)] = 4768,
  [SMALL_STATE(57)] = 4849,
  [SMALL_STATE(58)] = 4930,
  [SMALL_STATE(59)] = 5011,
  [SMALL_STATE(60)] = 5092,
  [SMALL_STATE(61)] = 5173,
  [SMALL_STATE(62)] = 5254,
  [SMALL_STATE(63)] = 5335,
  [SMALL_STATE(64)] = 5416,
  [SMALL_STATE(65)] = 5497,
  [SMALL_STATE(66)] = 5578,
  [SMALL_STATE(67)] = 5659,
  [SMALL_STATE(68)] = 5740,
  [SMALL_STATE(69)] = 5821,
  [SMALL_STATE(70)] = 5902,
  [SMALL_STATE(71)] = 5983,
  [SMALL_STATE(72)] = 6064,
  [SMALL_STATE(73)] = 6145,
  [SMALL_STATE(74)] = 6226,
  [SMALL_STATE(75)] = 6307,
  [SMALL_STATE(76)] = 6388,
  [SMALL_STATE(77)] = 6469,
  [SMALL_STATE(78)] = 6550,
  [SMALL_STATE(79)] = 6631,
  [SMALL_STATE(80)] = 6712,
  [SMALL_STATE(81)] = 6793,
  [SMALL_STATE(82)] = 6874,
  [SMALL_STATE(83)] = 6955,
  [SMALL_STATE(84)] = 7036,
  [SMALL_STATE(85)] = 7117,
  [SMALL_STATE(86)] = 7198,
  [SMALL_STATE(87)] = 7279,
  [SMALL_STATE(88)] = 7360,
  [SMALL_STATE(89)] = 7441,
  [SMALL_STATE(90)] = 7522,
  [SMALL_STATE(91)] = 7603,
  [SMALL_STATE(92)] = 7684,
  [SMALL_STATE(93)] = 7765,
  [SMALL_STATE(94)] = 7846,
  [SMALL_STATE(95)] = 7927,
  [SMALL_STATE(96)] = 8008,
  [SMALL_STATE(97)] = 8089,
  [SMALL_STATE(98)] = 8170,
  [SMALL_STATE(99)] = 8251,
  [SMALL_STATE(100)] = 8332,
  [SMALL_STATE(101)] = 8413,
  [SMALL_STATE(102)] = 8494,
  [SMALL_STATE(103)] = 8575,
  [SMALL_STATE(104)] = 8656,
  [SMALL_STATE(105)] = 8737,
  [SMALL_STATE(106)] = 8818,
  [SMALL_STATE(107)] = 8899,
  [SMALL_STATE(108)] = 8980,
  [SMALL_STATE(109)] = 9061,
  [SMALL_STATE(110)] = 9142,
  [SMALL_STATE(111)] = 9223,
  [SMALL_STATE(112)] = 9304,
  [SMALL_STATE(113)] = 9385,
  [SMALL_STATE(114)] = 9466,
  [SMALL_STATE(115)] = 9547,
  [SMALL_STATE(116)] = 9628,
  [SMALL_STATE(117)] = 9709,
  [SMALL_STATE(118)] = 9790,
  [SMALL_STATE(119)] = 9871,
  [SMALL_STATE(120)] = 9952,
  [SMALL_STATE(121)] = 10033,
  [SMALL_STATE(122)] = 10114,
  [SMALL_STATE(123)] = 10195,
  [SMALL_STATE(124)] = 10276,
  [SMALL_STATE(125)] = 10357,
  [SMALL_STATE(126)] = 10438,
  [SMALL_STATE(127)] = 10519,
  [SMALL_STATE(128)] = 10600,
  [SMALL_STATE(129)] = 10681,
  [SMALL_STATE(130)] = 10762,
  [SMALL_STATE(131)] = 10843,
  [SMALL_STATE(132)] = 10924,
  [SMALL_STATE(133)] = 11005,
  [SMALL_STATE(134)] = 11086,
  [SMALL_STATE(135)] = 11167,
  [SMALL_STATE(136)] = 11248,
  [SMALL_STATE(137)] = 11329,
  [SMALL_STATE(138)] = 11410,
  [SMALL_STATE(139)] = 11491,
  [SMALL_STATE(140)] = 11572,
  [SMALL_STATE(141)] = 11653,
  [SMALL_STATE(142)] = 11734,
  [SMALL_STATE(143)] = 11815,
  [SMALL_STATE(144)] = 11896,
  [SMALL_STATE(145)] = 11977,
  [SMALL_STATE(146)] = 12058,
  [SMALL_STATE(147)] = 12139,
  [SMALL_STATE(148)] = 12220,
  [SMALL_STATE(149)] = 12301,
  [SMALL_STATE(150)] = 12382,
  [SMALL_STATE(151)] = 12463,
  [SMALL_STATE(152)] = 12497,
  [SMALL_STATE(153)] = 12531,
  [SMALL_STATE(154)] = 12565,
  [SMALL_STATE(155)] = 12599,
  [SMALL_STATE(156)] = 12632,
  [SMALL_STATE(157)] = 12665,
  [SMALL_STATE(158)] = 12701,
  [SMALL_STATE(159)] = 12759,
  [SMALL_STATE(160)] = 12789,
  [SMALL_STATE(161)] = 12819,
  [SMALL_STATE(162)] = 12849,
  [SMALL_STATE(163)] = 12879,
  [SMALL_STATE(164)] = 12913,
  [SMALL_STATE(165)] = 12943,
  [SMALL_STATE(166)] = 12997,
  [SMALL_STATE(167)] = 13027,
  [SMALL_STATE(168)] = 13057,
  [SMALL_STATE(169)] = 13093,
  [SMALL_STATE(170)] = 13135,
  [SMALL_STATE(171)] = 13181,
  [SMALL_STATE(172)] = 13229,
  [SMALL_STATE(173)] = 13277,
  [SMALL_STATE(174)] = 13327,
  [SMALL_STATE(175)] = 13357,
  [SMALL_STATE(176)] = 13391,
  [SMALL_STATE(177)] = 13429,
  [SMALL_STATE(178)] = 13473,
  [SMALL_STATE(179)] = 13503,
  [SMALL_STATE(180)] = 13533,
  [SMALL_STATE(181)] = 13563,
  [SMALL_STATE(182)] = 13593,
  [SMALL_STATE(183)] = 13623,
  [SMALL_STATE(184)] = 13653,
  [SMALL_STATE(185)] = 13683,
  [SMALL_STATE(186)] = 13713,
  [SMALL_STATE(187)] = 13743,
  [SMALL_STATE(188)] = 13773,
  [SMALL_STATE(189)] = 13803,
  [SMALL_STATE(190)] = 13833,
  [SMALL_STATE(191)] = 13863,
  [SMALL_STATE(192)] = 13893,
  [SMALL_STATE(193)] = 13923,
  [SMALL_STATE(194)] = 13953,
  [SMALL_STATE(195)] = 13983,
  [SMALL_STATE(196)] = 14013,
  [SMALL_STATE(197)] = 14043,
  [SMALL_STATE(198)] = 14073,
  [SMALL_STATE(199)] = 14103,
  [SMALL_STATE(200)] = 14133,
  [SMALL_STATE(201)] = 14163,
  [SMALL_STATE(202)] = 14193,
  [SMALL_STATE(203)] = 14223,
  [SMALL_STATE(204)] = 14253,
  [SMALL_STATE(205)] = 14283,
  [SMALL_STATE(206)] = 14313,
  [SMALL_STATE(207)] = 14343,
  [SMALL_STATE(208)] = 14373,
  [SMALL_STATE(209)] = 14403,
  [SMALL_STATE(210)] = 14433,
  [SMALL_STATE(211)] = 14463,
  [SMALL_STATE(212)] = 14493,
  [SMALL_STATE(213)] = 14522,
  [SMALL_STATE(214)] = 14551,
  [SMALL_STATE(215)] = 14580,
  [SMALL_STATE(216)] = 14609,
  [SMALL_STATE(217)] = 14638,
  [SMALL_STATE(218)] = 14667,
  [SMALL_STATE(219)] = 14696,
  [SMALL_STATE(220)] = 14725,
  [SMALL_STATE(221)] = 14754,
  [SMALL_STATE(222)] = 14783,
  [SMALL_STATE(223)] = 14812,
  [SMALL_STATE(224)] = 14841,
  [SMALL_STATE(225)] = 14870,
  [SMALL_STATE(226)] = 14899,
  [SMALL_STATE(227)] = 14928,
  [SMALL_STATE(228)] = 14957,
  [SMALL_STATE(229)] = 14986,
  [SMALL_STATE(230)] = 15015,
  [SMALL_STATE(231)] = 15044,
  [SMALL_STATE(232)] = 15073,
  [SMALL_STATE(233)] = 15102,
  [SMALL_STATE(234)] = 15131,
  [SMALL_STATE(235)] = 15160,
  [SMALL_STATE(236)] = 15189,
  [SMALL_STATE(237)] = 15218,
  [SMALL_STATE(238)] = 15247,
  [SMALL_STATE(239)] = 15276,
  [SMALL_STATE(240)] = 15305,
  [SMALL_STATE(241)] = 15334,
  [SMALL_STATE(242)] = 15363,
  [SMALL_STATE(243)] = 15392,
  [SMALL_STATE(244)] = 15421,
  [SMALL_STATE(245)] = 15450,
  [SMALL_STATE(246)] = 15479,
  [SMALL_STATE(247)] = 15508,
  [SMALL_STATE(248)] = 15537,
  [SMALL_STATE(249)] = 15566,
  [SMALL_STATE(250)] = 15595,
  [SMALL_STATE(251)] = 15624,
  [SMALL_STATE(252)] = 15653,
  [SMALL_STATE(253)] = 15682,
  [SMALL_STATE(254)] = 15711,
  [SMALL_STATE(255)] = 15740,
  [SMALL_STATE(256)] = 15769,
  [SMALL_STATE(257)] = 15798,
  [SMALL_STATE(258)] = 15827,
  [SMALL_STATE(259)] = 15856,
  [SMALL_STATE(260)] = 15885,
  [SMALL_STATE(261)] = 15914,
  [SMALL_STATE(262)] = 15943,
  [SMALL_STATE(263)] = 15972,
  [SMALL_STATE(264)] = 16001,
  [SMALL_STATE(265)] = 16030,
  [SMALL_STATE(266)] = 16059,
  [SMALL_STATE(267)] = 16088,
  [SMALL_STATE(268)] = 16117,
  [SMALL_STATE(269)] = 16170,
  [SMALL_STATE(270)] = 16199,
  [SMALL_STATE(271)] = 16228,
  [SMALL_STATE(272)] = 16257,
  [SMALL_STATE(273)] = 16286,
  [SMALL_STATE(274)] = 16315,
  [SMALL_STATE(275)] = 16344,
  [SMALL_STATE(276)] = 16373,
  [SMALL_STATE(277)] = 16402,
  [SMALL_STATE(278)] = 16435,
  [SMALL_STATE(279)] = 16464,
  [SMALL_STATE(280)] = 16493,
  [SMALL_STATE(281)] = 16548,
  [SMALL_STATE(282)] = 16577,
  [SMALL_STATE(283)] = 16632,
  [SMALL_STATE(284)] = 16661,
  [SMALL_STATE(285)] = 16690,
  [SMALL_STATE(286)] = 16719,
  [SMALL_STATE(287)] = 16748,
  [SMALL_STATE(288)] = 16800,
  [SMALL_STATE(289)] = 16852,
  [SMALL_STATE(290)] = 16902,
  [SMALL_STATE(291)] = 16930,
  [SMALL_STATE(292)] = 16958,
  [SMALL_STATE(293)] = 16986,
  [SMALL_STATE(294)] = 17014,
  [SMALL_STATE(295)] = 17042,
  [SMALL_STATE(296)] = 17084,
  [SMALL_STATE(297)] = 17120,
  [SMALL_STATE(298)] = 17152,
  [SMALL_STATE(299)] = 17180,
  [SMALL_STATE(300)] = 17228,
  [SMALL_STATE(301)] = 17280,
  [SMALL_STATE(302)] = 17326,
  [SMALL_STATE(303)] = 17372,
  [SMALL_STATE(304)] = 17416,
  [SMALL_STATE(305)] = 17456,
  [SMALL_STATE(306)] = 17490,
  [SMALL_STATE(307)] = 17518,
  [SMALL_STATE(308)] = 17546,
  [SMALL_STATE(309)] = 17574,
  [SMALL_STATE(310)] = 17601,
  [SMALL_STATE(311)] = 17628,
  [SMALL_STATE(312)] = 17655,
  [SMALL_STATE(313)] = 17682,
  [SMALL_STATE(314)] = 17709,
  [SMALL_STATE(315)] = 17736,
  [SMALL_STATE(316)] = 17763,
  [SMALL_STATE(317)] = 17790,
  [SMALL_STATE(318)] = 17817,
  [SMALL_STATE(319)] = 17844,
  [SMALL_STATE(320)] = 17871,
  [SMALL_STATE(321)] = 17898,
  [SMALL_STATE(322)] = 17925,
  [SMALL_STATE(323)] = 17952,
  [SMALL_STATE(324)] = 17979,
  [SMALL_STATE(325)] = 18006,
  [SMALL_STATE(326)] = 18033,
  [SMALL_STATE(327)] = 18060,
  [SMALL_STATE(328)] = 18087,
  [SMALL_STATE(329)] = 18114,
  [SMALL_STATE(330)] = 18141,
  [SMALL_STATE(331)] = 18168,
  [SMALL_STATE(332)] = 18195,
  [SMALL_STATE(333)] = 18222,
  [SMALL_STATE(334)] = 18249,
  [SMALL_STATE(335)] = 18276,
  [SMALL_STATE(336)] = 18303,
  [SMALL_STATE(337)] = 18330,
  [SMALL_STATE(338)] = 18357,
  [SMALL_STATE(339)] = 18384,
  [SMALL_STATE(340)] = 18411,
  [SMALL_STATE(341)] = 18456,
  [SMALL_STATE(342)] = 18483,
  [SMALL_STATE(343)] = 18510,
  [SMALL_STATE(344)] = 18555,
  [SMALL_STATE(345)] = 18582,
  [SMALL_STATE(346)] = 18609,
  [SMALL_STATE(347)] = 18636,
  [SMALL_STATE(348)] = 18663,
  [SMALL_STATE(349)] = 18690,
  [SMALL_STATE(350)] = 18717,
  [SMALL_STATE(351)] = 18744,
  [SMALL_STATE(352)] = 18771,
  [SMALL_STATE(353)] = 18798,
  [SMALL_STATE(354)] = 18825,
  [SMALL_STATE(355)] = 18852,
  [SMALL_STATE(356)] = 18879,
  [SMALL_STATE(357)] = 18906,
  [SMALL_STATE(358)] = 18933,
  [SMALL_STATE(359)] = 18960,
  [SMALL_STATE(360)] = 18987,
  [SMALL_STATE(361)] = 19014,
  [SMALL_STATE(362)] = 19051,
  [SMALL_STATE(363)] = 19084,
  [SMALL_STATE(364)] = 19133,
  [SMALL_STATE(365)] = 19162,
  [SMALL_STATE(366)] = 19189,
  [SMALL_STATE(367)] = 19234,
  [SMALL_STATE(368)] = 19261,
  [SMALL_STATE(369)] = 19304,
  [SMALL_STATE(370)] = 19331,
  [SMALL_STATE(371)] = 19358,
  [SMALL_STATE(372)] = 19407,
  [SMALL_STATE(373)] = 19434,
  [SMALL_STATE(374)] = 19461,
  [SMALL_STATE(375)] = 19488,
  [SMALL_STATE(376)] = 19529,
  [SMALL_STATE(377)] = 19556,
  [SMALL_STATE(378)] = 19583,
  [SMALL_STATE(379)] = 19610,
  [SMALL_STATE(380)] = 19637,
  [SMALL_STATE(381)] = 19676,
  [SMALL_STATE(382)] = 19721,
  [SMALL_STATE(383)] = 19748,
  [SMALL_STATE(384)] = 19783,
  [SMALL_STATE(385)] = 19810,
  [SMALL_STATE(386)] = 19837,
  [SMALL_STATE(387)] = 19864,
  [SMALL_STATE(388)] = 19891,
  [SMALL_STATE(389)] = 19918,
  [SMALL_STATE(390)] = 19949,
  [SMALL_STATE(391)] = 19994,
  [SMALL_STATE(392)] = 20021,
  [SMALL_STATE(393)] = 20048,
  [SMALL_STATE(394)] = 20075,
  [SMALL_STATE(395)] = 20102,
  [SMALL_STATE(396)] = 20129,
  [SMALL_STATE(397)] = 20156,
  [SMALL_STATE(398)] = 20201,
  [SMALL_STATE(399)] = 20228,
  [SMALL_STATE(400)] = 20255,
  [SMALL_STATE(401)] = 20282,
  [SMALL_STATE(402)] = 20309,
  [SMALL_STATE(403)] = 20336,
  [SMALL_STATE(404)] = 20363,
  [SMALL_STATE(405)] = 20390,
  [SMALL_STATE(406)] = 20417,
  [SMALL_STATE(407)] = 20444,
  [SMALL_STATE(408)] = 20471,
  [SMALL_STATE(409)] = 20498,
  [SMALL_STATE(410)] = 20543,
  [SMALL_STATE(411)] = 20570,
  [SMALL_STATE(412)] = 20597,
  [SMALL_STATE(413)] = 20624,
  [SMALL_STATE(414)] = 20651,
  [SMALL_STATE(415)] = 20678,
  [SMALL_STATE(416)] = 20705,
  [SMALL_STATE(417)] = 20732,
  [SMALL_STATE(418)] = 20759,
  [SMALL_STATE(419)] = 20786,
  [SMALL_STATE(420)] = 20813,
  [SMALL_STATE(421)] = 20840,
  [SMALL_STATE(422)] = 20867,
  [SMALL_STATE(423)] = 20894,
  [SMALL_STATE(424)] = 20921,
  [SMALL_STATE(425)] = 20948,
  [SMALL_STATE(426)] = 20975,
  [SMALL_STATE(427)] = 21002,
  [SMALL_STATE(428)] = 21029,
  [SMALL_STATE(429)] = 21056,
  [SMALL_STATE(430)] = 21083,
  [SMALL_STATE(431)] = 21110,
  [SMALL_STATE(432)] = 21137,
  [SMALL_STATE(433)] = 21164,
  [SMALL_STATE(434)] = 21191,
  [SMALL_STATE(435)] = 21218,
  [SMALL_STATE(436)] = 21263,
  [SMALL_STATE(437)] = 21290,
  [SMALL_STATE(438)] = 21317,
  [SMALL_STATE(439)] = 21362,
  [SMALL_STATE(440)] = 21389,
  [SMALL_STATE(441)] = 21416,
  [SMALL_STATE(442)] = 21443,
  [SMALL_STATE(443)] = 21470,
  [SMALL_STATE(444)] = 21497,
  [SMALL_STATE(445)] = 21524,
  [SMALL_STATE(446)] = 21551,
  [SMALL_STATE(447)] = 21578,
  [SMALL_STATE(448)] = 21605,
  [SMALL_STATE(449)] = 21632,
  [SMALL_STATE(450)] = 21657,
  [SMALL_STATE(451)] = 21702,
  [SMALL_STATE(452)] = 21727,
  [SMALL_STATE(453)] = 21752,
  [SMALL_STATE(454)] = 21777,
  [SMALL_STATE(455)] = 21802,
  [SMALL_STATE(456)] = 21827,
  [SMALL_STATE(457)] = 21852,
  [SMALL_STATE(458)] = 21877,
  [SMALL_STATE(459)] = 21902,
  [SMALL_STATE(460)] = 21927,
  [SMALL_STATE(461)] = 21952,
  [SMALL_STATE(462)] = 21977,
  [SMALL_STATE(463)] = 22002,
  [SMALL_STATE(464)] = 22027,
  [SMALL_STATE(465)] = 22052,
  [SMALL_STATE(466)] = 22077,
  [SMALL_STATE(467)] = 22102,
  [SMALL_STATE(468)] = 22127,
  [SMALL_STATE(469)] = 22152,
  [SMALL_STATE(470)] = 22177,
  [SMALL_STATE(471)] = 22202,
  [SMALL_STATE(472)] = 22227,
  [SMALL_STATE(473)] = 22252,
  [SMALL_STATE(474)] = 22277,
  [SMALL_STATE(475)] = 22302,
  [SMALL_STATE(476)] = 22327,
  [SMALL_STATE(477)] = 22372,
  [SMALL_STATE(478)] = 22417,
  [SMALL_STATE(479)] = 22462,
  [SMALL_STATE(480)] = 22487,
  [SMALL_STATE(481)] = 22512,
  [SMALL_STATE(482)] = 22557,
  [SMALL_STATE(483)] = 22582,
  [SMALL_STATE(484)] = 22607,
  [SMALL_STATE(485)] = 22632,
  [SMALL_STATE(486)] = 22657,
  [SMALL_STATE(487)] = 22682,
  [SMALL_STATE(488)] = 22707,
  [SMALL_STATE(489)] = 22732,
  [SMALL_STATE(490)] = 22757,
  [SMALL_STATE(491)] = 22782,
  [SMALL_STATE(492)] = 22807,
  [SMALL_STATE(493)] = 22832,
  [SMALL_STATE(494)] = 22857,
  [SMALL_STATE(495)] = 22882,
  [SMALL_STATE(496)] = 22907,
  [SMALL_STATE(497)] = 22932,
  [SMALL_STATE(498)] = 22957,
  [SMALL_STATE(499)] = 22982,
  [SMALL_STATE(500)] = 23007,
  [SMALL_STATE(501)] = 23032,
  [SMALL_STATE(502)] = 23057,
  [SMALL_STATE(503)] = 23082,
  [SMALL_STATE(504)] = 23107,
  [SMALL_STATE(505)] = 23152,
  [SMALL_STATE(506)] = 23177,
  [SMALL_STATE(507)] = 23202,
  [SMALL_STATE(508)] = 23227,
  [SMALL_STATE(509)] = 23272,
  [SMALL_STATE(510)] = 23317,
  [SMALL_STATE(511)] = 23342,
  [SMALL_STATE(512)] = 23387,
  [SMALL_STATE(513)] = 23432,
  [SMALL_STATE(514)] = 23457,
  [SMALL_STATE(515)] = 23482,
  [SMALL_STATE(516)] = 23507,
  [SMALL_STATE(517)] = 23532,
  [SMALL_STATE(518)] = 23557,
  [SMALL_STATE(519)] = 23582,
  [SMALL_STATE(520)] = 23607,
  [SMALL_STATE(521)] = 23632,
  [SMALL_STATE(522)] = 23657,
  [SMALL_STATE(523)] = 23682,
  [SMALL_STATE(524)] = 23707,
  [SMALL_STATE(525)] = 23732,
  [SMALL_STATE(526)] = 23757,
  [SMALL_STATE(527)] = 23782,
  [SMALL_STATE(528)] = 23827,
  [SMALL_STATE(529)] = 23852,
  [SMALL_STATE(530)] = 23877,
  [SMALL_STATE(531)] = 23922,
  [SMALL_STATE(532)] = 23947,
  [SMALL_STATE(533)] = 23992,
  [SMALL_STATE(534)] = 24017,
  [SMALL_STATE(535)] = 24042,
  [SMALL_STATE(536)] = 24087,
  [SMALL_STATE(537)] = 24132,
  [SMALL_STATE(538)] = 24177,
  [SMALL_STATE(539)] = 24222,
  [SMALL_STATE(540)] = 24247,
  [SMALL_STATE(541)] = 24272,
  [SMALL_STATE(542)] = 24297,
  [SMALL_STATE(543)] = 24322,
  [SMALL_STATE(544)] = 24347,
  [SMALL_STATE(545)] = 24392,
  [SMALL_STATE(546)] = 24417,
  [SMALL_STATE(547)] = 24442,
  [SMALL_STATE(548)] = 24467,
  [SMALL_STATE(549)] = 24492,
  [SMALL_STATE(550)] = 24517,
  [SMALL_STATE(551)] = 24562,
  [SMALL_STATE(552)] = 24587,
  [SMALL_STATE(553)] = 24612,
  [SMALL_STATE(554)] = 24637,
  [SMALL_STATE(555)] = 24682,
  [SMALL_STATE(556)] = 24707,
  [SMALL_STATE(557)] = 24732,
  [SMALL_STATE(558)] = 24757,
  [SMALL_STATE(559)] = 24782,
  [SMALL_STATE(560)] = 24807,
  [SMALL_STATE(561)] = 24832,
  [SMALL_STATE(562)] = 24857,
  [SMALL_STATE(563)] = 24882,
  [SMALL_STATE(564)] = 24907,
  [SMALL_STATE(565)] = 24932,
  [SMALL_STATE(566)] = 24957,
  [SMALL_STATE(567)] = 24982,
  [SMALL_STATE(568)] = 25007,
  [SMALL_STATE(569)] = 25032,
  [SMALL_STATE(570)] = 25057,
  [SMALL_STATE(571)] = 25082,
  [SMALL_STATE(572)] = 25107,
  [SMALL_STATE(573)] = 25132,
  [SMALL_STATE(574)] = 25157,
  [SMALL_STATE(575)] = 25182,
  [SMALL_STATE(576)] = 25207,
  [SMALL_STATE(577)] = 25232,
  [SMALL_STATE(578)] = 25257,
  [SMALL_STATE(579)] = 25282,
  [SMALL_STATE(580)] = 25307,
  [SMALL_STATE(581)] = 25332,
  [SMALL_STATE(582)] = 25357,
  [SMALL_STATE(583)] = 25382,
  [SMALL_STATE(584)] = 25407,
  [SMALL_STATE(585)] = 25432,
  [SMALL_STATE(586)] = 25457,
  [SMALL_STATE(587)] = 25482,
  [SMALL_STATE(588)] = 25507,
  [SMALL_STATE(589)] = 25532,
  [SMALL_STATE(590)] = 25557,
  [SMALL_STATE(591)] = 25582,
  [SMALL_STATE(592)] = 25607,
  [SMALL_STATE(593)] = 25632,
  [SMALL_STATE(594)] = 25657,
  [SMALL_STATE(595)] = 25682,
  [SMALL_STATE(596)] = 25707,
  [SMALL_STATE(597)] = 25732,
  [SMALL_STATE(598)] = 25757,
  [SMALL_STATE(599)] = 25782,
  [SMALL_STATE(600)] = 25807,
  [SMALL_STATE(601)] = 25832,
  [SMALL_STATE(602)] = 25857,
  [SMALL_STATE(603)] = 25882,
  [SMALL_STATE(604)] = 25907,
  [SMALL_STATE(605)] = 25932,
  [SMALL_STATE(606)] = 25957,
  [SMALL_STATE(607)] = 25982,
  [SMALL_STATE(608)] = 26007,
  [SMALL_STATE(609)] = 26032,
  [SMALL_STATE(610)] = 26057,
  [SMALL_STATE(611)] = 26082,
  [SMALL_STATE(612)] = 26121,
  [SMALL_STATE(613)] = 26160,
  [SMALL_STATE(614)] = 26199,
  [SMALL_STATE(615)] = 26238,
  [SMALL_STATE(616)] = 26277,
  [SMALL_STATE(617)] = 26316,
  [SMALL_STATE(618)] = 26355,
  [SMALL_STATE(619)] = 26394,
  [SMALL_STATE(620)] = 26433,
  [SMALL_STATE(621)] = 26466,
  [SMALL_STATE(622)] = 26505,
  [SMALL_STATE(623)] = 26544,
  [SMALL_STATE(624)] = 26583,
  [SMALL_STATE(625)] = 26622,
  [SMALL_STATE(626)] = 26661,
  [SMALL_STATE(627)] = 26700,
  [SMALL_STATE(628)] = 26733,
  [SMALL_STATE(629)] = 26772,
  [SMALL_STATE(630)] = 26811,
  [SMALL_STATE(631)] = 26850,
  [SMALL_STATE(632)] = 26889,
  [SMALL_STATE(633)] = 26928,
  [SMALL_STATE(634)] = 26958,
  [SMALL_STATE(635)] = 26988,
  [SMALL_STATE(636)] = 27018,
  [SMALL_STATE(637)] = 27048,
  [SMALL_STATE(638)] = 27078,
  [SMALL_STATE(639)] = 27108,
  [SMALL_STATE(640)] = 27138,
  [SMALL_STATE(641)] = 27168,
  [SMALL_STATE(642)] = 27198,
  [SMALL_STATE(643)] = 27228,
  [SMALL_STATE(644)] = 27258,
  [SMALL_STATE(645)] = 27288,
  [SMALL_STATE(646)] = 27318,
  [SMALL_STATE(647)] = 27348,
  [SMALL_STATE(648)] = 27384,
  [SMALL_STATE(649)] = 27414,
  [SMALL_STATE(650)] = 27444,
  [SMALL_STATE(651)] = 27474,
  [SMALL_STATE(652)] = 27504,
  [SMALL_STATE(653)] = 27534,
  [SMALL_STATE(654)] = 27564,
  [SMALL_STATE(655)] = 27594,
  [SMALL_STATE(656)] = 27624,
  [SMALL_STATE(657)] = 27654,
  [SMALL_STATE(658)] = 27684,
  [SMALL_STATE(659)] = 27714,
  [SMALL_STATE(660)] = 27744,
  [SMALL_STATE(661)] = 27774,
  [SMALL_STATE(662)] = 27804,
  [SMALL_STATE(663)] = 27834,
  [SMALL_STATE(664)] = 27864,
  [SMALL_STATE(665)] = 27894,
  [SMALL_STATE(666)] = 27924,
  [SMALL_STATE(667)] = 27954,
  [SMALL_STATE(668)] = 27983,
  [SMALL_STATE(669)] = 28009,
  [SMALL_STATE(670)] = 28035,
  [SMALL_STATE(671)] = 28061,
  [SMALL_STATE(672)] = 28087,
  [SMALL_STATE(673)] = 28127,
  [SMALL_STATE(674)] = 28153,
  [SMALL_STATE(675)] = 28179,
  [SMALL_STATE(676)] = 28205,
  [SMALL_STATE(677)] = 28231,
  [SMALL_STATE(678)] = 28257,
  [SMALL_STATE(679)] = 28283,
  [SMALL_STATE(680)] = 28309,
  [SMALL_STATE(681)] = 28335,
  [SMALL_STATE(682)] = 28361,
  [SMALL_STATE(683)] = 28395,
  [SMALL_STATE(684)] = 28435,
  [SMALL_STATE(685)] = 28461,
  [SMALL_STATE(686)] = 28487,
  [SMALL_STATE(687)] = 28521,
  [SMALL_STATE(688)] = 28547,
  [SMALL_STATE(689)] = 28587,
  [SMALL_STATE(690)] = 28627,
  [SMALL_STATE(691)] = 28661,
  [SMALL_STATE(692)] = 28696,
  [SMALL_STATE(693)] = 28731,
  [SMALL_STATE(694)] = 28768,
  [SMALL_STATE(695)] = 28803,
  [SMALL_STATE(696)] = 28838,
  [SMALL_STATE(697)] = 28873,
  [SMALL_STATE(698)] = 28908,
  [SMALL_STATE(699)] = 28945,
  [SMALL_STATE(700)] = 28979,
  [SMALL_STATE(701)] = 28997,
  [SMALL_STATE(702)] = 29031,
  [SMALL_STATE(703)] = 29065,
  [SMALL_STATE(704)] = 29099,
  [SMALL_STATE(705)] = 29117,
  [SMALL_STATE(706)] = 29147,
  [SMALL_STATE(707)] = 29177,
  [SMALL_STATE(708)] = 29211,
  [SMALL_STATE(709)] = 29229,
  [SMALL_STATE(710)] = 29263,
  [SMALL_STATE(711)] = 29281,
  [SMALL_STATE(712)] = 29299,
  [SMALL_STATE(713)] = 29320,
  [SMALL_STATE(714)] = 29343,
  [SMALL_STATE(715)] = 29367,
  [SMALL_STATE(716)] = 29389,
  [SMALL_STATE(717)] = 29413,
  [SMALL_STATE(718)] = 29429,
  [SMALL_STATE(719)] = 29453,
  [SMALL_STATE(720)] = 29477,
  [SMALL_STATE(721)] = 29492,
  [SMALL_STATE(722)] = 29507,
  [SMALL_STATE(723)] = 29522,
  [SMALL_STATE(724)] = 29543,
  [SMALL_STATE(725)] = 29557,
  [SMALL_STATE(726)] = 29571,
  [SMALL_STATE(727)] = 29590,
  [SMALL_STATE(728)] = 29609,
  [SMALL_STATE(729)] = 29628,
  [SMALL_STATE(730)] = 29647,
  [SMALL_STATE(731)] = 29666,
  [SMALL_STATE(732)] = 29685,
  [SMALL_STATE(733)] = 29704,
  [SMALL_STATE(734)] = 29717,
  [SMALL_STATE(735)] = 29736,
  [SMALL_STATE(736)] = 29749,
  [SMALL_STATE(737)] = 29763,
  [SMALL_STATE(738)] = 29777,
  [SMALL_STATE(739)] = 29793,
  [SMALL_STATE(740)] = 29809,
  [SMALL_STATE(741)] = 29825,
  [SMALL_STATE(742)] = 29841,
  [SMALL_STATE(743)] = 29857,
  [SMALL_STATE(744)] = 29871,
  [SMALL_STATE(745)] = 29887,
  [SMALL_STATE(746)] = 29901,
  [SMALL_STATE(747)] = 29917,
  [SMALL_STATE(748)] = 29933,
  [SMALL_STATE(749)] = 29949,
  [SMALL_STATE(750)] = 29965,
  [SMALL_STATE(751)] = 29981,
  [SMALL_STATE(752)] = 29995,
  [SMALL_STATE(753)] = 30011,
  [SMALL_STATE(754)] = 30023,
  [SMALL_STATE(755)] = 30039,
  [SMALL_STATE(756)] = 30055,
  [SMALL_STATE(757)] = 30071,
  [SMALL_STATE(758)] = 30087,
  [SMALL_STATE(759)] = 30103,
  [SMALL_STATE(760)] = 30119,
  [SMALL_STATE(761)] = 30131,
  [SMALL_STATE(762)] = 30147,
  [SMALL_STATE(763)] = 30163,
  [SMALL_STATE(764)] = 30175,
  [SMALL_STATE(765)] = 30189,
  [SMALL_STATE(766)] = 30205,
  [SMALL_STATE(767)] = 30217,
  [SMALL_STATE(768)] = 30230,
  [SMALL_STATE(769)] = 30243,
  [SMALL_STATE(770)] = 30256,
  [SMALL_STATE(771)] = 30269,
  [SMALL_STATE(772)] = 30282,
  [SMALL_STATE(773)] = 30295,
  [SMALL_STATE(774)] = 30308,
  [SMALL_STATE(775)] = 30321,
  [SMALL_STATE(776)] = 30334,
  [SMALL_STATE(777)] = 30347,
  [SMALL_STATE(778)] = 30360,
  [SMALL_STATE(779)] = 30373,
  [SMALL_STATE(780)] = 30386,
  [SMALL_STATE(781)] = 30399,
  [SMALL_STATE(782)] = 30412,
  [SMALL_STATE(783)] = 30425,
  [SMALL_STATE(784)] = 30438,
  [SMALL_STATE(785)] = 30451,
  [SMALL_STATE(786)] = 30464,
  [SMALL_STATE(787)] = 30477,
  [SMALL_STATE(788)] = 30490,
  [SMALL_STATE(789)] = 30503,
  [SMALL_STATE(790)] = 30516,
  [SMALL_STATE(791)] = 30529,
  [SMALL_STATE(792)] = 30542,
  [SMALL_STATE(793)] = 30555,
  [SMALL_STATE(794)] = 30568,
  [SMALL_STATE(795)] = 30581,
  [SMALL_STATE(796)] = 30594,
  [SMALL_STATE(797)] = 30607,
  [SMALL_STATE(798)] = 30620,
  [SMALL_STATE(799)] = 30633,
  [SMALL_STATE(800)] = 30646,
  [SMALL_STATE(801)] = 30659,
  [SMALL_STATE(802)] = 30672,
  [SMALL_STATE(803)] = 30685,
  [SMALL_STATE(804)] = 30698,
  [SMALL_STATE(805)] = 30711,
  [SMALL_STATE(806)] = 30724,
  [SMALL_STATE(807)] = 30737,
  [SMALL_STATE(808)] = 30750,
  [SMALL_STATE(809)] = 30763,
  [SMALL_STATE(810)] = 30776,
  [SMALL_STATE(811)] = 30789,
  [SMALL_STATE(812)] = 30802,
  [SMALL_STATE(813)] = 30815,
  [SMALL_STATE(814)] = 30828,
  [SMALL_STATE(815)] = 30841,
  [SMALL_STATE(816)] = 30854,
  [SMALL_STATE(817)] = 30867,
  [SMALL_STATE(818)] = 30880,
  [SMALL_STATE(819)] = 30889,
  [SMALL_STATE(820)] = 30902,
  [SMALL_STATE(821)] = 30915,
  [SMALL_STATE(822)] = 30928,
  [SMALL_STATE(823)] = 30941,
  [SMALL_STATE(824)] = 30954,
  [SMALL_STATE(825)] = 30967,
  [SMALL_STATE(826)] = 30980,
  [SMALL_STATE(827)] = 30993,
  [SMALL_STATE(828)] = 31006,
  [SMALL_STATE(829)] = 31019,
  [SMALL_STATE(830)] = 31032,
  [SMALL_STATE(831)] = 31045,
  [SMALL_STATE(832)] = 31058,
  [SMALL_STATE(833)] = 31071,
  [SMALL_STATE(834)] = 31084,
  [SMALL_STATE(835)] = 31097,
  [SMALL_STATE(836)] = 31110,
  [SMALL_STATE(837)] = 31123,
  [SMALL_STATE(838)] = 31136,
  [SMALL_STATE(839)] = 31149,
  [SMALL_STATE(840)] = 31162,
  [SMALL_STATE(841)] = 31175,
  [SMALL_STATE(842)] = 31188,
  [SMALL_STATE(843)] = 31201,
  [SMALL_STATE(844)] = 31214,
  [SMALL_STATE(845)] = 31227,
  [SMALL_STATE(846)] = 31240,
  [SMALL_STATE(847)] = 31253,
  [SMALL_STATE(848)] = 31266,
  [SMALL_STATE(849)] = 31279,
  [SMALL_STATE(850)] = 31292,
  [SMALL_STATE(851)] = 31305,
  [SMALL_STATE(852)] = 31318,
  [SMALL_STATE(853)] = 31331,
  [SMALL_STATE(854)] = 31344,
  [SMALL_STATE(855)] = 31357,
  [SMALL_STATE(856)] = 31370,
  [SMALL_STATE(857)] = 31383,
  [SMALL_STATE(858)] = 31396,
  [SMALL_STATE(859)] = 31409,
  [SMALL_STATE(860)] = 31422,
  [SMALL_STATE(861)] = 31433,
  [SMALL_STATE(862)] = 31446,
  [SMALL_STATE(863)] = 31459,
  [SMALL_STATE(864)] = 31472,
  [SMALL_STATE(865)] = 31485,
  [SMALL_STATE(866)] = 31498,
  [SMALL_STATE(867)] = 31511,
  [SMALL_STATE(868)] = 31524,
  [SMALL_STATE(869)] = 31537,
  [SMALL_STATE(870)] = 31550,
  [SMALL_STATE(871)] = 31563,
  [SMALL_STATE(872)] = 31576,
  [SMALL_STATE(873)] = 31589,
  [SMALL_STATE(874)] = 31602,
  [SMALL_STATE(875)] = 31615,
  [SMALL_STATE(876)] = 31628,
  [SMALL_STATE(877)] = 31641,
  [SMALL_STATE(878)] = 31651,
  [SMALL_STATE(879)] = 31659,
  [SMALL_STATE(880)] = 31667,
  [SMALL_STATE(881)] = 31677,
  [SMALL_STATE(882)] = 31687,
  [SMALL_STATE(883)] = 31695,
  [SMALL_STATE(884)] = 31703,
  [SMALL_STATE(885)] = 31711,
  [SMALL_STATE(886)] = 31721,
  [SMALL_STATE(887)] = 31731,
  [SMALL_STATE(888)] = 31741,
  [SMALL_STATE(889)] = 31749,
  [SMALL_STATE(890)] = 31759,
  [SMALL_STATE(891)] = 31769,
  [SMALL_STATE(892)] = 31779,
  [SMALL_STATE(893)] = 31789,
  [SMALL_STATE(894)] = 31799,
  [SMALL_STATE(895)] = 31809,
  [SMALL_STATE(896)] = 31819,
  [SMALL_STATE(897)] = 31829,
  [SMALL_STATE(898)] = 31839,
  [SMALL_STATE(899)] = 31849,
  [SMALL_STATE(900)] = 31859,
  [SMALL_STATE(901)] = 31867,
  [SMALL_STATE(902)] = 31875,
  [SMALL_STATE(903)] = 31885,
  [SMALL_STATE(904)] = 31895,
  [SMALL_STATE(905)] = 31905,
  [SMALL_STATE(906)] = 31913,
  [SMALL_STATE(907)] = 31923,
  [SMALL_STATE(908)] = 31931,
  [SMALL_STATE(909)] = 31941,
  [SMALL_STATE(910)] = 31951,
  [SMALL_STATE(911)] = 31961,
  [SMALL_STATE(912)] = 31971,
  [SMALL_STATE(913)] = 31981,
  [SMALL_STATE(914)] = 31991,
  [SMALL_STATE(915)] = 32001,
  [SMALL_STATE(916)] = 32011,
  [SMALL_STATE(917)] = 32019,
  [SMALL_STATE(918)] = 32029,
  [SMALL_STATE(919)] = 32039,
  [SMALL_STATE(920)] = 32049,
  [SMALL_STATE(921)] = 32059,
  [SMALL_STATE(922)] = 32069,
  [SMALL_STATE(923)] = 32079,
  [SMALL_STATE(924)] = 32089,
  [SMALL_STATE(925)] = 32099,
  [SMALL_STATE(926)] = 32109,
  [SMALL_STATE(927)] = 32119,
  [SMALL_STATE(928)] = 32129,
  [SMALL_STATE(929)] = 32139,
  [SMALL_STATE(930)] = 32149,
  [SMALL_STATE(931)] = 32159,
  [SMALL_STATE(932)] = 32167,
  [SMALL_STATE(933)] = 32177,
  [SMALL_STATE(934)] = 32187,
  [SMALL_STATE(935)] = 32197,
  [SMALL_STATE(936)] = 32207,
  [SMALL_STATE(937)] = 32217,
  [SMALL_STATE(938)] = 32227,
  [SMALL_STATE(939)] = 32234,
  [SMALL_STATE(940)] = 32241,
  [SMALL_STATE(941)] = 32248,
  [SMALL_STATE(942)] = 32255,
  [SMALL_STATE(943)] = 32262,
  [SMALL_STATE(944)] = 32269,
  [SMALL_STATE(945)] = 32276,
  [SMALL_STATE(946)] = 32283,
  [SMALL_STATE(947)] = 32290,
  [SMALL_STATE(948)] = 32297,
  [SMALL_STATE(949)] = 32304,
  [SMALL_STATE(950)] = 32311,
  [SMALL_STATE(951)] = 32318,
  [SMALL_STATE(952)] = 32325,
  [SMALL_STATE(953)] = 32332,
  [SMALL_STATE(954)] = 32339,
  [SMALL_STATE(955)] = 32346,
  [SMALL_STATE(956)] = 32353,
  [SMALL_STATE(957)] = 32360,
  [SMALL_STATE(958)] = 32367,
  [SMALL_STATE(959)] = 32374,
  [SMALL_STATE(960)] = 32381,
  [SMALL_STATE(961)] = 32388,
  [SMALL_STATE(962)] = 32395,
  [SMALL_STATE(963)] = 32402,
  [SMALL_STATE(964)] = 32409,
  [SMALL_STATE(965)] = 32416,
  [SMALL_STATE(966)] = 32423,
  [SMALL_STATE(967)] = 32430,
  [SMALL_STATE(968)] = 32437,
  [SMALL_STATE(969)] = 32444,
  [SMALL_STATE(970)] = 32451,
  [SMALL_STATE(971)] = 32458,
  [SMALL_STATE(972)] = 32465,
  [SMALL_STATE(973)] = 32472,
  [SMALL_STATE(974)] = 32479,
  [SMALL_STATE(975)] = 32486,
  [SMALL_STATE(976)] = 32493,
  [SMALL_STATE(977)] = 32500,
  [SMALL_STATE(978)] = 32507,
  [SMALL_STATE(979)] = 32514,
  [SMALL_STATE(980)] = 32521,
  [SMALL_STATE(981)] = 32528,
  [SMALL_STATE(982)] = 32535,
  [SMALL_STATE(983)] = 32542,
  [SMALL_STATE(984)] = 32549,
  [SMALL_STATE(985)] = 32556,
  [SMALL_STATE(986)] = 32563,
  [SMALL_STATE(987)] = 32570,
  [SMALL_STATE(988)] = 32577,
  [SMALL_STATE(989)] = 32584,
  [SMALL_STATE(990)] = 32591,
  [SMALL_STATE(991)] = 32598,
  [SMALL_STATE(992)] = 32605,
  [SMALL_STATE(993)] = 32612,
  [SMALL_STATE(994)] = 32619,
  [SMALL_STATE(995)] = 32626,
  [SMALL_STATE(996)] = 32633,
  [SMALL_STATE(997)] = 32640,
  [SMALL_STATE(998)] = 32647,
  [SMALL_STATE(999)] = 32654,
  [SMALL_STATE(1000)] = 32661,
  [SMALL_STATE(1001)] = 32668,
  [SMALL_STATE(1002)] = 32675,
  [SMALL_STATE(1003)] = 32682,
  [SMALL_STATE(1004)] = 32689,
  [SMALL_STATE(1005)] = 32696,
  [SMALL_STATE(1006)] = 32703,
  [SMALL_STATE(1007)] = 32710,
  [SMALL_STATE(1008)] = 32717,
  [SMALL_STATE(1009)] = 32724,
  [SMALL_STATE(1010)] = 32731,
  [SMALL_STATE(1011)] = 32738,
  [SMALL_STATE(1012)] = 32745,
  [SMALL_STATE(1013)] = 32752,
  [SMALL_STATE(1014)] = 32759,
  [SMALL_STATE(1015)] = 32766,
  [SMALL_STATE(1016)] = 32773,
  [SMALL_STATE(1017)] = 32780,
  [SMALL_STATE(1018)] = 32787,
  [SMALL_STATE(1019)] = 32794,
  [SMALL_STATE(1020)] = 32801,
  [SMALL_STATE(1021)] = 32808,
  [SMALL_STATE(1022)] = 32815,
  [SMALL_STATE(1023)] = 32822,
  [SMALL_STATE(1024)] = 32829,
  [SMALL_STATE(1025)] = 32836,
  [SMALL_STATE(1026)] = 32843,
  [SMALL_STATE(1027)] = 32850,
  [SMALL_STATE(1028)] = 32857,
  [SMALL_STATE(1029)] = 32864,
  [SMALL_STATE(1030)] = 32871,
  [SMALL_STATE(1031)] = 32878,
  [SMALL_STATE(1032)] = 32885,
  [SMALL_STATE(1033)] = 32892,
  [SMALL_STATE(1034)] = 32899,
  [SMALL_STATE(1035)] = 32906,
  [SMALL_STATE(1036)] = 32913,
  [SMALL_STATE(1037)] = 32920,
  [SMALL_STATE(1038)] = 32927,
  [SMALL_STATE(1039)] = 32934,
  [SMALL_STATE(1040)] = 32941,
  [SMALL_STATE(1041)] = 32948,
  [SMALL_STATE(1042)] = 32955,
  [SMALL_STATE(1043)] = 32962,
  [SMALL_STATE(1044)] = 32969,
  [SMALL_STATE(1045)] = 32976,
  [SMALL_STATE(1046)] = 32983,
  [SMALL_STATE(1047)] = 32990,
  [SMALL_STATE(1048)] = 32997,
  [SMALL_STATE(1049)] = 33004,
  [SMALL_STATE(1050)] = 33011,
  [SMALL_STATE(1051)] = 33018,
  [SMALL_STATE(1052)] = 33025,
  [SMALL_STATE(1053)] = 33032,
  [SMALL_STATE(1054)] = 33039,
  [SMALL_STATE(1055)] = 33046,
  [SMALL_STATE(1056)] = 33053,
  [SMALL_STATE(1057)] = 33060,
  [SMALL_STATE(1058)] = 33067,
  [SMALL_STATE(1059)] = 33074,
  [SMALL_STATE(1060)] = 33081,
  [SMALL_STATE(1061)] = 33088,
  [SMALL_STATE(1062)] = 33095,
  [SMALL_STATE(1063)] = 33102,
  [SMALL_STATE(1064)] = 33109,
  [SMALL_STATE(1065)] = 33116,
  [SMALL_STATE(1066)] = 33123,
  [SMALL_STATE(1067)] = 33130,
  [SMALL_STATE(1068)] = 33137,
  [SMALL_STATE(1069)] = 33144,
  [SMALL_STATE(1070)] = 33151,
  [SMALL_STATE(1071)] = 33158,
  [SMALL_STATE(1072)] = 33165,
  [SMALL_STATE(1073)] = 33172,
  [SMALL_STATE(1074)] = 33179,
  [SMALL_STATE(1075)] = 33186,
  [SMALL_STATE(1076)] = 33193,
  [SMALL_STATE(1077)] = 33200,
  [SMALL_STATE(1078)] = 33207,
  [SMALL_STATE(1079)] = 33214,
  [SMALL_STATE(1080)] = 33221,
  [SMALL_STATE(1081)] = 33228,
  [SMALL_STATE(1082)] = 33235,
  [SMALL_STATE(1083)] = 33242,
  [SMALL_STATE(1084)] = 33249,
  [SMALL_STATE(1085)] = 33256,
  [SMALL_STATE(1086)] = 33263,
  [SMALL_STATE(1087)] = 33270,
  [SMALL_STATE(1088)] = 33277,
  [SMALL_STATE(1089)] = 33284,
  [SMALL_STATE(1090)] = 33291,
  [SMALL_STATE(1091)] = 33298,
  [SMALL_STATE(1092)] = 33305,
  [SMALL_STATE(1093)] = 33312,
  [SMALL_STATE(1094)] = 33319,
  [SMALL_STATE(1095)] = 33326,
  [SMALL_STATE(1096)] = 33333,
  [SMALL_STATE(1097)] = 33340,
  [SMALL_STATE(1098)] = 33347,
  [SMALL_STATE(1099)] = 33354,
  [SMALL_STATE(1100)] = 33361,
  [SMALL_STATE(1101)] = 33368,
  [SMALL_STATE(1102)] = 33375,
  [SMALL_STATE(1103)] = 33382,
  [SMALL_STATE(1104)] = 33389,
  [SMALL_STATE(1105)] = 33396,
  [SMALL_STATE(1106)] = 33403,
  [SMALL_STATE(1107)] = 33410,
  [SMALL_STATE(1108)] = 33417,
  [SMALL_STATE(1109)] = 33424,
  [SMALL_STATE(1110)] = 33431,
  [SMALL_STATE(1111)] = 33438,
  [SMALL_STATE(1112)] = 33445,
  [SMALL_STATE(1113)] = 33452,
  [SMALL_STATE(1114)] = 33459,
  [SMALL_STATE(1115)] = 33466,
  [SMALL_STATE(1116)] = 33473,
  [SMALL_STATE(1117)] = 33480,
  [SMALL_STATE(1118)] = 33487,
  [SMALL_STATE(1119)] = 33494,
  [SMALL_STATE(1120)] = 33501,
  [SMALL_STATE(1121)] = 33508,
  [SMALL_STATE(1122)] = 33515,
  [SMALL_STATE(1123)] = 33522,
  [SMALL_STATE(1124)] = 33529,
  [SMALL_STATE(1125)] = 33536,
  [SMALL_STATE(1126)] = 33543,
  [SMALL_STATE(1127)] = 33550,
  [SMALL_STATE(1128)] = 33557,
  [SMALL_STATE(1129)] = 33564,
  [SMALL_STATE(1130)] = 33571,
  [SMALL_STATE(1131)] = 33578,
  [SMALL_STATE(1132)] = 33585,
  [SMALL_STATE(1133)] = 33592,
  [SMALL_STATE(1134)] = 33599,
  [SMALL_STATE(1135)] = 33606,
  [SMALL_STATE(1136)] = 33613,
  [SMALL_STATE(1137)] = 33620,
  [SMALL_STATE(1138)] = 33627,
  [SMALL_STATE(1139)] = 33634,
  [SMALL_STATE(1140)] = 33641,
  [SMALL_STATE(1141)] = 33648,
  [SMALL_STATE(1142)] = 33655,
  [SMALL_STATE(1143)] = 33662,
  [SMALL_STATE(1144)] = 33669,
  [SMALL_STATE(1145)] = 33676,
  [SMALL_STATE(1146)] = 33683,
  [SMALL_STATE(1147)] = 33690,
  [SMALL_STATE(1148)] = 33697,
  [SMALL_STATE(1149)] = 33704,
  [SMALL_STATE(1150)] = 33711,
  [SMALL_STATE(1151)] = 33718,
  [SMALL_STATE(1152)] = 33725,
  [SMALL_STATE(1153)] = 33732,
  [SMALL_STATE(1154)] = 33739,
  [SMALL_STATE(1155)] = 33746,
  [SMALL_STATE(1156)] = 33753,
  [SMALL_STATE(1157)] = 33760,
  [SMALL_STATE(1158)] = 33767,
  [SMALL_STATE(1159)] = 33774,
  [SMALL_STATE(1160)] = 33781,
  [SMALL_STATE(1161)] = 33788,
  [SMALL_STATE(1162)] = 33795,
  [SMALL_STATE(1163)] = 33802,
  [SMALL_STATE(1164)] = 33809,
  [SMALL_STATE(1165)] = 33816,
  [SMALL_STATE(1166)] = 33823,
  [SMALL_STATE(1167)] = 33830,
  [SMALL_STATE(1168)] = 33837,
  [SMALL_STATE(1169)] = 33844,
  [SMALL_STATE(1170)] = 33851,
  [SMALL_STATE(1171)] = 33858,
  [SMALL_STATE(1172)] = 33865,
  [SMALL_STATE(1173)] = 33872,
  [SMALL_STATE(1174)] = 33879,
  [SMALL_STATE(1175)] = 33886,
  [SMALL_STATE(1176)] = 33893,
  [SMALL_STATE(1177)] = 33900,
  [SMALL_STATE(1178)] = 33907,
  [SMALL_STATE(1179)] = 33914,
  [SMALL_STATE(1180)] = 33921,
  [SMALL_STATE(1181)] = 33928,
  [SMALL_STATE(1182)] = 33935,
  [SMALL_STATE(1183)] = 33942,
  [SMALL_STATE(1184)] = 33949,
  [SMALL_STATE(1185)] = 33956,
  [SMALL_STATE(1186)] = 33963,
  [SMALL_STATE(1187)] = 33970,
  [SMALL_STATE(1188)] = 33977,
  [SMALL_STATE(1189)] = 33984,
  [SMALL_STATE(1190)] = 33991,
  [SMALL_STATE(1191)] = 33998,
  [SMALL_STATE(1192)] = 34005,
  [SMALL_STATE(1193)] = 34012,
  [SMALL_STATE(1194)] = 34019,
  [SMALL_STATE(1195)] = 34026,
  [SMALL_STATE(1196)] = 34033,
  [SMALL_STATE(1197)] = 34040,
  [SMALL_STATE(1198)] = 34047,
  [SMALL_STATE(1199)] = 34054,
  [SMALL_STATE(1200)] = 34061,
  [SMALL_STATE(1201)] = 34068,
  [SMALL_STATE(1202)] = 34075,
  [SMALL_STATE(1203)] = 34082,
  [SMALL_STATE(1204)] = 34089,
  [SMALL_STATE(1205)] = 34096,
  [SMALL_STATE(1206)] = 34103,
  [SMALL_STATE(1207)] = 34110,
  [SMALL_STATE(1208)] = 34117,
  [SMALL_STATE(1209)] = 34124,
  [SMALL_STATE(1210)] = 34131,
  [SMALL_STATE(1211)] = 34138,
  [SMALL_STATE(1212)] = 34145,
  [SMALL_STATE(1213)] = 34152,
  [SMALL_STATE(1214)] = 34159,
  [SMALL_STATE(1215)] = 34166,
  [SMALL_STATE(1216)] = 34173,
  [SMALL_STATE(1217)] = 34180,
  [SMALL_STATE(1218)] = 34187,
  [SMALL_STATE(1219)] = 34194,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1020),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1138),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1137),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(815),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(919),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1134),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(818),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(692),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(912),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(743),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1129),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1128),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(646),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1126),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(654),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1050),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(727),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(928),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(739),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(895),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(694),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(716),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(760),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(764),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1068),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1069),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(649),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1015),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1020),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1138),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1137),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(815),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(919),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1134),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(818),
  [116] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(692),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(912),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(743),
  [125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1129),
  [128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1128),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(646),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1126),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(945),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(949),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1141),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(806),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(925),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(696),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(914),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(745),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1040),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1041),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(640),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 3, .production_id = 7),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1008),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 3, .production_id = 15),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 2, .production_id = 7),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 4, .production_id = 15),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(732),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(932),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(758),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(920),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(697),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(719),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(766),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1096),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1097),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(653),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif_in_node, 3, .production_id = 15),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1045),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(727),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(928),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(739),
  [226] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(895),
  [229] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1134),
  [232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(818),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(694),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(716),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(760),
  [244] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(764),
  [247] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1068),
  [250] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1069),
  [253] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(649),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2),
  [258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1015),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif_in_node, 4, .production_id = 15),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [273] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(945),
  [276] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(949),
  [279] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1141),
  [282] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(806),
  [285] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(925),
  [288] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(696),
  [291] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(914),
  [294] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(745),
  [297] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1040),
  [300] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1041),
  [303] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(640),
  [306] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(1008),
  [309] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(732),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(932),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(758),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(920),
  [321] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(697),
  [324] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(719),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(766),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(751),
  [333] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1096),
  [336] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1097),
  [339] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(653),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1045),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else, 2),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else, 1),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(729),
  [353] = {.entry = {.count = 1, .reusable = false}}, SHIFT(922),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(752),
  [357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(889),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1111),
  [361] = {.entry = {.count = 1, .reusable = false}}, SHIFT(695),
  [363] = {.entry = {.count = 1, .reusable = false}}, SHIFT(714),
  [365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(753),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(736),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1006),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1007),
  [373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1080),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1084),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1003),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(968),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(967),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(966),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(965),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(964),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(963),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(961),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(958),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(948),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(947),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(946),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(941),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(942),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(943),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(953),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(954),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(956),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(960),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(979),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1002),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1027),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1028),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1030),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1026),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1033),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1034),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1013),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1079),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1001),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1056),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1064),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1065),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1000),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1115),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1038),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1113),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1014),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1074),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1004),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1075),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1076),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1086),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1087),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1090),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1092),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1093),
  [473] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(728),
  [476] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(935),
  [479] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(744),
  [482] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(887),
  [485] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(691),
  [488] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(718),
  [491] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(763),
  [494] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(737),
  [497] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1119),
  [500] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1120),
  [503] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(655),
  [506] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1073),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1107),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1109),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(970),
  [515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(728),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(935),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(744),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(887),
  [523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(691),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(718),
  [527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(763),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(737),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1119),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1120),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(655),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else_in_node, 2),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1073),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(999),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1110),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1116),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1117),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(971),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1122),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1139),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(986),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1143),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1189),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1146),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1099),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1102),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1148),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(972),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1131),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1150),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1157),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1071),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1159),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1164),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1067),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(973),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1168),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1171),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1172),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1175),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1063),
  [597] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(729),
  [600] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(922),
  [603] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(752),
  [606] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(889),
  [609] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(695),
  [612] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(714),
  [615] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(753),
  [618] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(736),
  [621] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1006),
  [624] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1007),
  [627] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(636),
  [630] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_repeat1, 2), SHIFT_REPEAT(1080),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1192),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1054),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1193),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1066),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(994),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(969),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(974),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1130),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(975),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_else_in_node, 1),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(976),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1094),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(977),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(978),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(984),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(987),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(989),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(990),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(991),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1029),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(992),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1024),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(993),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1016),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(938),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(995),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(996),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(997),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(998),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 4),
  [693] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 4),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2, .production_id = 8),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2, .production_id = 8),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 3),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 3),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 3),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 2),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 2),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [717] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [721] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(678),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(674),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(670),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 5, .production_id = 17),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 5, .production_id = 17),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_plugin, 2),
  [757] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_plugin, 2),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 4, .production_id = 16),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 4, .production_id = 16),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_omit_if_no_ref, 2),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_omit_if_no_ref, 2),
  [767] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__preproc_expression, 1),
  [769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__preproc_expression, 1),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 4, .production_id = 15),
  [775] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 4, .production_id = 15),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional_expression, 5, .production_id = 37),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dtsi_include, 2, .production_id = 5),
  [781] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dtsi_include, 2, .production_id = 5),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 4, .production_id = 7),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 4, .production_id = 7),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 14),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 14),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 3),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 3),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 8, .production_id = 31),
  [797] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 8, .production_id = 31),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_omit_if_no_ref, 3),
  [801] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_omit_if_no_ref, 3),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 9),
  [805] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 9),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 7, .production_id = 31),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 7, .production_id = 31),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_include, 3, .production_id = 5),
  [813] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_include, 3, .production_id = 5),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_def, 3, .production_id = 7),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_def, 3, .production_id = 7),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_undef, 3, .production_id = 7),
  [821] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_undef, 3, .production_id = 7),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 5, .production_id = 11),
  [825] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 5, .production_id = 11),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 4, .production_id = 11),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 4, .production_id = 11),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_memory_reservation, 4, .production_id = 10),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_memory_reservation, 4, .production_id = 10),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 3, .production_id = 7),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 3, .production_id = 7),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_function_def, 5, .production_id = 19),
  [841] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_function_def, 5, .production_id = 19),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 6, .production_id = 17),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 6, .production_id = 17),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 6, .production_id = 23),
  [849] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 6, .production_id = 23),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 5, .production_id = 20),
  [853] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 5, .production_id = 20),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 5, .production_id = 15),
  [857] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 5, .production_id = 15),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node, 7, .production_id = 23),
  [861] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node, 7, .production_id = 23),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file_version, 2),
  [865] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_file_version, 2),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_function_def, 4, .production_id = 13),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_function_def, 4, .production_id = 13),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef, 5, .production_id = 21),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef, 5, .production_id = 21),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_memory_reservation, 5, .production_id = 22),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_memory_reservation, 5, .production_id = 22),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_def, 4, .production_id = 12),
  [881] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_def, 4, .production_id = 12),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if, 6, .production_id = 26),
  [885] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if, 6, .production_id = 26),
  [887] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 6, .production_id = 34),
  [889] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 6, .production_id = 34),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 6, .production_id = 33),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 6, .production_id = 33),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, .production_id = 30),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, .production_id = 30),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, .production_id = 29),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, .production_id = 29),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 5, .production_id = 21),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 5, .production_id = 21),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 5, .production_id = 15),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 5, .production_id = 15),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 5, .production_id = 20),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 5, .production_id = 20),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, .production_id = 28),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, .production_id = 28),
  [919] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 5, .production_id = 27),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 5, .production_id = 27),
  [923] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, .production_id = 17),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, .production_id = 17),
  [927] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 4, .production_id = 7),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 4, .production_id = 7),
  [931] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 4, .production_id = 16),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 4, .production_id = 16),
  [935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 4, .production_id = 15),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 4, .production_id = 15),
  [939] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, .production_id = 25),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, .production_id = 25),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 4, .production_id = 24),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 4, .production_id = 24),
  [947] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 3, .production_id = 17),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 3, .production_id = 17),
  [951] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_ifdef_in_node, 3, .production_id = 7),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_ifdef_in_node, 3, .production_id = 7),
  [955] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_delete_property, 3, .production_id = 7),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_delete_property, 3, .production_id = 7),
  [959] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_delete_node, 3, .production_id = 7),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_delete_node, 3, .production_id = 7),
  [963] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 3, .production_id = 11),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 3, .production_id = 11),
  [967] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 2, .production_id = 11),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 2, .production_id = 11),
  [971] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_if_in_node, 6, .production_id = 26),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_if_in_node, 6, .production_id = 26),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 6, .production_id = 35),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 6, .production_id = 35),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property, 7, .production_id = 36),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property, 7, .production_id = 36),
  [985] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [987] = {.entry = {.count = 1, .reusable = false}}, SHIFT(627),
  [989] = {.entry = {.count = 1, .reusable = false}}, SHIFT(665),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [995] = {.entry = {.count = 1, .reusable = false}}, SHIFT(664),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(662),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(659),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(717),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_preproc_argument_list_repeat1, 2),
  [1025] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_call_expression, 2, .production_id = 8),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_call_expression, 2, .production_id = 8),
  [1029] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_unary_expression, 2, .production_id = 9),
  [1031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_unary_expression, 2, .production_id = 9),
  [1033] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_defined, 2),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_defined, 2),
  [1037] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_parenthesized_expression, 3),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_parenthesized_expression, 3),
  [1041] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_argument_list, 2),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_argument_list, 2),
  [1045] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_binary_expression, 3, .production_id = 14),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_binary_expression, 3, .production_id = 14),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1051] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_argument_list, 3),
  [1053] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_argument_list, 3),
  [1055] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_defined, 4),
  [1057] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_defined, 4),
  [1059] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_argument_list, 4),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_argument_list, 4),
  [1063] = {.entry = {.count = 1, .reusable = false}}, SHIFT(643),
  [1065] = {.entry = {.count = 1, .reusable = false}}, SHIFT(633),
  [1067] = {.entry = {.count = 1, .reusable = false}}, SHIFT(644),
  [1069] = {.entry = {.count = 1, .reusable = false}}, SHIFT(645),
  [1071] = {.entry = {.count = 1, .reusable = false}}, SHIFT(648),
  [1073] = {.entry = {.count = 1, .reusable = false}}, SHIFT(650),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(651),
  [1077] = {.entry = {.count = 1, .reusable = false}}, SHIFT(652),
  [1079] = {.entry = {.count = 1, .reusable = false}}, SHIFT(666),
  [1081] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1182),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1043),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(748),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(839),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [1181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(906),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [1217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(894),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(679),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(730),
  [1303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(933),
  [1305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(749),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(910),
  [1309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(908),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1329] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_integer_cells_repeat1, 2), SHIFT_REPEAT(1134),
  [1332] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2), SHIFT_REPEAT(818),
  [1335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2), SHIFT_REPEAT(684),
  [1338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2),
  [1340] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2), SHIFT_REPEAT(682),
  [1343] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_integer_cells_repeat1, 2), SHIFT_REPEAT(712),
  [1346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(726),
  [1348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(936),
  [1350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(742),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(897),
  [1354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(898),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(684),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(901),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(734),
  [1372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(929),
  [1374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(740),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(880),
  [1378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(886),
  [1380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(731),
  [1382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(923),
  [1384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(762),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(903),
  [1388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(904),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(878),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [1394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(812),
  [1396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(791),
  [1398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1147),
  [1400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(795),
  [1402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(926),
  [1404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(927),
  [1406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(840),
  [1408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(830),
  [1410] = {.entry = {.count = 1, .reusable = false}}, SHIFT(864),
  [1412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(827),
  [1414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1100),
  [1416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(836),
  [1418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(893),
  [1420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(892),
  [1422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(862),
  [1424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node_reference, 5, .production_id = 18),
  [1426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node_reference, 5, .production_id = 18),
  [1428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(829),
  [1430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(924),
  [1432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(873),
  [1434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(841),
  [1436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(930),
  [1438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__label_reference, 2, .production_id = 4),
  [1440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__label_reference, 2, .production_id = 4),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1144),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1170),
  [1446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(828),
  [1448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(934),
  [1450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference, 1, .production_id = 2),
  [1452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference, 1, .production_id = 2),
  [1454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(813),
  [1456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(937),
  [1458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node_reference, 3, .production_id = 5),
  [1460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node_reference, 3, .production_id = 5),
  [1462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference, 1, .production_id = 1),
  [1464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference, 1, .production_id = 1),
  [1466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__integer_cell_items, 1),
  [1468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__integer_cell_items, 1),
  [1470] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, .production_id = 6), SHIFT_REPEAT(1127),
  [1473] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, .production_id = 6),
  [1475] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, .production_id = 6),
  [1477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1032),
  [1479] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, .production_id = 6), SHIFT_REPEAT(1035),
  [1482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1077),
  [1484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__integer_cell_items, 3),
  [1486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__integer_cell_items, 3),
  [1488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1053),
  [1490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1133),
  [1492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bits, 2),
  [1494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bits, 2),
  [1496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 1, .production_id = 1),
  [1498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_memory_reservation_repeat1, 1, .production_id = 1),
  [1500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__label, 2, .production_id = 3),
  [1502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__label, 2, .production_id = 3),
  [1504] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_memory_reservation_repeat1, 2, .production_id = 6), SHIFT_REPEAT(1199),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(722),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1217),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1208),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1216),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1200),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1213),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1201),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1212),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1209),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(747),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(980),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(981),
  [1579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1181),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [1583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(761),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1211),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(860),
  [1597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1055),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1219),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1106),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1142),
  [1611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [1613] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1057),
  [1615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1191),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(738),
  [1619] = {.entry = {.count = 1, .reusable = false}}, SHIFT(738),
  [1621] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(757),
  [1625] = {.entry = {.count = 1, .reusable = false}}, SHIFT(757),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1215),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1635] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [1637] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1070),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(955),
  [1641] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1031),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1031),
  [1645] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [1647] = {.entry = {.count = 1, .reusable = false}}, SHIFT(959),
  [1649] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(765),
  [1653] = {.entry = {.count = 1, .reusable = false}}, SHIFT(765),
  [1655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(468),
  [1657] = {.entry = {.count = 1, .reusable = false}}, SHIFT(985),
  [1659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [1661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [1663] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1136),
  [1665] = {.entry = {.count = 1, .reusable = false}}, SHIFT(939),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(939),
  [1669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2),
  [1671] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(761),
  [1674] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(761),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1203),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1046),
  [1687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1046),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1059),
  [1691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [1693] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1132),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1132),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1727] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2), SHIFT_REPEAT(687),
  [1730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1738] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_argument_list_repeat1, 2), SHIFT_REPEAT(635),
  [1741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(735),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1112),
  [1753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(724),
  [1763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1205),
  [1765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1204),
  [1789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1807] = {.entry = {.count = 1, .reusable = false}}, SHIFT(899),
  [1809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(883),
  [1813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(882),
  [1815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(916),
  [1825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [1827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(879),
  [1837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [1839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1047),
  [1841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(900),
  [1849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(835),
  [1851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_property_repeat1, 2),
  [1867] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_property_repeat1, 2), SHIFT_REPEAT(647),
  [1870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_byte_string_literal_repeat1, 2),
  [1884] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_byte_string_literal_repeat1, 2), SHIFT_REPEAT(856),
  [1887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(905),
  [1895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(825),
  [1897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1919] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_params_repeat1, 2), SHIFT_REPEAT(883),
  [1922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_preproc_params_repeat1, 2),
  [1924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1926] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [1928] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1021),
  [1930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_cells, 3),
  [1932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_byte_string_literal, 3),
  [1934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1940] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_params, 4),
  [1942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(884),
  [1944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [1946] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1095),
  [1948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1952] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [1954] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1037),
  [1956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(705),
  [1958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(907),
  [1960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1036),
  [1962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1042),
  [1966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1062),
  [1970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [1976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1078),
  [1984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [1986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_byte_string_literal, 2),
  [1988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_cells, 2),
  [1990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1998] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_params, 2),
  [2000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1018),
  [2002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [2004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_incbin, 4, .production_id = 32),
  [2006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [2008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [2010] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [2012] = {.entry = {.count = 1, .reusable = false}}, SHIFT(988),
  [2014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [2016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [2018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [2020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [2022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(755),
  [2024] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [2026] = {.entry = {.count = 1, .reusable = false}}, SHIFT(962),
  [2028] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_params, 3),
  [2030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [2032] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [2034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1118),
  [2036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [2038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1202),
  [2040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [2042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1206),
  [2044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [2046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1207),
  [2048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [2050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1210),
  [2052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [2054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_incbin, 8, .production_id = 38),
  [2056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1214),
  [2058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [2060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1218),
  [2062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [2064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [2066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [2068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [2070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [2072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [2074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [2076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [2078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [2080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [2082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [2084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [2086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [2088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [2090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [2092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [2094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [2096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [2098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [2100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [2102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [2104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [2106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [2108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [2110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [2112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [2114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [2116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [2118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [2120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [2122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [2124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [2126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [2128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [2130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [2132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [2134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [2136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [2138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [2140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [2142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [2144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [2146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [2148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [2150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [2152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [2154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [2156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [2158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [2160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [2162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [2164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [2166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [2168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [2170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [2172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [2174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [2176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [2178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [2180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [2182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [2184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [2186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [2188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [2190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [2192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [2194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [2196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [2198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [2200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(746),
  [2202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(982),
  [2204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [2206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1039),
  [2208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [2210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 3, .production_id = 16),
  [2212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [2214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [2216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [2218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [2220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [2222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [2224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1098),
  [2226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1124),
  [2228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [2230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [2232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [2234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [2236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [2238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [2240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [2242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [2244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [2246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [2248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [2250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [2252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [2254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [2256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [2258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1082),
  [2260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [2262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [2264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [2266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [2268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1140),
  [2270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1023),
  [2272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(902),
  [2274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [2276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [2278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [2280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(951),
  [2282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1010),
  [2284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [2286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [2288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [2290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [2292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [2294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [2296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [2298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [2300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [2302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [2304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [2306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elif, 4, .production_id = 20),
  [2308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_elifdef, 4, .production_id = 21),