/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_my extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "\u1021\u101a\u103a\u101c\u103a\u1018\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_AM = "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_AZ = "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a";
        final String metaValue_BG = "\u1018\u1030\u101c\u103a\u1002\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_BY = "\u1018\u102e\u101c\u102c\u101b\u102f\u1005\u103a";
        final String metaValue_CD = "\u1000\u103d\u1014\u103a\u1002\u102d\u102f";
        final String metaValue_CN = "\u1010\u101b\u102f\u1010\u103a";
        final String metaValue_DK = "\u1012\u102d\u1014\u103a\u1038\u1019\u1010\u103a";
        final String metaValue_ES = "\u1005\u1015\u102d\u1014\u103a";
        final String metaValue_ET = "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_FI = "\u1016\u1004\u103a\u101c\u1014\u103a";
        final String metaValue_FJ = "\u1016\u102e\u1002\u103b\u102e";
        final String metaValue_FR = "\u1015\u103c\u1004\u103a\u101e\u1005\u103a";
        final String metaValue_GE = "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c";
        final String metaValue_GR = "\u1002\u101b\u102d";
        final String metaValue_HR = "\u1001\u101b\u102d\u102f\u1021\u1031\u1038\u101b\u103e\u102c\u1038";
        final String metaValue_HT = "\u101f\u1031\u1010\u102e";
        final String metaValue_HU = "\u101f\u1014\u103a\u1002\u1031\u101b\u102e";
        final String metaValue_ID = "\u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038";
        final String metaValue_IT = "\u1021\u102e\u1010\u101c\u102e";
        final String metaValue_JP = "\u1002\u103b\u1015\u1014\u103a";
        final String metaValue_LA = "\u101c\u102c\u1021\u102d\u102f";
        final String metaValue_LU = "\u101c\u1030\u1007\u1004\u103a\u1018\u1010\u103a";
        final String metaValue_LV = "\u101c\u1010\u103a\u1017\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_MK = "\u1019\u1000\u103a\u1006\u102e\u1012\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_MM = "\u1019\u103c\u1014\u103a\u1019\u102c";
        final String metaValue_MU = "\u1019\u1031\u102c\u101b\u1005\u103a\u101b\u103e";
        final String metaValue_NP = "\u1014\u102e\u1015\u1031\u102b";
        final String metaValue_NR = "\u1014\u1031\u102c\u103a\u101b\u1030\u1038";
        final String metaValue_PH = "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a";
        final String metaValue_PL = "\u1015\u102d\u102f\u101c\u1014\u103a";
        final String metaValue_PT = "\u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e";
        final String metaValue_PW = "\u1015\u101c\u102c\u1021\u102d\u102f";
        final String metaValue_RS = "\u1006\u102c\u1038\u1018\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_SD = "\u1006\u1030\u1012\u1014\u103a";
        final String metaValue_SE = "\u1006\u103d\u102e\u1012\u1004\u103a";
        final String metaValue_SI = "\u1006\u101c\u102d\u102f\u1017\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_SY = "\u1006\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_SZ = "\u1006\u103d\u102c\u1007\u102e\u101c\u1014\u103a";
        final String metaValue_TH = "\u1011\u102d\u102f\u1004\u103a\u1038";
        final String metaValue_TM = "\u1010\u102c\u1037\u1001\u103a\u1019\u1004\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a";
        final String metaValue_TO = "\u1010\u103d\u1014\u103a\u1002\u102b";
        final String metaValue_TR = "\u1010\u1030\u101b\u1000\u102e";
        final String metaValue_UA = "\u101a\u1030\u1000\u101b\u102d\u1014\u103a\u1038";
        final String metaValue_VN = "\u1017\u102e\u101a\u1000\u103a\u1014\u1019\u103a";
        final String metaValue_ZA = "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u1016\u101b\u102d\u1000";
        final String metaValue_bn = "\u1018\u1004\u103a\u1039\u1002\u102b\u101c\u102e";
        final String metaValue_bo = "\u1010\u102d\u1018\u1000\u103a";
        final String metaValue_km = "\u1001\u1019\u102c";
        final String metaValue_ko = "\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_la = "\u101c\u1000\u103a\u1010\u1004\u103a";
        final String metaValue_ml = "\u1019\u101c\u1031\u101a\u102c\u101c\u1019\u103a";
        final String metaValue_mn = "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u101c\u102e\u1038\u101a\u102c\u1038";
        final String metaValue_ta = "\u1010\u1019\u102e\u1038\u101c\u103a";
        final String metaValue_peo = "\u1015\u102b\u101b\u103e\u1014\u103a \u1021\u101f\u1031\u102c\u1004\u103a\u1038";
        final String metaValue_ListKeyTypePattern = "{0}\u104a {1}";
        final Object[][] data = new Object[][] {
            { "ksh", "\u1000\u102d\u102f\u101c\u102d\u102f\u1014\u102e\u101a\u1014\u103a\u1038" },
            { "mwl", "\u1019\u102e\u101b\u1014\u103a\u1012\u102e\u1038\u1007\u103a" },
            { "Zsym", "\u101e\u1004\u103a\u1039\u1000\u1031\u1010" },
            { "Zsye", "\u1021\u102e\u1019\u102d\u102f\u1002\u103b\u102e" },
            { "egy", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038 \u1021\u102e\u1002\u103b\u1005\u103a" },
            { "tem", "\u1010\u1004\u103a\u1019\u103a\u1014\u1032" },
            { "teo", "\u1010\u102e\u1006\u102d\u102f" },
            { "rap", "\u101b\u1015\u1014\u103a\u1014\u1030\u1021\u102e" },
            { "AC", "\u1021\u1006\u1014\u103a\u1038\u101b\u103e\u1004\u103a\u1038\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "rar", "\u101b\u101b\u102d\u102f\u1010\u103d\u1014\u103a\u1002\u1014\u103a" },
            { "tet", "\u1010\u102e\u1010\u103d\u1019\u103a" },
            { "AD", "\u1021\u1014\u103a\u1012\u102d\u102f\u101b\u102c" },
            { "AE", "\u101a\u1030\u1021\u1031\u1021\u102e\u1038" },
            { "nl_BE", "\u1016\u101c\u102e\u1019\u1005\u103a\u101b\u103e\u103a" },
            { "AF", "\u1021\u102c\u1016\u1002\u1014\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "AG", "\u1021\u1014\u103a\u1010\u102e\u1002\u103d\u102b\u1014\u103e\u1004\u1037\u103a \u1018\u102c\u1018\u1030\u1012\u102b" },
            { "type.ca.ethiopic", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "AI", "\u1021\u1014\u103a\u1002\u102e\u101c\u102c" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "\u1021\u1014\u103a\u1002\u102d\u102f\u101c\u102c" },
            { "AQ", "\u1021\u1014\u1039\u1010\u102c\u1010\u102d\u1000" },
            { "AR", "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038" },
            { "AS", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1006\u1019\u102d\u102f\u1038\u1021\u102c\u1038" },
            { "AT", "\u1029\u1005\u1010\u103c\u102e\u1038\u101a\u102c\u1038" },
            { "AU", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b" },
            { "AW", "\u1021\u102c\u101b\u1030\u1038\u1017\u102c\u1038" },
            { "en_US", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "AX", "\u1021\u102c\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "AZ", metaValue_AZ },
            { "%%AREVELA", "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "BA", "\u1018\u1031\u102c\u1037\u1005\u1014\u102e\u1038\u101a\u102c\u1038\u1014\u103e\u1004\u1037\u103a \u101f\u102c\u1007\u102e\u1002\u102d\u102f\u1017\u102e\u1014\u102c\u1038" },
            { "BB", "\u1018\u102c\u1018\u1031\u1038\u1012\u102d\u102f\u1038\u1005\u103a" },
            { "ceb", "\u1005\u102e\u1017\u1030\u1021\u102c\u1014\u102d\u102f" },
            { "BD", "\u1018\u1004\u103a\u1039\u1002\u101c\u102c\u1038\u1012\u1031\u1037\u101b\u103e\u103a" },
            { "kum", "\u1000\u103d\u1019\u103a\u1019\u102d\u102f\u1000\u103a" },
            { "BE", "\u1018\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u101a\u1019\u103a" },
            { "gmh", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u103c\u1004\u1037\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "BF", "\u1018\u102c\u1000\u102e\u1038\u1014\u102c\u1038 \u1016\u102c\u1038\u1006\u102d\u102f" },
            { "BG", metaValue_BG },
            { "BH", "\u1018\u102c\u101b\u102d\u1014\u103a\u1038" },
            { "BI", "\u1018\u1030\u101b\u103d\u1014\u103a\u1012\u102e" },
            { "BJ", "\u1018\u102e\u1014\u1004\u103a" },
            { "BL", "\u1005\u102d\u1014\u1037\u103a\u1018\u102c\u101e\u101a\u103a\u101c\u103a\u1019\u102e" },
            { "BM", "\u1018\u102c\u1019\u103c\u1030\u1012\u102b" },
            { "myv", "\u1021\u102e\u1007\u101a\u102c" },
            { "BN", "\u1018\u101b\u1030\u1014\u102d\u102f\u1004\u103a\u1038" },
            { "BO", "\u1018\u102d\u102f\u101c\u102e\u1038\u1017\u102e\u1038\u101a\u102c\u1038" },
            { "BQ", "\u1000\u102c\u101b\u1005\u103a\u1018\u102e\u101a\u1036 \u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a" },
            { "BR", "\u1018\u101b\u102c\u1007\u102e\u1038" },
            { "BS", "\u1018\u101f\u102c\u1038\u1019\u102c\u1038" },
            { "xog", "\u1006\u102d\u102f\u1002\u102b" },
            { "BT", "\u1018\u1030\u1010\u1014\u103a" },
            { "BV", "\u1018\u1030\u1017\u1000\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "BW", "\u1018\u1031\u102c\u1037\u1006\u103d\u102c\u1014\u102c" },
            { "BY", metaValue_BY },
            { "BZ", "\u1018\u101c\u102d\u1007\u103a" },
            { "Visp", "\u1019\u103c\u1004\u103a\u1014\u102d\u102f\u1004\u103a\u101e\u1031\u102c \u1005\u1000\u102c\u1038" },
            { "type.ca.persian", "\u1015\u102b\u101b\u103e\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "type.nu.hebr", "\u101f\u102e\u1018\u101b\u1030\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "CA", "\u1000\u1014\u1031\u1012\u102b" },
            { "CC", "\u1000\u102d\u102f\u1000\u102d\u102f\u1038\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "mzn", "\u1019\u102c\u1007\u1014\u103a\u1012\u102b\u101b\u1014\u103a\u1014\u102e" },
            { "CD", metaValue_CD },
            { "CF", "\u1017\u101f\u102d\u102f \u1021\u102c\u1016\u101b\u102d\u1000 \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f" },
            { "CG", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f-\u1018\u101b\u102c\u1007\u102c\u1017\u102e\u1038\u101c\u103a" },
            { "CH", "\u1006\u103d\u1005\u103a\u1007\u102c\u101c\u1014\u103a" },
            { "CI", "\u1000\u102d\u102f\u1037\u1010\u103a \u1012\u102e\u1017\u103d\u102c" },
            { "CK", "\u1000\u103d\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "CL", "\u1001\u103b\u102e\u101c\u102e" },
            { "CM", "\u1000\u1004\u103a\u1019\u101b\u103d\u1014\u103a\u1038" },
            { "CN", metaValue_CN },
            { "CO", "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c" },
            { "CP", "\u1000\u101c\u1005\u103a\u1015\u102b\u1010\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "CR", "\u1000\u102d\u102f\u1037\u1005\u103a\u1010\u102c\u101b\u102e\u1000\u102c" },
            { "CU", "\u1000\u103b\u1030\u1038\u1018\u102c\u1038" },
            { "CV", "\u1000\u102d\u1010\u103a\u1017\u102c\u1012\u102e" },
            { "CW", "\u1000\u103b\u1030\u101b\u1031\u1038\u1000\u102d\u102f\u1038\u1005\u103a" },
            { "CX", "\u1001\u101b\u1005\u103a\u1005\u1019\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038" },
            { "CY", "\u1006\u102d\u102f\u1000\u103a\u1015\u101b\u1015\u103a\u1005\u103a" },
            { "CZ", "\u1001\u103b\u1000\u103a\u1000\u102e\u101a\u102c\u1038" },
            { "eka", "\u1021\u102e\u1000\u102c\u1002\u103b\u102f\u1001\u103a" },
            { "DE", "\u1002\u103b\u102c\u1019\u1014\u102e" },
            { "ace", "\u1021\u102c\u1001\u103b\u1031\u1038" },
            { "cgg", "\u1001\u103b\u102e\u1002\u102b" },
            { "DG", "\u1012\u102e\u1021\u1032\u1002\u102d\u102f\u1002\u102b\u1005\u102e\u101b\u102c" },
            { "type.nu.deva", "\u1012\u102e\u1017\u102c\u1014\u102c\u1002\u101b\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "DJ", "\u1002\u103b\u102e\u1018\u1030\u1010\u102e" },
            { "DK", metaValue_DK },
            { "Brai", "\u1018\u101b\u1031" },
            { "Brah", "\u1017\u103c\u101f\u1039\u1019\u1019\u102e" },
            { "DM", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u102c" },
            { "type.nu.armnlow", "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031 \u1005\u102c\u101c\u102f\u1036\u1038\u101e\u1031\u1038" },
            { "DO", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u1014\u103a" },
            { "gor", "\u1002\u102d\u102f\u101b\u102d\u102f\u1010\u102c\u101c\u102d\u102f" },
            { "zun", "\u1007\u1030\u1014\u102e" },
            { "tig", "\u1010\u102e\u1002\u101b\u102e" },
            { "DZ", "\u1021\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "pag", "\u1015\u1014\u103a\u1002\u102b\u1005\u102e\u1014\u1014\u103a" },
            { "EA", "\u1006\u101a\u103a\u1025\u1010\u102c\u1014\u103e\u1004\u1037\u103a\u1019\u101a\u103a\u101c\u102e\u101c\u103a\u101c\u102c" },
            { "pam", "\u1015\u1019\u103a\u1015\u1014\u103a\u100a\u102c" },
            { "EC", "\u1021\u102e\u1000\u103d\u1031\u1012\u1031\u102b" },
            { "pap", "\u1015\u102b\u1015\u102e\u1019\u1004\u103a\u1010\u102d\u102f" },
            { "ada", "\u1012\u1014\u103a\u1019\u1032" },
            { "EE", "\u1021\u1000\u103a\u1005\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "EG", "\u1021\u102e\u1002\u103b\u1005\u103a" },
            { "EH", "\u1021\u1014\u1031\u102c\u1000\u103a \u1006\u102c\u101f\u102c\u101b" },
            { "pau", metaValue_PW },
            { "chk", "\u1001\u103b\u1030\u1000\u102e\u1038\u1005\u103a" },
            { "chm", "\u1019\u102c\u101b\u102e" },
            { "cho", "\u1001\u103b\u1031\u102c\u1037\u1010\u102d\u102f" },
            { "chr", "\u1001\u103b\u102c\u101b\u102d\u102f\u1000\u102e" },
            { "ER", "\u1021\u102e\u101b\u102e\u1011\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "\u1025\u101b\u1031\u102c\u1015\u101e\u1019\u1002\u1039\u1002" },
            { "type.ca.gregorian", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1000\u102c\u101e\u102f\u1036\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "EZ", "\u1025\u101b\u1031\u102c\u1015\u1012\u1031\u101e" },
            { "chy", "\u1001\u103b\u1031\u101a\u1014\u103a\u1038" },
            { "type.nu.gujr", "\u1002\u102f\u1002\u103b\u102c\u101b\u1010\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ady", "\u1021\u1012\u102d\u102f\u1004\u103a\u1002\u102e" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "\u1016\u1031\u102c\u1037\u1000\u101c\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "FM", "\u1019\u102d\u102f\u1004\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u101b\u103e\u102c\u1038" },
            { "FO", "\u1016\u102c\u101b\u102d\u102f\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "root", "\u1019\u1030\u101c\u101b\u1004\u103a\u1038\u1019\u103c\u1005\u103a" },
            { "type.ca.indian", "\u1021\u102d\u1014\u1039\u1012\u103c\u102d\u101a \u1021\u1019\u103b\u102d\u102f\u1038\u101e\u102c\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "grc", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038 \u1002\u101b\u102d" },
            { "GA", "\u1002\u102b\u1018\u103d\u1014\u103a" },
            { "GB", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1000\u1004\u103a\u1038\u1012\u1019\u103a\u1038" },
            { "pcm", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1015\u1005\u103a\u1002\u103b\u1004\u103a" },
            { "GD", "\u1002\u101b\u102e\u1014\u1031\u1012\u102b" },
            { "GE", metaValue_GE },
            { "GF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1002\u102e\u101a\u102c\u1014\u102c" },
            { "GG", "\u1002\u103d\u1014\u103a\u1038\u1007\u102e" },
            { "GH", "\u1002\u102b\u1014\u102c" },
            { "Tale", "\u1010\u102d\u102f\u1004\u103a\u101c\u102e" },
            { "GI", "\u1002\u103b\u102e\u1018\u101b\u1031\u102c\u103a\u101c\u103a\u1010\u102c" },
            { "GL", "\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038" },
            { "enm", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "GM", "\u1002\u1019\u103a\u1018\u102e\u101b\u102c" },
            { "GN", "\u1002\u102e\u1014\u102e" },
            { "GP", "\u1002\u103d\u102b\u1012\u102e\u101c\u102f" },
            { "GQ", "\u1021\u102e\u1000\u103d\u1031\u1010\u102c \u1002\u102e\u1014\u102e" },
            { "GR", metaValue_GR },
            { "GS", "\u1010\u1031\u102c\u1004\u103a \u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1014\u103e\u1004\u1037\u103a \u1010\u1031\u102c\u1004\u103a \u1006\u1004\u103a\u1038\u1012\u101d\u1005\u103a\u1002\u103b\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f\u1019\u103b\u102c\u1038" },
            { "GT", "\u1002\u103d\u102b\u1010\u102e\u1019\u102c\u101c\u102c" },
            { "GU", "\u1002\u1030\u1021\u1019\u103a" },
            { "GW", "\u1002\u102e\u1014\u102e-\u1018\u102e\u1005\u1031\u102c" },
            { "tlh", "\u1000\u101c\u1004\u103a\u1002\u103d\u1014\u103a" },
            { "GY", "\u1002\u102d\u102f\u1004\u103a\u101a\u102c\u1014\u102c" },
            { "ckb", "\u1006\u102d\u102f\u101b\u102c\u1014\u102e" },
            { "zxx", "\u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u1010\u103a\u101e\u1000\u103a\u101e\u1031\u102c\u1021\u101b\u102c \u1019\u101b\u103e\u102d\u1015\u102b" },
            { "de_AT", "\u1029\u1005\u1010\u103c\u102e\u1038\u101a\u102c\u1038 \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "HK", "\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a (\u1010\u101b\u102f\u1010\u103a\u1015\u103c\u100a\u103a)" },
            { "HM", "\u101f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1014\u103e\u1004\u1037\u103a\u1019\u1000\u103a\u1012\u1031\u102b\u1014\u101a\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "HN", "\u101f\u103d\u1014\u103a\u1012\u1030\u1038\u101b\u1015\u103a\u1005\u103a" },
            { "HR", metaValue_HR },
            { "agq", "\u1021\u102c\u1002\u103a\u101f\u102d\u1014\u103a\u1038" },
            { "gsw", "\u1006\u103d\u1005\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "\u1000\u1014\u1031\u101b\u102e \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "ID", metaValue_ID },
            { "peo", metaValue_peo },
            { "IE", "\u1021\u102d\u102f\u1004\u103a\u101a\u102c\u101c\u1014\u103a" },
            { "nap", "\u1014\u1015\u102d\u102f\u101c\u102e\u1010\u1014\u103a" },
            { "naq", "\u1014\u102c\u1019\u102c" },
            { "zza", "\u1007\u102c\u1007\u102c" },
            { "IL", "\u1021\u1005\u1039\u1005\u101b\u1031\u1038" },
            { "IM", "\u1019\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "IN", "\u1021\u102d\u1014\u1039\u1012\u102d\u101a" },
            { "IO", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e\u1015\u102d\u102f\u1004\u103a \u1021\u102d\u1014\u1039\u1012\u102d\u101a\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1019\u103b\u102c\u1038" },
            { "IQ", "\u1021\u102e\u101b\u1010\u103a" },
            { "IR", "\u1021\u102e\u101b\u1014\u103a" },
            { "IS", "\u1021\u102d\u102f\u1000\u103a\u1005\u101c\u1014\u103a" },
            { "IT", metaValue_IT },
            { "Zmth", "\u1002\u100f\u1014\u103a\u1038\u101e\u1004\u103a\u1039\u1001\u103b\u102c" },
            { "type.nu.thai", "\u1011\u102d\u102f\u1004\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "%%POSIX", "\u1000\u103d\u1014\u103a\u1015\u103b\u1030\u1010\u102c" },
            { "type.nu.beng", "\u1018\u1004\u103a\u1039\u1002\u102b\u101c\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "JE", "\u1002\u103b\u102c\u1005\u102e" },
            { "type.ca.islamic", "\u1021\u1005\u1039\u1005\u101c\u102c\u1019\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "Beng", metaValue_bn },
            { "JM", "\u1002\u103b\u1019\u1031\u1000\u102c" },
            { "JO", "\u1002\u103b\u1031\u102c\u103a\u1012\u1014\u103a" },
            { "JP", metaValue_JP },
            { "%%1606NICT", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1014\u1031\u102c\u1000\u103a\u1000\u103b\u101e\u1031\u102c\u1015\u103c\u1004\u103a\u101e\u1005\u103a\u1019\u103e \u1041\u1046\u1040\u1046" },
            { "ain", "\u1021\u102d\u1014\u103a\u1014\u102f" },
            { "guz", "\u1002\u1030\u1005\u102e\u1038" },
            { "type.nu.knda", "\u1001\u1014\u1039\u1014\u1012\u102b \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Kali", "\u1000\u101a\u102c\u1038\u101c\u102e" },
            { "de_CH", "\u1021\u101c\u102e\u1019\u1032\u1014\u103a\u1014\u1005\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "type.ca.buddhist", "\u1017\u102f\u1012\u1039\u1013 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "KE", "\u1000\u1004\u103a\u100a\u102c" },
            { "419", "\u101c\u1000\u103a\u1010\u1004\u103a\u1021\u1019\u1031\u101b\u102d\u1000" },
            { "KG", "\u1000\u102c\u1002\u103b\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "KH", "\u1000\u1019\u1039\u1018\u1031\u102c\u1012\u102e\u1038\u101a\u102c\u1038" },
            { "KI", "\u1001\u102e\u101b\u102e\u1018\u102c\u1010\u102e" },
            { "KM", "\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102d\u102f\u1005\u103a" },
            { "KN", "\u1005\u102d\u1014\u1037\u103a\u1000\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1014\u102e\u1017\u102e\u1005\u103a" },
            { "Knda", "\u1001\u1014\u1039\u1014\u102c\u1012\u102b" },
            { "fr_CA", "\u1000\u1014\u1031\u1012\u102b \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "KP", "\u1019\u103c\u1031\u102c\u1000\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "KR", "\u1010\u1031\u102c\u1004\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "fr_CH", "\u1006\u103d\u1005\u103a \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "KW", "\u1000\u1030\u101d\u102d\u1010\u103a" },
            { "tpi", "\u1010\u1031\u102c\u1037\u1001\u103a \u1015\u102d\u1005\u1004\u103a" },
            { "KY", "\u1000\u1031\u1019\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "KZ", "\u1000\u102c\u1007\u1000\u103a\u1005\u1010\u1014\u103a" },
            { "Cyrl", "\u1005\u1005\u103a\u101b\u102d\u101c\u1005\u103a" },
            { "LA", metaValue_LA },
            { "LB", "\u101c\u1000\u103a\u1018\u1014\u103d\u1014\u103a" },
            { "LC", "\u1005\u102d\u1014\u1037\u103a\u101c\u1030\u1005\u102e\u101a\u102c" },
            { "gwi", "\u1002\u103d\u1005\u103a\u1001\u103b\u1004\u103a" },
            { "nds", "\u1021\u1014\u102d\u1019\u1037\u103a \u1002\u103b\u102c\u1019\u1014\u103a" },
            { "LI", "\u101c\u1005\u103a\u1010\u1014\u103a\u1005\u1010\u102d\u1014\u103a\u1038" },
            { "LK", "\u101e\u102e\u101b\u102d\u101c\u1004\u103a\u1039\u1000\u102c" },
            { "LR", "\u101c\u102d\u102f\u1000\u103a\u1018\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "LS", "\u101c\u102e\u1006\u102d\u102f\u101e\u102d\u102f" },
            { "LT", "\u101c\u1005\u103a\u101e\u1030\u101a\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "Kana", "\u1001\u1010\u1001\u1014" },
            { "LY", "\u101c\u1005\u103a\u1017\u103b\u102c\u1038" },
            { "lad", "\u101c\u102c\u1012\u102e\u1014\u102d\u102f" },
            { "vun", "\u1017\u103d\u1014\u103a\u1002\u103b\u102d\u102f" },
            { "lag", "\u101c\u1014\u103a\u1002\u102e" },
            { "Thaa", "\u101e\u102c\u1021\u103a" },
            { "MA", "\u1019\u1031\u102c\u103a\u101b\u102d\u102f\u1000\u102d\u102f" },
            { "MC", "\u1019\u102d\u102f\u1014\u102c\u1000\u102d\u102f" },
            { "MD", "\u1019\u1031\u102c\u101c\u103a\u1012\u102d\u102f\u1017\u102c" },
            { "ME", "\u1019\u103d\u1014\u103a\u1010\u102e\u1014\u102d\u1002\u101b\u102d\u102f\u1038" },
            { "MF", "\u1005\u102d\u1014\u1037\u103a\u1019\u102c\u1010\u1004\u103a" },
            { "MG", "\u1019\u1012\u102b\u1002\u1010\u103a\u1005\u1000\u102c\u1038" },
            { "Thai", metaValue_TH },
            { "MH", "\u1019\u102c\u101b\u103e\u101a\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "ale", "\u1021\u102c\u101c\u102e\u101a\u102f" },
            { "MK", metaValue_MK },
            { "ML", "\u1019\u102c\u101c\u102e" },
            { "MM", metaValue_MM },
            { "MN", "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u1038\u101c\u102e\u1038\u101a\u102c\u1038" },
            { "new", "\u1014\u102e\u101d\u102b\u101b\u102e" },
            { "MO", "\u1019\u1000\u102c\u1021\u102d\u102f (\u1010\u101b\u102f\u1010\u103a\u1015\u103c\u100a\u103a)" },
            { "MP", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038\u1019\u102c\u101b\u102e\u1021\u102c\u1014\u102c\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "MQ", "\u1019\u102c\u1010\u102e\u1014\u102d\u1001\u103a" },
            { "MR", "\u1019\u1031\u102c\u103a\u101b\u102e\u1010\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "MS", "\u1019\u1031\u102c\u1004\u1037\u103a\u1005\u1032\u101b\u1000\u103a" },
            { "MT", "\u1019\u1031\u102c\u101c\u103a\u1010\u102c" },
            { "MU", metaValue_MU },
            { "alt", "\u1010\u1031\u102c\u1004\u103a \u1021\u102c\u101c\u103a\u1010\u102d\u102f\u1004\u103a\u1038" },
            { "MV", "\u1019\u1031\u102c\u103a\u101c\u103a\u1012\u102d\u102f\u1000\u103a" },
            { "MW", "\u1019\u102c\u101c\u102c\u101d\u102e" },
            { "MX", "\u1019\u1000\u1039\u1000\u1006\u102e\u1000\u102d\u102f" },
            { "type.ca.japanese", "\u1002\u103b\u1015\u1014\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "MY", "\u1019\u101c\u1031\u1038\u101b\u103e\u102c\u1038" },
            { "MZ", "\u1019\u102d\u102f\u1007\u1019\u103a\u1018\u1005\u103a" },
            { "NA", "\u1014\u1019\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "202", "\u1006\u102c\u101f\u102c\u101b-\u1021\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "type.ca.hebrew", "\u101f\u102e\u1018\u101b\u1030\u1038 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "NC", "\u1014\u101a\u1030\u1038 \u1000\u101a\u103a\u101c\u102e\u1012\u102d\u102f\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "NE", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102c" },
            { "NF", "\u1014\u1031\u102c\u1016\u102f\u1010\u103a\u1000\u103b\u103d\u1014\u103a\u1038" },
            { "NG", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038" },
            { "trv", "\u1010\u101b\u102d\u102f\u1000\u102d\u102f" },
            { "NI", "\u1014\u102e\u1000\u102c\u101b\u102c\u1002\u103d\u102b" },
            { "NL", "\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a" },
            { "NO", "\u1014\u1031\u102c\u103a\u101d\u1031" },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u1014\u102e\u1025\u1030\u1021\u1031" },
            { "rof", "\u101b\u103d\u1019\u103a\u1018\u102d\u102f" },
            { "NZ", "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a" },
            { "ang", "\u1021\u1004\u103a\u1002\u101c\u102d\u102f \u1006\u1000\u1039\u1000\u1005\u103d\u1014\u103a" },
            { "OM", "\u1021\u102d\u102f\u1019\u1014\u103a" },
            { "anp", "\u1021\u1014\u103a\u1002\u102e\u1000\u102c" },
            { "crs", "\u1001\u101b\u102e\u1021\u102d\u102f\u101c\u102e" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u1015\u1014\u102c\u1038\u1019\u102c\u1038" },
            { "en_GB", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "PE", "\u1015\u102e\u101b\u1030\u1038" },
            { "PF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1015\u1031\u102b\u103a\u101c\u102e\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "PG", "\u1015\u102b\u1015\u1030\u1021\u102c \u1014\u101a\u1030\u1038\u1002\u102e\u1014\u102e" },
            { "PH", metaValue_PH },
            { "PK", "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "PL", metaValue_PL },
            { "ewo", "\u1021\u102e\u101d\u1014\u103a\u1012\u102d\u102f" },
            { "PM", "\u1005\u102d\u1014\u1037\u103a\u1015\u102e\u1021\u1032\u101b\u103a\u1014\u103e\u1004\u1037\u103a \u1019\u102e\u1000\u103d\u102e\u101c\u103d\u1014\u103a" },
            { "PN", "\u1015\u1005\u103a\u1010\u103a\u1000\u102d\u1014\u103a\u1038\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "PR", "\u1015\u1031\u102b\u103a\u1010\u102d\u102f\u101b\u102e\u1000\u102d\u102f" },
            { "PS", "\u1015\u102b\u101c\u1000\u103a\u1005\u1010\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a" },
            { "PT", metaValue_PT },
            { "PW", metaValue_PW },
            { "nia", "\u1014\u102e\u1038\u101b\u1015\u103a\u1005\u103a" },
            { "type.nu.greklow", "\u1002\u101b\u102d \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031 \u1005\u102c\u101c\u102f\u1036\u1038\u101e\u1031\u1038" },
            { "PY", "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038" },
            { "tum", "\u1010\u1019\u103a\u1018\u1030\u1000\u102c" },
            { "Hebr", "\u101f\u102e\u1017\u101b\u1030\u1038" },
            { "QA", "\u1000\u102c\u1010\u102c" },
            { "%%SCOTLAND", "\u1005\u1000\u1031\u102c\u1037 \u1005\u1036 \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "niu", "\u1014\u1030\u1021\u1032\u101a\u1014\u103a\u1038" },
            { "QO", "\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c \u1021\u1015\u103c\u1004\u103a\u1018\u1000\u103a\u101b\u103e\u102d \u1000\u103b\u103d\u1014\u103a\u1038\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1019\u103b\u102c\u1038" },
            { "lez", "\u101c\u1000\u103a\u1007\u103a\u1002\u102e\u1038\u101a\u102c\u1038" },
            { "%%FONUPA", "UPA \u1021\u101e\u1036\u1011\u103d\u1000\u103a" },
            { "tvl", "\u1010\u1030\u1017\u102c\u101c\u1030" },
            { "001", "\u1000\u1019\u1039\u1018\u102c" },
            { "002", "\u1021\u102c\u1016\u101b\u102d\u1000" },
            { "003", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u1019\u1031\u101b\u102d\u1000\u1010\u102d\u102f\u1000\u103a" },
            { "RE", "\u101b\u102e\u101a\u1030\u1014\u102e\u101a\u1014\u103a" },
            { "005", "\u1010\u1031\u102c\u1004\u103a \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "jbo", "\u101c\u102d\u102f\u1002\u103b\u103a\u1018\u1014\u103a" },
            { "009", "\u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c\u1012\u1031\u101e" },
            { "RO", "\u101b\u102d\u102f\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "RS", metaValue_RS },
            { "RU", "\u101b\u102f\u101b\u103e\u102c\u1038" },
            { "RW", "\u101b\u101d\u1014\u103a\u1012\u102b" },
            { "SA", "\u1006\u1031\u102c\u103a\u1012\u102e\u1021\u102c\u101b\u1031\u1038\u1018\u102e\u1038\u101a\u102c\u1038" },
            { "SB", "\u1006\u1031\u102c\u103a\u101c\u1019\u103d\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "twq", "\u1010\u102c\u1006\u102c\u101d\u102b\u1001\u103a" },
            { "011", "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "SC", "\u1006\u1031\u1038\u101b\u103e\u1032" },
            { "SD", metaValue_SD },
            { "SE", metaValue_SE },
            { "013", "\u1017\u101f\u102d\u102f \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "014", "\u1021\u101b\u103e\u1031\u1037 \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "015", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "SG", "\u1005\u1004\u103a\u1039\u1000\u102c\u1015\u1030" },
            { "SH", "\u1005\u102d\u1014\u1037\u103a\u101f\u101a\u103a\u101c\u101a\u103a\u1014\u102c" },
            { "type.lb.strict", "\u1000\u1014\u1037\u103a\u101e\u1010\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "SI", metaValue_SI },
            { "017", "\u1021\u101c\u101a\u103a \u1021\u102c\u1016\u101b\u102d\u1000" },
            { "018", "\u1021\u102c\u1016\u101b\u102d\u1000 \u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038" },
            { "SJ", "\u1005\u1017\u102d\u102f\u101c\u103a\u1018\u1010\u103a\u1014\u103e\u1004\u1037\u103a\u1002\u103b\u1014\u103a\u1019\u1031\u101b\u1014\u103a" },
            { "019", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a" },
            { "SK", "\u1006\u101c\u102d\u102f\u1017\u1000\u103a\u1000\u102e\u1038\u101a\u102c\u1038" },
            { "SL", "\u1006\u102e\u101a\u102c\u101b\u102c \u101c\u102e\u101a\u103d\u1014\u103a\u1038" },
            { "SM", "\u1006\u1014\u103a\u1019\u102c\u101b\u102e\u1014\u102d\u102f" },
            { "SN", "\u1006\u102e\u1014\u102e\u1002\u1031\u102b" },
            { "SO", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e\u101a\u102c" },
            { "arn", "\u1019\u102c\u1015\u102f\u1001\u103b\u102e" },
            { "arp", "\u1021\u102c\u101b\u102c\u1015\u102b\u101f\u102d\u102f" },
            { "type.nu.taml", "\u101b\u102d\u102f\u1038\u101b\u102c \u1010\u1019\u102e\u1038\u101c\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "SR", "\u1006\u1030\u101b\u102c\u1014\u1019\u103a" },
            { "SS", "\u1010\u1031\u102c\u1004\u103a \u1006\u1030\u1012\u1014\u103a" },
            { "ST", "\u1006\u1031\u102c\u1004\u103a\u1010\u1030\u1019\u1031\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u101b\u1004\u103a\u1005\u102e\u1015\u102e" },
            { "SV", "\u1021\u101a\u103a\u101c\u103a\u1006\u102c\u1017\u1031\u1038\u1012\u102d\u102f\u1038" },
            { "SX", "\u1005\u1004\u1037\u103a\u1019\u102c\u1010\u1004\u103a" },
            { "SY", metaValue_SY },
            { "SZ", metaValue_SZ },
            { "TA", "\u1011\u101b\u1005\u1039\u1005\u1010\u1014\u103a \u1012\u102b \u1000\u103d\u1014\u103a\u101f\u102c" },
            { "asa", "\u1021\u102c\u1005\u102f" },
            { "type.ms.ussystem", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u1005\u1014\u1005\u103a" },
            { "021", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u1019\u1031\u101b\u102d\u1000" },
            { "TC", "\u1010\u1001\u103a\u1005\u103a\u1014\u103e\u1004\u1037\u103a\u1000\u102c\u1021\u102e\u1000\u102d\u102f\u1005\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "yav", "\u101b\u1014\u103a\u1018\u1032\u1014\u103a" },
            { "TD", "\u1001\u103b\u1012\u103a" },
            { "TF", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1015\u102d\u102f\u1004\u103a\u1014\u1000\u103a\u1019\u103b\u102c\u1038" },
            { "TG", "\u1010\u102d\u102f\u1002\u102d\u102f" },
            { "TH", metaValue_TH },
            { "TJ", "\u1010\u102c\u1002\u103b\u102e\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "029", "\u1000\u102c\u101b\u1005\u103a\u1018\u102e\u101a\u1036" },
            { "TK", "\u1010\u102d\u102f\u1000\u101c\u1031\u102c\u1004\u103a" },
            { "TL", "\u1021\u101b\u103e\u1031\u1037\u1010\u102e\u1019\u1031\u102c" },
            { "ybb", "\u101b\u1019\u103a\u1018\u102c" },
            { "TM", metaValue_TM },
            { "TN", "\u1010\u1030\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "\u1011\u101b\u102e\u1014\u102e\u1012\u1010\u103a\u1014\u103e\u1004\u1037\u103a \u1010\u102d\u102f\u1018\u1000\u103a\u1002\u102d\u102f" },
            { "TV", "\u1010\u1030\u1017\u102c\u1038\u101c\u1030" },
            { "TW", "\u1011\u102d\u102f\u1004\u103a\u101d\u1019\u103a" },
            { "ast", "\u1021\u1000\u103a\u1005\u1010\u1030\u101b\u102e\u101a\u1014\u103a\u1038" },
            { "TZ", "\u1010\u1014\u103a\u1007\u1014\u103a\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "nmg", "\u1000\u103d\u102c\u1005\u102e\u1021\u102d\u102f" },
            { "Zzzz", "\u1019\u101e\u102d \u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a \u1019\u101b\u103e\u102d\u101e\u1031\u102c \u1005\u1000\u102c\u1038\u101c\u102f\u1036\u1038" },
            { "UA", metaValue_UA },
            { "rup", "\u1021\u102c\u101b\u102d\u102f\u1019\u1014\u103a\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "030", "\u1021\u101b\u103e\u1031\u1037\u1021\u102c\u101b\u103e" },
            { "tyv", "\u1010\u1030\u1017\u1014\u103a" },
            { "sw_CD", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f \u1006\u103d\u102c\u101f\u102e\u101c\u102e" },
            { "034", "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u101b\u103e" },
            { "035", "\u1021\u101b\u103e\u1031\u1037\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u101b\u103e" },
            { "UG", "\u101a\u1030\u1002\u1014\u103a\u1038\u1012\u102b\u1038" },
            { "039", "\u1010\u1031\u102c\u1004\u103a\u1025\u101b\u1031\u102c\u1015" },
            { "Sinh", "\u1006\u1004\u103a\u101f\u102c\u101c" },
            { "UM", "\u101a\u1030\u1014\u102d\u102f\u1000\u103a\u1010\u1000\u103a\u1005\u1010\u102d\u1010\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1019\u103b\u102c\u1038" },
            { "UN", "\u1000\u102f\u101c\u101e\u1019\u1002\u1039\u1002" },
            { "US", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f" },
            { "haw", "\u101f\u102c\u101d\u102d\u102f\u1004\u103a\u101a\u102e" },
            { "UY", "\u1025\u101b\u102f\u1002\u103d\u1031\u1038" },
            { "prg", "\u1015\u101b\u1030\u101b\u103e\u1014\u103a" },
            { "UZ", "\u1025\u1007\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a" },
            { "tzm", "\u1021\u101c\u101a\u103a\u1021\u102c\u1037\u1010\u101c\u102c\u1005\u103a \u1010\u102c\u1019\u102c\u1007\u102d\u102f\u1000\u103a" },
            { "nnh", "\u1021\u103d\u1014\u103a\u101b\u1032\u1018\u103d\u1014\u103a\u1038" },
            { "VA", "\u1017\u102c\u1010\u102e\u1000\u1014\u103a\u1005\u102e\u1038\u1010\u102e\u1038" },
            { "VC", "\u1005\u102d\u1014\u1037\u103a\u1017\u1004\u103a\u1038\u1006\u1004\u1037\u103a\u1014\u103e\u1004\u1037\u103a \u1002\u101b\u102d\u1014\u1031\u1012\u102d\u102f\u1004\u103a" },
            { "VE", "\u1017\u1004\u103a\u1014\u102e\u1007\u103d\u1032\u101c\u102c\u1038" },
            { "VG", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1017\u102c\u1002\u103b\u1004\u103a\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "VI", "\u101a\u1030\u1021\u1000\u103a\u1005\u103a \u1017\u102c\u1002\u103b\u1004\u103a\u1038 \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f" },
            { "VN", metaValue_VN },
            { "VU", "\u1017\u1014\u103d\u102c\u1038\u1010\u1030" },
            { "nog", "\u1014\u102d\u102f\u1002\u102d\u102f\u1004\u103a" },
            { "rwk", "\u101b\u1030\u101d\u1019\u103a" },
            { "053", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u1014\u103e\u1004\u1037\u103a \u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a" },
            { "054", "\u1019\u102e\u101c\u102c\u1014\u102e\u1038\u101b\u103e\u102c\u1038" },
            { "WF", "\u101d\u1031\u102b\u101c\u1005\u103a\u1014\u103e\u1004\u1037\u103a \u1016\u1030\u1000\u103b\u1030\u1038\u1014\u102c\u1038" },
            { "057", "\u1019\u102d\u102f\u1000\u103a\u1001\u101b\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u1012\u1031\u101e" },
            { "jgo", "\u1002\u103d\u1019\u103a\u1018\u102c" },
            { "lkt", "\u101c\u102c\u1000\u102d\u102f\u1010\u102c" },
            { "wae", "\u101d\u1031\u102b\u101c\u103a\u1006\u102c" },
            { "WS", "\u1006\u1019\u102d\u102f\u1038\u1021\u102c\u1038" },
            { "wal", "\u101d\u102d\u102f\u101c\u1000\u103a\u1010\u102c" },
            { "war", "\u101d\u102b\u101b\u1031\u1038" },
            { "awa", "\u1021\u102c\u101d\u102b\u1012\u102e" },
            { "061", "\u1015\u102d\u102f\u101c\u102e\u1014\u102e\u101b\u103e\u102c\u1038" },
            { "XK", "\u1000\u102d\u102f\u1006\u102d\u102f\u1017\u102d\u102f" },
            { "Gujr", "\u1002\u102f\u1002\u103b\u102c\u101b\u101e\u102e" },
            { "Zxxx", "\u1011\u102f\u1036\u1038\u1010\u1019\u103a\u1038\u101e\u1016\u103d\u101a\u103a\u101c\u102d\u102f\u1000\u103a\u1014\u102c\u101c\u103b\u1000\u103a\u101b\u103e\u102d\u101e\u1031\u102c" },
            { "wbp", "\u101d\u1031\u102b\u101c\u103a\u1015\u102e\u101b\u102e" },
            { "YE", "\u101a\u102e\u1019\u1004\u103a" },
            { "nqo", "\u1021\u103d\u1014\u103a\u1000\u102d\u102f" },
            { "type.co.standard", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a\u1005\u102e\u1011\u102c\u1038\u101e\u1031\u102c" },
            { "YT", "\u1019\u1031\u101a\u1031\u102c\u1037" },
            { "ZA", metaValue_ZA },
            { "type.lb.loose", "\u1000\u1014\u1037\u103a\u101e\u1010\u103a\u1019\u1011\u102c\u1038\u101e\u1031\u102c \u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "Deva", "\u1012\u102e\u1017\u1014\u102c\u1002\u101b\u102e" },
            { "type.nu.geor", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1000\u102c\u101e\u102f\u1036\u1038\u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Hira", "\u101f\u102e\u101b\u1002\u1014" },
            { "ZM", "\u1007\u1019\u103a\u1018\u102e\u101a\u102c" },
            { "ZW", "\u1007\u1004\u103a\u1018\u102c\u1018\u103d\u1031" },
            { "ZZ", "\u1019\u101e\u102d (\u101e\u102d\u102f\u1037) \u1019\u101b\u103e\u102d\u101e\u1031\u102c \u1012\u1031\u101e" },
            { "type.ms.metric", "\u1019\u1000\u103a\u1011\u101b\u1005\u103a\u1005\u1014\u1005\u103a" },
            { "type.ca.iso8601", "ISO-8601 \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "nso", "\u1019\u103c\u1031\u102c\u1000\u103a \u1006\u102d\u102f\u101e\u102d\u102f" },
            { "type.nu.telu", "\u1010\u101c\u102f\u1002\u102f \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "loz", "\u101c\u102d\u102f\u1007\u102e" },
            { "jmc", "\u1019\u1001\u103b\u102c\u1019\u102e" },
            { "type.nu.hansfin", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038 \u1010\u101b\u102f\u1010\u103a \u1018\u100f\u1039\u100d\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "hil", "\u101f\u102e\u101c\u102e\u1002\u1031\u1014\u103d\u1014\u103a" },
            { "type.nu.arabext", "\u1010\u102d\u102f\u1038\u1001\u103b\u1032\u1037\u1021\u102c\u101b\u1015\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "nus", "\u1014\u1030\u1021\u102c" },
            { "dak", "\u1012\u102b\u1000\u102d\u102f\u1010\u102c" },
            { "type.nu.fullwide", "\u1017\u103c\u1000\u103a\u1015\u103c\u100a\u1037\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "dar", "\u1012\u102b\u1002\u103a\u101d\u102b" },
            { "dav", "\u1010\u102d\u102f\u1004\u103a\u1010\u102c" },
            { "lrc", "\u1019\u103c\u1031\u102c\u1000\u103a\u101c\u1030\u101b\u102e" },
            { "udm", "\u1021\u1030\u1019\u1030\u101b\u1010\u103a" },
            { "Khmr", metaValue_km },
            { "sad", "\u1006\u1014\u103a\u1012\u102b\u101d\u102e" },
            { "type.nu.roman", "\u101b\u1031\u102c\u1019 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "sah", "\u1006\u1001\u102b" },
            { "saq", "\u1006\u1019\u103a\u1018\u1030\u101b\u1030" },
            { "sat", "\u1006\u1014\u103a\u1010\u102c\u101c\u102e" },
            { "jpr", "\u1002\u103b\u1030\u1012\u102e\u101a\u102d\u102f-\u1015\u102b\u101b\u103e\u1014\u103a" },
            { "sba", "\u1021\u103d\u1014\u103a\u1002\u1019\u103a\u1038\u1018\u1031\u1038" },
            { "Guru", "\u1002\u1030\u101b\u1030" },
            { "lua", "\u101c\u1030\u1018\u102c-\u101c\u1030\u101c\u1030\u1021\u102c" },
            { "sbp", "\u1006\u1014\u103a\u1002\u102f" },
            { "nyn", "\u1014\u101b\u1014\u103a\u1000\u102d\u102f\u101c\u102e" },
            { "lun", "\u101c\u103d\u1014\u103a\u1012\u102b" },
            { "luo", "\u101c\u1030\u1021\u102d\u102f" },
            { "fil", metaValue_PH },
            { "hmn", "\u1019\u102f\u1036" },
            { "del", "\u1012\u101a\u103a\u101c\u102c\u101d\u1032\u101c\u103a" },
            { "lus", "\u1019\u102e\u1007\u102d\u102f" },
            { "ban", "\u1018\u102c\u101c\u102e" },
            { "luy", "\u101c\u1030\u101b\u102e\u1021\u102c" },
            { "bas", "\u1018\u102c\u1006\u102c" },
            { "jrb", "\u1002\u103b\u1030\u1012\u102e\u101a\u102d\u102f-\u1021\u102c\u101b\u1017\u102e" },
            { "es_ES", "\u1005\u1015\u102d\u1014\u103a (\u1025\u101b\u1031\u102c\u1015)" },
            { "sco", "\u1005\u1000\u1031\u102c\u1037\u1010\u103a" },
            { "scn", "\u1005\u1005\u1039\u1005\u101c\u102e" },
            { "aa", "\u1021\u102c\u1016\u102c" },
            { "ab", "\u1021\u1018\u103a\u1001\u102b\u1007\u102e\u101b\u102c" },
            { "af", metaValue_ZA },
            { "ak", "\u1021\u102c\u1000\u1014\u103a" },
            { "am", "\u1021\u1019\u103a\u101f\u102c\u101b\u1005\u103a\u1001\u103a" },
            { "an", "\u1021\u102c\u101b\u102c\u1002\u103d\u1014\u103a" },
            { "Arab", "\u1021\u102c\u101b\u1031\u1017\u103b" },
            { "Jpan", metaValue_JP },
            { "ar", "\u1021\u102c\u101b\u1017\u102e" },
            { "Hrkt", "\u1002\u103b\u1015\u1014\u103a \u1021\u1000\u1039\u1001\u101b\u102c" },
            { "as", "\u1021\u102c\u101e\u1036" },
            { "av", "\u1021\u102c\u1017\u102c\u101b\u1005\u103a\u1001\u103a" },
            { "ay", "\u1021\u102d\u102f\u1004\u103a\u1019\u102c\u101b" },
            { "az", metaValue_AZ },
            { "ba", "\u1018\u1000\u103a\u101b\u103e\u103a\u1000\u102c" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "\u1018\u1005\u103a\u1005\u103a\u101c\u102c\u1019\u102c" },
            { "bm", "\u1018\u1014\u103a\u1018\u102c\u101b\u102c" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u1012\u1031\u102b\u1037\u1002\u103a\u101b\u1005\u103a\u1018\u103a" },
            { "br", "\u1018\u101b\u102e\u1010\u103d\u1014\u103a" },
            { "bs", "\u1018\u1031\u102c\u1037\u1005\u103a\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "Mymr", metaValue_MM },
            { "type.nu.laoo", "\u101c\u102c\u1021\u102d\u102f \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "seh", "\u1005\u102e\u1014\u102c" },
            { "ca", "\u1000\u1010\u103a\u1010\u101c\u1014\u103a" },
            { "ses", "\u1000\u102d\u102f\u101b\u102c\u1018\u102d\u102f\u101b\u102d\u102f \u1006\u1019\u103a\u1014\u102e" },
            { "ce", "\u1001\u103b\u1000\u103a\u1001\u103b\u1014\u103a\u1038" },
            { "ch", "\u1001\u103b\u1019\u102d\u102f\u101b\u102d\u102f" },
            { "%%REVISED", "\u1015\u103c\u1014\u103a\u101c\u100a\u103a\u1005\u102e\u1005\u1005\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "co", "\u1001\u102d\u102f\u1005\u102e\u1000\u1014\u103a" },
            { "Orya", "\u1021\u102d\u102f\u101b\u102c" },
            { "cr", "\u1001\u101b\u102e\u1038" },
            { "cs", "\u1001\u103b\u1000\u103a" },
            { "cu", "\u1001\u103b\u1015\u103a\u1001\u103b\u103a \u1005\u101c\u102c\u1017\u1005\u103a" },
            { "cv", "\u1001\u103b\u1030\u1017\u1000\u103a\u101b\u103e\u103a" },
            { "cy", "\u101d\u1031\u101c" },
            { "type.nu.ethi", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1015\u102e\u1038\u101a\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Yiii", "\u101b\u102e" },
            { "da", metaValue_DK },
            { "pt_PT", "\u1025\u101b\u1031\u102c\u1015 \u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e" },
            { "de", "\u1002\u103b\u102c\u1019\u1014\u103a" },
            { "type.cf.standard", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a \u1004\u103d\u1031\u101b\u1031\u1010\u103d\u1000\u103a\u1015\u102f\u1036\u1005\u1014\u1005\u103a" },
            { "bem", "\u1018\u102d\u1014\u103a\u1018\u102c" },
            { "sga", "\u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a \u101f\u1031\u102c\u1004\u103a\u1038" },
            { "dv", "\u1012\u102e\u1017\u102c\u101f\u102e" },
            { "dz", "\u1012\u1007\u103d\u1014\u103a\u1000\u102c" },
            { "bez", "\u1018\u102e\u1014\u102c" },
            { "type.ca.chinese", "\u1010\u101b\u102f\u1010\u103a \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "dje", "\u1007\u102c\u1019\u102c" },
            { "type.nu.grek", "\u1002\u101b\u102d \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ee", "\u1021\u102e\u101d\u102e" },
            { "type.lb.normal", "\u1015\u102f\u1036\u1019\u103e\u1014\u103a\u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "ro_MD", "\u1019\u1031\u102c\u103a\u101c\u1012\u102d\u102f\u1017\u102c" },
            { "el", metaValue_GR },
            { "en", "\u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "eo", "\u1021\u1000\u103a\u1005\u103a\u1015\u101b\u1014\u103a\u1010\u102d\u102f" },
            { "es", metaValue_ES },
            { "et", "\u1021\u1000\u103a\u1005\u103a\u1010\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "Hanb", "\u101f\u1014\u103a\u1018\u103a" },
            { "eu", "\u1018\u102c\u1005\u103a\u1001\u103a" },
            { "Hang", "\u101f\u1014\u103a\u1002\u1030\u1038\u101c\u103a" },
            { "shi", "\u1010\u102c\u1001\u103b\u101a\u103a\u101c\u103a\u101f\u1005\u103a" },
            { "hsb", "\u1006\u1000\u1039\u1000\u1006\u102d\u102f\u1014\u102e" },
            { "Hani", "\u101f\u1014\u103a" },
            { "shn", "\u101b\u103e\u1019\u103a\u1038" },
            { "fa", "\u1015\u102b\u101b\u103e\u1014\u103a" },
            { "Hans", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038" },
            { "type.nu.latn", "\u1021\u1014\u1031\u102c\u1000\u103a\u1010\u102d\u102f\u1004\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Hant", "\u101b\u102d\u102f\u1038\u101b\u102c" },
            { "ff", "\u1016\u1030\u101c\u102c" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fon", "\u1016\u1031\u102c\u103a\u1014\u103a" },
            { "bgn", "\u1021\u1014\u1031\u102c\u1000\u103a \u1018\u1032\u101c\u102d\u102f\u1001\u103b\u102e" },
            { "yue", "\u1000\u103d\u1019\u103a\u1010\u102f\u1036" },
            { "fo", "\u1016\u102c\u101b\u102d\u102f" },
            { "umb", "\u1021\u1030\u1018\u1014\u103a\u1012\u1030" },
            { "fr", metaValue_FR },
            { "fy", "\u1021\u1014\u1031\u102c\u1000\u103a \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "ga", "\u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a\u101b\u103e\u103a" },
            { "gd", "\u1005\u1000\u1031\u102c\u1037\u1010\u1005\u103a\u101b\u103e\u103a \u1002\u1031\u1038\u101c\u1005\u103a\u1001\u103a" },
            { "gl", "\u1002\u102b\u101c\u102e\u1005\u102e\u101a\u102c" },
            { "gn", "\u1002\u1030\u1021\u102c\u101b\u102c\u1014\u102e" },
            { "bho", "\u1018\u102d\u102f\u1037\u1002\u103b\u103a\u1015\u1030\u101b\u102e" },
            { "und", "\u1019\u101e\u102d\u101e\u1031\u102c \u1018\u102c\u101e\u102c" },
            { "gu", "\u1002\u1030\u1002\u103b\u102c\u101b\u101e\u102e" },
            { "gv", "\u1019\u1014\u103a\u1038\u1007\u103a" },
            { "ha", "\u101f\u102c\u1025\u1005\u102c" },
            { "he", "\u101f\u102e\u1038\u1018\u101b\u1030\u1038" },
            { "hi", "\u101f\u102d\u1014\u1039\u1012\u1030" },
            { "hup", "\u101f\u1030\u1015\u102b" },
            { "bin", "\u1018\u102e\u1014\u102e" },
            { "hr", metaValue_HR },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "\u101f\u102e\u101b\u1032\u101b\u102d\u102f" },
            { "%%FONIPA", "IPA \u1021\u101e\u1036\u1011\u103d\u1000\u103a" },
            { "ia", "\u1021\u1004\u103a\u1010\u102c\u101c\u1004\u103a\u1002\u103d\u102b" },
            { "Jamo", "\u1002\u103b\u1019\u102d\u102f" },
            { "id", metaValue_ID },
            { "type.nu.tibt", "\u1010\u102d\u1018\u1000\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ig", "\u1021\u1005\u1039\u1002\u1018\u102d\u102f" },
            { "ii", "\u1005\u102e\u1001\u103b\u103d\u1019\u103a \u101b\u102e" },
            { "frm", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1015\u103c\u1004\u103a\u101e\u1005\u103a" },
            { "fro", "\u1016\u101b\u1014\u103a\u1005\u102e\u1005\u103a" },
            { "io", "\u1021\u102e\u1012\u102d\u102f" },
            { "frs", "\u1021\u101b\u103e\u1031\u1037 \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "frr", "\u1019\u103c\u1031\u102c\u1000\u103a \u1016\u101b\u102e\u1005\u102e\u101b\u1014\u103a" },
            { "is", "\u1021\u102d\u102f\u1000\u103a\u1005\u103a\u101c\u1014\u103a" },
            { "it", metaValue_IT },
            { "iu", "\u1021\u102e\u1014\u102f\u1001\u103a\u1010\u102e\u1010\u102f" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "sma", "\u1010\u1031\u102c\u1004\u103a \u1006\u102c\u1019\u102d" },
            { "jv", "\u1002\u103b\u102c\u1017\u102c\u1038" },
            { "mad", "\u1019\u1012\u1030\u101b\u102c" },
            { "smj", "\u101c\u1030\u101c\u102e \u1006\u102c\u1019\u102d" },
            { "mag", "\u1019\u1002\u102b\u101f\u102e" },
            { "mai", "\u1019\u102d\u102f\u1004\u103a\u101e\u102e\u101c\u102e" },
            { "smn", "\u1021\u102e\u1014\u102c\u101b\u102e \u1006\u102c\u1019\u102d" },
            { "ka", metaValue_GE },
            { "bla", "\u1005\u1005\u1039\u1005\u102e\u1000\u102c" },
            { "mak", "\u1019\u1000\u102c\u1006\u102c" },
            { "sms", "\u1005\u1001\u102d\u102f\u1038\u101c\u103a \u1006\u1019\u103a\u1019\u102e" },
            { "kg", metaValue_CD },
            { "ki", "\u1000\u102e\u1000\u1030\u101a\u1030" },
            { "mas", "\u1019\u102c\u1006\u102d\u102f\u1004\u103a" },
            { "kj", "\u1000\u103d\u1014\u103a\u1038\u101a\u102c\u1019\u102c" },
            { "kk", "\u1000\u102c\u1007\u102c\u1001\u103a" },
            { "kl", "\u1000\u101c\u102c\u1021\u103a\u101c\u102e\u1006\u1015\u103a" },
            { "km", metaValue_km },
            { "kn", "\u1000\u1014\u1039\u1014\u102c\u1012\u102b" },
            { "ko", metaValue_ko },
            { "kr", "\u1000\u1014\u1030\u101b\u102e" },
            { "ks", "\u1000\u1000\u103a\u101b\u103e\u103a\u1019\u102e\u1038\u101a\u102c\u1038" },
            { "ku", "\u1000\u1012\u103a" },
            { "kv", "\u1000\u102d\u102f\u1019\u102e" },
            { "kw", "\u1001\u102d\u102f\u1014\u102e\u101b\u103e\u103a" },
            { "ky", "\u1000\u102c\u1002\u103b\u1005\u103a" },
            { "snk", "\u1006\u102d\u102f\u1014\u1004\u103a\u1000\u1031\u1038" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "type.nu.mlym", "\u1019\u101c\u1031\u101a\u102c\u101c\u1019\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "lg", "\u1002\u1014\u103a\u1012\u102b" },
            { "li", "\u101c\u1004\u103a\u1018\u102c\u1002\u1005\u103a\u101b\u103e\u103a" },
            { "Tibt", metaValue_bo },
            { "ln", "\u101c\u1004\u103a\u1002\u102b\u101c\u102c" },
            { "fur", "\u1016\u101b\u1030\u101c\u102e\u101a\u1014\u103a\u1038" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u1005\u1014\u1005\u103a" },
            { "lt", "\u101c\u1005\u103a\u101e\u1030\u101d\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "lu", "\u101c\u1030\u1018\u102c-\u1000\u1010\u1014\u103a\u1002\u102b" },
            { "lv", metaValue_LV },
            { "ListCompositionPattern", metaValue_ListKeyTypePattern },
            { "mg", "\u1019\u102c\u101c\u1002\u1000\u103a\u1005\u102e" },
            { "mh", "\u1019\u102c\u101b\u103e\u101a\u103a\u101c\u102d\u1007\u103a" },
            { "type.co.ducet", "\u1021\u1005\u1009\u103a\u101c\u102d\u102f\u1000\u103a\u1005\u102e\u1011\u102c\u1038\u101e\u1031\u102c \u101a\u1030\u1014\u102e\u1000\u102f\u1010\u103a" },
            { "mi", "\u1019\u102c\u1021\u102d\u102f\u101b\u102e" },
            { "mk", metaValue_MK },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u1019\u102c\u101b\u101e\u102e" },
            { "ms", "\u1019\u101c\u1031\u1038" },
            { "mt", "\u1019\u1031\u102c\u103a\u101c\u103a\u1010\u102c" },
            { "my", metaValue_MM },
            { "Armn", metaValue_AM },
            { "mdf", "\u1019\u102d\u102f\u1037\u1001\u103a\u101b\u103e\u102c" },
            { "dsb", "\u1021\u1014\u102d\u1019\u1037\u103a \u1006\u102d\u102f\u1018\u102e\u101a\u1014\u103a\u1038" },
            { "na", metaValue_NR },
            { "type.co.search", "\u101a\u1031\u1018\u102f\u101a\u103b\u101b\u103e\u102c\u1001\u103c\u1004\u103a\u1038" },
            { "nb", "\u1014\u1031\u102c\u103a\u101d\u1031 \u1018\u103d\u1010\u103a\u1001\u103a\u1019\u1031\u102c\u103a\u101c\u103a" },
            { "nd", "\u1019\u103c\u1031\u102c\u1000\u103a \u1021\u103d\u1014\u103a\u1014\u103a\u1012\u102e\u1018\u102e\u101c\u102e" },
            { "ne", metaValue_NP },
            { "ng", "\u1021\u103d\u1014\u103a\u1012\u103d\u1014\u103a\u1002\u102b" },
            { "nl", "\u1012\u1010\u103a\u1001\u103a\u103b" },
            { "nn", "\u1014\u1031\u102c\u103a\u101d\u1031 \u1014\u102e\u1038\u1014\u1031\u102c\u1005\u103a" },
            { "no", "\u1014\u1031\u102c\u103a\u101d\u1031\u1038" },
            { "nr", "\u1010\u1031\u102c\u1004\u103a \u1021\u103d\u1014\u103a\u1014\u103a\u1018\u102e\u101c\u102e" },
            { "nv", "\u1014\u102c\u1017\u102c\u101f\u102d\u102f" },
            { "ny", "\u1014\u101b\u1014\u103a\u1002\u103b\u102c" },
            { "kac", "\u1000\u1001\u103b\u1004\u103a" },
            { "kab", "\u1000\u1018\u102d\u102f\u1004\u103a\u101c\u103a" },
            { "oc", "\u1021\u102d\u102f\u1005\u102e\u1010\u1014\u103a" },
            { "kaj", "\u1002\u103b\u1030\u1021\u1030" },
            { "kam", "\u1000\u1019\u103a\u1018\u102c" },
            { "men", "\u1019\u1014\u103a\u1012\u1032" },
            { "mer", "\u1019\u102e\u101b\u102f" },
            { "type.nu.armn", "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "om", "\u1021\u102d\u102f\u101b\u102d\u102f\u1019\u102d\u102f" },
            { "or", "\u1021\u102d\u102f\u101b\u102e\u101b\u102c" },
            { "os", "\u1021\u102d\u102f\u1006\u1032\u1010\u1005\u103a\u1001\u103a" },
            { "kbd", "\u1000\u1018\u102c\u1012\u1004\u103a" },
            { "mfe", metaValue_MU },
            { "srn", "\u1006\u101b\u102c\u1014\u1014\u103a \u1010\u103d\u1014\u103a\u1002\u102d\u102f" },
            { "pa", "\u1015\u1014\u103a\u1001\u103b\u102c\u1015\u102e" },
            { "dua", "\u1012\u1030\u1021\u101c\u102c" },
            { "pi", "\u1015\u102b\u1020\u102d" },
            { "pl", metaValue_PL },
            { "dum", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1012\u1010\u103a\u1001\u103b\u103a" },
            { "type.ca.dangi", "\u1012\u1014\u103a\u1038\u1002\u102d \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "ps", "\u1015\u1000\u103a\u101b\u103e\u103a\u1010\u103d\u1014\u103a\u1038" },
            { "pt", metaValue_PT },
            { "mga", "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102d\u102f\u1004\u103a\u1038\u101b\u1005\u103a\u101b\u103e\u103a" },
            { "key.co", "\u1021\u1005\u1009\u103a\u101c\u102d\u102f\u1000\u103a\u1005\u102e\u101b\u1014\u103a" },
            { "pt_BR", "\u1018\u101b\u102c\u1007\u102e\u1038 \u1015\u1031\u102b\u103a\u1010\u1030\u1002\u102e" },
            { "kcg", "\u1010\u102d\u102f\u1004\u103a\u1021\u1015\u103a" },
            { "mgh", "\u1019\u102c\u1001\u1030\u101d\u102b-\u1019\u102e\u1021\u102e\u1010\u102d\u102f" },
            { "key.cf", "\u1004\u103d\u1031\u101b\u1031\u1010\u103d\u1000\u103a\u1015\u102f\u1036\u1005\u1014\u1005\u103a" },
            { "key.ca", "\u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "Laoo", metaValue_LA },
            { "mgo", "\u1019\u102e\u1010\u102c" },
            { "type.hc.h23", "\u1042\u1044 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a (\u1040\u2013\u1042\u1043)" },
            { "type.hc.h24", "\u1042\u1044 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a(\u1041\u2013\u1042\u1044)" },
            { "ssy", "\u1006\u102c\u101f\u102d\u102f" },
            { "type.nu.mymr", "\u1019\u103c\u1014\u103a\u1019\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "qu", "\u1001\u102e\u1001\u103b\u1030\u101d\u102b\u1021\u102d\u102f\u101d\u102b" },
            { "brx", "\u1017\u102d\u102f\u1012\u102d\u102f" },
            { "kde", "\u1019\u102c\u1001\u103d\u1014\u103a\u1012\u102e" },
            { "Ethi", metaValue_ET },
            { "type.hc.h12", "\u1041\u1042 \u1014\u102c\u101b\u102e\u1005\u1014\u1005\u103a (\u1041\u2013\u1041\u1042)" },
            { "type.hc.h11", "\u1041\u1042 \u1014\u102c\u101b\u102e \u1005\u1014\u1005\u103a (\u1040\u2013\u1041\u1041)" },
            { "rm", "\u101b\u1031\u102c\u1019" },
            { "rn", "\u101b\u103d\u1014\u103a\u1012\u102e" },
            { "key.cu", "\u1004\u103d\u1031\u1000\u103c\u1031\u1038" },
            { "ro", "\u101b\u102d\u102f\u1019\u1031\u1014\u102e\u101a\u102c\u1038" },
            { "type.nu.orya", "\u1029\u101b\u102e\u101b\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hanidec", "\u1010\u101b\u102f\u1010\u103a \u1006\u101a\u103a\u101c\u102e\u1005\u1014\u1005\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ru", "\u101b\u102f\u101b\u103e" },
            { "rw", "\u1000\u1004\u103a\u101b\u102c\u101d\u1014\u103a\u1012\u102b" },
            { "kea", "\u1000\u1018\u1030\u1017\u102c\u1012\u102e\u1021\u102c\u1014\u1030" },
            { "mic", "\u1019\u1005\u103a\u1001\u103a\u1019\u1000\u103a\u1001\u103a" },
            { "suk", "\u1006\u1030\u1000\u1030\u1019\u102c" },
            { "en_AU", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "sa", "\u101e\u1004\u103a\u1039\u101e\u1000\u101b\u102d\u102f\u1000\u103a" },
            { "sc", "\u1006\u102c\u1012\u102e\u1014\u102e\u1038\u101a\u102c\u1038" },
            { "sd", "\u1005\u1004\u103a\u1012\u102e" },
            { "se", "\u1019\u103c\u1031\u102c\u1000\u103a \u1006\u102c\u1019\u102d" },
            { "min", "\u1005\u1030\u1000\u1030\u1019\u102e\u1014\u1014\u103a" },
            { "sg", "\u1006\u1014\u103a\u1002\u102d\u102f" },
            { "si", "\u1005\u1004\u103a\u101f\u102c\u101c\u102c" },
            { "sk", "\u1006\u101c\u102d\u102f\u1017\u1000\u103a" },
            { "sl", metaValue_SI },
            { "sm", "\u1006\u1019\u102d\u102f\u1021\u102c" },
            { "sn", "\u101b\u103e\u102d\u102f\u1014\u102c" },
            { "so", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e" },
            { "type.nu.arab", "\u1021\u102c\u101b\u1015\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ListKeyTypePattern", metaValue_ListKeyTypePattern },
            { "ss", metaValue_SZ },
            { "type.cf.account", "\u1005\u102c\u101b\u1004\u103a\u1038\u1000\u102d\u102f\u1004\u103a\u101e\u102f\u1036\u1038 \u1004\u103d\u1031\u101b\u1031\u1010\u103d\u1000\u103a\u1015\u102f\u1036\u1005\u1014\u1005\u103a" },
            { "st", "\u1010\u1031\u102c\u1004\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1006\u102d\u102f\u101e\u102d\u102f" },
            { "Java", "\u1002\u103b\u102c\u1017\u102c\u1038\u1014\u102e\u1038\u1005\u103a" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "sw", "\u1006\u103d\u102c\u101f\u102e\u101c\u102e" },
            { "type.nu.hantfin", "\u101b\u102d\u102f\u1038\u101b\u102c \u1010\u101b\u102f\u1010\u103a \u1018\u100f\u1039\u100d\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ibb", "\u1021\u102e\u1018\u102e\u1018\u102e\u101a\u102d\u102f" },
            { "iba", "\u1021\u102e\u1017\u1014\u103a" },
            { "ta", metaValue_ta },
            { "142", "\u1021\u102c\u101b\u103e" },
            { "143", "\u1021\u101c\u101a\u103a\u1021\u102c\u101b\u103e" },
            { "te", "\u1010\u102e\u101c\u102e\u1002\u1030" },
            { "145", "\u1021\u1014\u1031\u102c\u1000\u103a\u1021\u102c\u101b\u103e" },
            { "tg", "\u1010\u102c\u1002\u103b\u1005\u103a" },
            { "th", metaValue_TH },
            { "ti", "\u1010\u102e\u1002\u103a\u101b\u1004\u103a\u101a\u102c" },
            { "bug", "\u1018\u1030\u1002\u1005\u103a\u1005\u103a" },
            { "kfo", "\u1000\u102d\u102f\u101b\u102d\u102f" },
            { "en_CA", "\u1000\u1014\u1031\u1012\u102b \u1021\u1004\u103a\u1039\u1002\u101c\u102d\u1015\u103a" },
            { "tk", metaValue_TM },
            { "tn", "\u1010\u102e\u1006\u101d\u102b\u1014\u102c" },
            { "to", metaValue_TO },
            { "dyo", "\u1002\u103b\u102d\u102f\u101c\u102c-\u1016\u103d\u1014\u103a\u101b\u102e" },
            { "type.nu.jpan", "\u1002\u103b\u1015\u1014\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "tr", metaValue_TR },
            { "ts", "\u1006\u103d\u1014\u103a\u1002\u102b" },
            { "swb", "\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102e\u1038\u101a\u1014\u103a\u1038" },
            { "tt", "\u1010\u102c\u1010\u102c" },
            { "ty", "\u1010\u101f\u102e\u1010\u102e" },
            { "150", "\u1025\u101b\u1031\u102c\u1015" },
            { "151", "\u1021\u101b\u103e\u1031\u1037 \u1025\u101b\u1031\u102c\u1015" },
            { "154", "\u1019\u103c\u1031\u102c\u1000\u103a \u1025\u101b\u1031\u102c\u1015" },
            { "dzg", "\u1012\u1007\u102c\u1002\u102b" },
            { "155", "\u1021\u1014\u1031\u102c\u1000\u103a \u1025\u101b\u1031\u102c\u1015" },
            { "ug", "\u101d\u102e\u1002\u102b" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u1021\u1019\u103b\u102c\u1038\u1014\u103e\u1004\u1037\u103a\u101e\u1000\u103a\u1006\u102d\u102f\u1004\u103a\u101e\u1031\u102c" },
            { "uk", metaValue_UA },
            { "ur", "\u1021\u1030\u101b\u103a\u1012\u1030" },
            { "xal", "\u1000\u102c\u101c\u103a\u1019\u102d\u102f\u1000\u103a" },
            { "uz", "\u1025\u1007\u1018\u1010\u103a" },
            { "kha", "\u1001\u102b\u1005\u102e" },
            { "%%1996", "\u1041\u1049\u1049\u1046 \u1002\u103b\u102c\u1019\u1014\u103a \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "nds_NL", "\u1002\u103b\u102c\u1019\u1014\u103a (\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a)" },
            { "ve", "\u1017\u1004\u103a\u1014\u103a\u1012\u102b" },
            { "type.ca.roc", "\u1019\u1004\u103a\u1002\u102f\u1021\u102d\u102f \u1015\u103c\u1000\u1039\u1001\u1012\u102d\u1014\u103a" },
            { "vi", metaValue_VN },
            { "khq", "\u1000\u102d\u102f\u101b\u102c \u1001\u103b\u102e\u1021\u102e\u1014\u102e" },
            { "key.hc", "\u1014\u102c\u101b\u102e\u1005\u1000\u103a\u101d\u1014\u103a\u1038 (\u1041\u1042 \u1014\u103e\u1004\u1037\u103a \u1042\u1044)" },
            { "vo", "\u1017\u102d\u102f\u101c\u102c\u1015\u102d\u102f\u1000\u103a" },
            { "quc", "\u1000\u102e\u1001\u103a\u1021\u102e\u1001\u103b\u102e" },
            { "gaa", "\u1002\u102b" },
            { "wa", "\u101d\u102b\u101c\u1030\u1038\u1014\u103a" },
            { "gag", "\u1002\u102b\u1002\u102f\u1007\u103a" },
            { "syr", metaValue_SY },
            { "Grek", metaValue_GR },
            { "wo", "\u101d\u1030\u101c\u102d\u102f\u1016\u103a" },
            { "zgh", "\u1019\u102d\u102f\u101b\u102d\u102f\u1000\u102d\u102f \u1010\u1019\u1007\u102d\u102f\u1000\u103a" },
            { "Mong", metaValue_mn },
            { "mnc", "\u1019\u1014\u103a\u1001\u103b\u1030\u1038" },
            { "mni", "\u1019\u1014\u102d\u1015\u1030\u101b" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u101b\u102d\u102f\u1038\u101b\u103e\u1004\u103a\u1038 \u1010\u101b\u102f\u1010\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "type.nu.hant", "\u101b\u102d\u102f\u1038\u101b\u102c \u1010\u101b\u102f\u1010\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "xh", "\u1007\u102d\u102f\u1005\u102c" },
            { "type.nu.romanlow", "\u101b\u1031\u102c\u1019 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031 \u1005\u102c\u101c\u102f\u1036\u1038\u101e\u1031\u1038" },
            { "byn", "\u1018\u101c\u1004\u103a" },
            { "moh", "\u1019\u102d\u102f\u101f\u1031\u102c\u1037\u1001\u103a" },
            { "kkj", "\u1000\u1000\u102d\u102f" },
            { "%%1694ACAD", "\u1041\u1046\u1049\u1044ACAD" },
            { "yi", "\u1002\u103b\u1030\u1038" },
            { "mos", "\u1019\u102d\u102f\u1005\u102e" },
            { "yo", "\u101a\u102d\u102f\u101b\u1030\u1018\u102c" },
            { "vai", "\u1017\u102d\u102f\u1004\u103a" },
            { "kln", "\u1000\u101c\u1014\u103a\u1002\u103b\u1004\u103a" },
            { "zh", metaValue_CN },
            { "Bopo", "\u1018\u102d\u102f\u1015\u102d\u102f" },
            { "key.lb", "\u1005\u102c\u1015\u102d\u102f\u1012\u103a\u1001\u103d\u1032\u1015\u102f\u1036\u1005\u1036" },
            { "zu", "\u1007\u1030\u1038\u101c\u1030\u1038" },
            { "type.co.phonebook", "\u1016\u102f\u1014\u103a\u1038\u1005\u102c\u1021\u102f\u1015\u103a \u1021\u1005\u102e\u1021\u1005\u1009\u103a" },
            { "Geor", metaValue_GE },
            { "kmb", "\u1000\u1004\u103a\u1018\u103d\u1014\u103a\u1012\u1030" },
            { "type.nu.jpanfin", "\u1002\u103b\u1015\u1014\u103a \u1018\u100f\u1039\u100d\u102c\u101b\u1031\u1038\u101e\u102f\u1036\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "gez", "\u1002\u102e\u1038\u1007\u103a" },
            { "type.nu.mymrshan", "\u101b\u103e\u1019\u103a\u1038 \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "Tglg", "\u1010\u1002\u101c\u1031\u102c\u1037\u1002\u103a" },
            { "ebu", "\u1021\u1019\u103a\u1018\u1030" },
            { "koi", "\u1000\u102d\u102f\u1019\u102e-\u1015\u102b\u1019\u103c\u1000\u103a" },
            { "kok", "\u1000\u103d\u1014\u103a\u1000\u1014\u102e" },
            { "%%1901", "\u101b\u103e\u1031\u1038\u101b\u102d\u102f\u1038\u1005\u1009\u103a\u101c\u102c \u1002\u103b\u102c\u1019\u1014\u103a \u101b\u1031\u1038\u1011\u102f\u1036\u1038" },
            { "kpe", "\u1000\u1015\u103a\u1015\u1032\u101c\u103a" },
            { "type.nu.khmr", "\u1001\u1019\u102c \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "ilo", "\u1021\u102e\u101c\u102d\u102f\u1000\u102d\u102f" },
            { "%%BAKU1926", "\u1015\u1031\u102b\u1004\u103a\u1038\u1005\u1015\u103a\u1011\u102c\u1038\u101e\u1031\u102c \u1010\u1030\u101b\u1000\u102e \u101c\u1000\u103a\u1010\u1004\u103a\u1005\u1000\u102c\u1038\u101c\u102f\u1036\u1038" },
            { "mua", "\u1019\u103d\u1014\u103a\u1012\u1014\u103a\u1038" },
            { "type.nu.guru", "\u1002\u1030\u1019\u1030\u1001\u102e \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "mul", "\u1018\u102c\u101e\u102c\u1005\u1000\u102c\u1038 \u1021\u1019\u103b\u102d\u102f\u1038\u1019\u103b\u102d\u102f\u1038" },
            { "key.ms", "\u1010\u102d\u102f\u1004\u103a\u1038\u1010\u102c\u101b\u1031\u1038\u1005\u1014\u1005\u103a" },
            { "mus", "\u1001\u101b\u102d\u1001\u103a" },
            { "gil", "\u1000\u102c\u101b\u102e\u1017\u102c\u1010\u102e" },
            { "type.nu.tamldec", "\u1010\u1019\u102e\u1038\u101c\u103a \u1002\u100f\u1014\u103a\u1038\u1001\u103c\u1031" },
            { "krc", "\u1000\u101b\u102c\u1001\u103b\u1031\u1038-\u1018\u102c\u1000\u102c" },
            { "inh", "\u1021\u1004\u103a\u1002\u102f\u101b\u103e\u103a" },
            { "krl", "\u1000\u102c\u101b\u102e\u101c\u102e\u101a\u1014\u103a" },
            { "efi", "\u1021\u102c\u1016\u102d\u1001\u103a" },
            { "key.nu", "\u1000\u102d\u1014\u103a\u1038\u1002\u100f\u1014\u103a\u1038" },
            { "kru", "\u1000\u1030\u101b\u102f\u1015\u103a\u1001\u103a" },
            { "ksb", "\u101b\u103e\u1014\u103a\u1018\u102c\u101c\u102c" },
            { "Telu", "\u1010\u102e\u101c\u102f" },
            { "ksf", "\u1018\u102c\u1016\u102e\u1021\u102c" },
        };
        return data;
    }
}
