#ifndef _ARGS_H
#define _ARGS_H

#include "cdstatus.h"

/** enum of different encoder backends
 *
 * this enum defines the set of possible encoders to use (including none)
 */
typedef enum _Encoders { ENC_NULL, ENC_RAW, ENC_WAVE, ENC_LAME, ENC_TOOLAME, ENC_OGGENC } Encoders;

/** structure to hold all relevant program options
 *
 *  These hold all the settings that cdstatus cares about during its operation.
 *  Some of them are flags on/off, others are strings/integers set and used. 
 */
typedef struct
{
   /** Whether or not to actually do extraction, on/off */
    int readtest;
   /** Maximum number of read retries to attempt */
    int max_retries;
   /** First track to start extracting from */
    int start;
   /** Final track to stop at */
    int stop;
   /** Whether we are performing an internal optical drive reset, this is an exclusive option. */
    int reset;
   /** How many data "chunks" to read in a single read ioctl() */
    int read_chunk_size;
   /** Whether or not to use cddb lookup, on/off */
    int cddb;
   /** Whether or not we are using a custom file naming format to go with cddb */
    int format_on;
   /** custom file naming format for use with cddb info */
    char format[4096];
   /** directory to place output files (base, may have other directories apended based on format value) */
    char outputdir[CDSTATUS_PATH_MAX];
   /** base track name when not using cddb */
    char basename[CDSTATUS_NAME_MAX];
   /** filesystem path to optical drive (/dev/cdrom) */
    char drivename[CDSTATUS_PATH_MAX];
   /** This is set if we do NOT want to modify returned cddb info in order to be "friendlier" to the filesystem */
    int noMangle;
   /** Whether or not to operate "quietly" */
    int silent;
   /** Whether to automatically accept first of multiple cddb entries that match (on/off) */
    unsigned int default_first_match;
   /** IP/hostname of cddb server to use */
    char cddb_site[CDSTATUS_HOST_NAME_MAX];
    /** which output engine to pass to */
    Encoders encoder;
    /** Options to pass to the encoder, after any options required for the basic encode (where to read input, etc) */
    char encopts[512];
	/** How many times to re-read successfully read data while checking for
	 * consistently matching values */
	unsigned int identical_reads;
	/** How many times at most to attempt to obtain 'identical_reads'
	 * identical read sets, after starting back at 0. */
	unsigned int max_read_sets;
} cdstatus_args;

#endif
