#include "gimme_config_h.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "cddb_fetch_and_parse_results.h"
#include "cdstatus_cddb.h"
#include "cddb_hearken.h"
#include "cddb_send.h"
#include "cdstatus_output.h"

int fetchAndParseResults(void *buffer, char *category, unsigned int *discid, int client_sock)
{
	char *token;
	char *token2;
	unsigned int index;
	int result;

	(void)snprintf((char *) buffer, BUFFSIZE-1, "cddb read %s %08x\n", category, *discid);
	cddb_send(client_sock, buffer);
	result = hearken(client_sock, buffer);
	switch (result)
	{
	case 401:
	   	conditional_puts(WARNING, "The server reports that the entry does not exist, despite having just listed it.  Please try a different server.");
	   	return 0;
	case 402:
		conditional_puts(WARNING, "General server error.  Please try a different server.");
	   	return 0;
	case 403:
	   	conditional_puts(WARNING, "The server reports that this database entry is corrupted.  Please try a different server.");
	   	return 0;
	case 409:
	   	conditional_puts(WARNING, "The server indicates that the client has not established a proper server connection, despite having done so.  Please try a different server.");
	   	return 0;
	case 210:
		break;
	default:
	   	conditional_puts(CRITICAL, "The server has returned an error code that does not comply with the published cddb protocol."
			" Please try a different server.");
		return 0;
	}

	/* parse and handle the returned information */
	/* discard the already used status line */
	token = strtok((char *) buffer, "\n");
	token = strtok(NULL, "\n");
	while (token != NULL)
	{
		if (token[0] == '#')
		{
			token = strtok(NULL, "\n");
			continue;
		}
		else if (token[0] == '.')
		{
			break;
		}

		conditional_printf(DEBUG, "Lineitem: %s\n", token);

		/* actual handling of data lines */
		if (strncmp(token, "DTITLE=", 7)==0)
		{

			/* artist and album names */
			token2 = strchr(token, '/');
			if(token2==NULL)
			{
				conditional_puts(WARNING, "Invalid server response or error in parsing, fudging artist and album names to 'unknown'.");
				strcpy(artist_name,"unknown");
                strcpy(album_name,"unknown");
			}
            else
            {
			    --token2;
    			strncpy(artist_name, token + 7, (size_t)(token2 - (token + 7)));
                conditional_printf(DEBUG, "Artist name: %s\n",artist_name);
    			token2 += 3;
    			strncpy(album_name, token2, strlen(token2) - 1);
    			if (strchr(album_name, '\n') != NULL)
    			{
    				*strchr(album_name, '\n') = '\0';
    			}
                conditional_printf(DEBUG, "Album name: %s\n",album_name);
    		}
        }

		else if (strncmp(token, "DYEAR=",6)==0)
		{
			/* Album year */
			if(sscanf(token+6,"%d",&album_year)!=1)
			{
				conditional_puts(WARNING, "Error parsing album_year string (invalid server response).  Fudging to 0.");
                album_year=0;
			}
		}

		else if(strncmp(token, "DGENRE=",7)==0)
		{
			memset(album_genre,'\0', 127);
			strncpy(album_genre,token+7,128);
            while((album_genre[strlen(album_genre)-1]=='\r') || (album_genre[strlen(album_genre)-1]=='\n'))
            {
                album_genre[strlen(album_genre)-1]='\0';
            }
		}

		else if (strncmp(token, "TTITLE", 6)==0)
		{

			/* track listing data */
			++cddb_tracks;
			if(sscanf(token, "TTITLE%u=", &index)!=1)
			{
				conditional_puts(WARNING, "Invalid server response or parsing error, fudging track title to 'unknown'.");
				strcpy(trackinfo[index].title, "unknown");
			}
            else
            {
    			++index;
    			if (strchr(token, '/') == NULL)
    			{
    				strncpy(trackinfo[index].title, strchr(token, '=') + 1, strlen(strchr(token, '=') + 1) - 1);
    				conditional_printf(VERBOSE_DEBUG, "Track %d: %s\n",index,trackinfo[index].title);
    			}
    			else
    			{
    				token2 = strchr(token, '/');
    				--token2;
    				strncpy(trackinfo[index].artist, strchr(token, '=') + 1, (size_t)(token2 - (strchr(token, '=') + 1)));
    				token2 += 3;
    				strncpy(trackinfo[index].title, token2, strlen(token2) - 1);
    
    				conditional_printf(VERBOSE_DEBUG, "Track %d: %s by %s",index,trackinfo[index].title, \
    				   trackinfo[index].artist);
    				(void)fflush(stdout);
    			}
            }
		}
		token = strtok(NULL, "\n");
	}
	strcpy((char *) buffer, "QUIT\n");
	cddb_send(client_sock, buffer);
	(void)close(client_sock);
	return 1;
}
