/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract the first string in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * idx - an integer expression that representing the group index. The regex maybe contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\u0010 \u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011!\u0011\u0005A!f\u0001\n\u0003Y\u0004\u0002C\"\u0001\u0005#\u0005\u000b\u0011\u0002\u001f\t\u000b\u0011\u0003A\u0011A#\t\u000b\u0011\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000ba\u0003A\u0011I-\t\u000b\u0001\u0004A\u0011I1\t\u000b5\u0004A\u0011\u000b8\t\u000fq\u0004\u0011\u0011!C\u0001{\"I\u00111\u0001\u0001\u0012\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003\u000bA\u0011\"!\b\u0001#\u0003%\t!!\u0002\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005\u0002\"CA\u0019\u0001\u0005\u0005I\u0011AA\u001a\u0011%\tY\u0004AA\u0001\n\u0003\ti\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0011\u0002F!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003C:\u0011\"!\" \u0003\u0003E\t!a\"\u0007\u0011yy\u0012\u0011!E\u0001\u0003\u0013Ca\u0001\u0012\r\u0005\u0002\u0005]\u0005\"CAM1\u0005\u0005IQIAN\u0011%\ti\nGA\u0001\n\u0003\u000by\nC\u0005\u0002(b\t\t\u0011\"!\u0002*\"I\u00111\u0018\r\u0002\u0002\u0013%\u0011Q\u0018\u0002\u000e%\u0016<W\t\u001f9FqR\u0014\u0018m\u0019;\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00172oA\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0012%\u0016<W\t\u001f9FqR\u0014\u0018m\u0019;CCN,\u0007C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$a\u0002)s_\u0012,8\r\u001e\t\u0003eaJ!!O\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000fM,(M[3diV\tA\b\u0005\u0002/{%\u0011ah\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:vE*,7\r\u001e\u0011\u0002\rI,w-\u001a=q\u0003\u001d\u0011XmZ3ya\u0002\n1!\u001b3y\u0003\u0011IG\r\u001f\u0011\u0002\rqJg.\u001b;?)\u00111u\tS%\u0011\u00059\u0002\u0001\"\u0002\u001e\b\u0001\u0004a\u0004\"\u0002!\b\u0001\u0004a\u0004\"\u0002\"\b\u0001\u0004aDc\u0001$L\u001b\")A\n\u0003a\u0001y\u0005\t1\u000fC\u0003O\u0011\u0001\u0007A(A\u0001s\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\tF+V,\u0011\u0005I\u0012\u0016BA*4\u0005\r\te.\u001f\u0005\u0006\u0019&\u0001\r!\u0015\u0005\u0006-&\u0001\r!U\u0001\u0002a\")a*\u0003a\u0001#\u0006AA-\u0019;b)f\u0004X-F\u0001[!\tYf,D\u0001]\u0015\ti6%A\u0003usB,7/\u0003\u0002`9\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0019\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015\u001cT\"\u00014\u000b\u0005\u001d\\\u0013A\u0002\u001fs_>$h(\u0003\u0002jg\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI7'A\u0005e_\u001e+gnQ8eKR\u0019q.\u001e>\u0011\u0005A\u001cX\"A9\u000b\u0005I|\u0012aB2pI\u0016<WM\\\u0005\u0003iF\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006m2\u0001\ra^\u0001\u0004GRD\bC\u00019y\u0013\tI\u0018O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bmd\u0001\u0019A8\u0002\u0005\u00154\u0018\u0001B2paf$RA\u0012@\u0000\u0003\u0003AqAO\u0007\u0011\u0002\u0003\u0007A\bC\u0004A\u001bA\u0005\t\u0019\u0001\u001f\t\u000f\tk\u0001\u0013!a\u0001y\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0004U\ra\u0014\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011QC\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0005Y\u0006twM\u0003\u0002\u0002.\u0005!!.\u0019<b\u0013\rY\u0017qE\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003k\u00012AMA\u001c\u0013\r\tId\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004#\u0006}\u0002\"CA!'\u0005\u0005\t\u0019AA\u001b\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\t\t\u0006\u0003\u0013\ny%U\u0007\u0003\u0003\u0017R1!!\u00144\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\nYE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA,\u0003;\u00022AMA-\u0013\r\tYf\r\u0002\b\u0005>|G.Z1o\u0011!\t\t%FA\u0001\u0002\u0004\t\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002X\u0005\r\u0004\u0002CA!-\u0005\u0005\t\u0019A))'\u0001\t9'!\u001c\u0002p\u0005M\u0014QOA=\u0003w\ny(!!\u0011\u00079\nI'C\u0002\u0002l}\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002r\u0005\tYD\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!e\u0016<W\r\u001f9\\Y\u0001JG\r_/*A5\u0002S\t\u001f;sC\u000e$\b\u0005\u001e5fA\u0019L'o\u001d;!gR\u0014\u0018N\\4!S:\u0004C\u000f[3!AN$(\u000f\u0019\u0011uQ\u0006$\b%\\1uG\"\u0004C\u000f[3!AJ,w-\u001a=qA*\u0001\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u0004\u0013M\u001c3!G>\u0014(/Z:q_:$\u0017N\\4!i>\u0004C\u000f[3!e\u0016<W\r\u001f\u0011he>,\b\u000fI5oI\u0016DhF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002x\u0005AYK\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016<W\r\u001f9![\u0001\n\u0007e\u001d;sS:<\u0007E]3qe\u0016\u001cXM\u001c;j]\u001e\u0004\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t\u0003\u0005\u00165fAI,w-\u001a=!gR\u0014\u0018N\\4!g\"|W\u000f\u001c3!E\u0016\u0004\u0013M\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A)\u000bg/\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tgF\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!Q%t7\r\\;eS:<\u0007E]3hKb\u0004\u0003/\u0019;uKJt7/\u000b\u0011be\u0016\u0004SO\\3tG\u0006\u0004X\r\u001a\u0011j]\u0002zWO\u001d\u0011T#2S\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011qCJ\u001cXM\u001d\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011u_\u0002j\u0017\r^2iA\tb\u0016MY2#Y\u0001\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]\u00022wN\u001d\u0011ae\u0016<W\r\u001f9aA\r\fg\u000e\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\t0]9\u0006\u00147\r\n\u0012/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iKJ,\u0007%[:!C\u0002\u001a\u0016\u000b\u0014\u0011d_:4\u0017n\u001a\u0011(gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cx\u0005\t;iCR\u00043-\u00198!E\u0016\u0004So]3eAQ|'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!M\u0006dGNY1dW\u0002\"x\u000e\t;iK\u0002\u001a\u0006/\u0019:lAErc\u0007\t2fQ\u00064\u0018n\u001c:!e\u0016<\u0017M\u001d3j]\u001e\u00043\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d\u0007\u0005]1sg&twM\f\u0011G_J\u0004S\r_1na2,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%4\u0007\u0005\u001e5fA\r|gNZ5hA%\u001c\b%\u001a8bE2,G\r\f\u0011uQ\u0016\u0004\u0003M]3hKb\u0004\b\r\t;iCR\u00043-\u00198![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0011jg\u0002\u0012c\fX1cG\u0012\u0012cF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011jIb\u0004S\u0006I1oA%tG/Z4fe\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011uQ\u0006$\bE]3qe\u0016\u001cXM\u001c;j]\u001e\u0004C\u000f[3!OJ|W\u000f\u001d\u0011j]\u0012,\u0007P\f\u0011UQ\u0016\u0004#/Z4fq\u0002j\u0017-\u001f2fA\r|g\u000e^1j]NT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011nk2$\u0018\u000e\u001d7fA\u001d\u0014x.\u001e9t]\u0001\u0002\u0017\u000e\u001a=aA%tG-[2bi\u0016\u001c\be\u001e5jG\"\u0004#/Z4fq\u0002:'o\\;qAQ|\u0007%\u001a=ue\u0006\u001cGO\f\u0011UQ\u0016\u0004sM]8va\u0002Jg\u000eZ3yAMDw.\u001e7e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EY3!]>tWF\\3hCRLg/\u001a\u0018!)\",\u0007%\\5oS6,X\u000e\t<bYV,\u0007e\u001c4!A&$\u0007\u0010\u0019\u0011jg\u0002\u0002D\u0006I<iS\u000eD\u0007%\\3b]N\u0004S.\u0019;dQ&tw\r\t;iK\u0002*g\u000e^5sK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t\u0003%\u00134!A&$\u0007\u0010\u0019\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002C\u000f[3!I\u00164\u0017-\u001e7uA\u001d\u0014x.\u001e9!S:$W\r\u001f\u0011wC2,X\rI5tAEr\u0003\u0005\u00165f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005Y5eq\u0002\u0004\u0003/\u0019:b[\u0016$XM\u001d\u0011jg\u0002\"\b.\u001a\u0011KCZ\f\u0007E]3hKb\u0004S*\u0019;dQ\u0016\u0014\be\u001a:pkBD\u0013\u0006I7fi\"|G\rI5oI\u0016DhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA?\u0003IS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00191a5\u0012\u0004\u0007M\u0014-A\u001dBC\f\u00183,S5BC\f\u00183,S\u001db\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0002\u0004G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019)A\u00032]Ur\u0003'A\u0007SK\u001e,\u0005\u0010]#yiJ\f7\r\u001e\t\u0003]a\u0019B\u0001GAFoAA\u0011QRAJyqbd)\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S\u001a\u0002\u000fI,h\u000e^5nK&!\u0011QSAH\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003\u000f\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003G\tQ!\u00199qYf$rARAQ\u0003G\u000b)\u000bC\u0003;7\u0001\u0007A\bC\u0003A7\u0001\u0007A\bC\u0003C7\u0001\u0007A(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0016q\u0017\t\u0006e\u00055\u0016\u0011W\u0005\u0004\u0003_\u001b$AB(qi&|g\u000e\u0005\u00043\u0003gcD\bP\u0005\u0004\u0003k\u001b$A\u0002+va2,7\u0007\u0003\u0005\u0002:r\t\t\u00111\u0001G\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002@B!\u0011QEAa\u0013\u0011\t\u0019-a\n\u0003\r=\u0013'.Z2u\u0001")
public class RegExpExtract
extends RegExpExtractBase
implements scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract regExpExtract) {
        return RegExpExtract$.MODULE$.unapply(regExpExtract);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtract> tupled() {
        return RegExpExtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtract>>> curried() {
        return RegExpExtract$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        UTF8String uTF8String;
        Matcher m = this.getLastMatcher(s, p);
        if (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            uTF8String = group == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group);
        } else {
            uTF8String = UTF8String.EMPTY_UTF8;
        }
        return uTF8String;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(519).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      java.util.regex.Matcher ").append(matcher).append(" =\n        ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n      if (").append(matcher).append(".find()) {\n        java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n        ").append(classNameRegExpExtractBase).append(".checkGroupIndex(").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n        if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n          ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        } else {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append("));\n        }\n        ").append(setEvNotNull).append("\n      } else {\n        ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        ").append(setEvNotNull).append("\n      }").toString());
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

