/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the left with space characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n          hi\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003I\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000bI\u0003A\u0011A*\t\u000bI\u0003A\u0011\u0001-\t\u000bm\u0003A\u0011\t/\t\u000b!\u0004A\u0011I5\t\u000bA\u0004A\u0011I9\t\u000bM\u0004A\u0011\t;\t\u000bm\u0004A\u0011\u000b?\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"a\u0013\u0001#\u0003%\t!!\u000e\t\u0013\u00055\u0003!%A\u0005\u0002\u0005U\u0002\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"a$\u0001\u0003\u0003%\t%!%\b\u0013\u0005=6%!A\t\u0002\u0005Ef\u0001\u0003\u0012$\u0003\u0003E\t!a-\t\rISB\u0011AAa\u0011%\t\u0019MGA\u0001\n\u000b\n)\rC\u0005\u0002Hj\t\t\u0011\"!\u0002J\"I\u0011\u0011\u001b\u000e\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003'T\u0012\u0011!CA\u0003+D\u0011\"a:\u001b#\u0003%\t!!\u000e\t\u0013\u0005%($!A\u0005\n\u0005-(AC*ue&tw\r\u0014)bI*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001cUBt(\u0012\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011d'\u0003\u00028G\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002:y9\u0011!GO\u0005\u0003w\r\nq\u0001]1dW\u0006<W-\u0003\u0002>}\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001e$!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0011$\n\u0005\u001d\u000b%\u0001D*fe&\fG.\u001b>bE2,\u0017aA:ueV\t!\n\u0005\u00023\u0017&\u0011Aj\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:ue\u0002\n1\u0001\\3o\u0003\u0011aWM\u001c\u0011\u0002\u0007A\fG-\u0001\u0003qC\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003U+Z;\u0006C\u0001\u001a\u0001\u0011\u0015Au\u00011\u0001K\u0011\u0015qu\u00011\u0001K\u0011\u001d\u0001v\u0001%AA\u0002)#2\u0001V-[\u0011\u0015A\u0005\u00021\u0001K\u0011\u0015q\u0005\u00021\u0001K\u0003!\u0019\u0007.\u001b7ee\u0016tW#A/\u0011\u0007y+'J\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!mL\u0001\u0007yI|w\u000e\u001e \n\u0003\tK!aO!\n\u0005\u0019<'aA*fc*\u00111(Q\u0001\tI\u0006$\u0018\rV=qKV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002nO\u0005)A/\u001f9fg&\u0011q\u000e\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003I\u00042AX3k\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011)\b0\u001f>\u0011\u0005\u00013\u0018BA<B\u0005\r\te.\u001f\u0005\u0006\u00112\u0001\r!\u001e\u0005\u0006\u001d2\u0001\r!\u001e\u0005\u0006!2\u0001\r!^\u0001\nI><UM\\\"pI\u0016$R!`A\u0004\u0003#\u00012A`A\u0002\u001b\u0005y(bAA\u0001G\u000591m\u001c3fO\u0016t\u0017bAA\u0003\u007f\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\n5\u0001\r!a\u0003\u0002\u0007\r$\b\u0010E\u0002\u007f\u0003\u001bI1!a\u0004\u0000\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0005\u000e\u0001\u0004i\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00033\u0001B!a\u0007\u0002$9!\u0011QDA\u0010!\t\u0001\u0017)C\u0002\u0002\"\u0005\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011\u0003\u0006!1m\u001c9z)\u001d!\u0016QFA\u0018\u0003cAq\u0001S\b\u0011\u0002\u0003\u0007!\nC\u0004O\u001fA\u0005\t\u0019\u0001&\t\u000fA{\u0001\u0013!a\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001cU\rQ\u0015\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011QI!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0005Y\u0006twM\u0003\u0002\u0002^\u0005!!.\u0019<b\u0013\u0011\t)#a\u0016\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0004c\u0001!\u0002h%\u0019\u0011\u0011N!\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007U\fy\u0007C\u0005\u0002rU\t\t\u00111\u0001\u0002f\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001e\u0011\u000b\u0005e\u0014qP;\u000e\u0005\u0005m$bAA?\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\b\u00065\u0005c\u0001!\u0002\n&\u0019\u00111R!\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011O\f\u0002\u0002\u0003\u0007Q/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u000b\u0019\n\u0003\u0005\u0002ra\t\t\u00111\u0001vQ=\u0001\u0011qSAO\u0003?\u000b\u0019+!*\u0002*\u0006-\u0006c\u0001\u001a\u0002\u001a&\u0019\u00111T\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011U\u0001\u0003\u001e)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003\u0005\\3o72\u0002\u0003/\u00193^S\u0001j\u0003EU3ukJt7\u000f\t1tiJ\u0004G\u0006\t7fMRl\u0003/\u00193eK\u0012\u0004s/\u001b;iA\u0001\u0004\u0018\r\u001a1!i>\u0004\u0013\r\t7f]\u001e$\b\u000eI8gA\u0001dWM\u001c1/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003m\u001d;sA\u0002J7\u000f\t7p]\u001e,'\u000f\t;iC:\u0004\u0003\r\\3oA2\u0002C\u000f[3!e\u0016$XO\u001d8!m\u0006dW/\u001a\u0011jg\u0002\u001a\bn\u001c:uK:,G\r\t;pA\u0001dWM\u001c1!G\"\f'/Y2uKJ\u001chF\u0003\u0011!A\u0001\u0002\u0003%\u00134!AB\fG\r\u0019\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002\u0003m\u001d;sA\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003/\u00193eK\u0012\u0004Co\u001c\u0011uQ\u0016\u0004C.\u001a4uA]LG\u000f\u001b\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qU\u0001\u0002B)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005[5(Y\u0001*D\u0006I\u0014@\u007f\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I @\u007f!L'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014iS\u001eb\u0003%\r\u0017!O}zt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005[5(Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001B\u0017N\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti+A\u00032]Ur\u0003'\u0001\u0006TiJLgn\u001a'QC\u0012\u0004\"A\r\u000e\u0014\ti\t),\u0012\t\t\u0003o\u000biL\u0013&K)6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w\u000b\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003\u007f\u000bILA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fQ\u000bY-!4\u0002P\")\u0001*\ba\u0001\u0015\")a*\ba\u0001\u0015\"9\u0001+\bI\u0001\u0002\u0004Q\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011q[Ar!\u0015\u0001\u0015\u0011\\Ao\u0013\r\tY.\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0001\u000byN\u0013&K\u0013\r\t\t/\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005\u0015x$!AA\u0002Q\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u000f\u0005\u0003\u0002V\u0005=\u0018\u0002BAy\u0003/\u0012aa\u00142kK\u000e$\b")
public class StringLPad
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Expression $lessinit$greater$default$3() {
        return StringLPad$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLPad stringLPad) {
        return StringLPad$.MODULE$.unapply(stringLPad);
    }

    public static Expression apply$default$3() {
        return StringLPad$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLPad> tupled() {
        return StringLPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLPad>>> curried() {
        return StringLPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).lpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".lpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "lpad";
    }

    public StringLPad copy(Expression str, Expression len, Expression pad) {
        return new StringLPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringLPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLPad stringLPad = (StringLPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringLPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringLPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringLPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLPad.canEqual(this)) return false;
        return true;
    }

    public StringLPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }

    public StringLPad(Expression str, Expression len) {
        this(str, len, Literal$.MODULE$.apply(" "));
    }
}

