/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric\n      column `col` which is the smallest value in the ordered `col` values (sorted from least to\n      greatest) such that no more than `percentage` of `col` values is less than the value\n      or equal to that value. The value of percentage must be between 0.0 and 1.0. The `accuracy`\n      parameter (default: 10000) is a positive numeric literal which controls approximation accuracy\n      at the cost of memory. Higher value of `accuracy` yields better accuracy, `1.0/accuracy` is\n      the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001\u0002%J\u0001bC!\"a)\u0001\u0005+\u0007I\u0011AAy\u0011)\t\u0019\u0010\u0001B\tB\u0003%\u0011Q\u0015\u0005\u000b\u0003_\u0003!Q3A\u0005\u0002\u0005E\bBCA{\u0001\tE\t\u0015!\u0003\u0002&\"Q\u00111\u0017\u0001\u0003\u0016\u0004%\t!!=\t\u0015\u0005]\bA!E!\u0002\u0013\t)\u000bC\u0005\u00028\u0002\u0011)\u001a!C!\u007f\"Q\u0011\u0011 \u0001\u0003\u0012\u0003\u0006I!!\u0001\t\u0013\u0005m\u0006A!f\u0001\n\u0003z\bBCA~\u0001\tE\t\u0015!\u0003\u0002\u0002!1A\u0010\u0001C\u0001\u0003{Da\u0001 \u0001\u0005\u0002\t%\u0001B\u0002?\u0001\t\u0003\u0011\t\u0002\u0003\u0006\u0003\u0018\u0001A)\u0019!C\u0005\u00053AqA!\t\u0001\t\u0003\u0012\u0019\u0003\u0003\u0007\u0002*\u0001\u0001\n\u0011cb!\n\u0013\u0011\u0019\u0005\u0003\u0006\u0003L\u0001A)\u0019!C\u0005\u0003\u0007B!\"!\u001b\u0001\u0011\u000b\u0007I\u0011\u0002B'\u0011\u001d\u0011y\u0005\u0001C!\u0005#BqAa\u0018\u0001\t\u0003\u0012\t\u0007C\u0004\u0003d\u0001!\tE!\u001a\t\u000f\u0005U\u0003\u0001\"\u0011\u0003x!9!Q\u0010\u0001\u0005B\t}\u0004b\u0002BE\u0001\u0011\u0005#1\u0012\u0005\b\u0005#\u0003A\u0011\tBJ\u0011\u001d\u00119\n\u0001C!\u00053CqA!(\u0001\t\u0003\n\u0019\u0005\u0003\u0006\u0003 \u0002A)\u0019!C\u0005\u0005CCqA!+\u0001\t\u0003\u0012\t\u000bC\u0004\u0003,\u0002!\tE!,\t\u000f\u0005u\u0004\u0001\"\u0011\u0003@\"9\u0011Q\u0012\u0001\u0005B\t\r\u0007\"\u0003Bd\u0001\u0005\u0005I\u0011\u0001Be\u0011%\u0011)\u000eAI\u0001\n\u0003\u00119\u000eC\u0005\u0003n\u0002\t\n\u0011\"\u0001\u0003X\"I!q\u001e\u0001\u0012\u0002\u0013\u0005!q\u001b\u0005\n\u0005c\u0004\u0011\u0013!C\u0001\u0005gD\u0011Ba>\u0001#\u0003%\tAa=\t\u0013\te\b!!A\u0005B\tm\b\u0002CB\u0001\u0001\u0005\u0005I\u0011A@\t\u0013\r\r\u0001!!A\u0005\u0002\r\u0015\u0001\"CB\u0005\u0001\u0005\u0005I\u0011IB\u0006\u0011%\u0019I\u0002AA\u0001\n\u0003\u0019Y\u0002C\u0005\u0004 \u0001\t\t\u0011\"\u0011\u0004\"\u001d)\u0001/\u0013E\u0001c\u001a)\u0001*\u0013E\u0001e\")AP\fC\u0001{\"9aP\fb\u0001\n\u0003y\b\u0002CA\u0004]\u0001\u0006I!!\u0001\u0007\r\u0005%a\u0006AA\u0006\u0011)\tiA\rBA\u0002\u0013%\u0011q\u0002\u0005\u000b\u0003;\u0011$\u00111A\u0005\n\u0005}\u0001BCA\u0016e\t\u0005\t\u0015)\u0003\u0002\u0012!1AP\rC\u0001\u0003[Aa\u0001 \u001a\u0005\u0002\u0005U\u0002\u0002CA!e\u0011\u0005q*a\u0011\t\u000f\u0005-#\u0007\"\u0001\u0002\u0010!9\u0011Q\n\u001a\u0005\u0002\u0005=\u0003bBA+e\u0011\u0005\u0011q\u000b\u0005\b\u0003;\u0012D\u0011AA0\u0011\u001d\tYG\rC\u0007\u0003[2a!a\u001c/\u0001\u0005E\u0004B\u0002??\t\u0003\t\u0019\bC\u0004\u0002xy\"i!!\u001f\t\u000f\u0005ud\b\"\u0002\u0002\u0000!9\u0011Q\u0012 \u0005\u0006\u0005=\u0005\"CAK]\t\u0007I\u0011AAL\u0011!\tIJ\fQ\u0001\n\u0005U\u0004\"CAN]\u0005\u0005I\u0011QAO\u0011%\tiLLA\u0001\n\u0003\u000by\fC\u0005\u0002R:\n\t\u0011\"\u0003\u0002T\n)\u0012\t\u001d9s_bLW.\u0019;f!\u0016\u00148-\u001a8uS2,'B\u0001&L\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002M\u001b\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqu*\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0016+A\u0002tc2T!AU*\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q+\u0016AB1qC\u000eDWMC\u0001W\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011,!:\u0002lf\u00042AW.^\u001b\u0005I\u0015B\u0001/J\u0005a!\u0016\u0010]3e\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003=Jr!aX\u0017\u000f\u0005\u0001|gBA1o\u001d\t\u0011WN\u0004\u0002dY:\u0011Am\u001b\b\u0003K*t!AZ5\u000e\u0003\u001dT!\u0001[,\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016B\u0001+V\u0013\t\u00116+\u0003\u0002Q#&\u0011ajT\u0005\u0003\u00196K!AS&\u0002+\u0005\u0003\bO]8yS6\fG/\u001a)fe\u000e,g\u000e^5mKB\u0011!LL\n\u0004]ML\bC\u0001;x\u001b\u0005)(\"\u0001<\u0002\u000bM\u001c\u0017\r\\1\n\u0005a,(AB!osJ+g\r\u0005\u0002uu&\u001110\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\f1\u0004R#G\u0003VcEk\u0018)F%\u000e+e\nV%M\u000b~\u000b5iQ+S\u0003\u000eKVCAA\u0001!\r!\u00181A\u0005\u0004\u0003\u000b)(aA%oi\u0006aB)\u0012$B+2#v\fU#S\u0007\u0016sE+\u0013'F?\u0006\u001b5)\u0016*B\u0007f\u0003#\u0001\u0005)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\t\u00114/A\u0005tk6l\u0017M]5fgV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC'\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\t)BA\tRk\u0006tG/\u001b7f'VlW.\u0019:jKN\fQb];n[\u0006\u0014\u0018.Z:`I\u0015\fH\u0003BA\u0011\u0003O\u00012\u0001^A\u0012\u0013\r\t)#\u001e\u0002\u0005+:LG\u000fC\u0005\u0002*Q\n\t\u00111\u0001\u0002\u0012\u0005\u0019\u0001\u0010J\u0019\u0002\u0015M,X.\\1sS\u0016\u001c\b\u0005\u0006\u0003\u00020\u0005M\u0002cAA\u0019e5\ta\u0006C\u0004\u0002\u000eY\u0002\r!!\u0005\u0015\t\u0005=\u0012q\u0007\u0005\b\u0003s9\u0004\u0019AA\u001e\u00035\u0011X\r\\1uSZ,WI\u001d:peB\u0019A/!\u0010\n\u0007\u0005}RO\u0001\u0004E_V\u0014G.Z\u0001\rSN\u001cu.\u001c9sKN\u001cX\rZ\u000b\u0003\u0003\u000b\u00022\u0001^A$\u0013\r\tI%\u001e\u0002\b\u0005>|G.Z1o\u0003E\tX/\u00198uS2,7+^7nCJLWm]\u0001\u0004C\u0012$G\u0003BA\u0011\u0003#Bq!a\u0015;\u0001\u0004\tY$A\u0003wC2,X-A\u0003nKJ<W\r\u0006\u0003\u0002\"\u0005e\u0003bBA.w\u0001\u0007\u0011qF\u0001\u0006_RDWM]\u0001\u000fO\u0016$\b+\u001a:dK:$\u0018\u000e\\3t)\u0011\t\t'a\u001a\u0011\u000bQ\f\u0019'a\u000f\n\u0007\u0005\u0015TOA\u0003BeJ\f\u0017\u0010C\u0004\u0002jq\u0002\r!!\u0019\u0002\u0017A,'oY3oi\u0006<Wm]\u0001\tG>l\u0007O]3tgR\u0011\u0011\u0011\u0005\u0002\u001b!\u0016\u00148-\u001a8uS2,G)[4fgR\u001cVM]5bY&TXM]\n\u0003}M$\"!!\u001e\u0011\u0007\u0005Eb(\u0001\u0004mK:<G\u000f\u001b\u000b\u0005\u0003\u0003\tY\bC\u0004\u0002\u000e\u0001\u0003\r!!\u0005\u0002\u0013M,'/[1mSj,G\u0003BAA\u0003\u0013\u0003R\u0001^A2\u0003\u0007\u00032\u0001^AC\u0013\r\t9)\u001e\u0002\u0005\u0005f$X\rC\u0004\u0002\f\u0006\u0003\r!a\f\u0002\u0007=\u0014'.A\u0006eKN,'/[1mSj,G\u0003BA\u0018\u0003#Cq!a%C\u0001\u0004\t\t)A\u0003csR,7/\u0001\u0006tKJL\u0017\r\\5{KJ,\"!!\u001e\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003?\u000b\t+!,\u00022\u0006U\u0016\u0011\u0018\t\u00035\u0002Aq!a)F\u0001\u0004\t)+A\u0003dQ&dG\r\u0005\u0003\u0002(\u0006%V\"A&\n\u0007\u0005-6J\u0001\u0006FqB\u0014Xm]:j_:Dq!a,F\u0001\u0004\t)+\u0001\u000bqKJ\u001cWM\u001c;bO\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003g+\u0005\u0019AAS\u0003I\t7mY;sC\u000eLX\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005]V\t1\u0001\u0002\u0002\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fC\u0004\u0002<\u0016\u0003\r!!\u0001\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003\u001d)h.\u00199qYf$B!!1\u0002NB)A/a1\u0002H&\u0019\u0011QY;\u0003\r=\u0003H/[8o!5!\u0018\u0011ZAS\u0003K\u000b)+!\u0001\u0002\u0002%\u0019\u00111Z;\u0003\rQ+\b\u000f\\36\u0011%\tyMRA\u0001\u0002\u0004\ty*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001b\t\u0005\u0003/\f\t/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0017\u0001\u00026bm\u0006LA!a9\u0002Z\n1qJ\u00196fGR\u0004B!a*\u0002h&\u0019\u0011\u0011^&\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042\u0001^Aw\u0013\r\ty/\u001e\u0002\b!J|G-^2u+\t\t)+\u0001\u0004dQ&dG\rI\u0001\u0016a\u0016\u00148-\u001a8uC\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8!\u0003M\t7mY;sC\u000eLX\t\u001f9sKN\u001c\u0018n\u001c8!\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0015\u0019\u0005}\u0015q B\u0001\u0005\u0007\u0011)Aa\u0002\t\u000f\u0005\r6\u00021\u0001\u0002&\"9\u0011qV\u0006A\u0002\u0005\u0015\u0006bBAZ\u0017\u0001\u0007\u0011Q\u0015\u0005\b\u0003o[\u0001\u0019AA\u0001\u0011\u001d\tYl\u0003a\u0001\u0003\u0003!\u0002\"a(\u0003\f\t5!q\u0002\u0005\b\u0003Gc\u0001\u0019AAS\u0011\u001d\ty\u000b\u0004a\u0001\u0003KCq!a-\r\u0001\u0004\t)\u000b\u0006\u0004\u0002 \nM!Q\u0003\u0005\b\u0003Gk\u0001\u0019AAS\u0011\u001d\ty+\u0004a\u0001\u0003K\u000b\u0001\"Y2dkJ\f7-_\u000b\u0003\u00057\u00012\u0001\u001eB\u000f\u0013\r\u0011y\"\u001e\u0002\u0005\u0019>tw-\u0001\u0006j]B,H\u000fV=qKN,\"A!\n\u0011\r\t\u001d\"\u0011\u0007B\u001c\u001d\u0011\u0011IC!\f\u000f\u0007\u0019\u0014Y#C\u0001w\u0013\r\u0011y#^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019D!\u000e\u0003\u0007M+\u0017OC\u0002\u00030U\u0004BA!\u000f\u0003@5\u0011!1\b\u0006\u0004\u0005{y\u0015!\u0002;za\u0016\u001c\u0018\u0002\u0002B!\u0005w\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0016\u0005\t\u0015\u0003c\u0002;\u0003H\u0005\u0015\u0013\u0011M\u0005\u0004\u0005\u0013*(A\u0002+va2,''A\u000bsKR,(O\u001c)fe\u000e,g\u000e^5mK\u0006\u0013(/Y=\u0016\u0005\u0005\u0005\u0014aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHC\u0001B*!\u0011\u0011)Fa\u0017\u000e\u0005\t]#b\u0001B-\u001b\u0006A\u0011M\\1msNL7/\u0003\u0003\u0003^\t]#a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#A/\u0002\rU\u0004H-\u0019;f)\u0015i&q\rB6\u0011\u0019\u0011I'\u0006a\u0001;\u00061!-\u001e4gKJDqA!\u001c\u0016\u0001\u0004\u0011y'\u0001\u0005j]B,HOU8x!\u0011\u0011\tHa\u001d\u000e\u00035K1A!\u001eN\u0005-Ie\u000e^3s]\u0006d'k\\<\u0015\u000bu\u0013IHa\u001f\t\r\t%d\u00031\u0001^\u0011\u0019\tYF\u0006a\u0001;\u0006!QM^1m)\u0011\u0011\tIa\"\u0011\u0007Q\u0014\u0019)C\u0002\u0003\u0006V\u00141!\u00118z\u0011\u0019\u0011Ig\u0006a\u0001;\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002 \n5\u0005b\u0002BH1\u0001\u0007\u0011\u0011A\u0001\n]\u0016<xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BAP\u0005+CqAa$\u001a\u0001\u0004\t\t!\u0001\u0005dQ&dGM]3o+\t\u0011Y\n\u0005\u0004\u0003(\tE\u0012QU\u0001\t]VdG.\u00192mK\u0006\u0001\u0012N\u001c;fe:\fG\u000eR1uCRK\b/Z\u000b\u0003\u0005G\u0003BA!\u000f\u0003&&!!q\u0015B\u001e\u0005!!\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u00030B!!\u0011\u0017B]\u001d\u0011\u0011\u0019L!.\u0011\u0005\u0019,\u0018b\u0001B\\k\u00061\u0001K]3eK\u001aLAAa/\u0003>\n11\u000b\u001e:j]\u001eT1Aa.v)\u0011\t\tI!1\t\r\u0005-u\u00041\u0001^)\ri&Q\u0019\u0005\b\u0003'\u0003\u0003\u0019AAA\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005}%1\u001aBg\u0005\u001f\u0014\tNa5\t\u0013\u0005\r\u0016\u0005%AA\u0002\u0005\u0015\u0006\"CAXCA\u0005\t\u0019AAS\u0011%\t\u0019,\tI\u0001\u0002\u0004\t)\u000bC\u0005\u00028\u0006\u0002\n\u00111\u0001\u0002\u0002!I\u00111X\u0011\u0011\u0002\u0003\u0007\u0011\u0011A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IN\u000b\u0003\u0002&\nm7F\u0001Bo!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dX/\u0001\u0006b]:|G/\u0019;j_:LAAa;\u0003b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005kTC!!\u0001\u0003\\\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003~B!\u0011q\u001bB\u0000\u0013\u0011\u0011Y,!7\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011QB\u0004\u0011%\tI#KA\u0001\u0002\u0004\t\t!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019i\u0001\u0005\u0004\u0004\u0010\rU!\u0011Q\u0007\u0003\u0007#Q1aa\u0005v\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007/\u0019\tB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA#\u0007;A\u0011\"!\u000b,\u0003\u0003\u0005\rA!!\u0002\r\u0015\fX/\u00197t)\u0011\t)ea\t\t\u0013\u0005%B&!AA\u0002\t\u0005\u0005f\u0005\u0001\u0004(\r52qFB\u001a\u0007k\u0019Ida\u000f\u0004@\r\u0005\u0003\u0003BAT\u0007SI1aa\u000bL\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#a!\r\u0002\r7S\u0001\u0005\t\u0011!?\u001a+fjQ0)G>dG\u0006\t9fe\u000e,g\u000e^1hK\u0002ZF\u0006I1dGV\u0014\u0018mY=^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^3!AB,'oY3oi&dW\r\u0019\u0011pM\u0002\"\b.\u001a\u0011ok6,'/[2\u000bA\u0001\u0002\u0003\u0005\t\u0011d_2,XN\u001c\u0011aG>d\u0007\rI<iS\u000eD\u0007%[:!i\",\u0007e]7bY2,7\u000f\u001e\u0011wC2,X\rI5oAQDW\rI8sI\u0016\u0014X\r\u001a\u0011aG>d\u0007\r\t<bYV,7\u000f\t\u0015t_J$X\r\u001a\u0011ge>l\u0007\u0005\\3bgR\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005I4sK\u0006$Xm\u001d;*AM,8\r\u001b\u0011uQ\u0006$\bE\\8![>\u0014X\r\t;iC:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002zg\r\t1d_2\u0004\u0007E^1mk\u0016\u001c\b%[:!Y\u0016\u001c8\u000f\t;iC:\u0004C\u000f[3!m\u0006dW/\u001a\u0006!A\u0001\u0002\u0003\u0005I8sA\u0015\fX/\u00197!i>\u0004C\u000f[1uAY\fG.^3/AQCW\r\t<bYV,\u0007e\u001c4!a\u0016\u00148-\u001a8uC\u001e,\u0007%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002d\u0006\t+iK\u0002\u0002\u0017mY2ve\u0006\u001c\u0017\u0010\u0019\u0006!A\u0001\u0002\u0003\u0005\t9be\u0006lW\r^3sA!\"WMZ1vYRT\u0004%\r\u00191aAJ\u0003%[:!C\u0002\u0002xn]5uSZ,\u0007E\\;nKJL7\r\t7ji\u0016\u0014\u0018\r\u001c\u0011xQ&\u001c\u0007\u000eI2p]R\u0014x\u000e\\:!CB\u0004(o\u001c=j[\u0006$\u0018n\u001c8!C\u000e\u001cWO]1ds*\u0001\u0003\u0005\t\u0011!A\u0005$\b\u0005\u001e5fA\r|7\u000f\u001e\u0011pM\u0002jW-\\8ss:\u0002\u0003*[4iKJ\u0004c/\u00197vK\u0002zg\r\t1bG\u000e,(/Y2zA\u0002J\u0018.\u001a7eg\u0002\u0012W\r\u001e;fe\u0002\n7mY;sC\u000eLH\u0006\t12]Az\u0013mY2ve\u0006\u001c\u0017\u0010\u0019\u0011jg*\u0001\u0003\u0005\t\u0011!AQDW\r\t:fY\u0006$\u0018N^3!KJ\u0014xN\u001d\u0011pM\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007\u0005\u00199fe\u000e,g\u000e^1hK\u0002\u0004\u0013n\u001d\u0011b]\u0002\n'O]1zY\u0001*\u0017m\u00195!m\u0006dW/\u001a\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9R\u0001\u0005\t\u0011!A\u0001Je\u000e\t;iSN\u00043-Y:fY\u0001\u0012X\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u0002\n'O]1zA=4\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]*\u0001\u0003\u0005\t\u0011!AA,'oY3oi\u0006<W\rI1se\u0006LhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAB\u001c\u0003\u0005\u001d'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152S1\u0002\u0003FM\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YEb\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006\t\u0019/k1\u0002\u0013\u0007\r\u0019*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u001c*Y\u0001Bs'\u000b\u0017!QeJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001:$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\ru\u0012!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0019\u0019%A\u00033]Er\u0003\u0007")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
scala.Serializable {
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private DataType internalDataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = ((Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1())).longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType(DoubleType$.MODULE$, false)})), IntegralType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.x$1 = tuple23;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The accuracy provided must be a literal between (0, ").append(Integer.MAX_VALUE).append("]").append(" (current value = ").append(this.accuracy()).append(")").toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("All percentage values must be between 0.0 and 1.0 ").append("(current = ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).mkString(", ")).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = numericType.numeric().toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Object object;
        double[] doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$3 -> (long)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$6 -> (int)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$7 -> (long)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = doubleResult;
        } else if (dataType instanceof DecimalType) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
            }
            throw new MatchError((Object)dataType);
        }
        Object result = object;
        return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType internalDataType$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.internalDataType = this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.internalDataType$lzycompute() : this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = Array$.MODULE$.emptyDoubleArray();
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, x$3));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

