/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%fAB\r\u001b\u0003\u0003qB\u0005C\u0003/\u0001\u0011\u0005\u0001\u0007C\u00034\u0001\u0019\u0005A\u0007C\u00034\u0001\u0011\u0005!\bC\u0003E\u0001\u0011\u0005Q\tC\u0003U\u0001\u0019\u0005Q\u000bC\u0003U\u0001\u0011\u0005\u0011\rC\u0003e\u0001\u0011\u0005Q\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003:\u0001\u0019\u00051\u000fC\u0003y\u0001\u0019\u0005\u0011\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\rm\u0004A\u0011AA\u0011\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\u000e\u0001\t\u0003\tIdB\u0004\u0002@iA\t!!\u0011\u0007\reQ\u0002\u0012AA\"\u0011\u0019q\u0003\u0003\"\u0001\u0002F!I\u0011q\t\tC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003[\u0002\u0002\u0015!\u0003\u0002L!I\u0011\u0011\u000f\tC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003k\u0002\u0002\u0015!\u0003\u0002L!A\u0011\u0011\u0010\t\u0005\u0002y\tY\b\u0003\u0005\u0002\u0016B!\tAHAL\u0011%\tY\nEA\u0001\n\u0013\tiJA\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0015\tYB$\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\b\u0010\u0002\u000b5dG.\u001b2\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c2\u0001A\u0013,!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011a\u0005L\u0005\u0003[\u001d\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002cA\u0011!\u0007A\u0007\u00025\u0005\t2m\\7qkR,7\u000b^1uSN$\u0018nY:\u0015\u0005UB\u0004C\u0001\u00147\u0013\t9tE\u0001\u0004E_V\u0014G.\u001a\u0005\u0006s\t\u0001\r!N\u0001\tI&\u001cH/\u00198dKR\u00111H\u0010\t\u0004Mq*\u0014BA\u001f(\u0005\u0015\t%O]1z\u0011\u0015y4\u00011\u0001A\u0003\u001d\u0019WM\u001c;feN\u00042A\n\u001fB!\t\u0011$)\u0003\u0002D5\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0017AH2p[B,H/Z*uCRL7\u000f^5dg\u0012K7\u000f\u001e:jEV$X\r\u001a7z)\rYd\t\u0014\u0005\u0006\u000f\u0012\u0001\r\u0001S\u0001\u0003g\u000e\u0004\"!\u0013&\u000e\u0003yI!a\u0013\u0010\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000b5#\u0001\u0019\u0001(\u0002\u0013\t\u001c7)\u001a8uKJ\u001c\bcA(S\u00016\t\u0001K\u0003\u0002R=\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003'B\u0013\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0002\u0017\u0019Lg\u000eZ\"m_N,7\u000f\u001e\u000b\u0005-rkv\f\u0005\u0003'/f+\u0014B\u0001-(\u0005\u0019!V\u000f\u001d7feA\u0011aEW\u0005\u00037\u001e\u00121!\u00138u\u0011\u0015yT\u00011\u0001A\u0011\u0015qV\u00011\u0001<\u0003)\u0019H/\u0019;jgRL7m\u001d\u0005\u0006A\u0016\u0001\r!Q\u0001\u0006a>Lg\u000e\u001e\u000b\u0004-\n\u001c\u0007\"B \u0007\u0001\u0004\u0001\u0005\"\u00021\u0007\u0001\u0004\t\u0015!\u00039pS:$8i\\:u)\r)dm\u001a\u0005\u0006\u007f\u001d\u0001\r\u0001\u0011\u0005\u0006A\u001e\u0001\r!Q\u0001\u0012SN\u001cUM\u001c;fe\u000e{gN^3sO\u0016$G\u0003\u00026n_F\u0004\"AJ6\n\u00051<#a\u0002\"p_2,\u0017M\u001c\u0005\u0006]\"\u0001\r!Q\u0001\n_2$7)\u001a8uKJDQ\u0001\u001d\u0005A\u0002\u0005\u000b\u0011B\\3x\u0007\u0016tG/\u001a:\t\u000bID\u0001\u0019A\u001b\u0002\u000f\u0015\u00048/\u001b7p]R\u0019Q\u0007\u001e<\t\u000bUL\u0001\u0019A!\u0002\u0005Y\f\u0004\"B<\n\u0001\u0004\t\u0015A\u0001<3\u0003-\u0019G.^:uKJ\u001cun\u001d;\u0015\rURHP`A\u0001\u0011\u0015Y(\u00021\u0001B\u0003!\u0019WM\u001c;s_&$\u0007\"B?\u000b\u0001\u0004\t\u0015!\u00039pS:$8oU;n\u0011\u0015y(\u00021\u00016\u0003%9X-[4iiN+X\u000e\u0003\u0004\u0002\u0004)\u0001\r!N\u0001\u0012a>Lg\u000e^:TcV\f'/\u001a3O_Jl\u0017\u0001E;qI\u0006$Xm\u00117vgR,'oU;n)\u0019\tI!a\u0004\u0002\u0012A\u0019a%a\u0003\n\u0007\u00055qE\u0001\u0003V]&$\b\"\u00021\f\u0001\u0004\t\u0005bBA\n\u0017\u0001\u0007\u0011QC\u0001\u0004gVl\u0007\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mA$\u0001\u0004mS:\fGnZ\u0005\u0005\u0003?\tIB\u0001\u0004WK\u000e$xN\u001d\u000b\u0006\u0003\u0006\r\u0012Q\u0005\u0005\b\u0003'a\u0001\u0019AA\u000b\u0011\u0015yH\u00021\u00016\u0003I\u0019\u00180\\7fiJL7mQ3oiJ|\u0017\u000eZ:\u0015\u0011\u0005-\u0012QFA\u0019\u0003k\u0001BAJ,B\u0003\"1\u0011qF\u0007A\u0002U\nQ\u0001\\3wK2Dq!a\r\u000e\u0001\u0004\t)\"A\u0003o_&\u001cX\r\u0003\u0004|\u001b\u0001\u0007\u0011QC\u0001\u0005G>\u001cH\u000fF\u00036\u0003w\ti\u0004C\u0003a\u001d\u0001\u0007\u0011\tC\u0003|\u001d\u0001\u0007\u0011)A\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f!\t\u0011\u0004cE\u0002\u0011K-\"\"!!\u0011\u0002\u0013\u0015+6\tT%E\u000b\u0006sUCAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nA\u0001\\1oO*\u0011\u0011QK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0005=#AB*ue&tw\rK\u0003\u0013\u0003;\nI\u0007\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019GH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA4\u0003C\u0012QaU5oG\u0016\f#!a\u001b\u0002\u000bIrCG\f\u0019\u0002\u0015\u0015+6\tT%E\u000b\u0006s\u0005\u0005K\u0003\u0014\u0003;\nI'\u0001\u0004D\u001fNKe*\u0012\u0015\u0006)\u0005u\u0013\u0011N\u0001\b\u0007>\u001b\u0016JT#!Q\u0015)\u0012QLA5\u0003A!WmY8eK\u001a\u0013x.\\*ue&tw\rF\u00022\u0003{Bq!a \u0017\u0001\u0004\t\t)A\beSN$\u0018M\\2f\u001b\u0016\f7/\u001e:f!\u0011\t\u0019)!%\u000f\t\u0005\u0015\u0015Q\u0012\t\u0004\u0003\u000f;SBAAE\u0015\r\tYiL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=u%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\n\u0019JC\u0002\u0002\u0010\u001e\nqC^1mS\u0012\fG/\u001a#jgR\fgnY3NK\u0006\u001cXO]3\u0015\u0007)\fI\nC\u0004\u0002\u0000]\u0001\r!!!\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0003B!!\u0014\u0002\"&!\u00111UA(\u0005\u0019y%M[3di\"*\u0001#!\u0018\u0002j!*q\"!\u0018\u0002j\u0001")
public abstract class DistanceMeasure
implements scala.Serializable {
    public static String COSINE() {
        return DistanceMeasure$.MODULE$.COSINE();
    }

    public static String EUCLIDEAN() {
        return DistanceMeasure$.MODULE$.EUCLIDEAN();
    }

    public abstract double computeStatistics(double var1);

    /*
     * WARNING - void declaration
     */
    public double[] computeStatistics(VectorWithNorm[] centers) {
        void var3_3;
        int i;
        int k = centers.length;
        if (k == 1) {
            return new double[]{Double.NaN};
        }
        double[] packedValues = (double[])Array$.MODULE$.ofDim(k * (k + 1) / 2, ClassTag$.MODULE$.Double());
        double[] diagValues = (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.POSITIVE_INFINITY, ClassTag$.MODULE$.Double());
        for (i = 0; i < k; ++i) {
            for (int j = i + 1; j < k; ++j) {
                double d = this.distance(centers[i], centers[j]);
                double s = this.computeStatistics(d);
                int index = Utils$.MODULE$.indexUpperTriangular(k, i, j);
                packedValues[index] = s;
                if (s < diagValues[i]) {
                    diagValues[i] = s;
                }
                if (!(s < diagValues[j])) continue;
                diagValues[j] = s;
            }
        }
        for (i = 0; i < k; ++i) {
            int index = Utils$.MODULE$.indexUpperTriangular(k, i, i);
            packedValues[index] = diagValues[i];
        }
        return var3_3;
    }

    public double[] computeStatisticsDistributedly(SparkContext sc, Broadcast<VectorWithNorm[]> bcCenters) {
        int k = ((VectorWithNorm[])bcCenters.value()).length;
        if (k == 1) {
            return new double[]{Double.NaN};
        }
        double[] packedValues = (double[])Array$.MODULE$.ofDim(k * (k + 1) / 2, ClassTag$.MODULE$.Double());
        double[] diagValues = (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.POSITIVE_INFINITY, ClassTag$.MODULE$.Double());
        int numParts = package$.MODULE$.min(k, 1024);
        RDD qual$1 = sc.range(0L, (long)numParts, 1L, numParts);
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$2(this, bcCenters, k, numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DistanceMeasure.$anonfun$computeStatisticsDistributedly$5(k, packedValues, diagValues, x0$2);
            return BoxedUnit.UNIT;
        });
        for (int i = 0; i < k; ++i) {
            int index = Utils$.MODULE$.indexUpperTriangular(k, i, i);
            packedValues[index] = diagValues[i];
        }
        return packedValues;
    }

    public abstract Tuple2<Object, Object> findClosest(VectorWithNorm[] var1, double[] var2, VectorWithNorm var3);

    public Tuple2<Object, Object> findClosest(VectorWithNorm[] centers, VectorWithNorm point) {
        double bestDistance = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        for (int i = 0; i < centers.length; ++i) {
            VectorWithNorm center = centers[i];
            double currentDistance = this.distance(center, point);
            if (!(currentDistance < bestDistance)) continue;
            bestDistance = currentDistance;
            bestIndex = i;
        }
        return new Tuple2.mcID.sp(bestIndex, bestDistance);
    }

    public double pointCost(VectorWithNorm[] centers, VectorWithNorm point) {
        return this.findClosest(centers, point)._2$mcD$sp();
    }

    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return this.distance(oldCenter, newCenter) <= epsilon;
    }

    public abstract double distance(VectorWithNorm var1, VectorWithNorm var2);

    public abstract double clusterCost(VectorWithNorm var1, VectorWithNorm var2, double var3, double var5);

    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        BLAS$.MODULE$.axpy(point.weight(), point.vector(), sum);
    }

    public VectorWithNorm centroid(Vector sum, double weightSum) {
        BLAS$.MODULE$.scal(1.0 / weightSum, sum);
        return new VectorWithNorm(sum);
    }

    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Vector left = centroid.copy();
        BLAS$.MODULE$.axpy(-level, noise, left);
        Vector right = centroid.copy();
        BLAS$.MODULE$.axpy(level, noise, right);
        return new Tuple2((Object)new VectorWithNorm(left), (Object)new VectorWithNorm(right));
    }

    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return this.distance(point, centroid);
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$4(DistanceMeasure $this, int i$1, int numParts$1, int pid$1, VectorWithNorm[] centers$1, int j) {
        Iterator iterator;
        int hash = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(new Tuple2.mcII.sp(i$1, j).hashCode()));
        if (hash % numParts$1 == pid$1) {
            double d = $this.distance(centers$1[i$1], centers$1[j]);
            double s = $this.computeStatistics(d);
            iterator = scala.package$.MODULE$.Iterator().single((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i$1), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)s)));
        } else {
            iterator = scala.package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$3(DistanceMeasure $this, int k$1, int numParts$1, int pid$1, VectorWithNorm[] centers$1, int i) {
        return scala.package$.MODULE$.Iterator().range(i + 1, k$1).flatMap((Function1 & Serializable & scala.Serializable)j -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$4($this, i, numParts$1, pid$1, centers$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$2(DistanceMeasure $this, Broadcast bcCenters$1, int k$1, int numParts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int pid = tuple2._1$mcI$sp();
        VectorWithNorm[] centers = (VectorWithNorm[])bcCenters$1.value();
        Iterator iterator = scala.package$.MODULE$.Iterator().range(0, k$1).flatMap((Function1 & Serializable & scala.Serializable)i -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$3($this, k$1, numParts$1, pid, centers, BoxesRunTime.unboxToInt((Object)i)));
        return iterator;
    }

    public static final /* synthetic */ void $anonfun$computeStatisticsDistributedly$5(int k$1, double[] packedValues$1, double[] diagValues$1, Tuple3 x0$2) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            int index = Utils$.MODULE$.indexUpperTriangular(k$1, i, j);
            packedValues$1[index] = s;
            if (s < diagValues$1[i]) {
                diagValues$1[i] = s;
            }
            if (s < diagValues$1[j]) {
                diagValues$1[j] = s;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }
}

