/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001\u0002\r\u001a\u0001!BQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004L\u0001\u0001\u0006I\u0001\u0013\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u00063\u0002!\t%\u0014\u0005\u00065\u0002!\te\u0017\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006S\u0002!\tE\u001b\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u001a\u0001\u0005B\u00055waBAm3!\u0005\u00111\u001c\u0004\u00071eA\t!!8\t\r\t\u0003B\u0011AAp\u0011!\t\t\u000f\u0005C\u00013\u0005\r\b\u0002CA}!\u0011\u0005\u0011$a?\t\u000f\t\u001d\u0001\u0003\"\u0001\u0003\n!9!1\u0003\t\u0005\u0002\tU\u0001b\u0002B\u0013!\u0011%!q\u0005\u0005\n\u0005[\u0001\u0012\u0011!C\u0005\u0005_\u0011\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u\u0015\tQ2$A\u0004qCJ\fX/\u001a;\u000b\u0005qi\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!AH\u0010\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011C\u0002\u0001*_MJt\b\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aEj\u0011aG\u0005\u0003em\u0011!BR5mK\u001a{'/\\1u!\t!t'D\u00016\u0015\t1t$A\u0004t_V\u00148-Z:\n\u0005a*$A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0011\u0002\u0011%tG/\u001a:oC2L!AP\u001e\u0003\u000f1{wmZ5oOB\u0011!\u0006Q\u0005\u0003\u0003.\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001#\u0011\u0005\u0015\u0003Q\"A\r\u0002)A\f'/];fi2{wMU3eSJ,7\r^8s+\u0005A\u0005CA#J\u0013\tQ\u0015D\u0001\u000bQCJ\fX/\u001a;M_\u001e\u0014V\rZ5sK\u000e$xN]\u0001\u0016a\u0006\u0014\u0018/^3u\u0019><'+\u001a3je\u0016\u001cGo\u001c:!\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u0001O!\tyeK\u0004\u0002Q)B\u0011\u0011kK\u0007\u0002%*\u00111kJ\u0001\u0007yI|w\u000e\u001e \n\u0005U[\u0013A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!V\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00029B\u0011!&X\u0005\u0003=.\u00121!\u00138u\u0003\u0019)\u0017/^1mgR\u0011\u0011\r\u001a\t\u0003U\tL!aY\u0016\u0003\u000f\t{w\u000e\\3b]\")Qm\u0002a\u0001M\u0006)q\u000e\u001e5feB\u0011!fZ\u0005\u0003Q.\u00121!\u00118z\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u0019Yg\u000e\u001e@\u0002\bA\u0011\u0001\u0007\\\u0005\u0003[n\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQa\u001c\u0005A\u0002A\fAb\u001d9be.\u001cVm]:j_:\u0004\"!\u001d:\u000e\u0003}I!a]\u0010\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bUD\u0001\u0019\u0001<\u0002\u0007)|'\r\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003w\u000e\na\u0001[1e_>\u0004\u0018BA?y\u0005\rQuN\u0019\u0005\u0007\u007f\"\u0001\r!!\u0001\u0002\u000f=\u0004H/[8ogB)q*a\u0001O\u001d&\u0019\u0011Q\u0001-\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\n!\u0001\r!a\u0003\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\r\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tbH\u0001\u0006if\u0004Xm]\u0005\u0005\u0003+\tyA\u0001\u0006TiJ,8\r\u001e+za\u0016\f1\"\u001b8gKJ\u001c6\r[3nCRA\u00111DA\u0011\u0003G\t9\u0003E\u0003+\u0003;\tY!C\u0002\u0002 -\u0012aa\u00149uS>t\u0007\"B8\n\u0001\u0004\u0001\bbBA\u0013\u0013\u0001\u0007\u0011\u0011A\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bbBA\u0015\u0013\u0001\u0007\u00111F\u0001\u0006M&dWm\u001d\t\u0007\u0003[\t9$!\u0010\u000f\t\u0005=\u00121\u0007\b\u0004#\u0006E\u0012\"\u0001\u0017\n\u0007\u0005U2&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00121\b\u0002\u0004'\u0016\f(bAA\u001bWA!\u0011qHA#\u001b\t\t\tEC\u0002\u0002Di\f!AZ:\n\t\u0005\u001d\u0013\u0011\t\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#B1\u0002N\u0005=\u0003\"B8\u000b\u0001\u0004\u0001\bbBA)\u0015\u0001\u0007\u00111B\u0001\u0007g\u000eDW-\\1\u0002\u0017Y,7\r^8s)f\u0004Xm\u001d\u000b\t\u0003/\nY&a\u0018\u0002dA)!&!\b\u0002ZA)\u0011QFA\u001c\u001d\"9\u0011QL\u0006A\u0002\u0005-\u0011A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\b\u0003CZ\u0001\u0019AA\u0006\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007bBA3\u0017\u0001\u0007\u0011qM\u0001\bgFd7i\u001c8g!\u0011\tI'!\u001c\u000e\u0005\u0005-$B\u0001\u001f \u0013\u0011\ty'a\u001b\u0003\u000fM\u000bFjQ8oM\u0006Y\u0011n]*qY&$\u0018M\u00197f)\u001d\t\u0017QOA<\u0003sBQa\u001c\u0007A\u0002ADaa \u0007A\u0002\u0005\u0005\u0001bBA>\u0019\u0001\u0007\u0011QP\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002@\u0005}\u0014\u0002BAA\u0003\u0003\u0012A\u0001U1uQ\u0006q\"-^5mIJ+\u0017\rZ3s/&$\b\u000eU1si&$\u0018n\u001c8WC2,Xm\u001d\u000b\u0011\u0003\u000f\u000b)+a*\u0002*\u0006-\u0016QVA]\u0003w\u0003rAKAE\u0003\u001b\u000b\u0019*C\u0002\u0002\f.\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007A\ny)C\u0002\u0002\u0012n\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0007\u0003[\t)*!'\n\t\u0005]\u00151\b\u0002\t\u0013R,'/\u0019;peB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 ~\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003G\u000biJA\u0006J]R,'O\\1m%><\b\"B8\u000e\u0001\u0004\u0001\bbBA\u0005\u001b\u0001\u0007\u00111\u0002\u0005\b\u0003Cj\u0001\u0019AA\u0006\u0011\u001d\ti&\u0004a\u0001\u0003\u0017Aq!a,\u000e\u0001\u0004\t\t,A\u0004gS2$XM]:\u0011\r\u00055\u0012qGAZ!\r!\u0014QW\u0005\u0004\u0003o+$A\u0002$jYR,'\u000f\u0003\u0004\u0000\u001b\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003{k\u0001\u0019AA`\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u0019\u0011Q\u0019>\u0002\t\r|gNZ\u0005\u0005\u0003\u0013\f\u0019MA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019\u0011-a4\t\u000f\u0005Eg\u00021\u0001\u0002T\u0006AA-\u0019;b)f\u0004X\r\u0005\u0003\u0002\u000e\u0005U\u0017\u0002BAl\u0003\u001f\u0011\u0001\u0002R1uCRK\b/Z\u0001\u0012!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$\bCA#\u0011'\u0011\u0001\u0012&O \u0015\u0005\u0005m\u0017A\u0003:fC\u0012\u001c6\r[3nCR1\u00111DAs\u0003oDq!a:\u0013\u0001\u0004\tI/A\u0004g_>$XM]:\u0011\r\u00055\u0012qGAv!\u0011\ti/a=\u000e\u0005\u0005=(bA>\u0002r*\u0011!dI\u0005\u0005\u0003k\fyO\u0001\u0004G_>$XM\u001d\u0005\u0006_J\u0001\r\u0001]\u0001\u001de\u0016\fG\rU1scV,GOR8pi\u0016\u00148/\u00138QCJ\fG\u000e\\3m)!\tI/!@\u0002\u0000\n\r\u0001bBAc'\u0001\u0007\u0011q\u0018\u0005\b\u0005\u0003\u0019\u0002\u0019AA\u0016\u0003%\u0001\u0018M\u001d;GS2,7\u000f\u0003\u0004\u0003\u0006M\u0001\r!Y\u0001\u0013S\u001etwN]3D_J\u0014X\u000f\u001d;GS2,7/\u0001\fnKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)!\tYBa\u0003\u0003\u000e\tE\u0001bBA\u0013)\u0001\u0007\u0011\u0011\u0001\u0005\b\u0005\u001f!\u0002\u0019AA\u0016\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u0015yG\u00031\u0001q\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feR1\u00111\u0002B\f\u00057AqA!\u0007\u0016\u0001\u0004\tY/\u0001\u0004g_>$XM\u001d\u0005\b\u0005;)\u0002\u0019\u0001B\u0010\u0003%\u0019wN\u001c<feR,'\u000fE\u0002F\u0005CI1Aa\t\u001a\u0005u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\u0018a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u001c6\r[3nCN#(/\u001b8h)\u0011\tYB!\u000b\t\r\t-b\u00031\u0001O\u00031\u00198\r[3nCN#(/\u001b8h\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tE\u0002\u0003\u0002B\u001a\u0005{i!A!\u000e\u000b\t\t]\"\u0011H\u0001\u0005Y\u0006twM\u0003\u0002\u0003<\u0005!!.\u0019<b\u0013\u0011\u0011yD!\u000e\u0003\r=\u0013'.Z2u\u0001")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
scala.Serializable {
    private final ParquetLogRedirector parquetLogRedirector;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        return new OutputWriterFactory(null){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$supportBatch$1(x$1)));
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply((Object)Seq$.MODULE$.fill(requiredSchema.fields().length + partitionSchema.fields().length, (Function0 & Serializable & scala.Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName()));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$2)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable & scala.Serializable)file -> {
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            ParquetInputSplit split = new ParquetInputSplit(filePath, file.start(), file.start() + file.length(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)x$3)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            Map map = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            Enumeration.Value datetimeRebaseMode = DataSourceUtils$.MODULE$.datetimeRebaseMode((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), (String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_READ()));
            Map map2 = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            Enumeration.Value int96RebaseMode = DataSourceUtils$.MODULE$.int96RebaseMode((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), (String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_PARQUET_INT96_REBASE_MODE_IN_READ()));
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull(Predef$.MODULE$.$conforms()), datetimeRebaseMode.toString(), int96RebaseMode.toString(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                if (returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            } else {
                ParquetRecordReader parquetRecordReader;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseMode, int96RebaseMode);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator(reader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$7 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    recordReaderIterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    recordReaderIterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$2) {
        return x$2.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFileReader.readFooter((Configuration)sharedConf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }
}

