/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4Aa\u0002\u0005\u00013!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005<\u0001\t\u0005\t\u0015!\u00034\u0011!a\u0004A!A!\u0002\u0013i\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bM\u0003A\u0011\u0001+\t\u000bm\u0003A\u0011\t/\u0003'A\u000b'/];fi^\u0013\u0018\u000e^3Ck&dG-\u001a:\u000b\u0005%Q\u0011a\u00029beF,X\r\u001e\u0006\u0003\u00171\t!A\u001e\u001a\u000b\u00055q\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0004\t\u0002\u0013\u0015DXmY;uS>t'BA\t\u0013\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001b=A\u00111\u0004H\u0007\u0002\u0015%\u0011QD\u0003\u0002\u0011\r&dWm\u0016:ji\u0016\u0014U/\u001b7eKJ\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\n\u0002\u0011%tG/\u001a:oC2L!a\t\u0011\u0003\u000f1{wmZ5oO\u0006)\u0001/\u0019;igB\u0019a\u0005M\u001a\u000f\u0005\u001djcB\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0019\u0003\u0019a$o\\8u}%\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/_\u00059\u0001/Y2lC\u001e,'\"\u0001\u0017\n\u0005E\u0012$aA*fc*\u0011af\f\t\u0003iar!!\u000e\u001c\u0011\u0005!z\u0013BA\u001c0\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]z\u0013A\u00034pe6\fGOT1nK\u0006\u00012/\u001e9q_J$8\u000fR1uCRK\b/\u001a\t\u0005}}\nu)D\u00010\u0013\t\u0001uFA\u0005Gk:\u001cG/[8ocA\u0011!)R\u0007\u0002\u0007*\u0011A\tE\u0001\u0006if\u0004Xm]\u0005\u0003\r\u000e\u0013\u0001\u0002R1uCRK\b/\u001a\t\u0003}!K!!S\u0018\u0003\u000f\t{w\u000e\\3b]\u0006!\u0011N\u001c4p!\ta\u0015+D\u0001N\u0015\tqu*A\u0003xe&$XM\u0003\u0002Q!\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003%6\u0013\u0001\u0003T8hS\u000e\fGn\u0016:ji\u0016LeNZ8\u0002\rqJg.\u001b;?)\u0015)v\u000bW-[!\t1\u0006!D\u0001\t\u0011\u0015!S\u00011\u0001&\u0011\u0015YT\u00011\u00014\u0011\u0015aT\u00011\u0001>\u0011\u0015QU\u00011\u0001L\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u0015i\u0016\r\u001b:x!\tqv,D\u0001\r\u0013\t\u0001GBA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003c\r\u0001\u00071-A\u0004tc2\u001cuN\u001c4\u0011\u0005\u00114W\"A3\u000b\u0005\u0005\u0002\u0012BA4f\u0005\u001d\u0019\u0016\u000bT\"p]\u001aDQ!\u001b\u0004A\u0002)\f1A[8c!\tY\u0007/D\u0001m\u0015\tig.A\u0005nCB\u0014X\rZ;dK*\u0011q\u000eF\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ed'a\u0001&pE\")1O\u0002a\u0001i\u00069q\u000e\u001d;j_:\u001c\b\u0003\u0002\u001bvgMJ!A\u001e\u001e\u0003\u00075\u000b\u0007\u000fC\u0003y\r\u0001\u0007\u00110\u0001\u0006eCR\f7k\u00195f[\u0006\u0004\"A\u0011>\n\u0005m\u001c%AC*ueV\u001cG\u000fV=qK\u0002")
public class ParquetWriteBuilder
extends FileWriteBuilder
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sqlConf.writeLegacyParquetFormat())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if (!(jobSummaryLevel != null ? !jobSummaryLevel.equals(jobSummaryLevel2) : jobSummaryLevel2 != null) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public ParquetWriteBuilder(Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType, LogicalWriteInfo info) {
        super(paths, formatName, supportsDataType, info);
        Logging.$init$((Logging)this);
    }
}

