/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.execution.HiveResult;
import org.apache.spark.sql.execution.HiveResult$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.VariableSubstitution;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmf!B\u001a5\u0001Y\u0002\u0005\u0002\u0003,\u0001\u0005\u000b\u0007I\u0011\u0001-\t\u0011u\u0003!\u0011!Q\u0001\neC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"A1\u000f\u0001B\u0001B\u0003%A\u000f\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\t\u0019\u0001\u0001B\u0001B\u0003%\u0011Q\u0001\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0003\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)\u0003C\u0004\u0002(\u0001\u0001\u000b\u0011\u00024\t\u0017\u0005%\u0002\u00011AA\u0002\u0013%\u00111\u0006\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0005C\u0006\u0002Z\u0001\u0001\r\u0011!Q!\n\u00055\u0002bCA.\u0001\u0001\u0007\t\u0019!C\u0005\u0003;B1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002t!Y\u0011q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA0\u0011%\tI\b\u0001a\u0001\n\u0013\ty\u0002C\u0005\u0002|\u0001\u0001\r\u0011\"\u0003\u0002~!A\u0011\u0011\u0011\u0001!B\u0013\t)\u0001C\u0005\u0002\u0004\u0002\u0001\r\u0011\"\u0003\u0002 !I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\t\u0003\u0017\u0003\u0001\u0015)\u0003\u0002\u0006!Y\u0011Q\u0012\u0001A\u0002\u0003\u0007I\u0011BAH\u0011-\t\t\u000b\u0001a\u0001\u0002\u0004%I!a)\t\u0017\u0005\u001d\u0006\u00011A\u0001B\u0003&\u0011\u0011\u0013\u0005\f\u0003S\u0003\u0001\u0019!a\u0001\n\u0013\tY\u000bC\u0006\u0002<\u0002\u0001\r\u00111A\u0005\n\u0005u\u0006bCAa\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[C!\"a1\u0001\u0011\u000b\u0007I\u0011BAc\u0011\u001d\ty\r\u0001C\u0001\u0003#DqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003.\u0001!IAa\f\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!\u0011\b\u0001\u0005B\tm\u0002b\u0002B\u001f\u0001\u0011%!1\b\u0005\b\u0005\u007f\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011\t\u0005\u0001C!\u0005wAqAa\u0011\u0001\t#\u0012Y\u0004\u0003\u0007\u0003F\u0001\u0001\n\u0011!A\u0001\n\u0003\u00119\u0005\u0003\u0007\u0003R\u0001\u0001\n\u0011!A\u0001\n\u0003\u0011\u0019\u0006\u0003\u0007\u0003d\u0001\u0001\n\u0011!A\u0001\n\u0003\u0011)\u0007\u0003\u0007\u0003p\u0001\u0001\n\u0011!A\u0001\n\u0003\u0011\t\b\u0003\u0007\u0003\u0002\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011\u0019i\u0002\u0005\u0003\bRB\tA\u000eBE\r\u001d\u0019D\u0007#\u00017\u0005\u0017Cq!a\u00030\t\u0003\u0011\u0019\nC\u0004\u0003\u0016>\"\tAa&\t\u0013\t\rv&%A\u0005\u0002\t\u0015&AH*qCJ\\W\t_3dkR,7\u000b^1uK6,g\u000e^(qKJ\fG/[8o\u0015\t)d'\u0001\u0007uQJLg\r^:feZ,'O\u0003\u00028q\u0005!\u0001.\u001b<f\u0015\tI$(A\u0002tc2T!a\u000f\u001f\u0002\u000bM\u0004\u0018M]6\u000b\u0005ur\u0014AB1qC\u000eDWMC\u0001@\u0003\ry'oZ\n\u0005\u0001\u0005c\u0005\u000b\u0005\u0002C\u00156\t1I\u0003\u0002E\u000b\u0006Iq\u000e]3sCRLwN\u001c\u0006\u0003\r\u001e\u000b1a\u00197j\u0015\tA\u0015*A\u0004tKJ4\u0018nY3\u000b\u0005]b\u0014BA&D\u0005e)\u00050Z2vi\u0016\u001cF/\u0019;f[\u0016tGo\u00149fe\u0006$\u0018n\u001c8\u0011\u00055sU\"\u0001\u001b\n\u0005=#$AD*qCJ\\w\n]3sCRLwN\u001c\t\u0003#Rk\u0011A\u0015\u0006\u0003'j\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003+J\u0013q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u0001Z!\tQ6,D\u00019\u0013\ta\u0006H\u0001\u0006T#2\u001buN\u001c;fqR\f1b]9m\u0007>tG/\u001a=uA\u0005i\u0001/\u0019:f]R\u001cVm]:j_:\u0004\"\u0001Y2\u000e\u0003\u0005T!AY#\u0002\u000fM,7o]5p]&\u0011A-\u0019\u0002\f\u0011&4XmU3tg&|g.A\u0005ti\u0006$X-\\3oiB\u0011q\r\u001d\b\u0003Q:\u0004\"!\u001b7\u000e\u0003)T!a[,\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0017!B:dC2\f\u0017BA8m\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=d\u0017aC2p]\u001a|e/\u001a:mCf\u0004B!\u001e>gM6\taO\u0003\u0002xq\u0006!Q\u000f^5m\u0015\u0005I\u0018\u0001\u00026bm\u0006L!a\u001f<\u0003\u00075\u000b\u0007/A\bsk:LeNQ1dW\u001e\u0014x.\u001e8e!\tqx0D\u0001m\u0013\r\t\t\u0001\u001c\u0002\b\u0005>|G.Z1o\u00031\tX/\u001a:z)&lWm\\;u!\rq\u0018qA\u0005\u0004\u0003\u0013a'\u0001\u0002'p]\u001e\fa\u0001P5oSRtDCDA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111\u0004\t\u0003\u001b\u0002AQA\u0016\u0005A\u0002eCQA\u0018\u0005A\u0002}CQ!\u001a\u0005A\u0002\u0019DQa\u001d\u0005A\u0002QDq\u0001 \u0005\u0011\u0002\u0003\u0007Q\u0010C\u0004\u0002\u0004!\u0001\r!!\u0002\u0002\u000fQLW.Z8viV\u0011\u0011QA\u0001\ti&lWm\\;uA\u0005!2/\u001e2ti&$X\u000f^8s'R\fG/Z7f]R,\u0012AZ\u0001\u0016gV\u00147\u000f^5ukR|'o\u0015;bi\u0016lWM\u001c;!\u0003\u0019\u0011Xm];miV\u0011\u0011Q\u0006\t\u0005\u0003_\t)E\u0004\u0003\u00022\u0005\u0005c\u0002BA\u001a\u0003\u007fqA!!\u000e\u0002>9!\u0011qGA\u001e\u001d\rI\u0017\u0011H\u0005\u0002\u007f%\u0011QHP\u0005\u0003wqJ!!\u000f\u001e\n\u0007\u0005\r\u0003(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a\u00119\u0003)\u0011Xm];mi~#S-\u001d\u000b\u0005\u0003\u001f\n)\u0006E\u0002\u007f\u0003#J1!a\u0015m\u0005\u0011)f.\u001b;\t\u0013\u0005]c\"!AA\u0002\u00055\u0012a\u0001=%c\u00059!/Z:vYR\u0004\u0013A\u0003:fgVdG\u000fT5tiV\u0011\u0011q\f\t\u0006}\u0006\u0005\u0014QM\u0005\u0004\u0003Gb'AB(qi&|g\u000eE\u0003\u007f\u0003O\nY'C\u0002\u0002j1\u0014Q!\u0011:sCf\u00042AWA7\u0013\r\ty\u0007\u000f\u0002\u0004%><\u0018A\u0004:fgVdG\u000fT5ti~#S-\u001d\u000b\u0005\u0003\u001f\n)\bC\u0005\u0002XE\t\t\u00111\u0001\u0002`\u0005Y!/Z:vYRd\u0015n\u001d;!\u0003Y\u0001(/\u001a<j_V\u001ch)\u001a;dQ\u0016sGm\u00144gg\u0016$\u0018A\u00079sKZLw.^:GKR\u001c\u0007.\u00128e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA(\u0003\u007fB\u0011\"a\u0016\u0015\u0003\u0003\u0005\r!!\u0002\u0002/A\u0014XM^5pkN4U\r^2i\u000b:$wJ\u001a4tKR\u0004\u0013\u0001\u00079sKZLw.^:GKR\u001c\u0007n\u0015;beR|eMZ:fi\u0006a\u0002O]3wS>,8OR3uG\"\u001cF/\u0019:u\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA(\u0003\u0013C\u0011\"a\u0016\u0018\u0003\u0003\u0005\r!!\u0002\u00023A\u0014XM^5pkN4U\r^2i'R\f'\u000f^(gMN,G\u000fI\u0001\u0005SR,'/\u0006\u0002\u0002\u0012B1\u00111SAN\u0003WrA!!&\u0002\u001a:\u0019\u0011.a&\n\u00035L1!a\u0011m\u0013\u0011\ti*a(\u0003\u0011%#XM]1u_JT1!a\u0011m\u0003!IG/\u001a:`I\u0015\fH\u0003BA(\u0003KC\u0011\"a\u0016\u001b\u0003\u0003\u0005\r!!%\u0002\u000b%$XM\u001d\u0011\u0002\u0013\u0011\fG/\u0019+za\u0016\u001cXCAAW!\u0015q\u0018qMAX!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[q\u0005)A/\u001f9fg&!\u0011\u0011XAZ\u0005!!\u0015\r^1UsB,\u0017!\u00043bi\u0006$\u0016\u0010]3t?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0005}\u0006\"CA,;\u0005\u0005\t\u0019AAW\u0003)!\u0017\r^1UsB,7\u000fI\u0001\re\u0016\u001cX\u000f\u001c;TG\",W.Y\u000b\u0003\u0003\u000f\u0004B!!3\u0002L6\tQ)C\u0002\u0002N\u0016\u00131\u0002V1cY\u0016\u001c6\r[3nC\u0006)\u0012\r\u001a3O_:tU\u000f\u001c7D_2,XN\u001c,bYV,GCCA(\u0003'\f9.!=\u0002|\"9\u0011Q\u001b\u0011A\u0002\u0005-\u0014\u0001\u00024s_6Dq!!7!\u0001\u0004\tY.\u0001\u0002u_B1\u0011Q\\At\u0003Wl!!a8\u000b\t\u0005\u0005\u00181]\u0001\b[V$\u0018M\u00197f\u0015\r\t)\u000f\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAu\u0003?\u00141\"\u0011:sCf\u0014UO\u001a4feB\u0019a0!<\n\u0007\u0005=HNA\u0002B]fDq!a=!\u0001\u0004\t)0A\u0004pe\u0012Lg.\u00197\u0011\u0007y\f90C\u0002\u0002z2\u00141!\u00138u\u0011\u001d\ti\u0010\ta\u0001\u0003\u007f\fa\u0002^5nK\u001a{'/\\1ui\u0016\u00148\u000f\u0005\u0003\u0003\u0002\t=a\u0002\u0002B\u0002\u0005\u0013qA!!\r\u0003\u0006%\u0019!q\u0001\u001d\u0002\u0013\u0015DXmY;uS>t\u0017\u0002\u0002B\u0006\u0005\u001b\t!\u0002S5wKJ+7/\u001e7u\u0015\r\u00119\u0001O\u0005\u0005\u0005#\u0011\u0019B\u0001\bUS6,gi\u001c:nCR$XM]:\u000b\t\t-!QB\u0001\u000eO\u0016$h*\u001a=u%><8+\u001a;\u0015\r\te!q\u0004B\u0015!\u0011\tIMa\u0007\n\u0007\tuQI\u0001\u0004S_^\u001cV\r\u001e\u0005\b\u0005C\t\u0003\u0019\u0001B\u0012\u0003\u0015y'\u000fZ3s!\u0011\tIM!\n\n\u0007\t\u001dRI\u0001\tGKR\u001c\u0007n\u0014:jK:$\u0018\r^5p]\"9!1F\u0011A\u0002\u0005\u0015\u0011\u0001C7bqJ{wo\u001d'\u0002+\u001d,GOT3yiJ{woU3u\u0013:$XM\u001d8bYR1!\u0011\u0004B\u0019\u0005gAqA!\t#\u0001\u0004\u0011\u0019\u0003C\u0004\u0003,\t\u0002\r!!\u0002\u0002%\u001d,GOU3tk2$8+\u001a;TG\",W.\u0019\u000b\u0003\u0003\u000f\f1B];o\u0013:$XM\u001d8bYR\u0011\u0011qJ\u0001\bKb,7-\u001e;f\u00035!\u0018.\\3pkR\u001c\u0015M\\2fY\u000611-\u00198dK2\fqa\u00197fC:,\b/A\u0015qe>$Xm\u0019;fI\u00122\u0018\r\\5eCR,G)\u001a4bk2$h)\u001a;dQ>\u0013\u0018.\u001a8uCRLwN\u001c\u000b\u0005\u0005\u0013\u0012y\u0005\u0006\u0003\u0002P\t-\u0003b\u0002B'S\u0001\u0007!1E\u0001\f_JLWM\u001c;bi&|g\u000eC\u0005\u0002X%\n\t\u00111\u0001\u0002\u0010\u0005)\u0002O]8uK\u000e$X\r\u001a\u0013bgN,'\u000f^*uCR,G\u0003\u0002B+\u0005C\"B!a\u0014\u0003X!9!\u0011\f\u0016A\u0002\tm\u0013!B:uCR,\u0007\u0003BAe\u0005;J1Aa\u0018F\u00059y\u0005/\u001a:bi&|gn\u0015;bi\u0016D\u0011\"a\u0016+\u0003\u0003\u0005\r!a\u0004\u00023A\u0014x\u000e^3di\u0016$Ge]3u\u0011\u0006\u001c(+Z:vYR\u001cV\r\u001e\u000b\u0005\u0005O\u0012i\u0007\u0006\u0003\u0002P\t%\u0004B\u0002B6W\u0001\u0007Q0\u0001\u0007iCN\u0014Vm];miN+G\u000fC\u0005\u0002X-\n\t\u00111\u0001\u0002\u0010\u0005y\u0002O]8uK\u000e$X\r\u001a\u0013tKR|\u0005/\u001a:bi&|g.\u0012=dKB$\u0018n\u001c8\u0015\t\tM$q\u0010\u000b\u0005\u0003\u001f\u0012)\bC\u0004\u0003x1\u0002\rA!\u001f\u0002%=\u0004XM]1uS>tW\t_2faRLwN\u001c\t\u0005\u0003\u0013\u0014Y(C\u0002\u0003~\u0015\u0013\u0001\u0003S5wKN\u000bF*\u0012=dKB$\u0018n\u001c8\t\u0013\u0005]C&!AA\u0002\u0005=\u0011!\n9s_R,7\r^3eII,w-[:uKJ\u001cUO\u001d:f]R|\u0005/\u001a:bi&|g\u000eT8h)\u0011\u0011YD!\"\t\u0013\u0005]S&!AA\u0002\u0005=\u0011AH*qCJ\\W\t_3dkR,7\u000b^1uK6,g\u000e^(qKJ\fG/[8o!\tiufE\u00020\u0005\u001b\u00032A BH\u0013\r\u0011\t\n\u001c\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t%\u0015AD4fiR\u000b'\r\\3TG\",W.\u0019\u000b\u0005\u0003\u000f\u0014I\nC\u0004\u0003\u001cF\u0002\rA!(\u0002\u0015M$(/^2u)f\u0004X\r\u0005\u0003\u00022\n}\u0015\u0002\u0002BQ\u0003g\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\u0015\u0016\u0004{\n%6F\u0001BV!\u0011\u0011iKa.\u000e\u0005\t=&\u0002\u0002BY\u0005g\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tUF.\u0001\u0006b]:|G/\u0019;j_:LAA!/\u00030\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SparkExecuteStatementOperation
extends ExecuteStatementOperation
implements SparkOperation {
    private TableSchema resultSchema;
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String statement;
    private final boolean runInBackground;
    private final long org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout;
    private final String substitutorStatement;
    private Dataset<Row> result;
    private Option<Row[]> resultList;
    private long previousFetchEndOffset;
    private long previousFetchStartOffset;
    private Iterator<Row> iter;
    private DataType[] dataTypes;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return SparkExecuteStatementOperation$.MODULE$.$lessinit$greater$default$5();
    }

    public static TableSchema getTableSchema(StructType structType) {
        return SparkExecuteStatementOperation$.MODULE$.getTableSchema(structType);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public /* synthetic */ OperationState org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$setState(OperationState newState) {
        return super.setState(newState);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    @Override
    public PartialFunction<Throwable, BoxedUnit> onError() {
        return SparkOperation.onError$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ void protected$validateDefaultFetchOrientation(SparkExecuteStatementOperation x$1, FetchOrientation orientation) {
        x$1.validateDefaultFetchOrientation(orientation);
    }

    public /* synthetic */ void protected$assertState(SparkExecuteStatementOperation x$1, OperationState state) {
        x$1.assertState(state);
    }

    public /* synthetic */ void protected$setHasResultSet(SparkExecuteStatementOperation x$1, boolean hasResultSet) {
        x$1.setHasResultSet(hasResultSet);
    }

    public /* synthetic */ void protected$setOperationException(SparkExecuteStatementOperation x$1, HiveSQLException operationException) {
        x$1.setOperationException(operationException);
    }

    public /* synthetic */ void protected$registerCurrentOperationLog(SparkExecuteStatementOperation x$1) {
        x$1.registerCurrentOperationLog();
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public long org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout;
    }

    private String substitutorStatement() {
        return this.substitutorStatement;
    }

    private Dataset<Row> result() {
        return this.result;
    }

    private void result_$eq(Dataset<Row> x$1) {
        this.result = x$1;
    }

    private Option<Row[]> resultList() {
        return this.resultList;
    }

    private void resultList_$eq(Option<Row[]> x$1) {
        this.resultList = x$1;
    }

    private long previousFetchEndOffset() {
        return this.previousFetchEndOffset;
    }

    private void previousFetchEndOffset_$eq(long x$1) {
        this.previousFetchEndOffset = x$1;
    }

    private long previousFetchStartOffset() {
        return this.previousFetchStartOffset;
    }

    private void previousFetchStartOffset_$eq(long x$1) {
        this.previousFetchStartOffset = x$1;
    }

    private Iterator<Row> iter() {
        return this.iter;
    }

    private void iter_$eq(Iterator<Row> x$1) {
        this.iter = x$1;
    }

    private DataType[] dataTypes() {
        return this.dataTypes;
    }

    private void dataTypes_$eq(DataType[] x$1) {
        this.dataTypes = x$1;
    }

    private TableSchema resultSchema$lzycompute() {
        SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
        synchronized (sparkExecuteStatementOperation) {
            if (!this.bitmap$0) {
                TableSchema tableSchema;
                if (this.result() == null || this.result().schema().isEmpty()) {
                    tableSchema = new TableSchema(Arrays.asList((Object[])new FieldSchema[]{new FieldSchema("Result", "string", "")}));
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Result Schema: ").append(this.result().schema()).toString());
                    tableSchema = SparkExecuteStatementOperation$.MODULE$.getTableSchema(this.result().schema());
                }
                this.resultSchema = tableSchema;
                this.bitmap$0 = true;
            }
        }
        return this.resultSchema;
    }

    private TableSchema resultSchema() {
        return !this.bitmap$0 ? this.resultSchema$lzycompute() : this.resultSchema;
    }

    public void addNonNullColumnValue(Row from, ArrayBuffer<Object> to, int ordinal, HiveResult.TimeFormatters timeFormatters) {
        DataType dataType = this.dataTypes()[ordinal];
        if (StringType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)from.getString(ordinal));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToInteger((int)from.getInt(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)from.getBoolean(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToDouble((double)from.getDouble(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToFloat((float)from.getFloat(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            to.$plus$eq((Object)from.getDecimal(ordinal));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LongType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToLong((long)from.getLong(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToByte((byte)from.getByte(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToShort((short)from.getShort(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            to.$plus$eq(from.getAs(ordinal));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = dataType instanceof DateType ? true : dataType instanceof TimestampType;
            if (bl) {
                to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.get(ordinal), (Object)this.dataTypes()[ordinal]), false, timeFormatters));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.getAs(ordinal), (Object)CalendarIntervalType$.MODULE$), false, timeFormatters));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = dataType instanceof ArrayType ? true : (dataType instanceof StructType ? true : (dataType instanceof MapType ? true : dataType instanceof UserDefinedType));
                if (bl2) {
                    to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.get(ordinal), (Object)this.dataTypes()[ordinal]), false, timeFormatters));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation order, long maxRowsL) {
        return (RowSet)this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> {
            RowSet rowSet;
            try {
                SparkContext qual$1 = this.sqlContext().sparkContext();
                String x$1 = this.statementId();
                String x$2 = this.substitutorStatement();
                boolean x$3 = qual$1.setJobGroup$default$3();
                qual$1.setJobGroup(x$1, x$2, x$3);
                rowSet = this.getNextRowSetInternal(order, maxRowsL);
            }
            finally {
                this.sqlContext().sparkContext().clearJobGroup();
            }
            return rowSet;
        });
    }

    private RowSet getNextRowSetInternal(FetchOrientation order, long maxRowsL) {
        return (RowSet)this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> {
            RowSet rowSet;
            long l;
            this.log().info(new StringBuilder(57).append("Received getNextRowSet request order=").append((Object)order).append(" and maxRowsL=").append(maxRowsL).append(" ").append("with ").append(this.statementId()).toString());
            this.protected$validateDefaultFetchOrientation(this, order);
            this.protected$assertState(this, OperationState.FINISHED);
            this.protected$setHasResultSet(this, true);
            RowSet resultRowSet = RowSetFactory.create(this.getResultSetSchema(), this.getProtocolVersion(), false);
            if ((order.equals((Object)FetchOrientation.FETCH_FIRST) || order.equals((Object)FetchOrientation.FETCH_PRIOR)) && this.previousFetchEndOffset() != 0L) {
                Iterator iterator;
                if (new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf(SQLConf$.MODULE$.THRIFTSERVER_INCREMENTAL_COLLECT().key()))).toBoolean()) {
                    this.resultList_$eq((Option<Row[]>)None$.MODULE$);
                    iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.result().toLocalIterator()).asScala();
                } else {
                    if (this.resultList().isEmpty()) {
                        this.resultList_$eq((Option<Row[]>)new Some(this.result().collect()));
                    }
                    iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.resultList().get())).iterator();
                }
                this.iter_$eq((Iterator<Row>)iterator);
            }
            if (order.equals((Object)FetchOrientation.FETCH_FIRST)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("FETCH_FIRST request with ").append(this.statementId()).append(". Resetting to resultOffset=0").toString());
                l = 0;
            } else if (order.equals((Object)FetchOrientation.FETCH_PRIOR)) {
                long targetOffset = package$.MODULE$.max(this.previousFetchStartOffset() - maxRowsL, 0L);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("FETCH_PRIOR request with ").append(this.statementId()).append(". Resetting to resultOffset=").append(targetOffset).toString());
                int off = 0;
                while ((long)off < targetOffset && this.iter().hasNext()) {
                    this.iter().next();
                    ++off;
                }
                l = off;
            } else {
                l = this.previousFetchEndOffset();
            }
            long resultOffset = l;
            resultRowSet.setStartOffset(resultOffset);
            this.previousFetchStartOffset_$eq(resultOffset);
            if (!this.iter().hasNext()) {
                rowSet = resultRowSet;
            } else {
                HiveResult.TimeFormatters timeFormatters = HiveResult$.MODULE$.getTimeFormatters();
                int maxRows = (int)maxRowsL;
                int curRow = 0;
                while (curRow < maxRows && this.iter().hasNext()) {
                    Row sparkRow = (Row)this.iter().next();
                    ArrayBuffer row = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    for (int curCol = 0; curCol < sparkRow.length(); ++curCol) {
                        ArrayBuffer arrayBuffer;
                        if (sparkRow.isNullAt(curCol)) {
                            arrayBuffer = row.$plus$eq(null);
                            continue;
                        }
                        this.addNonNullColumnValue(sparkRow, (ArrayBuffer<Object>)row, curCol, timeFormatters);
                        arrayBuffer = BoxedUnit.UNIT;
                    }
                    resultRowSet.addRow((Object[])row.toArray(ClassTag$.MODULE$.Any()));
                    ++curRow;
                    ++resultOffset;
                }
                this.previousFetchEndOffset_$eq(resultOffset);
                this.log().info(new StringBuilder(55).append("Returning result set with ").append(curRow).append(" rows from offsets ").append("[").append(this.previousFetchStartOffset()).append(", ").append(this.previousFetchEndOffset()).append(") with ").append(this.statementId()).toString());
                rowSet = resultRowSet;
            }
            return rowSet;
        });
    }

    @Override
    public TableSchema getResultSetSchema() {
        return this.resultSchema();
    }

    @Override
    public void runInternal() {
        Object object;
        this.setState(OperationState.PENDING);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Submitting query '").append($this.statement).append("' with ").append(this.statementId()).toString());
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), this.statement, this.statementId(), this.parentSession.getUsername());
        this.setHasResultSet(true);
        if (this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout() > 0L) {
            ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
            object = timeoutExecutor.schedule(new Runnable(this, timeoutExecutor){
                private final /* synthetic */ SparkExecuteStatementOperation $outer;
                private final ScheduledExecutorService timeoutExecutor$1;

                public void run() {
                    block6: {
                        try {
                            try {
                                this.$outer.timeoutCancel();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option.isEmpty()) {
                                    Throwable e = (Throwable)option.get();
                                    this.$outer.protected$setOperationException(this.$outer, new HiveSQLException(e));
                                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Error cancelling the query after timeout: ").append($this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout()).append(" seconds").toString());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            this.timeoutExecutor$1.shutdown();
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeoutExecutor$1 = timeoutExecutor$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$1 )}, serializedLambda);
                }
            }, this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout(), TimeUnit.SECONDS);
        } else {
            object = BoxedUnit.UNIT;
        }
        if (!this.runInBackground) {
            this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute();
        } else {
            UserGroupInformation sparkServiceUGI = Utils.getUGI();
            Runnable backgroundOperation = new Runnable(this, sparkServiceUGI){
                private final /* synthetic */ SparkExecuteStatementOperation $outer;
                private final UserGroupInformation sparkServiceUGI$1;

                public void run() {
                    PrivilegedExceptionAction<BoxedUnit> doAsAction = new PrivilegedExceptionAction<BoxedUnit>(this){
                        private final /* synthetic */ $anon$2 $outer;

                        public void run() {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().protected$registerCurrentOperationLog(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer());
                            try {
                                this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().withLocalProperties((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute());
                            }
                            catch (HiveSQLException e) {
                                this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().protected$setOperationException(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer(), e);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$2$$anon$3 )}, serializedLambda);
                        }
                    };
                    try {
                        this.sparkServiceUGI$1.doAs((PrivilegedExceptionAction)doAsAction);
                    }
                    catch (Exception e) {
                        this.$outer.protected$setOperationException(this.$outer, new HiveSQLException(e));
                        this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error running hive query as user : ").append($this.sparkServiceUGI$1.getShortUserName()).toString(), e);
                    }
                }

                public /* synthetic */ SparkExecuteStatementOperation org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sparkServiceUGI$1 = sparkServiceUGI$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$2 )}, serializedLambda);
                }
            };
            try {
                Future<?> backgroundHandle = this.parentSession.getSessionManager().submitBackgroundOperation(backgroundOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof RejectedExecutionException) {
                    RejectedExecutionException rejectedExecutionException = (RejectedExecutionException)throwable2;
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error submitting query in background, query rejected", rejectedExecutionException);
                    this.setState(OperationState.ERROR);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), rejectedExecutionException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)rejectedExecutionException));
                    throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejectedExecutionException);
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error executing query in background", e);
                    this.setState(OperationState.ERROR);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), e.getMessage(), Utils$.MODULE$.exceptionString(e));
                    throw new HiveSQLException(e);
                }
                throw throwable;
            }
        }
    }

    public void org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute() {
        block29: {
            block28: {
                try {
                    try {
                        Iterator iterator;
                        block27: {
                            SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
                            synchronized (sparkExecuteStatementOperation) {
                                block26: {
                                    if (this.getStatus().getState().isTerminal()) {
                                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Query with ").append(this.statementId()).append(" in terminal state before it started running").toString());
                                        break block26;
                                    }
                                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running query with ").append(this.statementId()).toString());
                                    this.setState(OperationState.RUNNING);
                                    break block27;
                                }
                                break block28;
                            }
                        }
                        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
                        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
                        if (!this.runInBackground) {
                            this.parentSession.getSessionState().getConf().setClassLoader((ClassLoader)executionHiveClassLoader);
                        }
                        SparkContext qual$1 = this.sqlContext().sparkContext();
                        String x$12 = this.statementId();
                        String x$2 = this.substitutorStatement();
                        boolean x$3 = qual$1.setJobGroup$default$3();
                        qual$1.setJobGroup(x$12, x$2, x$3);
                        this.result_$eq((Dataset<Row>)this.sqlContext().sql(this.statement));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.result().queryExecution().toString());
                        HiveThriftServer2$.MODULE$.eventManager().onStatementParsed(this.statementId(), this.result().queryExecution().toString());
                        if (new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf(SQLConf$.MODULE$.THRIFTSERVER_INCREMENTAL_COLLECT().key()))).toBoolean()) {
                            this.resultList_$eq((Option<Row[]>)None$.MODULE$);
                            iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.result().toLocalIterator()).asScala();
                        } else {
                            this.resultList_$eq((Option<Row[]>)new Some(this.result().collect()));
                            iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.resultList().get())).iterator();
                        }
                        this.iter_$eq((Iterator<Row>)iterator);
                        this.dataTypes_$eq((DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.result().schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
                        break block29;
                    }
                    catch (Throwable e) {
                        OperationState currentState;
                        if (this.statementId() != null) {
                            this.sqlContext().sparkContext().cancelJobGroup(this.statementId());
                        }
                        if ((currentState = this.getStatus().getState()).isTerminal()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Ignore exception in terminal state with ").append(this.statementId()).append(": ").append(e).toString());
                            break block29;
                        }
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error executing query with ").append(this.statementId()).append(", currentState ").append((Object)currentState).append(", ").toString(), e);
                        this.setState(OperationState.ERROR);
                        HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), e.getMessage(), Utils$.MODULE$.exceptionString(e));
                        Throwable throwable = e;
                        if (throwable instanceof HiveSQLException) {
                            throw e;
                        }
                        throw new HiveSQLException(new StringBuilder(21).append("Error running query: ").append(e.toString()).toString(), e);
                    }
                }
                catch (Throwable throwable) {
                    SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
                    synchronized (sparkExecuteStatementOperation) {
                        if (!this.getStatus().getState().isTerminal()) {
                            this.setState(OperationState.FINISHED);
                            HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
                        }
                    }
                    this.sqlContext().sparkContext().clearJobGroup();
                    throw throwable;
                }
            }
            SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
            synchronized (sparkExecuteStatementOperation) {
                if (!this.getStatus().getState().isTerminal()) {
                    this.setState(OperationState.FINISHED);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
                }
            }
            this.sqlContext().sparkContext().clearJobGroup();
            return;
        }
        SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
        synchronized (sparkExecuteStatementOperation) {
            if (!this.getStatus().getState().isTerminal()) {
                this.setState(OperationState.FINISHED);
                HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
            }
        }
        this.sqlContext().sparkContext().clearJobGroup();
    }

    public synchronized void timeoutCancel() {
        block0: {
            if (this.getStatus().getState().isTerminal()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Query with ").append(this.statementId()).append(" timed out after ").append(this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout()).append(" seconds").toString());
            this.setState(OperationState.TIMEDOUT);
            this.cleanup();
            HiveThriftServer2$.MODULE$.eventManager().onStatementTimeout(this.statementId());
        }
    }

    @Override
    public synchronized void cancel() {
        block0: {
            if (this.getStatus().getState().isTerminal()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Cancel query with ").append(this.statementId()).toString());
            this.setState(OperationState.CANCELED);
            this.cleanup();
            HiveThriftServer2$.MODULE$.eventManager().onStatementCanceled(this.statementId());
        }
    }

    @Override
    public void cleanup() {
        block0: {
            Future<?> backgroundHandle;
            Object object = this.runInBackground ? ((backgroundHandle = this.getBackgroundHandle()) != null ? BoxesRunTime.boxToBoolean((boolean)backgroundHandle.cancel(true)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            if (this.statementId() == null) break block0;
            this.sqlContext().sparkContext().cancelJobGroup(this.statementId());
        }
    }

    public SparkExecuteStatementOperation(SQLContext sqlContext, HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.statement = statement;
        this.runInBackground = runInBackground;
        super(parentSession, statement, confOverlay, runInBackground);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
        long globalTimeout = BoxesRunTime.unboxToLong((Object)sqlContext.conf().getConf(SQLConf$.MODULE$.THRIFTSERVER_QUERY_TIMEOUT()));
        this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout = globalTimeout > 0L && (queryTimeout <= 0L || globalTimeout < queryTimeout) ? globalTimeout : queryTimeout;
        this.substitutorStatement = (String)SQLConf$.MODULE$.withExistingConf(sqlContext.conf(), (Function0 & Serializable & scala.Serializable)() -> new VariableSubstitution().substitute($this.statement));
        this.previousFetchEndOffset = 0L;
        this.previousFetchStartOffset = 0L;
    }
}

