/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.GetLocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.LocalDirsForExecutors;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0006\r\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003>\u0001\u0011\u0005a\bC\u0004E\u0001\t\u0007I\u0011B#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u001d\tI\u0003\u0001C!\u0003W\u00111CT3uif\u0014En\\2l%B\u001c7+\u001a:wKJT!!\u0004\b\u0002\u000b9,G\u000f^=\u000b\u0005=\u0001\u0012a\u00028fi^|'o\u001b\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\u00111DD\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005uQ\"A\u0003*qG\"\u000bg\u000e\u001a7feB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005E\u0001\tS:$XM\u001d8bY&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u0015\t\u0007\u000f]%e!\t1sF\u0004\u0002([A\u0011\u0001fK\u0007\u0002S)\u0011!FF\u0001\u0007yI|w\u000e\u001e \u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-\n!b]3sS\u0006d\u0017N_3s!\t!d'D\u00016\u0015\t\u0011\u0004#\u0003\u00028k\tQ1+\u001a:jC2L'0\u001a:\u0002\u0019\tdwnY6NC:\fw-\u001a:\u0011\u0005iZT\"\u0001\b\n\u0005qr!\u0001\u0005\"m_\u000e\\G)\u0019;b\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q!q(\u0011\"D!\t\u0001\u0005!D\u0001\r\u0011\u0015!C\u00011\u0001&\u0011\u0015\u0011D\u00011\u00014\u0011\u0015AD\u00011\u0001:\u00035\u0019HO]3b[6\u000bg.Y4feV\ta\t\u0005\u0002\u001a\u000f&\u0011\u0001J\u0007\u0002\u0017\u001f:,gi\u001c:P]\u0016\u001cFO]3b[6\u000bg.Y4fe\u0006q1\u000f\u001e:fC6l\u0015M\\1hKJ\u0004\u0013a\u0002:fG\u0016Lg/\u001a\u000b\u0005\u0019B;\u0016\r\u0005\u0002N\u001d6\t1&\u0003\u0002PW\t!QK\\5u\u0011\u0015\tv\u00011\u0001S\u0003\u0019\u0019G.[3oiB\u00111+V\u0007\u0002)*\u0011\u0011KD\u0005\u0003-R\u0013q\u0002\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\u0005\u00061\u001e\u0001\r!W\u0001\u000beB\u001cW*Z:tC\u001e,\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\rq\u0017n\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0006CsR,')\u001e4gKJDQAY\u0004A\u0002\r\fqB]3ta>t7/Z\"p]R,\u0007\u0010\u001e\t\u0003'\u0012L!!\u001a+\u0003'I\u00038MU3ta>t7/Z\"bY2\u0014\u0017mY6\u0002\u001bI,7-Z5wKN#(/Z1n)\u0011A7\u000e\u001c8\u0011\u0005MK\u0017B\u00016U\u0005Q\u0019FO]3b[\u000e\u000bG\u000e\u001c2bG.<\u0016\u000e\u001e5J\t\")\u0011\u000b\u0003a\u0001%\")Q\u000e\u0003a\u00013\u0006iQ.Z:tC\u001e,\u0007*Z1eKJDQA\u0019\u0005A\u0002\r\f1\u0003Z3tKJL\u0017\r\\5{K6+G/\u00193bi\u0006,2!]A\u0004)\r\u0011\u0018\u0011\u0004\t\u0005\u001bN,80\u0003\u0002uW\t1A+\u001e9mKJ\u0002\"A^=\u000e\u0003]T!\u0001\u001f\t\u0002\u000fM$xN]1hK&\u0011!p\u001e\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\t\u0005y~\f\u0019!D\u0001~\u0015\tq8&A\u0004sK\u001adWm\u0019;\n\u0007\u0005\u0005QP\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\t)!a\u0002\r\u0001\u00119\u0011\u0011B\u0005C\u0002\u0005-!!\u0001+\u0012\t\u00055\u00111\u0003\t\u0004\u001b\u0006=\u0011bAA\tW\t9aj\u001c;iS:<\u0007cA'\u0002\u0016%\u0019\u0011qC\u0016\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u001c%\u0001\r!!\b\u0002\u00115,G/\u00193bi\u0006\u0004R!TA\u0010\u0003GI1!!\t,\u0005\u0015\t%O]1z!\ri\u0015QE\u0005\u0004\u0003OY#\u0001\u0002\"zi\u0016\f\u0001cZ3u'R\u0014X-Y7NC:\fw-\u001a:\u0015\u0005\u00055\u0002cA\r\u00020%\u0019\u0011\u0011\u0007\u000e\u0003\u001bM#(/Z1n\u001b\u0006t\u0017mZ3s\u0001")
public class NettyBlockRpcServer
extends RpcHandler
implements Logging {
    private final String appId;
    private final Serializer serializer;
    private final BlockDataManager blockManager;
    private final OneForOneStreamManager streamManager;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private OneForOneStreamManager streamManager() {
        return this.streamManager;
    }

    public void receive(TransportClient client, ByteBuffer rpcMessage, RpcResponseCallback responseContext) {
        BlockTransferMessage message = BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)rpcMessage);
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Received request: ").append(message).toString());
        BlockTransferMessage blockTransferMessage = message;
        if (blockTransferMessage instanceof OpenBlocks) {
            OpenBlocks openBlocks = (OpenBlocks)blockTransferMessage;
            int blocksNum = openBlocks.blockIds.length;
            IndexedSeq blocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), blocksNum).map((Function1 & Serializable & scala.Serializable)i -> NettyBlockRpcServer.$anonfun$receive$2(this, openBlocks, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            long streamId = this.streamManager().registerStream(this.appId, (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(blocks.iterator()).asJava(), client.getChannel());
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Registered streamId ").append(streamId).append(" with ").append(blocksNum).append(" buffers").toString());
            responseContext.onSuccess(new StreamHandle(streamId, blocksNum).toByteBuffer());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (blockTransferMessage instanceof FetchShuffleBlocks) {
            FetchShuffleBlocks fetchShuffleBlocks = (FetchShuffleBlocks)blockTransferMessage;
            ManagedBuffer[] blocks = (ManagedBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(fetchShuffleBlocks.mapIds)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> new ArrayOps.ofRef(NettyBlockRpcServer.$anonfun$receive$5(this, fetchShuffleBlocks, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ManagedBuffer.class)));
            int numBlockIds = fetchShuffleBlocks.batchFetchEnabled ? fetchShuffleBlocks.mapIds.length : BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fetchShuffleBlocks.reduceIds)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)NettyBlockRpcServer.$anonfun$receive$7(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            long streamId = this.streamManager().registerStream(this.appId, (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).iterator()).asJava(), client.getChannel());
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Registered streamId ").append(streamId).append(" with ").append(numBlockIds).append(" buffers").toString());
            responseContext.onSuccess(new StreamHandle(streamId, numBlockIds).toByteBuffer());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (blockTransferMessage instanceof UploadBlock) {
            BoxedUnit boxedUnit;
            UploadBlock uploadBlock = (UploadBlock)blockTransferMessage;
            Tuple2 tuple2 = this.deserializeMetadata(uploadBlock.metadata);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StorageLevel level = (StorageLevel)tuple2._1();
            ClassTag classTag = (ClassTag)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)level, (Object)classTag);
            Tuple2 tuple23 = tuple22;
            StorageLevel level2 = (StorageLevel)tuple23._1();
            ClassTag classTag2 = (ClassTag)tuple23._2();
            NioManagedBuffer data = new NioManagedBuffer(ByteBuffer.wrap(uploadBlock.blockData));
            BlockId blockId = BlockId$.MODULE$.apply(uploadBlock.blockId);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Receiving replicated block ").append(blockId).append(" with level ").append(level2).append(" ").append("from ").append(client.getSocketAddress()).toString());
            boolean blockStored = this.blockManager.putBlockData(blockId, (ManagedBuffer)data, level2, classTag2);
            if (blockStored) {
                responseContext.onSuccess(ByteBuffer.allocate(0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Exception exception = new Exception(new StringBuilder(110).append("Upload block for ").append(blockId).append(" failed. This mostly happens ").append("when there is not sufficient space available to store the block.").toString());
                responseContext.onFailure((Throwable)exception);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (blockTransferMessage instanceof GetLocalDirsForExecutors) {
            BoxedUnit boxedUnit;
            GetLocalDirsForExecutors getLocalDirsForExecutors = (GetLocalDirsForExecutors)blockTransferMessage;
            String string = getLocalDirsForExecutors.appId;
            String string2 = this.appId;
            boolean isIncorrectAppId = string == null ? string2 != null : !string.equals(string2);
            int execNum = getLocalDirsForExecutors.execIds.length;
            if (isIncorrectAppId || execNum != 1) {
                String errorMsg = new StringBuilder(42).append("Invalid GetLocalDirsForExecutors request: ").append((Object)(isIncorrectAppId ? new StringBuilder(27).append("incorrect application id: ").append(getLocalDirsForExecutors.appId).append(";").toString() : BoxedUnit.UNIT)).append((Object)(execNum != 1 ? new StringBuilder(41).append("incorrect executor number: ").append(execNum).append(" (expected 1);").toString() : BoxedUnit.UNIT)).toString();
                responseContext.onFailure((Throwable)new IllegalStateException(errorMsg));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                String actualExecId;
                String expectedExecId = ((BlockManager)this.blockManager).executorId();
                String string3 = actualExecId = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])getLocalDirsForExecutors.execIds)).head();
                String string4 = expectedExecId;
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    responseContext.onFailure((Throwable)new IllegalStateException(new StringBuilder(33).append("Invalid executor id: ").append(actualExecId).append(", expected ").append(expectedExecId).append(".").toString()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    responseContext.onSuccess(new LocalDirsForExecutors((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)actualExecId), (Object)this.blockManager.getLocalDiskDirs())}))).asJava()).toByteBuffer());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)blockTransferMessage);
        }
    }

    public StreamCallbackWithID receiveStream(TransportClient client, ByteBuffer messageHeader, RpcResponseCallback responseContext) {
        UploadBlockStream message = (UploadBlockStream)BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)messageHeader);
        Tuple2 tuple2 = this.deserializeMetadata(message.metadata);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StorageLevel level = (StorageLevel)tuple2._1();
        ClassTag classTag = (ClassTag)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)level, (Object)classTag);
        Tuple2 tuple23 = tuple22;
        StorageLevel level2 = (StorageLevel)tuple23._1();
        ClassTag classTag2 = (ClassTag)tuple23._2();
        BlockId blockId = BlockId$.MODULE$.apply(message.blockId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Receiving replicated block ").append(blockId).append(" with level ").append(level2).append(" as stream ").append("from ").append(client.getSocketAddress()).toString());
        return this.blockManager.putBlockDataAsStream(blockId, level2, classTag2);
    }

    private <T> Tuple2<StorageLevel, ClassTag<T>> deserializeMetadata(byte[] metadata) {
        return (Tuple2)this.serializer.newInstance().deserialize(ByteBuffer.wrap(metadata), ClassTag$.MODULE$.Nothing());
    }

    public StreamManager getStreamManager() {
        return this.streamManager();
    }

    public static final /* synthetic */ ManagedBuffer $anonfun$receive$2(NettyBlockRpcServer $this, OpenBlocks x2$1, int i) {
        BlockId blockId = BlockId$.MODULE$.apply(x2$1.blockIds[i]);
        Predef$.MODULE$.assert(!(blockId instanceof ShuffleBlockBatchId), (Function0 & Serializable & scala.Serializable)() -> "Continuous shuffle block fetching only works for new fetch protocol.");
        return $this.blockManager.getLocalBlockData(blockId);
    }

    public static final /* synthetic */ Object[] $anonfun$receive$5(NettyBlockRpcServer $this, FetchShuffleBlocks x3$1, Tuple2 x0$1) {
        Object[] objectArray;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long mapId = tuple2._1$mcJ$sp();
            int index = tuple2._2$mcI$sp();
            if (!x3$1.batchFetchEnabled) {
                objectArray = Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x3$1.reduceIds[index])).map((Function1 & Serializable & scala.Serializable)reduceId -> $this.blockManager.getLocalBlockData(new ShuffleBlockId(x3$1.shuffleId, mapId, BoxesRunTime.unboxToInt((Object)reduceId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ManagedBuffer.class))));
            } else {
                int[] startAndEndId = x3$1.reduceIds[index];
                if (startAndEndId.length != 2) {
                    throw new IllegalStateException(new StringBuilder(58).append("Invalid shuffle fetch request when batch mode ").append("is enabled: ").append(x3$1).toString());
                }
                objectArray = Predef$.MODULE$.refArrayOps((Object[])new ManagedBuffer[]{$this.blockManager.getLocalBlockData(new ShuffleBlockBatchId(x3$1.shuffleId, mapId, startAndEndId[0], startAndEndId[1]))});
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Object[] objectArray2 = objectArray;
        return objectArray2;
    }

    public static final /* synthetic */ int $anonfun$receive$7(int[] x$1) {
        return x$1.length;
    }

    public NettyBlockRpcServer(String appId, Serializer serializer, BlockDataManager blockManager) {
        this.appId = appId;
        this.serializer = serializer;
        this.blockManager = blockManager;
        Logging.$init$(this);
        this.streamManager = new OneForOneStreamManager();
    }
}

