/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SSLOptions;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.ui.JettyUtils;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.JettyUtils$ServletParams$;
import org.apache.spark.ui.ProxyRedirectHandler;
import org.apache.spark.ui.ServerInfo;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.client.api.Response;
import org.sparkproject.jetty.client.http.HttpClientTransportOverHTTP;
import org.sparkproject.jetty.proxy.ProxyServlet;
import org.sparkproject.jetty.server.AbstractConnectionFactory;
import org.sparkproject.jetty.server.ConnectionFactory;
import org.sparkproject.jetty.server.HttpConfiguration;
import org.sparkproject.jetty.server.HttpConnectionFactory;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.ServerConnector;
import org.sparkproject.jetty.server.handler.AbstractHandler;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.server.handler.ContextHandlerCollection;
import org.sparkproject.jetty.server.handler.ErrorHandler;
import org.sparkproject.jetty.servlet.DefaultServlet;
import org.sparkproject.jetty.servlet.FilterHolder;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import org.sparkproject.jetty.servlet.ServletHolder;
import org.sparkproject.jetty.util.ssl.SslContextFactory;
import org.sparkproject.jetty.util.thread.QueuedThreadPool;
import org.sparkproject.jetty.util.thread.ScheduledExecutorScheduler;
import org.sparkproject.jetty.util.thread.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.xml.Node;

public final class JettyUtils$
implements Logging {
    public static JettyUtils$ MODULE$;
    private final String SPARK_CONNECTOR_NAME;
    private final String REDIRECT_CONNECTOR_NAME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JettyUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String SPARK_CONNECTOR_NAME() {
        return this.SPARK_CONNECTOR_NAME;
    }

    public String REDIRECT_CONNECTOR_NAME() {
        return this.REDIRECT_CONNECTOR_NAME;
    }

    public JettyUtils.ServletParams<JsonAST.JValue> jsonResponderToServlet(Function1<HttpServletRequest, JsonAST.JValue> responder) {
        return new JettyUtils.ServletParams<JsonAST.JValue>(responder, "text/json", (Function1 & Serializable & scala.Serializable)in -> {
            JsonAST.JValue x$1 = in;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
            return JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(x$1, x$2));
        });
    }

    public JettyUtils.ServletParams<Seq<Node>> htmlResponderToServlet(Function1<HttpServletRequest, Seq<Node>> responder) {
        return new JettyUtils.ServletParams<Seq<Node>>(responder, "text/html", (Function1 & Serializable & scala.Serializable)in -> new java.lang.StringBuilder(15).append("<!DOCTYPE html>").append(in.toString()).toString());
    }

    public JettyUtils.ServletParams<String> textResponderToServlet(Function1<HttpServletRequest, String> responder) {
        return new JettyUtils.ServletParams<Object>(responder, "text/plain", JettyUtils$ServletParams$.MODULE$.$lessinit$greater$default$3());
    }

    private <T> HttpServlet createServlet(JettyUtils.ServletParams<T> servletParams, SparkConf conf) {
        return new HttpServlet(servletParams){
            private final JettyUtils.ServletParams servletParams$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    response.setContentType(new StringOps(Predef$.MODULE$.augmentString("%s;charset=utf-8")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.servletParams$1.contentType()})));
                    response.setStatus(200);
                    Object result = this.servletParams$1.responder().apply((Object)request);
                    response.getWriter().print((String)this.servletParams$1.extractFn().apply(result));
                }
                catch (IllegalArgumentException e) {
                    response.sendError(400, e.getMessage());
                }
                catch (Exception e) {
                    JettyUtils$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(13).append("GET ").append(request.getRequestURI()).append(" failed: ").append(e).toString(), e);
                    throw e;
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.servletParams$1 = servletParams$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doGet$1(javax.servlet.http.HttpServletRequest java.lang.Exception )}, serializedLambda);
            }
        };
    }

    public <T> ServletContextHandler createServletHandler(String path, JettyUtils.ServletParams<T> servletParams, SparkConf conf, String basePath) {
        return this.createServletHandler(path, this.createServlet(servletParams, conf), basePath);
    }

    /*
     * Unable to fully structure code
     */
    public ServletContextHandler createServletHandler(String path, HttpServlet servlet, String basePath) {
        v0 = basePath;
        var5_4 = "";
        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
        v1 = path;
        var6_5 = "/";
        if (!(v1 != null ? v1.equals(var6_5) == false : var6_5 != null)) {
            v2 = path;
        } else lbl-1000:
        // 2 sources

        {
            v2 = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(0).append(basePath).append(path).toString())).stripSuffix("/");
        }
        prefixedPath = v2;
        contextHandler = new ServletContextHandler();
        holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath(prefixedPath);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public <T> String createServletHandler$default$4() {
        return "";
    }

    public ServletContextHandler createRedirectHandler(String srcPath, String destPath, Function1<HttpServletRequest, BoxedUnit> beforeRedirect, String basePath, Set<String> httpMethods) {
        String prefixedDestPath = new java.lang.StringBuilder(0).append(basePath).append(destPath).toString();
        HttpServlet servlet = new HttpServlet(httpMethods, beforeRedirect, prefixedDestPath){
            private final Set httpMethods$1;
            private final Function1 beforeRedirect$1;
            private final String prefixedDestPath$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"GET")) {
                    this.doRequest(request, response);
                } else {
                    response.sendError(405);
                }
            }

            public void doPost(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"POST")) {
                    this.doRequest(request, response);
                } else {
                    response.sendError(405);
                }
            }

            private void doRequest(HttpServletRequest request, HttpServletResponse response) {
                this.beforeRedirect$1.apply((Object)request);
                String newUrl = new URL(new URL(request.getRequestURL().toString()), this.prefixedDestPath$1).toString();
                response.sendRedirect(newUrl);
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.httpMethods$1 = httpMethods$1;
                this.beforeRedirect$1 = beforeRedirect$1;
                this.prefixedDestPath$1 = prefixedDestPath$1;
            }
        };
        return this.createServletHandler(srcPath, servlet, basePath);
    }

    public Function1<HttpServletRequest, BoxedUnit> createRedirectHandler$default$3() {
        return (Function1 & Serializable & scala.Serializable)x -> {
            JettyUtils$.$anonfun$createRedirectHandler$default$3$1(x);
            return BoxedUnit.UNIT;
        };
    }

    public String createRedirectHandler$default$4() {
        return "";
    }

    public Set<String> createRedirectHandler$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET"}));
    }

    public ServletContextHandler createStaticHandler(String resourceBase, String path) {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setInitParameter("org.sparkproject.jetty.servlet.Default.gzip", "false");
        DefaultServlet staticHandler = new DefaultServlet();
        ServletHolder holder = new ServletHolder((Servlet)staticHandler);
        Option option = Option$.MODULE$.apply((Object)Utils$.MODULE$.getSparkClassLoader().getResource(resourceBase));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new java.lang.StringBuilder(41).append("Could not find resource path for Web UI: ").append(resourceBase).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        URL res = (URL)some.value();
        holder.setInitParameter("resourceBase", res.toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        contextHandler.setContextPath(path);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler createProxyHandler(Function1<String, Option<String>> idToUiAddress) {
        void var3_3;
        ProxyServlet servlet = new ProxyServlet(idToUiAddress){
            private final Function1 idToUiAddress$1;

            public String rewriteTarget(HttpServletRequest request) {
                String path = request.getPathInfo();
                if (path == null) {
                    return null;
                }
                int prefixTrailingSlashIndex = path.indexOf(47, 1);
                String prefix = prefixTrailingSlashIndex == -1 ? path : path.substring(0, prefixTrailingSlashIndex);
                String id = (String)new StringOps(Predef$.MODULE$.augmentString(prefix)).drop(1);
                return (String)((Option)this.idToUiAddress$1.apply((Object)id)).map((Function1 & Serializable & scala.Serializable)x$1 -> JettyUtils$.MODULE$.createProxyURI(prefix, (String)x$1, path, request.getQueryString())).filter((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)anon.3.$anonfun$rewriteTarget$2(this, uri))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).orNull(Predef$.MODULE$.$conforms());
            }

            public HttpClient newHttpClient() {
                int numSelectors = package$.MODULE$.max(1, package$.MODULE$.min(8, Runtime.getRuntime().availableProcessors() / 2));
                return new HttpClient(new HttpClientTransportOverHTTP(numSelectors), null);
            }

            public String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
                String newHeader;
                if (headerName.equalsIgnoreCase("location") && (newHeader = JettyUtils$.MODULE$.createProxyLocationHeader(headerValue, clientRequest, serverResponse.getRequest().getURI())) != null) {
                    return newHeader;
                }
                return super.filterServerResponseHeader(clientRequest, serverResponse, headerName, headerValue);
            }

            public static final /* synthetic */ boolean $anonfun$rewriteTarget$2(anon.3 $this, URI uri) {
                return uri != null && $this.validateDestination(uri.getHost(), uri.getPort());
            }
            {
                this.idToUiAddress$1 = idToUiAddress$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$rewriteTarget$1(java.lang.String java.lang.String javax.servlet.http.HttpServletRequest java.lang.String ), $anonfun$rewriteTarget$2$adapted(org.apache.spark.ui.JettyUtils$$anon$3 java.net.URI ), $anonfun$rewriteTarget$3(java.net.URI )}, serializedLambda);
            }
        };
        ServletContextHandler contextHandler = new ServletContextHandler();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath("/proxy");
        contextHandler.addServlet(holder, "/*");
        return var3_3;
    }

    public ServerInfo startJettyServer(String hostName, int port, SSLOptions sslOptions, SparkConf conf, String serverName) {
        ServerInfo serverInfo;
        QueuedThreadPool pool = new QueuedThreadPool();
        if (new StringOps(Predef$.MODULE$.augmentString(serverName)).nonEmpty()) {
            pool.setName(serverName);
        }
        pool.setDaemon(true);
        Server server = new Server(pool);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(server);
        server.addBean(errorHandler);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        Option option = (Option)conf.get(UI$.MODULE$.PROXY_REDIRECT_URI());
        if (option instanceof Some) {
            Some some = (Some)option;
            String proxyUri = (String)some.value();
            ProxyRedirectHandler proxyHandler = new ProxyRedirectHandler(proxyUri);
            proxyHandler.setHandler(collection);
            server.setHandler(proxyHandler);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            server.setHandler(collection);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ScheduledExecutorScheduler serverExecutor = new ScheduledExecutorScheduler(new java.lang.StringBuilder(15).append(serverName).append("-JettyScheduler").toString(), true);
        try {
            server.start();
            IntRef minThreads = IntRef.create((int)1);
            HttpConfiguration httpConfig = new HttpConfiguration();
            int requestHeaderSize = (int)BoxesRunTime.unboxToLong((Object)conf.get(UI$.MODULE$.UI_REQUEST_HEADER_SIZE()));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("Using requestHeaderSize: ").append(requestHeaderSize).toString());
            httpConfig.setRequestHeaderSize(requestHeaderSize);
            Option securePort = sslOptions.createJettySslContextFactory().map((Function1 & Serializable & scala.Serializable)factory -> BoxesRunTime.boxToInteger((int)JettyUtils$.$anonfun$startJettyServer$2(sslOptions, port, serverName, httpConfig, conf, server, serverExecutor, hostName, minThreads, factory)));
            Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(port, (Function1 & Serializable & scala.Serializable)currentPort -> JettyUtils$.httpConnect$1(BoxesRunTime.unboxToInt((Object)currentPort), httpConfig, server, serverExecutor, hostName, minThreads), conf, serverName);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ServerConnector httpConnector = (ServerConnector)tuple2._1();
            int httpPort = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)httpConnector, (Object)BoxesRunTime.boxToInteger((int)httpPort));
            Tuple2 tuple23 = tuple22;
            ServerConnector httpConnector2 = (ServerConnector)tuple23._1();
            int httpPort2 = tuple23._2$mcI$sp();
            Option option2 = securePort;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                int p = BoxesRunTime.unboxToInt((Object)some.value());
                httpConnector2.setName(this.REDIRECT_CONNECTOR_NAME());
                ContextHandler redirector = this.createRedirectHttpsHandler(p, "https");
                collection.addHandler(redirector);
                redirector.start();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                httpConnector2.setName(this.SPARK_CONNECTOR_NAME());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            server.addConnector(httpConnector2);
            pool.setMaxThreads(package$.MODULE$.max(pool.getMaxThreads(), minThreads.elem));
            serverInfo = new ServerInfo(server, httpPort2, (Option<Object>)securePort, conf, collection);
        }
        catch (Exception e) {
            server.stop();
            if (serverExecutor.isStarted()) {
                serverExecutor.stop();
            }
            if (pool.isStarted()) {
                pool.stop();
            }
            throw e;
        }
        return serverInfo;
    }

    public String startJettyServer$default$5() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private ContextHandler createRedirectHttpsHandler(int securePort, String scheme) {
        void var3_3;
        ContextHandler redirectHandler = new ContextHandler();
        redirectHandler.setContextPath("/");
        redirectHandler.setVirtualHosts(this.toVirtualHosts((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.REDIRECT_CONNECTOR_NAME()})));
        redirectHandler.setHandler(new AbstractHandler(scheme, securePort){
            private final String scheme$1;
            private final int securePort$1;

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                if (baseRequest.isSecure()) {
                    return;
                }
                String httpsURI = JettyUtils$.MODULE$.org$apache$spark$ui$JettyUtils$$createRedirectURI(this.scheme$1, this.securePort$1, baseRequest);
                response.setContentLength(0);
                response.sendRedirect(response.encodeRedirectURL(httpsURI));
                baseRequest.setHandled(true);
            }
            {
                this.scheme$1 = scheme$1;
                this.securePort$1 = securePort$1;
            }
        });
        return var3_3;
    }

    public URI createProxyURI(String prefix, String target, String path, String query) {
        BoxedUnit boxedUnit;
        if (!path.startsWith(prefix)) {
            return null;
        }
        StringBuilder uri = new StringBuilder(target);
        String rest = path.substring(prefix.length());
        if (!rest.isEmpty()) {
            Object object = !rest.startsWith("/") && !uri.endsWith((GenSeq)Predef$.MODULE$.wrapString("/")) ? uri.append("/") : BoxedUnit.UNIT;
            boxedUnit = uri.append(rest);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String queryString = query == null ? "" : new java.lang.StringBuilder(1).append("?").append(query).toString();
        return URI.create(new java.lang.StringBuilder(0).append(uri.toString()).append(queryString).toString()).normalize();
    }

    public String createProxyLocationHeader(String headerValue, HttpServletRequest clientRequest, URI targetUri) {
        String string;
        String toReplace = new java.lang.StringBuilder(3).append(targetUri.getScheme()).append("://").append(targetUri.getAuthority()).toString();
        if (headerValue.startsWith(toReplace)) {
            String id = (String)new StringOps(Predef$.MODULE$.augmentString(clientRequest.getPathInfo().substring("/proxy/".length()))).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JettyUtils$.$anonfun$createProxyLocationHeader$1(BoxesRunTime.unboxToChar((Object)x$5))));
            String headerPath = headerValue.substring(toReplace.length());
            string = new java.lang.StringBuilder(10).append(clientRequest.getScheme()).append("://").append(clientRequest.getHeader("host")).append("/proxy/").append(id).append(headerPath).toString();
        } else {
            string = null;
        }
        return string;
    }

    public void addFilter(ServletContextHandler handler, String filter, Map<String, String> params) {
        FilterHolder holder = new FilterHolder();
        holder.setClassName(filter);
        params.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JettyUtils$.$anonfun$addFilter$1(holder, x0$1);
            return BoxedUnit.UNIT;
        });
        handler.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    private String decodeURL(String url, String encoding) {
        return url == null ? null : URLDecoder.decode(url, encoding);
    }

    public String org$apache$spark$ui$JettyUtils$$createRedirectURI(String scheme, int port, Request request) {
        String server = request.getServerName();
        String redirectServer = server.contains(":") && !server.startsWith("[") ? new java.lang.StringBuilder(2).append("[").append(server).append("]").toString() : server;
        String authority = new java.lang.StringBuilder(1).append(redirectServer).append(":").append(port).toString();
        String queryEncoding = request.getQueryEncoding() != null ? request.getQueryEncoding() : "UTF-8";
        String requestURI = this.decodeURL(request.getRequestURI(), queryEncoding);
        String queryString = this.decodeURL(request.getQueryString(), queryEncoding);
        return new URI(scheme, authority, requestURI, queryString, null).toString();
    }

    public String[] toVirtualHosts(Seq<String> connectors) {
        return (String[])((TraversableOnce)connectors.map((Function1 & Serializable & scala.Serializable)x$6 -> new java.lang.StringBuilder(1).append("@").append((String)x$6).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ void $anonfun$createRedirectHandler$default$3$1(HttpServletRequest x) {
    }

    private static final Tuple2 newConnector$1(ConnectionFactory[] connectionFactories, int port, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1) {
        ServerConnector connector = new ServerConnector(server$1, null, (Scheduler)serverExecutor$1, null, -1, -1, connectionFactories);
        connector.setPort(port);
        connector.setHost(hostName$1);
        connector.setReuseAddress(!Utils$.MODULE$.isWindows());
        connector.setAcceptQueueSize(package$.MODULE$.min(connector.getAcceptors(), 8));
        connector.start();
        minThreads$1.elem += connector.getAcceptors() * 2;
        return new Tuple2((Object)connector, (Object)BoxesRunTime.boxToInteger((int)connector.getLocalPort()));
    }

    private static final Tuple2 sslConnect$1(int currentPort, ConnectionFactory[] connectionFactories$1, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1) {
        return JettyUtils$.newConnector$1(connectionFactories$1, currentPort, server$1, serverExecutor$1, hostName$1, minThreads$1);
    }

    public static final /* synthetic */ int $anonfun$startJettyServer$2(SSLOptions sslOptions$1, int port$1, String serverName$1, HttpConfiguration httpConfig$1, SparkConf conf$1, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1, SslContextFactory factory) {
        int securePort = BoxesRunTime.unboxToInt((Object)sslOptions$1.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> port$1 > 0 ? Utils$.MODULE$.userPort(port$1, 400) : 0));
        String secureServerName = new StringOps(Predef$.MODULE$.augmentString(serverName$1)).nonEmpty() ? new java.lang.StringBuilder(8).append(serverName$1).append(" (HTTPS)").toString() : serverName$1;
        ConnectionFactory[] connectionFactories = AbstractConnectionFactory.getFactories(factory, new HttpConnectionFactory(httpConfig$1));
        Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(securePort, (Function1 & Serializable & scala.Serializable)currentPort -> JettyUtils$.sslConnect$1(BoxesRunTime.unboxToInt((Object)currentPort), connectionFactories, server$1, serverExecutor$1, hostName$1, minThreads$1), conf$1, secureServerName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ServerConnector connector = (ServerConnector)tuple2._1();
        int boundPort = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)connector, (Object)BoxesRunTime.boxToInteger((int)boundPort));
        Tuple2 tuple23 = tuple22;
        ServerConnector connector2 = (ServerConnector)tuple23._1();
        int boundPort2 = tuple23._2$mcI$sp();
        connector2.setName(MODULE$.SPARK_CONNECTOR_NAME());
        server$1.addConnector(connector2);
        return boundPort2;
    }

    private static final Tuple2 httpConnect$1(int currentPort, HttpConfiguration httpConfig$1, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1) {
        return JettyUtils$.newConnector$1((ConnectionFactory[])((Object[])new ConnectionFactory[]{new HttpConnectionFactory(httpConfig$1)}), currentPort, server$1, serverExecutor$1, hostName$1, minThreads$1);
    }

    public static final /* synthetic */ boolean $anonfun$createProxyLocationHeader$1(char x$5) {
        return x$5 != '/';
    }

    public static final /* synthetic */ void $anonfun$addFilter$1(FilterHolder holder$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        holder$1.setInitParameter(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private JettyUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.SPARK_CONNECTOR_NAME = "Spark";
        this.REDIRECT_CONNECTOR_NAME = "HttpsRedirect";
    }
}

