/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeRDD;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointer;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.util.PeriodicRDDCheckpointer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Pregel$
implements Logging {
    public static Pregel$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Pregel$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <VD, ED, A> Graph<VD, ED> apply(Graph<VD, ED> graph, A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg, Function2<A, A, A> mergeMsg, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2, ClassTag<A> evidence$3) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Maximum number of iterations must be greater than 0,").append(" but got ").append(maxIterations).toString());
        int checkpointInterval = graph.vertices().sparkContext().getConf().getInt("spark.graphx.pregel.checkpointInterval", -1);
        Graph<VD, ED> g = graph.mapVertices((Function2 & Serializable & scala.Serializable)(vid, vdata) -> vprog.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)vid)), vdata, initialMsg), evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
        PeriodicGraphCheckpointer graphCheckpointer = new PeriodicGraphCheckpointer(checkpointInterval, graph.vertices().sparkContext());
        graphCheckpointer.update(g);
        VertexRDD<A> messages = GraphXUtils$.MODULE$.mapReduceTriplets(g, sendMsg, mergeMsg, GraphXUtils$.MODULE$.mapReduceTriplets$default$4(), evidence$1, evidence$2, evidence$3);
        PeriodicRDDCheckpointer messageCheckpointer = new PeriodicRDDCheckpointer(checkpointInterval, graph.vertices().sparkContext());
        messageCheckpointer.update(messages);
        long activeMessages = messages.count();
        Graph<VD, ED> prevG = null;
        IntRef i = IntRef.create((int)0);
        while (activeMessages > 0L && i.elem < maxIterations) {
            prevG = g;
            g = Graph$.MODULE$.graphToGraphOps(g, evidence$1, evidence$2).joinVertices(messages, vprog, evidence$3);
            graphCheckpointer.update(g);
            VertexRDD<A> oldMessages = messages;
            messages = GraphXUtils$.MODULE$.mapReduceTriplets(g, sendMsg, mergeMsg, (Option<Tuple2<VertexRDD<?>, EdgeDirection>>)new Some((Object)new Tuple2(oldMessages, (Object)activeDirection)), evidence$1, evidence$2, evidence$3);
            messageCheckpointer.update(messages);
            activeMessages = messages.count();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Pregel finished iteration ").append(i$1.elem).toString());
            oldMessages.unpersist(oldMessages.unpersist$default$1());
            Graph<VD, ED> qual$1 = prevG;
            boolean x$1 = qual$1.unpersistVertices$default$1();
            qual$1.unpersistVertices(x$1);
            EdgeRDD<ED> qual$2 = prevG.edges();
            boolean x$2 = qual$2.unpersist$default$1();
            qual$2.unpersist(x$2);
            ++i.elem;
        }
        messageCheckpointer.unpersistDataSet();
        graphCheckpointer.deleteAllCheckpoints();
        messageCheckpointer.deleteAllCheckpoints();
        return g;
    }

    public <VD, ED, A> int apply$default$3() {
        return Integer.MAX_VALUE;
    }

    public <VD, ED, A> EdgeDirection apply$default$4() {
        return EdgeDirection$.MODULE$.Either();
    }

    private Pregel$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

