/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Binarizer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaBinarizerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaBinarizerExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0, 0.1}), RowFactory.create((Object[])new Object[]{1, 0.8}), RowFactory.create((Object[])new Object[]{2, 0.2}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("feature", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset continuousDataFrame = spark.createDataFrame(data, schema);
        Binarizer binarizer = new Binarizer().setInputCol("feature").setOutputCol("binarized_feature").setThreshold(0.5);
        Dataset binarizedDataFrame = binarizer.transform(continuousDataFrame);
        System.out.println("Binarizer output with Threshold = " + binarizer.getThreshold());
        binarizedDataFrame.show();
        spark.stop();
    }
}

