/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaStringIndexerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaStringIndexerExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0, "a"}), RowFactory.create((Object[])new Object[]{1, "b"}), RowFactory.create((Object[])new Object[]{2, "c"}), RowFactory.create((Object[])new Object[]{3, "a"}), RowFactory.create((Object[])new Object[]{4, "a"}), RowFactory.create((Object[])new Object[]{5, "c"}));
        StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"category", (DataType)DataTypes.StringType, (boolean)false)});
        Dataset df = spark.createDataFrame(data, schema);
        StringIndexer indexer = new StringIndexer().setInputCol("category").setOutputCol("categoryIndex");
        Dataset indexed = indexer.fit(df).transform(df);
        indexed.show();
        spark.stop();
    }
}

