/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.MovieLensALS;
import org.apache.spark.examples.mllib.MovieLensALS$;
import org.apache.spark.examples.mllib.MovieLensALS$Params$;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BitSet;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scopt.OptionParser;
import scopt.Read$;

public final class MovieLensALS$ {
    public static MovieLensALS$ MODULE$;

    static {
        new MovieLensALS$();
    }

    public void main(String[] args) {
        MovieLensALS.Params defaultParams = new MovieLensALS.Params(MovieLensALS$Params$.MODULE$.apply$default$1(), MovieLensALS$Params$.MODULE$.apply$default$2(), MovieLensALS$Params$.MODULE$.apply$default$3(), MovieLensALS$Params$.MODULE$.apply$default$4(), MovieLensALS$Params$.MODULE$.apply$default$5(), MovieLensALS$Params$.MODULE$.apply$default$6(), MovieLensALS$Params$.MODULE$.apply$default$7(), MovieLensALS$Params$.MODULE$.apply$default$8());
        OptionParser<MovieLensALS.Params> parser = new OptionParser<MovieLensALS.Params>(defaultParams){

            public static final /* synthetic */ MovieLensALS.Params $anonfun$new$1(int x, MovieLensALS.Params c) {
                int x$1 = x;
                String x$2 = c.copy$default$1();
                boolean x$3 = c.copy$default$2();
                int x$4 = c.copy$default$3();
                double x$5 = c.copy$default$4();
                int x$6 = c.copy$default$6();
                int x$7 = c.copy$default$7();
                boolean x$8 = c.copy$default$8();
                return c.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
            }

            public static final /* synthetic */ MovieLensALS.Params $anonfun$new$2(int x, MovieLensALS.Params c) {
                int x$9 = x;
                String x$10 = c.copy$default$1();
                boolean x$11 = c.copy$default$2();
                double x$12 = c.copy$default$4();
                int x$13 = c.copy$default$5();
                int x$14 = c.copy$default$6();
                int x$15 = c.copy$default$7();
                boolean x$16 = c.copy$default$8();
                return c.copy(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16);
            }

            public static final /* synthetic */ MovieLensALS.Params $anonfun$new$3(double x, MovieLensALS.Params c) {
                double x$17 = x;
                String x$18 = c.copy$default$1();
                boolean x$19 = c.copy$default$2();
                int x$20 = c.copy$default$3();
                int x$21 = c.copy$default$5();
                int x$22 = c.copy$default$6();
                int x$23 = c.copy$default$7();
                boolean x$24 = c.copy$default$8();
                return c.copy(x$18, x$19, x$20, x$17, x$21, x$22, x$23, x$24);
            }

            public static final /* synthetic */ MovieLensALS.Params $anonfun$new$5(int x, MovieLensALS.Params c) {
                int x$33 = x;
                String x$34 = c.copy$default$1();
                boolean x$35 = c.copy$default$2();
                int x$36 = c.copy$default$3();
                double x$37 = c.copy$default$4();
                int x$38 = c.copy$default$5();
                int x$39 = c.copy$default$7();
                boolean x$40 = c.copy$default$8();
                return c.copy(x$34, x$35, x$36, x$37, x$38, x$33, x$39, x$40);
            }

            public static final /* synthetic */ MovieLensALS.Params $anonfun$new$6(int x, MovieLensALS.Params c) {
                int x$41 = x;
                String x$42 = c.copy$default$1();
                boolean x$43 = c.copy$default$2();
                int x$44 = c.copy$default$3();
                double x$45 = c.copy$default$4();
                int x$46 = c.copy$default$5();
                int x$47 = c.copy$default$6();
                boolean x$48 = c.copy$default$8();
                return c.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$41, x$48);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MovieLensALS: an example app for ALS on MovieLens data."}));
                this.opt("rank", Read$.MODULE$.intRead()).text(new StringBuilder(15).append("rank, default: ").append(defaultParams$1.rank()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("numIterations", Read$.MODULE$.intRead()).text(new StringBuilder(31).append("number of iterations, default: ").append(defaultParams$1.numIterations()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("lambda", Read$.MODULE$.doubleRead()).text(new StringBuilder(38).append("lambda (smoothing constant), default: ").append(defaultParams$1.lambda()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("kryo", Read$.MODULE$.unitRead()).text("use Kryo serialization").action((Function2 & Serializable & scala.Serializable)(x$1, c) -> {
                    boolean x$25 = true;
                    String x$26 = c.copy$default$1();
                    int x$27 = c.copy$default$3();
                    double x$28 = c.copy$default$4();
                    int x$29 = c.copy$default$5();
                    int x$30 = c.copy$default$6();
                    int x$31 = c.copy$default$7();
                    boolean x$32 = c.copy$default$8();
                    return c.copy(x$26, x$25, x$27, x$28, x$29, x$30, x$31, x$32);
                });
                this.opt("numUserBlocks", Read$.MODULE$.intRead()).text(new StringBuilder(39).append("number of user blocks, default: ").append(defaultParams$1.numUserBlocks()).append(" (auto)").toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("numProductBlocks", Read$.MODULE$.intRead()).text(new StringBuilder(42).append("number of product blocks, default: ").append(defaultParams$1.numProductBlocks()).append(" (auto)").toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("implicitPrefs", Read$.MODULE$.unitRead()).text("use implicit preference").action((Function2 & Serializable & scala.Serializable)(x$2, c) -> {
                    boolean x$49 = true;
                    String x$50 = c.copy$default$1();
                    boolean x$51 = c.copy$default$2();
                    int x$52 = c.copy$default$3();
                    double x$53 = c.copy$default$4();
                    int x$54 = c.copy$default$5();
                    int x$55 = c.copy$default$6();
                    int x$56 = c.copy$default$7();
                    return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$49);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).required().text("input paths to a MovieLens dataset of ratings").action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8()));
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a synthetic dataset:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.mllib.MovieLensALS \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  --rank 5 --numIterations 20 --lambda 1.0 --kryo \\\n          |  data/mllib/sample_movielens_data.txt\n        ")).stripMargin());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$4(scala.runtime.BoxedUnit org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$6$adapted(java.lang.Object org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$7(scala.runtime.BoxedUnit org.apache.spark.examples.mllib.MovieLensALS$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.mllib.MovieLensALS$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        MovieLensALS.Params params = (MovieLensALS.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(MovieLensALS.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(18).append("MovieLensALS with ").append(params).toString());
        Object object = params.kryo() ? conf.registerKryoClasses((Class[])((Object[])new Class[]{BitSet.class, Rating.class})).set("spark.kryoserializer.buffer", "8m") : BoxedUnit.UNIT;
        SparkContext sc = new SparkContext(conf);
        Logger.getRootLogger().setLevel(Level.WARN);
        boolean implicitPrefs = params.implicitPrefs();
        RDD ratings = sc.textFile(params.input(), sc.textFile$default$2()).map((Function1 & Serializable & scala.Serializable)line -> {
            String[] fields = line.split("::");
            return implicitPrefs ? new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble() - 2.5) : new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble());
        }, ClassTag$.MODULE$.apply(Rating.class)).cache();
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.user()), ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.product()), ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("Got ").append(numRatings).append(" ratings from ").append(numUsers).append(" users on ").append(numMovies).append(" movies.").toString());
        RDD[] splits = ratings.randomSplit(new double[]{0.8, 0.2}, ratings.randomSplit$default$2());
        RDD training = splits[0].cache();
        RDD test = params.implicitPrefs() ? splits[1].map((Function1 & Serializable & scala.Serializable)x -> new Rating(x.user(), x.product(), x.rating() > 0.0 ? 1.0 : 0.0), ClassTag$.MODULE$.apply(Rating.class)) : splits[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Training: ").append(numTraining).append(", test: ").append(numTest).append(".").toString());
        ratings.unpersist(ratings.unpersist$default$1());
        MatrixFactorizationModel model = new ALS().setRank(params.rank()).setIterations(params.numIterations()).setLambda(params.lambda()).setImplicitPrefs(params.implicitPrefs()).setUserBlocks(params.numUserBlocks()).setProductBlocks(params.numProductBlocks()).run(training);
        double rmse = this.computeRmse(model, (RDD<Rating>)test, params.implicitPrefs());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Test RMSE = ").append(rmse).append(".").toString());
        sc.stop();
    }

    public double computeRmse(MatrixFactorizationModel model, RDD<Rating> data, boolean implicitPrefs) {
        RDD predictions = model.predict(data.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcII.sp(x.user(), x.product()), ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD predictionsAndRatings = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(predictions.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new Tuple2.mcII.sp(x.user(), x.product()), (Object)BoxesRunTime.boxToDouble((double)MovieLensALS$.mapPredictedRating$1(x.rating(), implicitPrefs))), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(data.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new Tuple2.mcII.sp(x.user(), x.product()), (Object)BoxesRunTime.boxToDouble((double)x.rating())), ClassTag$.MODULE$.apply(Tuple2.class))), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).values();
        return package$.MODULE$.sqrt(RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictionsAndRatings.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)MovieLensALS$.$anonfun$computeRmse$4(x)), ClassTag$.MODULE$.Double())).mean());
    }

    private static final double mapPredictedRating$1(double r, boolean implicitPrefs$2) {
        return implicitPrefs$2 ? package$.MODULE$.max(package$.MODULE$.min(r, 1.0), 0.0) : r;
    }

    public static final /* synthetic */ double $anonfun$computeRmse$4(Tuple2 x) {
        return (x._1$mcD$sp() - x._2$mcD$sp()) * (x._1$mcD$sp() - x._2$mcD$sp());
    }

    private MovieLensALS$() {
        MODULE$ = this;
    }
}

