/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;

public class JavaSQLDataSourceExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("Java Spark SQL data sources example").config("spark.some.config.option", "some-value").getOrCreate();
        JavaSQLDataSourceExample.runBasicDataSourceExample(spark);
        JavaSQLDataSourceExample.runGenericFileSourceOptionsExample(spark);
        JavaSQLDataSourceExample.runBasicParquetExample(spark);
        JavaSQLDataSourceExample.runParquetSchemaMergingExample(spark);
        JavaSQLDataSourceExample.runJsonDatasetExample(spark);
        JavaSQLDataSourceExample.runJdbcDatasetExample(spark);
        spark.stop();
    }

    private static void runGenericFileSourceOptionsExample(SparkSession spark) {
        spark.sql("set spark.sql.files.ignoreCorruptFiles=true");
        Dataset testCorruptDF = spark.read().parquet(new String[]{"examples/src/main/resources/dir1/", "examples/src/main/resources/dir1/dir2/"});
        testCorruptDF.show();
        Dataset recursiveLoadedDF = spark.read().format("parquet").option("recursiveFileLookup", "true").load("examples/src/main/resources/dir1");
        recursiveLoadedDF.show();
        spark.sql("set spark.sql.files.ignoreCorruptFiles=false");
        Dataset testGlobFilterDF = spark.read().format("parquet").option("pathGlobFilter", "*.parquet").load("examples/src/main/resources/dir1");
        testGlobFilterDF.show();
        Dataset beforeFilterDF = spark.read().format("parquet").option("modifiedBefore", "2020-07-01T05:30:00").option("modifiedAfter", "2020-06-01T05:30:00").option("timeZone", "CST").load("examples/src/main/resources/dir1");
        beforeFilterDF.show();
    }

    private static void runBasicDataSourceExample(SparkSession spark) {
        Dataset usersDF = spark.read().load("examples/src/main/resources/users.parquet");
        usersDF.select("name", new String[]{"favorite_color"}).write().save("namesAndFavColors.parquet");
        Dataset peopleDF = spark.read().format("json").load("examples/src/main/resources/people.json");
        peopleDF.select("name", new String[]{"age"}).write().format("parquet").save("namesAndAges.parquet");
        Dataset peopleDFCsv = spark.read().format("csv").option("sep", ";").option("inferSchema", "true").option("header", "true").load("examples/src/main/resources/people.csv");
        usersDF.write().format("orc").option("orc.bloom.filter.columns", "favorite_color").option("orc.dictionary.key.threshold", "1.0").option("orc.column.encoding.direct", "name").save("users_with_options.orc");
        Dataset sqlDF = spark.sql("SELECT * FROM parquet.`examples/src/main/resources/users.parquet`");
        peopleDF.write().bucketBy(42, "name", new String[0]).sortBy("age", new String[0]).saveAsTable("people_bucketed");
        usersDF.write().partitionBy(new String[]{"favorite_color"}).format("parquet").save("namesPartByColor.parquet");
        usersDF.write().partitionBy(new String[]{"favorite_color"}).bucketBy(42, "name", new String[0]).saveAsTable("users_partitioned_bucketed");
        spark.sql("DROP TABLE IF EXISTS people_bucketed");
        spark.sql("DROP TABLE IF EXISTS users_partitioned_bucketed");
    }

    private static void runBasicParquetExample(SparkSession spark) {
        Dataset peopleDF = spark.read().json("examples/src/main/resources/people.json");
        peopleDF.write().parquet("people.parquet");
        Dataset parquetFileDF = spark.read().parquet("people.parquet");
        parquetFileDF.createOrReplaceTempView("parquetFile");
        Dataset namesDF = spark.sql("SELECT name FROM parquetFile WHERE age BETWEEN 13 AND 19");
        Dataset namesDS = namesDF.map((MapFunction & Serializable)row -> "Name: " + row.getString(0), Encoders.STRING());
        namesDS.show();
    }

    private static void runParquetSchemaMergingExample(SparkSession spark) {
        ArrayList<Square> squares = new ArrayList<Square>();
        for (int value = 1; value <= 5; ++value) {
            Square square = new Square();
            square.setValue(value);
            square.setSquare(value * value);
            squares.add(square);
        }
        Dataset squaresDF = spark.createDataFrame(squares, Square.class);
        squaresDF.write().parquet("data/test_table/key=1");
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        for (int value = 6; value <= 10; ++value) {
            Cube cube = new Cube();
            cube.setValue(value);
            cube.setCube(value * value * value);
            cubes.add(cube);
        }
        Dataset cubesDF = spark.createDataFrame(cubes, Cube.class);
        cubesDF.write().parquet("data/test_table/key=2");
        Dataset mergedDF = spark.read().option("mergeSchema", true).parquet("data/test_table");
        mergedDF.printSchema();
    }

    private static void runJsonDatasetExample(SparkSession spark) {
        Dataset people = spark.read().json("examples/src/main/resources/people.json");
        people.printSchema();
        people.createOrReplaceTempView("people");
        Dataset namesDF = spark.sql("SELECT name FROM people WHERE age BETWEEN 13 AND 19");
        namesDF.show();
        List<String> jsonData = Arrays.asList("{\"name\":\"Yin\",\"address\":{\"city\":\"Columbus\",\"state\":\"Ohio\"}}");
        Dataset anotherPeopleDataset = spark.createDataset(jsonData, Encoders.STRING());
        Dataset anotherPeople = spark.read().json(anotherPeopleDataset);
        anotherPeople.show();
    }

    private static void runJdbcDatasetExample(SparkSession spark) {
        Dataset jdbcDF = spark.read().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").load();
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", "username");
        connectionProperties.put("password", "password");
        Dataset jdbcDF2 = spark.read().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
        jdbcDF.write().format("jdbc").option("url", "jdbc:postgresql:dbserver").option("dbtable", "schema.tablename").option("user", "username").option("password", "password").save();
        jdbcDF2.write().jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
        jdbcDF.write().option("createTableColumnTypes", "name CHAR(64), comments VARCHAR(1024)").jdbc("jdbc:postgresql:dbserver", "schema.tablename", connectionProperties);
    }

    public static class Cube
    implements Serializable {
        private int value;
        private int cube;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getCube() {
            return this.cube;
        }

        public void setCube(int cube) {
            this.cube = cube;
        }
    }

    public static class Square
    implements Serializable {
        private int value;
        private int square;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getSquare() {
            return this.square;
        }

        public void setSquare(int square) {
            this.square = square;
        }
    }
}

