/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RowMultiSetImpl;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OffsetOrderVisitor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VarbitConstantNode;
import org.apache.derby.impl.sql.compile.XMLConstantNode;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;

public abstract class QueryTreeNode
implements Visitable {
    static final int AUTOINCREMENT_START_INDEX = 0;
    static final int AUTOINCREMENT_INC_INDEX = 1;
    static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    static final int AUTOINCREMENT_CREATE_MODIFY = 3;
    private int beginOffset = -1;
    private int endOffset = -1;
    private ContextManager cm;
    private LanguageConnectionContext lcc;
    private GenericConstantActionFactory constantActionFactory;
    private ArrayList<String> visitableTags;
    private boolean isPrivilegeCollectionRequired = true;

    QueryTreeNode(ContextManager contextManager) {
        this.cm = contextManager;
    }

    final ContextManager getContextManager() {
        return this.cm;
    }

    public final OptimizerFactory getOptimizerFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getOptimizerFactory();
    }

    public OptTrace getOptimizerTracer() {
        return this.getLanguageConnectionContext().getOptimizerTracer();
    }

    public boolean optimizerTracingIsOn() {
        return this.getLanguageConnectionContext().optimizerTracingIsOn();
    }

    public final GenericConstantActionFactory getGenericConstantActionFactory() {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory genericExecutionFactory = (GenericExecutionFactory)this.getExecutionFactory();
            this.constantActionFactory = genericExecutionFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    public final ExecutionFactory getExecutionFactory() {
        ExecutionFactory executionFactory = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
        return executionFactory;
    }

    protected final ClassFactory getClassFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getClassFactory();
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int n) {
        this.beginOffset = n;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    protected String nodeHeader() {
        return "";
    }

    static String formatNodeString(String string, int n) {
        return "";
    }

    public void treePrint() {
    }

    void stackPrint() {
    }

    void treePrint(int n) {
    }

    private static boolean containsInfo(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\t' || string.charAt(i) == '\n') continue;
            return true;
        }
        return false;
    }

    static void debugPrint(String string) {
    }

    protected static void debugFlush() {
    }

    void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    void printLabel(int n, String string) {
    }

    public boolean referencesSessionSchema() throws StandardException {
        return false;
    }

    final boolean isSessionSchema(SchemaDescriptor schemaDescriptor) {
        return QueryTreeNode.isSessionSchema(schemaDescriptor.getSchemaName());
    }

    static boolean isSessionSchema(String string) {
        return "SESSION".equals(string);
    }

    final void disablePrivilegeCollection() {
        this.isPrivilegeCollectionRequired = false;
    }

    boolean isPrivilegeCollectionRequired() throws StandardException {
        return this.isPrivilegeCollectionRequired && this.getCompilerContext().passesPrivilegeFilters(this);
    }

    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return ((CompilerContextImpl)this.getCompilerContext()).getParameterTypes();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return null;
    }

    public final DataDictionary getDataDictionary() {
        return this.getLanguageConnectionContext().getDataDictionary();
    }

    final DependencyManager getDependencyManager() {
        return this.getDataDictionary().getDependencyManager();
    }

    protected final CompilerContext getCompilerContext() {
        return (CompilerContext)this.getContextManager().getContext("CompilerContext");
    }

    protected final TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.getCompilerContext().getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    @Override
    public final Visitable accept(Visitor visitor) throws StandardException {
        QueryTreeNode queryTreeNode;
        boolean bl = visitor.visitChildrenFirst(this);
        boolean bl2 = visitor.skipChildren(this);
        if (bl && !bl2 && !visitor.stopTraversal()) {
            this.acceptChildren(visitor);
        }
        Visitable visitable = queryTreeNode = visitor.stopTraversal() ? this : visitor.visit(this);
        if (!(bl || bl2 || visitor.stopTraversal())) {
            this.acceptChildren(visitor);
        }
        return queryTreeNode;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
    }

    @Override
    public void addTag(String string) {
        if (this.visitableTags == null) {
            this.visitableTags = new ArrayList();
        }
        this.visitableTags.add(string);
    }

    @Override
    public boolean taggedWith(String string) {
        if (this.visitableTags == null) {
            return false;
        }
        return this.visitableTags.contains(string);
    }

    protected void copyTagsFrom(QueryTreeNode queryTreeNode) {
        if (queryTreeNode.visitableTags == null) {
            return;
        }
        for (String string : queryTreeNode.visitableTags) {
            this.addTag(string);
        }
    }

    protected int getIntProperty(String string, String string2) throws StandardException {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42Y58", string, string2);
        }
        return n;
    }

    protected long getLongProperty(String string, String string2) throws StandardException {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42Y58", string, string2);
        }
        return l;
    }

    StatementNode parseStatement(String string, boolean bl) throws StandardException {
        return (StatementNode)this.parseStatementOrSearchCondition(string, bl, true);
    }

    ValueNode parseSearchCondition(String string, boolean bl) throws StandardException {
        return (ValueNode)this.parseStatementOrSearchCondition(string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Visitable parseStatementOrSearchCondition(String string, boolean bl, boolean bl2) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        if (bl) {
            compilerContext.setReliability(0);
        }
        try {
            Parser parser = compilerContext.getParser();
            Visitable visitable = bl2 ? parser.parseStatement(string) : parser.parseSearchCondition(string);
            return visitable;
        }
        finally {
            languageConnectionContext.popCompilerContext(compilerContext);
        }
    }

    protected int getStatementType() {
        return 0;
    }

    ConstantNode getNullNode(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        switch (dataTypeDescriptor.getTypeId().getJDBCTypeId()) {
            case 12: {
                CharConstantNode charConstantNode = new CharConstantNode(1, dataTypeDescriptor.getTypeId(), this.cm);
                charConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return charConstantNode;
            }
            case 1: {
                CharConstantNode charConstantNode = new CharConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                charConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return charConstantNode;
            }
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                NumericConstantNode numericConstantNode = new NumericConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                numericConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return numericConstantNode;
            }
            case 2: {
                NumericConstantNode numericConstantNode = new NumericConstantNode(TypeId.getBuiltInTypeId(3), this.cm);
                numericConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return numericConstantNode;
            }
            case 91: 
            case 92: 
            case 93: {
                UserTypeConstantNode userTypeConstantNode = new UserTypeConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                userTypeConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return userTypeConstantNode;
            }
            case -2: {
                BitConstantNode bitConstantNode = new BitConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                bitConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return bitConstantNode;
            }
            case -3: {
                VarbitConstantNode varbitConstantNode = new VarbitConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                varbitConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return varbitConstantNode;
            }
            case -1: {
                CharConstantNode charConstantNode = new CharConstantNode(2, dataTypeDescriptor.getTypeId(), this.cm);
                charConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return charConstantNode;
            }
            case 2005: {
                CharConstantNode charConstantNode = new CharConstantNode(3, dataTypeDescriptor.getTypeId(), this.cm);
                charConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return charConstantNode;
            }
            case -4: {
                VarbitConstantNode varbitConstantNode = new VarbitConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                varbitConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return varbitConstantNode;
            }
            case 2004: {
                VarbitConstantNode varbitConstantNode = new VarbitConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                varbitConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return varbitConstantNode;
            }
            case 2009: {
                XMLConstantNode xMLConstantNode = new XMLConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                xMLConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return xMLConstantNode;
            }
            case 16: {
                BooleanConstantNode booleanConstantNode = new BooleanConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
                booleanConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
                return booleanConstantNode;
            }
        }
        if (dataTypeDescriptor.getTypeId().userType()) {
            UserTypeConstantNode userTypeConstantNode = new UserTypeConstantNode(dataTypeDescriptor.getTypeId(), this.cm);
            userTypeConstantNode.setType(dataTypeDescriptor.getNullabilityType(true));
            return userTypeConstantNode;
        }
        return null;
    }

    DataValueDescriptor convertDefaultNode(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        return null;
    }

    public TableName makeTableName(String string, String string2) throws StandardException {
        return QueryTreeNode.makeTableName(this.getContextManager(), string, string2);
    }

    public static TableName makeTableName(ContextManager contextManager, String string, String string2) throws StandardException {
        return new TableName(string, string2, contextManager);
    }

    public boolean isAtomic() throws StandardException {
        return false;
    }

    protected final TableDescriptor getTableDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TableDescriptor tableDescriptor;
        if (this.isSessionSchema(schemaDescriptor) && (tableDescriptor = this.getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable(string)) != null) {
            return tableDescriptor;
        }
        if (schemaDescriptor.getUUID() == null) {
            return null;
        }
        TableDescriptor tableDescriptor2 = this.getDataDictionary().getTableDescriptor(string, schemaDescriptor, this.getLanguageConnectionContext().getTransactionCompile());
        if (tableDescriptor2 == null || tableDescriptor2.isSynonymDescriptor()) {
            return null;
        }
        return tableDescriptor2;
    }

    final SchemaDescriptor getSchemaDescriptor(String string) throws StandardException {
        return this.getSchemaDescriptor(string, true);
    }

    final SchemaDescriptor getSchemaDescriptor(String string, boolean bl) throws StandardException {
        return StatementUtil.getSchemaDescriptor(string, bl, this.getDataDictionary(), this.getLanguageConnectionContext(), this.getCompilerContext());
    }

    TableName resolveTableToSynonym(TableName tableName) throws StandardException {
        AliasDescriptor aliasDescriptor;
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = tableName.getTableName();
        String string2 = tableName.getSchemaName();
        boolean bl = false;
        CompilerContext compilerContext = this.getCompilerContext();
        while ((object = this.getSchemaDescriptor(string2, false)) != null && ((SchemaDescriptor)object).getUUID() != null && (aliasDescriptor = dataDictionary.getAliasDescriptor(((SchemaDescriptor)object).getUUID().toString(), string, 'S')) != null) {
            compilerContext.createDependency(aliasDescriptor);
            bl = true;
            SynonymAliasInfo synonymAliasInfo = (SynonymAliasInfo)aliasDescriptor.getAliasInfo();
            string = synonymAliasInfo.getSynonymTable();
            string2 = synonymAliasInfo.getSynonymSchema();
        }
        if (!bl) {
            return null;
        }
        object = new TableName(string2, string, this.getContextManager());
        return object;
    }

    void verifyClassExist(String string) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        ClassNotFoundException classNotFoundException = null;
        boolean bl = false;
        try {
            bl = classInspector.accessible(string);
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        if (!bl) {
            throw StandardException.newException("42X51", classNotFoundException, string);
        }
        if (ClassInspector.primitiveType(string)) {
            throw StandardException.newException("42Y37", string);
        }
    }

    void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
    }

    void generateAuthorizeCheck(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n) {
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        methodBuilder.callMethod((short)185, null, "getAuthorizer", "org.apache.derby.iapi.sql.conn.Authorizer", 0);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, null, "authorize", "void", 2);
    }

    public void checkReliability(String string, int n) throws StandardException {
        if ((this.getCompilerContext().getReliability() & n) != 0) {
            this.throwReliabilityException(string, n);
        }
    }

    public void checkReliability(int n, String string) throws StandardException {
        if ((this.getCompilerContext().getReliability() & n) != 0) {
            String string2 = MessageService.getTextMessage(string, new Object[0]);
            this.throwReliabilityException(string2, n);
        }
    }

    public DataTypeDescriptor bindUserType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (dataTypeDescriptor.getCatalogType().isRowMultiSet()) {
            return this.bindRowMultiSet(dataTypeDescriptor);
        }
        if (!dataTypeDescriptor.getTypeId().userType()) {
            return dataTypeDescriptor;
        }
        UserDefinedTypeIdImpl userDefinedTypeIdImpl = (UserDefinedTypeIdImpl)dataTypeDescriptor.getTypeId().getBaseTypeId();
        if (userDefinedTypeIdImpl.isBound()) {
            return dataTypeDescriptor;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(userDefinedTypeIdImpl.getSchemaName());
        char c = 'A';
        String string = userDefinedTypeIdImpl.getUnqualifiedName();
        AliasDescriptor aliasDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string, c);
        if (aliasDescriptor == null) {
            throw StandardException.newException("42X94", AliasDescriptor.getAliasType(c), string);
        }
        this.createTypeDependency(aliasDescriptor);
        DataTypeDescriptor dataTypeDescriptor2 = new DataTypeDescriptor(TypeId.getUserDefinedTypeId(schemaDescriptor.getSchemaName(), string, aliasDescriptor.getJavaClassName()), dataTypeDescriptor.isNullable());
        return dataTypeDescriptor2;
    }

    public TypeDescriptor bindUserCatalogType(TypeDescriptor typeDescriptor) throws StandardException {
        if (!typeDescriptor.isUserDefinedType()) {
            return typeDescriptor;
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptor);
        dataTypeDescriptor = this.bindUserType(dataTypeDescriptor);
        return dataTypeDescriptor.getCatalogType();
    }

    public AliasDescriptor getUDTDesc(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        UserDefinedTypeIdImpl userDefinedTypeIdImpl = (UserDefinedTypeIdImpl)dataTypeDescriptor.getTypeId().getBaseTypeId();
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(userDefinedTypeIdImpl.getSchemaName());
        char c = 'A';
        String string = userDefinedTypeIdImpl.getUnqualifiedName();
        AliasDescriptor aliasDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string, c);
        return aliasDescriptor;
    }

    void addUDTUsagePriv(List<ValueNode> list) throws StandardException {
        if (!this.isPrivilegeCollectionRequired()) {
            return;
        }
        for (ValueNode valueNode : list) {
            this.addUDTUsagePriv(valueNode);
        }
    }

    void addUDTUsagePriv(ValueNode valueNode) throws StandardException {
        if (!this.isPrivilegeCollectionRequired()) {
            return;
        }
        DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
        if (dataTypeDescriptor != null && dataTypeDescriptor.getTypeId().userType()) {
            AliasDescriptor aliasDescriptor = this.getUDTDesc(dataTypeDescriptor);
            this.getCompilerContext().addRequiredUsagePriv(aliasDescriptor);
        }
    }

    public DataTypeDescriptor bindRowMultiSet(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (!dataTypeDescriptor.getCatalogType().isRowMultiSet()) {
            return dataTypeDescriptor;
        }
        RowMultiSetImpl rowMultiSetImpl = (RowMultiSetImpl)dataTypeDescriptor.getTypeId().getBaseTypeId();
        TypeDescriptor[] typeDescriptorArray = rowMultiSetImpl.getTypes();
        int n = typeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            typeDescriptorArray[i] = this.bindUserCatalogType(typeDescriptorArray[i]);
        }
        rowMultiSetImpl.setTypes(typeDescriptorArray);
        return dataTypeDescriptor;
    }

    public void createTypeDependency(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        AliasDescriptor aliasDescriptor = this.getDataDictionary().getAliasDescriptorForUDT(null, dataTypeDescriptor);
        if (aliasDescriptor != null) {
            this.createTypeDependency(aliasDescriptor);
        }
    }

    private void createTypeDependency(AliasDescriptor aliasDescriptor) throws StandardException {
        this.getCompilerContext().createDependency(aliasDescriptor);
        if (this.isPrivilegeCollectionRequired() && !this.getCompilerContext().skippingTypePrivileges()) {
            this.getCompilerContext().addRequiredUsagePriv(aliasDescriptor);
        }
    }

    private void throwReliabilityException(String string, int n) throws StandardException {
        String string2;
        int n2 = this.getCompilerContext().getReliability();
        if (n2 == 1192) {
            string2 = "42Y84";
        } else if (n2 == 30329) {
            switch (n) {
                case 8192: {
                    string2 = "42XA5";
                    break;
                }
                default: {
                    string2 = "42XA2";
                    break;
                }
            }
        } else {
            string2 = (n2 & n & 0x2000) != 0 ? "42XA5" : (n2 == 18041 ? "42Y39" : "42Y98");
        }
        throw StandardException.newException(string2, string);
    }

    public int orReliability(int n) {
        CompilerContext compilerContext = this.getCompilerContext();
        int n2 = compilerContext.getReliability();
        compilerContext.setReliability(n2 | n);
        return n2;
    }

    public static void bindOffsetFetch(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        long l;
        DataValueDescriptor dataValueDescriptor;
        if (valueNode instanceof ConstantNode) {
            dataValueDescriptor = ((ConstantNode)valueNode).getValue();
            l = dataValueDescriptor.getLong();
            if (l < 0L) {
                throw StandardException.newException("2201X", Long.toString(l));
            }
        } else if (valueNode instanceof ParameterNode) {
            valueNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
        if (valueNode2 instanceof ConstantNode) {
            dataValueDescriptor = ((ConstantNode)valueNode2).getValue();
            l = dataValueDescriptor.getLong();
            if (l < 1L) {
                throw StandardException.newException("2201W", Long.toString(l));
            }
        } else if (valueNode2 instanceof ParameterNode) {
            valueNode2.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(-5), false));
        }
    }

    public <N extends QueryTreeNode> SortedSet<N> getOffsetOrderedNodes(Class<N> clazz) throws StandardException {
        OffsetOrderVisitor<N> offsetOrderVisitor = new OffsetOrderVisitor<N>(clazz, this.getBeginOffset(), this.getEndOffset() + 1);
        this.accept(offsetOrderVisitor);
        return offsetOrderVisitor.getNodes();
    }

    static Context getContext(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }
}

