/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.pb;

import com.google.protobuf.GeneratedMessage;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.NodeAttributeOpCode;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
public class PlacementConstraintToProtoConverter
implements PlacementConstraint.Visitor<GeneratedMessage> {
    private PlacementConstraint placementConstraint;

    public PlacementConstraintToProtoConverter(PlacementConstraint placementConstraint) {
        this.placementConstraint = placementConstraint;
    }

    public YarnProtos.PlacementConstraintProto convert() {
        return (YarnProtos.PlacementConstraintProto)this.placementConstraint.getConstraintExpr().accept((PlacementConstraint.Visitor)this);
    }

    public GeneratedMessage visit(PlacementConstraint.SingleConstraint constraint) {
        YarnProtos.SimplePlacementConstraintProto.Builder sb = YarnProtos.SimplePlacementConstraintProto.newBuilder();
        if (constraint.getScope() != null) {
            sb.setScope(constraint.getScope());
        }
        sb.setMinCardinality(constraint.getMinCardinality());
        sb.setMaxCardinality(constraint.getMaxCardinality());
        if (constraint.getNodeAttributeOpCode() != null) {
            sb.setAttributeOpCode(PlacementConstraintToProtoConverter.convertToProtoFormat(constraint.getNodeAttributeOpCode()));
        }
        if (constraint.getTargetExpressions() != null) {
            for (PlacementConstraint.TargetExpression target : constraint.getTargetExpressions()) {
                sb.addTargetExpressions((YarnProtos.PlacementConstraintTargetProto)target.accept((PlacementConstraint.Visitor)this));
            }
        }
        YarnProtos.SimplePlacementConstraintProto sProto = sb.build();
        YarnProtos.PlacementConstraintProto.Builder pb = YarnProtos.PlacementConstraintProto.newBuilder();
        pb.setSimpleConstraint(sProto);
        return pb.build();
    }

    public GeneratedMessage visit(PlacementConstraint.TargetExpression target) {
        YarnProtos.PlacementConstraintTargetProto.Builder tb = YarnProtos.PlacementConstraintTargetProto.newBuilder();
        tb.setTargetType(ProtoUtils.convertToProtoFormat(target.getTargetType()));
        if (target.getTargetKey() != null) {
            tb.setTargetKey(target.getTargetKey());
        }
        if (target.getTargetValues() != null) {
            tb.addAllTargetValues((Iterable)target.getTargetValues());
        }
        return tb.build();
    }

    public GeneratedMessage visit(PlacementConstraint.TargetConstraint constraint) {
        throw new YarnRuntimeException("Unexpected TargetConstraint found.");
    }

    public GeneratedMessage visit(PlacementConstraint.CardinalityConstraint constraint) {
        throw new YarnRuntimeException("Unexpected CardinalityConstraint found.");
    }

    private GeneratedMessage visitAndOr(PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint> composite, YarnProtos.CompositePlacementConstraintProto.CompositeType type) {
        YarnProtos.CompositePlacementConstraintProto.Builder cb = YarnProtos.CompositePlacementConstraintProto.newBuilder();
        cb.setCompositeType(type);
        for (PlacementConstraint.AbstractConstraint c : composite.getChildren()) {
            cb.addChildConstraints((YarnProtos.PlacementConstraintProto)c.accept((PlacementConstraint.Visitor)this));
        }
        YarnProtos.CompositePlacementConstraintProto cProto = cb.build();
        YarnProtos.PlacementConstraintProto.Builder pb = YarnProtos.PlacementConstraintProto.newBuilder();
        pb.setCompositeConstraint(cProto);
        return pb.build();
    }

    public GeneratedMessage visit(PlacementConstraint.And constraint) {
        return this.visitAndOr((PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint>)constraint, YarnProtos.CompositePlacementConstraintProto.CompositeType.AND);
    }

    public GeneratedMessage visit(PlacementConstraint.Or constraint) {
        return this.visitAndOr((PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint>)constraint, YarnProtos.CompositePlacementConstraintProto.CompositeType.OR);
    }

    public GeneratedMessage visit(PlacementConstraint.DelayedOr constraint) {
        YarnProtos.CompositePlacementConstraintProto.Builder cb = YarnProtos.CompositePlacementConstraintProto.newBuilder();
        cb.setCompositeType(YarnProtos.CompositePlacementConstraintProto.CompositeType.DELAYED_OR);
        for (PlacementConstraint.TimedPlacementConstraint c : constraint.getChildren()) {
            cb.addTimedChildConstraints((YarnProtos.TimedPlacementConstraintProto)c.accept((PlacementConstraint.Visitor)this));
        }
        YarnProtos.CompositePlacementConstraintProto cProto = cb.build();
        YarnProtos.PlacementConstraintProto.Builder pb = YarnProtos.PlacementConstraintProto.newBuilder();
        pb.setCompositeConstraint(cProto);
        return pb.build();
    }

    public GeneratedMessage visit(PlacementConstraint.TimedPlacementConstraint constraint) {
        YarnProtos.TimedPlacementConstraintProto.Builder tb = YarnProtos.TimedPlacementConstraintProto.newBuilder();
        tb.setDelayUnit(ProtoUtils.convertToProtoFormat(constraint.getDelayUnit()));
        tb.setSchedulingDelay(constraint.getSchedulingDelay());
        tb.setPlacementConstraint((YarnProtos.PlacementConstraintProto)constraint.getConstraint().accept((PlacementConstraint.Visitor)this));
        return tb.build();
    }

    private static YarnProtos.NodeAttributeOpCodeProto convertToProtoFormat(NodeAttributeOpCode p) {
        return YarnProtos.NodeAttributeOpCodeProto.valueOf((String)p.name());
    }
}

