/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_RTS
#define GUARD_RTS

#include "GameState.h"
#include "DragWindow.h"
#include "Menu_Base.h"
#include "OptWindow.h"

namespace RTS {

class RTS_State: public GameState {
public:
	RTS_State();
	~RTS_State();
	void Main();
	
	void MouseD(Uint8 button, Uint16 x, Uint16 y);
	void MouseU(Uint8 button, Uint16 x, Uint16 y);
	void MouseM(Uint8 state, Uint16 x, Uint16 y);
	void Keyboard(SDL_keysym& keysym);
};

void RTSMouseD(Uint8 button, Uint16 x, Uint16 y);
void RTSMouseU(Uint8 button, Uint16 x, Uint16 y);
void RTSMouseM(Uint8 state, Uint16 x, Uint16 y);
void RTSKeyboard(SDL_keysym& keysym);
void ScrollAndDrag();

void SetupTerrain();

void RunGroupAI();
void RunMoveCommands();
void RunFireCommands();
void Upkeep();

void CheckViewPos();
void SetWorldUpdateInterval(int newValue);

void DrawWorld();
void DrawTerrain();
void DrawRadar();

void RestartPreBattle();

string MoveComToString(const AICommands& theCommands);
string FireComToString(const AICommands& theCommands);

class BasePU: public PopupMenu {
public:
	BasePU(int ix, int iy);
	bool SwitchOnChoice(Uint16 x, Uint16 y);
};

class OptPU: public StandardOptions {
public:
	OptPU(int ix, int iy);
	void Update();
};

class InfoChoicePU: public PopupMenu {
public:
	InfoChoicePU(int ix, int iy, int iInfoWinID, int groupOptions);
	InfoChoicePU(int ix, int iy, int iMySide, int iMyGroup, int groupOptions, int iParentID);

	bool SwitchOnChoice(Uint16 x, Uint16 y);

private:
	void AddSideOptions(MenuItem& tempItem);
	void AddGroupOptions(MenuItem& tempItem);
	int mySide;
	int myGroup;
	bool createNew;
};

class GroupInfo: public DragWindow {
public:
	GroupInfo(int ix, int iy, int iMySide, int iMyGroup, int flags);
	bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual void DrawSelf() = 0;

	void WinMessage(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID);

protected:
	int mySide;
	int myGroup;
};

class GroupStatsInfo: public GroupInfo {
public:
	GroupStatsInfo(int ix, int iy, int iMySide, int iNGroup, int flags);

	void DrawSelf();
};

class GroupShieldsInfo: public GroupInfo {
public:
	GroupShieldsInfo(int ix, int iy, int iMySide, int iNGroup, int flags);

	void DrawSelf();
};

class GroupStatusReport: public GroupInfo {
public:
	GroupStatusReport(int ix, int iy, int iMySide, int iMyGroup, int flags);

	void DrawSelf();
};

class GroupAIReport: public GroupInfo {
public:
	GroupAIReport(int ix, int iy, int iMySide, int iMyGroup, int flags);

	void DrawSelf();

protected:
	list<string> reports;
	AICommands oldCommands;
};

class GroupVarsInfo: public GroupInfo {
public:
	GroupVarsInfo(int ix, int iy, int iMySide, int iMyGroup, int flags);
	void DrawSelf();
};

class GroupSaveGroupsInfo: public GroupInfo {
public:
	GroupSaveGroupsInfo(int ix, int iy, int iMySide, int iMyGroup, int flags);
	void DrawSelf();
};

class GroupTimersInfo: public GroupInfo {
public:
	GroupTimersInfo(int ix, int iy, int iMySide, int iMyGroup, int flags);
	void DrawSelf();
};

class GameInfo: public DragWindow {
public:
	GameInfo(int ix, int iy, int flags);
	void DrawSelf();
};

class SideInfo: public DragWindow {
public:
	SideInfo(int ix, int iy, int iMySide, int flags);
	bool MouseD(Uint8 button, Uint16 x, Uint16 y);
	virtual void DrawSelf() = 0;
	
	void WinMessage(WindowChoice theMessage, int paremOne, int paremTwo, int targetID, int sourceID);

protected:
	int mySide;
};

class SideStatsInfo: public SideInfo {
public:
	SideStatsInfo(int ix, int iy, int iMySide);
	void DrawSelf();
};

class SideVarsInfo: public SideInfo {
public:
	SideVarsInfo(int ix, int iy, int iMySide);
	void DrawSelf();
};

class SideSaveGroupsInfo: public SideInfo {
public:
	SideSaveGroupsInfo(int ix, int iy, int iMySide);
	void DrawSelf();
};

class SideAIErrors: public SideInfo {
public:
	SideAIErrors(int ix, int iy, int iMySide);
	void DrawSelf();
};

class RestartQ: public Menu_Base {
public:
	RestartQ();
	bool SwitchOnChoice(Uint16 x, Uint16 y);
};

class GameSpeedSlider: public SliderWithUnits {
public:
	GameSpeedSlider(int ix, int iy, int flags);

	bool MouseM(Uint8 state, Uint16 x, Uint16 y);
	void DrawSelf();
};

class ScrollSpeedSlider: public SliderWithUnits {
public:
	ScrollSpeedSlider(int ix, int iy, int flags);

	bool MouseM(Uint8 state, Uint16 x, Uint16 y);
};

} //end namespace

#endif

