/*
 *  Copyright (C) 2005-2018 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#pragma once

#include "IDirectory.h"

namespace XFILE
{
  class CHTTPDirectory : public IDirectory
  {
    public:
      CHTTPDirectory(void);
      ~CHTTPDirectory(void) override;
      bool GetDirectory(const CURL& url, CFileItemList &items) override;
      bool Exists(const CURL& url) override;
      CacheType GetCacheType(const CURL& url) const override { return CacheType::ONCE; }

    private:
  };
}
