#include "defs.h"
#include <stdio.h>
#include "imageio.h"
#include "imagemath.h"
#ifdef USE_DEBUG
#include "time.h"
#endif
#ifdef USE_CLUSTER
#include "cluster.h"
#endif

int normalize(ImagePtr* dest, ImagePtr imsource,int size) {
/*Modifies the brightness of the source image
  to use all values between 0 and 255
  and saves this into dest
  averages over <size> pixels when calculating
  minimum and maximum to disregard errors
  */

   ImagePtr imdest;		/*VarPointers to the Image Data*/
   int t,tt,actual,sum;		/*Several integers*/
   int x,y,x2,y2,min,max;
   int color[256];		/*Some sort of Color Map*/

#ifdef USE_DEBUG
   clock_t starttime;
   starttime=clock();
   fprintf(stderr,"Running normalize with size %i ...\n", size);
#endif

   imdest   = createim(widthim(imsource),heightim(imsource));
   *dest=imdest;
   /*We create a destination image the size of the source*/
   /*and give its adress back*/

   t=0;
   while (t<256) {
      color[t]=collorallocateim(imdest,t,t,t);
      t++;
   }
   /*We create some sort of 256 colors b/w colormap for the destination*/

   tt=0;
   sum=0;
   min=pixelbrightim(imsource,0,0);
   max=min;
   x=widthim(imdest);
   x2=x/size;
   y=heightim(imdest);
   y2=y/size;
   #ifdef USE_CLUSTER
      cluster_split();
      tt=cluster_split_min(0,y2);
      y2=cluster_split_max(0,y2);
      #ifdef USE_DEBUG
         fprintf(stderr,"process(%i): doing from %i till %i ...\n",pid(),tt,y);
      #endif
   #endif
   while (tt<y2) {
      t=0;
      while (t<x2) {
         actual=scalepixelim(imsource,256*t*size,256*tt*size,256*(t+1)*size,256*(tt+1)*size);
	 if (actual<min) min=actual;
	 if (actual>max) max=actual;
	 t++;
      }
      tt++;
   }
   #ifdef USE_CLUSTER
      min=cluster_sync_min(min);
      max=cluster_sync_max(max);
   #endif
   if (max==min) max++;
   x2=65536/(max-min);
   y2=-min;
#ifdef USE_DEBUG
   fprintf(stderr,"... min is %i, max is %i, correction is %i times %.4f\n", min,max,y2,x2/256);
#endif
   /*newbrightness=a*oldbrightness+b*/
   tt=0;
   #ifdef USE_CLUSTER
      tt=cluster_split_min(0,y);
      y=cluster_split_max(0,y);
      #ifdef USE_DEBUG
         fprintf(stderr,"process(%i): doing from %i till %i ...\n",pid(),tt,y);
      #endif
   #endif
   while (tt<y) {
      t=0;
      while (t<x) {
         actual=pixelbrightim(imsource,t,tt);
         actual=(x2*(actual+y2))/256;
	 if (actual>255) actual=255;
	 if (actual<0) actual=0;
	 sum+=actual;
	 drawpixelim(imdest,t,tt,color[actual]);
         t++;
      }
      tt++;
   };
   /*Main Working stuff, this is important!
     First calculate the minimum and maximum brightness values
     by going through all pixels,
     then calculate the correction factor and save all pixels
     in destination modified by that correction */

#ifdef USE_CLUSTER
   sum=cluster_sync_add(sum);
   processsyncim(imdest,heightim(imdest));
   cluster_regroup();
   /*re combine execution*/
#endif



#ifdef USE_DEBUG
   fprintf(stderr," ... took  %.4f seconds!\n",(1.0 * (clock() - starttime) / CLOCKS_PER_SEC));
#endif
  return sum;
  /*and we are finnished*/

}


