// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPErrorRuleDefaultsAcceptedCode is the HTTP code returned for type DeleteHTTPErrorRuleDefaultsAccepted
const DeleteHTTPErrorRuleDefaultsAcceptedCode int = 202

/*
DeleteHTTPErrorRuleDefaultsAccepted Configuration change accepted and reload requested

swagger:response deleteHttpErrorRuleDefaultsAccepted
*/
type DeleteHTTPErrorRuleDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPErrorRuleDefaultsAccepted creates DeleteHTTPErrorRuleDefaultsAccepted with default headers values
func NewDeleteHTTPErrorRuleDefaultsAccepted() *DeleteHTTPErrorRuleDefaultsAccepted {

	return &DeleteHTTPErrorRuleDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the delete Http error rule defaults accepted response
func (o *DeleteHTTPErrorRuleDefaultsAccepted) WithReloadID(reloadID string) *DeleteHTTPErrorRuleDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http error rule defaults accepted response
func (o *DeleteHTTPErrorRuleDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPErrorRuleDefaultsNoContentCode is the HTTP code returned for type DeleteHTTPErrorRuleDefaultsNoContent
const DeleteHTTPErrorRuleDefaultsNoContentCode int = 204

/*
DeleteHTTPErrorRuleDefaultsNoContent HTTP Error Rule deleted

swagger:response deleteHttpErrorRuleDefaultsNoContent
*/
type DeleteHTTPErrorRuleDefaultsNoContent struct {
}

// NewDeleteHTTPErrorRuleDefaultsNoContent creates DeleteHTTPErrorRuleDefaultsNoContent with default headers values
func NewDeleteHTTPErrorRuleDefaultsNoContent() *DeleteHTTPErrorRuleDefaultsNoContent {

	return &DeleteHTTPErrorRuleDefaultsNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleDefaultsNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPErrorRuleDefaultsNotFoundCode is the HTTP code returned for type DeleteHTTPErrorRuleDefaultsNotFound
const DeleteHTTPErrorRuleDefaultsNotFoundCode int = 404

/*
DeleteHTTPErrorRuleDefaultsNotFound The specified resource was not found

swagger:response deleteHttpErrorRuleDefaultsNotFound
*/
type DeleteHTTPErrorRuleDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPErrorRuleDefaultsNotFound creates DeleteHTTPErrorRuleDefaultsNotFound with default headers values
func NewDeleteHTTPErrorRuleDefaultsNotFound() *DeleteHTTPErrorRuleDefaultsNotFound {

	return &DeleteHTTPErrorRuleDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http error rule defaults not found response
func (o *DeleteHTTPErrorRuleDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPErrorRuleDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http error rule defaults not found response
func (o *DeleteHTTPErrorRuleDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http error rule defaults not found response
func (o *DeleteHTTPErrorRuleDefaultsNotFound) WithPayload(payload *models.Error) *DeleteHTTPErrorRuleDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http error rule defaults not found response
func (o *DeleteHTTPErrorRuleDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPErrorRuleDefaultsDefault General Error

swagger:response deleteHttpErrorRuleDefaultsDefault
*/
type DeleteHTTPErrorRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPErrorRuleDefaultsDefault creates DeleteHTTPErrorRuleDefaultsDefault with default headers values
func NewDeleteHTTPErrorRuleDefaultsDefault(code int) *DeleteHTTPErrorRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPErrorRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP error rule defaults default response
func (o *DeleteHTTPErrorRuleDefaultsDefault) WithStatusCode(code int) *DeleteHTTPErrorRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP error rule defaults default response
func (o *DeleteHTTPErrorRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP error rule defaults default response
func (o *DeleteHTTPErrorRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPErrorRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP error rule defaults default response
func (o *DeleteHTTPErrorRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP error rule defaults default response
func (o *DeleteHTTPErrorRuleDefaultsDefault) WithPayload(payload *models.Error) *DeleteHTTPErrorRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP error rule defaults default response
func (o *DeleteHTTPErrorRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPErrorRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
