// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateLogTargetGlobalCreatedCode is the HTTP code returned for type CreateLogTargetGlobalCreated
const CreateLogTargetGlobalCreatedCode int = 201

/*
CreateLogTargetGlobalCreated Log Target created

swagger:response createLogTargetGlobalCreated
*/
type CreateLogTargetGlobalCreated struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetGlobalCreated creates CreateLogTargetGlobalCreated with default headers values
func NewCreateLogTargetGlobalCreated() *CreateLogTargetGlobalCreated {

	return &CreateLogTargetGlobalCreated{}
}

// WithPayload adds the payload to the create log target global created response
func (o *CreateLogTargetGlobalCreated) WithPayload(payload *models.LogTarget) *CreateLogTargetGlobalCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target global created response
func (o *CreateLogTargetGlobalCreated) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetGlobalCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetGlobalAcceptedCode is the HTTP code returned for type CreateLogTargetGlobalAccepted
const CreateLogTargetGlobalAcceptedCode int = 202

/*
CreateLogTargetGlobalAccepted Configuration change accepted and reload requested

swagger:response createLogTargetGlobalAccepted
*/
type CreateLogTargetGlobalAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetGlobalAccepted creates CreateLogTargetGlobalAccepted with default headers values
func NewCreateLogTargetGlobalAccepted() *CreateLogTargetGlobalAccepted {

	return &CreateLogTargetGlobalAccepted{}
}

// WithReloadID adds the reloadId to the create log target global accepted response
func (o *CreateLogTargetGlobalAccepted) WithReloadID(reloadID string) *CreateLogTargetGlobalAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create log target global accepted response
func (o *CreateLogTargetGlobalAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create log target global accepted response
func (o *CreateLogTargetGlobalAccepted) WithPayload(payload *models.LogTarget) *CreateLogTargetGlobalAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target global accepted response
func (o *CreateLogTargetGlobalAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetGlobalAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetGlobalBadRequestCode is the HTTP code returned for type CreateLogTargetGlobalBadRequest
const CreateLogTargetGlobalBadRequestCode int = 400

/*
CreateLogTargetGlobalBadRequest Bad request

swagger:response createLogTargetGlobalBadRequest
*/
type CreateLogTargetGlobalBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetGlobalBadRequest creates CreateLogTargetGlobalBadRequest with default headers values
func NewCreateLogTargetGlobalBadRequest() *CreateLogTargetGlobalBadRequest {

	return &CreateLogTargetGlobalBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target global bad request response
func (o *CreateLogTargetGlobalBadRequest) WithConfigurationVersion(configurationVersion string) *CreateLogTargetGlobalBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target global bad request response
func (o *CreateLogTargetGlobalBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target global bad request response
func (o *CreateLogTargetGlobalBadRequest) WithPayload(payload *models.Error) *CreateLogTargetGlobalBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target global bad request response
func (o *CreateLogTargetGlobalBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetGlobalBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetGlobalConflictCode is the HTTP code returned for type CreateLogTargetGlobalConflict
const CreateLogTargetGlobalConflictCode int = 409

/*
CreateLogTargetGlobalConflict The specified resource already exists

swagger:response createLogTargetGlobalConflict
*/
type CreateLogTargetGlobalConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetGlobalConflict creates CreateLogTargetGlobalConflict with default headers values
func NewCreateLogTargetGlobalConflict() *CreateLogTargetGlobalConflict {

	return &CreateLogTargetGlobalConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target global conflict response
func (o *CreateLogTargetGlobalConflict) WithConfigurationVersion(configurationVersion string) *CreateLogTargetGlobalConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target global conflict response
func (o *CreateLogTargetGlobalConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target global conflict response
func (o *CreateLogTargetGlobalConflict) WithPayload(payload *models.Error) *CreateLogTargetGlobalConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target global conflict response
func (o *CreateLogTargetGlobalConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetGlobalConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateLogTargetGlobalDefault General Error

swagger:response createLogTargetGlobalDefault
*/
type CreateLogTargetGlobalDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetGlobalDefault creates CreateLogTargetGlobalDefault with default headers values
func NewCreateLogTargetGlobalDefault(code int) *CreateLogTargetGlobalDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateLogTargetGlobalDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create log target global default response
func (o *CreateLogTargetGlobalDefault) WithStatusCode(code int) *CreateLogTargetGlobalDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create log target global default response
func (o *CreateLogTargetGlobalDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create log target global default response
func (o *CreateLogTargetGlobalDefault) WithConfigurationVersion(configurationVersion string) *CreateLogTargetGlobalDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target global default response
func (o *CreateLogTargetGlobalDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target global default response
func (o *CreateLogTargetGlobalDefault) WithPayload(payload *models.Error) *CreateLogTargetGlobalDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target global default response
func (o *CreateLogTargetGlobalDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetGlobalDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
