// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllTCPRequestRuleBackendOKCode is the HTTP code returned for type GetAllTCPRequestRuleBackendOK
const GetAllTCPRequestRuleBackendOKCode int = 200

/*
GetAllTCPRequestRuleBackendOK Successful operation

swagger:response getAllTcpRequestRuleBackendOK
*/
type GetAllTCPRequestRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.TCPRequestRules `json:"body,omitempty"`
}

// NewGetAllTCPRequestRuleBackendOK creates GetAllTCPRequestRuleBackendOK with default headers values
func NewGetAllTCPRequestRuleBackendOK() *GetAllTCPRequestRuleBackendOK {

	return &GetAllTCPRequestRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Tcp request rule backend o k response
func (o *GetAllTCPRequestRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllTCPRequestRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Tcp request rule backend o k response
func (o *GetAllTCPRequestRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Tcp request rule backend o k response
func (o *GetAllTCPRequestRuleBackendOK) WithPayload(payload models.TCPRequestRules) *GetAllTCPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Tcp request rule backend o k response
func (o *GetAllTCPRequestRuleBackendOK) SetPayload(payload models.TCPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllTCPRequestRuleBackendDefault General Error

swagger:response getAllTcpRequestRuleBackendDefault
*/
type GetAllTCPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllTCPRequestRuleBackendDefault creates GetAllTCPRequestRuleBackendDefault with default headers values
func NewGetAllTCPRequestRuleBackendDefault(code int) *GetAllTCPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllTCPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all TCP request rule backend default response
func (o *GetAllTCPRequestRuleBackendDefault) WithStatusCode(code int) *GetAllTCPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all TCP request rule backend default response
func (o *GetAllTCPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all TCP request rule backend default response
func (o *GetAllTCPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllTCPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all TCP request rule backend default response
func (o *GetAllTCPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all TCP request rule backend default response
func (o *GetAllTCPRequestRuleBackendDefault) WithPayload(payload *models.Error) *GetAllTCPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all TCP request rule backend default response
func (o *GetAllTCPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
