/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.ConstraintsParameters;
import sun.security.util.Debug;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private final String[] disabledAlgorithms;
    private final Constraints algorithmConstraints;

    public DisabledAlgorithmConstraints(String string) {
        this(string, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String string, AlgorithmDecomposer algorithmDecomposer) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(string);
        this.algorithmConstraints = new Constraints(this.disabledAlgorithms);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (!DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, string, this.decomposer)) {
            return false;
        }
        if (algorithmParameters != null) {
            return this.algorithmConstraints.permits(string, algorithmParameters);
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    public final void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        this.permits(constraintsParameters.getAlgorithm(), constraintsParameters);
    }

    public final void permits(String string, Key key, AlgorithmParameters algorithmParameters, String string2) throws CertPathValidatorException {
        this.permits(string, new ConstraintsParameters(string, algorithmParameters, key, string2 == null ? "generic" : string2));
    }

    public final void permits(String string, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        this.algorithmConstraints.permits(string, constraintsParameters);
    }

    public boolean checkProperty(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (String string2 : this.disabledAlgorithms) {
            if (string2.toLowerCase(Locale.ENGLISH).indexOf(string) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    private static class DisabledConstraint
    extends Constraint {
        DisabledConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + this.algorithm + this.extendedMsg(constraintsParameters), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;
        private int size;

        public KeySizeConstraint(String string, Constraint.Operator operator, int n) {
            this.algorithm = string;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n;
                    break;
                }
                case NE: {
                    this.minSize = n;
                    this.maxSize = n;
                    break;
                }
                case LT: {
                    this.minSize = n;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = n + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = n;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = n > 1 ? n - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            Key key = null;
            if (constraintsParameters.getPublicKey() != null) {
                key = constraintsParameters.getPublicKey();
            } else if (constraintsParameters.getCertificate() != null) {
                key = constraintsParameters.getCertificate().getPublicKey();
            }
            if (key != null && !this.permitsImpl(key)) {
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(constraintsParameters);
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits. " + this.algorithm + " " + KeyUtil.getKeySize(key) + "bit key" + this.extendedMsg(constraintsParameters), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        @Override
        public boolean permits(AlgorithmParameters algorithmParameters) {
            Collection<String> collection;
            String string = algorithmParameters.getAlgorithm();
            if (!this.algorithm.equalsIgnoreCase(algorithmParameters.getAlgorithm()) && !(collection = AlgorithmDecomposer.getAliases(this.algorithm)).contains(string)) {
                return true;
            }
            int n = KeyUtil.getKeySize(algorithmParameters);
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                return n >= this.minSize && n <= this.maxSize && this.prohibitedSize != n;
            }
            return true;
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            this.size = KeyUtil.getKeySize(key);
            if (this.size == 0) {
                return false;
            }
            if (this.size > 0) {
                return this.size >= this.minSize && this.size <= this.maxSize && this.prohibitedSize != this.size;
            }
            return true;
        }
    }

    private static class UsageConstraint
    extends Constraint {
        String[] usages;

        UsageConstraint(String string, String[] stringArray) {
            this.algorithm = string;
            this.usages = stringArray;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            for (String string : this.usages) {
                String string2 = null;
                if (string.compareToIgnoreCase("TLSServer") == 0) {
                    string2 = "tls server";
                } else if (string.compareToIgnoreCase("TLSClient") == 0) {
                    string2 = "tls client";
                } else if (string.compareToIgnoreCase("SignedJAR") == 0) {
                    string2 = "plugin code signing";
                }
                if (debug != null) {
                    debug.println("Checking if usage constraint \"" + string2 + "\" matches \"" + constraintsParameters.getVariant() + "\"");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    new Exception().printStackTrace(printStream);
                    debug.println(byteArrayOutputStream.toString());
                }
                if (constraintsParameters.getVariant().compareTo(string2) != 0) continue;
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Usage constraint " + string + " check failed: " + this.algorithm + this.extendedMsg(constraintsParameters), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static class DenyAfterConstraint
    extends Constraint {
        private Date denyAfterDate;
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d HH:mm:ss z yyyy");

        DenyAfterConstraint(String string, int n, int n2, int n3) {
            Calendar calendar;
            this.algorithm = string;
            if (debug != null) {
                debug.println("DenyAfterConstraint read in as:  year " + n + ", month = " + n2 + ", day = " + n3);
            }
            if (n > (calendar = new Calendar.Builder().setTimeZone(TimeZone.getTimeZone("GMT")).setDate(n, n2 - 1, n3).build()).getActualMaximum(1) || n < calendar.getActualMinimum(1)) {
                throw new IllegalArgumentException("Invalid year given in constraint: " + n);
            }
            if (n2 - 1 > calendar.getActualMaximum(2) || n2 - 1 < calendar.getActualMinimum(2)) {
                throw new IllegalArgumentException("Invalid month given in constraint: " + n2);
            }
            if (n3 > calendar.getActualMaximum(5) || n3 < calendar.getActualMinimum(5)) {
                throw new IllegalArgumentException("Invalid Day of Month given in constraint: " + n3);
            }
            this.denyAfterDate = calendar.getTime();
            if (debug != null) {
                debug.println("DenyAfterConstraint date set to: " + dateFormat.format(this.denyAfterDate));
            }
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            String string;
            Date date;
            if (constraintsParameters.getJARTimestamp() != null) {
                date = constraintsParameters.getJARTimestamp().getTimestamp();
                string = "JAR Timestamp date: ";
            } else if (constraintsParameters.getPKIXParamDate() != null) {
                date = constraintsParameters.getPKIXParamDate();
                string = "PKIXParameter date: ";
            } else {
                date = new Date();
                string = "Current date: ";
            }
            if (!this.denyAfterDate.after(date)) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("denyAfter constraint check failed: " + this.algorithm + " used with Constraint date: " + dateFormat.format(this.denyAfterDate) + "; " + string + dateFormat.format(date) + this.extendedMsg(constraintsParameters), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.next(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("DenyAfterConstraints.permits(): " + this.algorithm);
            }
            return this.denyAfterDate.after(new Date());
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (constraintsParameters.isTrustedMatch()) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits. " + this.algorithm + this.extendedMsg(constraintsParameters), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public boolean permits(AlgorithmParameters algorithmParameters) {
            return true;
        }

        public abstract void permits(ConstraintsParameters var1) throws CertPathValidatorException;

        boolean next(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (this.nextConstraint != null) {
                this.nextConstraint.permits(constraintsParameters);
                return true;
            }
            return false;
        }

        boolean next(Key key) {
            return this.nextConstraint != null && this.nextConstraint.permits(key);
        }

        String extendedMsg(ConstraintsParameters constraintsParameters) {
            return constraintsParameters.getCertificate() == null ? "." : " used with certificate: " + constraintsParameters.getCertificate().getSubjectX500Principal() + (constraintsParameters.getVariant() != "generic" ? ".  Usage was " + constraintsParameters.getVariant() : ".");
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + string + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();

        /*
         * WARNING - void declaration
         */
        public Constraints(String[] stringArray) {
            for (String string : stringArray) {
                int n;
                if (string == null || string.isEmpty()) continue;
                string = string.trim();
                if (debug != null) {
                    debug.println("Constraints: " + string);
                }
                String string2 = AlgorithmDecomposer.hashName((n = string.indexOf(32)) > 0 ? string.substring(0, n) : string);
                List list = this.constraintsMap.getOrDefault(string2.toUpperCase(Locale.ENGLISH), new ArrayList(1));
                for (String string3 : AlgorithmDecomposer.getAliases(string2)) {
                    this.constraintsMap.putIfAbsent(string3.toUpperCase(Locale.ENGLISH), list);
                }
                if (n <= 0) {
                    list.add(new DisabledConstraint(string2));
                    continue;
                }
                String string3 = string.substring(n + 1);
                Object var11_17 = null;
                boolean bl = false;
                boolean bl2 = false;
                for (String string4 : string3.split("&")) {
                    void var10_16;
                    Matcher matcher;
                    String[] stringArray2;
                    if ((string4 = string4.trim()).startsWith("keySize")) {
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + string4);
                        }
                        if (!"keySize".equals((stringArray2 = new StringTokenizer(string4)).nextToken())) {
                            throw new IllegalArgumentException("Error in security property. Constraint unknown: " + string4);
                        }
                        KeySizeConstraint keySizeConstraint = new KeySizeConstraint(string2, Constraint.Operator.of(stringArray2.nextToken()), Integer.parseInt(stringArray2.nextToken()));
                    } else if (string4.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (bl) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + string);
                        }
                        jdkCAConstraint jdkCAConstraint2 = new jdkCAConstraint(string2);
                        bl = true;
                    } else if (string4.startsWith("denyAfter") && (matcher = Holder.DENY_AFTER_PATTERN.matcher(string4)).matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to denyAfter");
                        }
                        if (bl2) {
                            throw new IllegalArgumentException("Only one denyAfter entry allowed in property. Constraint: " + string);
                        }
                        int n2 = Integer.parseInt(matcher.group(1));
                        int n3 = Integer.parseInt(matcher.group(2));
                        int n4 = Integer.parseInt(matcher.group(3));
                        DenyAfterConstraint denyAfterConstraint = new DenyAfterConstraint(string2, n2, n3, n4);
                        bl2 = true;
                    } else if (string4.startsWith("usage")) {
                        stringArray2 = string4.substring(5).trim().split(" ");
                        UsageConstraint usageConstraint = new UsageConstraint(string2, stringArray2);
                        if (debug != null) {
                            debug.println("Constraints usage length is " + stringArray2.length);
                        }
                    } else {
                        throw new IllegalArgumentException("Error in security property. Constraint unknown: " + string4);
                    }
                    if (var11_17 == null) {
                        list.add(var10_16);
                    } else {
                        var11_17.nextConstraint = var10_16;
                    }
                    var11_17 = var10_16;
                }
            }
        }

        private List<Constraint> getConstraints(String string) {
            return this.constraintsMap.get(string.toUpperCase(Locale.ENGLISH));
        }

        public boolean permits(Key key) {
            List<Constraint> list = this.getConstraints(key.getAlgorithm());
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("keySizeConstraint: failed key constraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public boolean permits(String string, AlgorithmParameters algorithmParameters) {
            List<Constraint> list = this.getConstraints(string);
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(algorithmParameters)) continue;
                if (debug != null) {
                    debug.println("keySizeConstraint: failed algorithm parameters constraint check " + algorithmParameters);
                }
                return false;
            }
            return true;
        }

        public void permits(String string, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            X509Certificate x509Certificate = constraintsParameters.getCertificate();
            if (debug != null) {
                debug.println("Constraints.permits(): " + string + " Variant: " + constraintsParameters.getVariant());
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (string != null) {
                hashSet.addAll(AlgorithmDecomposer.decomposeOneHash(string));
                hashSet.add(string);
            }
            if (x509Certificate != null) {
                hashSet.add(x509Certificate.getPublicKey().getAlgorithm());
            }
            if (constraintsParameters.getPublicKey() != null) {
                hashSet.add(constraintsParameters.getPublicKey().getAlgorithm());
            }
            for (String string2 : hashSet) {
                List<Constraint> list = this.getConstraints(string2);
                if (list == null) continue;
                for (Constraint constraint : list) {
                    constraint.permits(constraintsParameters);
                }
            }
        }

        private static class Holder {
            private static final Pattern DENY_AFTER_PATTERN = Pattern.compile("denyAfter\\s+(\\d{4})-(\\d{2})-(\\d{2})");

            private Holder() {
            }
        }
    }
}

