/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avfilter;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.bytedeco.javacpp.postproc;
import org.bytedeco.javacpp.swresample;
import org.bytedeco.javacpp.swscale;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameFilter;

public class FFmpegFrameFilter
extends FrameFilter {
    private static FrameFilter.Exception loadingException = null;
    avfilter.AVFilterContext buffersink_ctx;
    avfilter.AVFilterContext buffersrc_ctx;
    avfilter.AVFilterContext setpts_ctx;
    avfilter.AVFilterGraph filter_graph;
    avfilter.AVFilterContext abuffersink_ctx;
    avfilter.AVFilterContext abuffersrc_ctx;
    avfilter.AVFilterGraph afilter_graph;
    avutil.AVFrame image_frame;
    avutil.AVFrame samples_frame;
    avutil.AVFrame filt_frame;
    BytePointer[] image_ptr;
    BytePointer[] samples_ptr;
    Buffer[] image_buf;
    Buffer[] samples_buf;
    Frame frame;
    Frame inframe;

    public static void tryLoad() throws FrameFilter.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(postproc.class);
            Loader.load(swresample.class);
            Loader.load(swscale.class);
            Loader.load(avfilter.class);
            avformat.av_register_all();
            avfilter.avfilter_register_all();
        }
        catch (Throwable t) {
            if (t instanceof FrameFilter.Exception) {
                loadingException = (FrameFilter.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameFilter.Exception("Failed to load " + FFmpegFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameFilter(String videoFilters, String audioFilters, int imageWidth, int imageHeight, int audioChannels) {
        this.filters = videoFilters;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 3;
        this.frameRate = 30.0;
        this.aspectRatio = 0.0;
        this.afilters = audioFilters;
        this.audioChannels = audioChannels;
        this.sampleFormat = 1;
        this.sampleRate = 44100;
    }

    public FFmpegFrameFilter(String filters, int imageWidth, int imageHeight) {
        this(filters, null, imageWidth, imageHeight, 0);
    }

    public FFmpegFrameFilter(String afilters, int audioChannels) {
        this(null, afilters, 0, 0, audioChannels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws FrameFilter.Exception {
        Class<avfilter> clazz = avfilter.class;
        synchronized (avfilter.class) {
            this.releaseUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void releaseUnsafe() throws FrameFilter.Exception {
        if (this.filter_graph != null) {
            avfilter.avfilter_graph_free((avfilter.AVFilterGraph)this.filter_graph);
            this.buffersink_ctx = null;
            this.buffersrc_ctx = null;
            this.setpts_ctx = null;
            this.filter_graph = null;
        }
        if (this.afilter_graph != null) {
            avfilter.avfilter_graph_free((avfilter.AVFilterGraph)this.afilter_graph);
            this.abuffersink_ctx = null;
            this.abuffersrc_ctx = null;
            this.afilter_graph = null;
        }
        if (this.image_frame != null) {
            avutil.av_frame_free((avutil.AVFrame)this.image_frame);
            this.image_frame = null;
        }
        if (this.samples_frame != null) {
            avutil.av_frame_free((avutil.AVFrame)this.samples_frame);
            this.samples_frame = null;
        }
        if (this.filt_frame != null) {
            avutil.av_frame_free((avutil.AVFrame)this.filt_frame);
            this.filt_frame = null;
        }
        this.frame = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public int getImageWidth() {
        return this.buffersink_ctx != null ? avfilter.av_buffersink_get_w((avfilter.AVFilterContext)this.buffersink_ctx) : super.getImageWidth();
    }

    @Override
    public int getImageHeight() {
        return this.buffersink_ctx != null ? avfilter.av_buffersink_get_h((avfilter.AVFilterContext)this.buffersink_ctx) : super.getImageHeight();
    }

    @Override
    public int getPixelFormat() {
        return this.buffersink_ctx != null ? avfilter.av_buffersink_get_format((avfilter.AVFilterContext)this.buffersink_ctx) : super.getPixelFormat();
    }

    @Override
    public double getFrameRate() {
        if (this.buffersink_ctx != null) {
            avutil.AVRational r = avfilter.av_buffersink_get_frame_rate((avfilter.AVFilterContext)this.buffersink_ctx);
            if (r.num() == 0 && r.den() == 0) {
                r = avfilter.av_buffersink_get_time_base((avfilter.AVFilterContext)this.buffersink_ctx);
                return (double)r.den() / (double)r.num();
            }
            return (double)r.num() / (double)r.den();
        }
        return super.getFrameRate();
    }

    @Override
    public double getAspectRatio() {
        if (this.buffersink_ctx != null) {
            avutil.AVRational r = avfilter.av_buffersink_get_sample_aspect_ratio((avfilter.AVFilterContext)this.buffersink_ctx);
            double a = (double)r.num() / (double)r.den();
            return a == 0.0 ? 1.0 : a;
        }
        return super.getAspectRatio();
    }

    @Override
    public int getAudioChannels() {
        return this.abuffersink_ctx != null ? avfilter.av_buffersink_get_channels((avfilter.AVFilterContext)this.abuffersink_ctx) : super.getAudioChannels();
    }

    @Override
    public int getSampleFormat() {
        return this.abuffersink_ctx != null ? avfilter.av_buffersink_get_format((avfilter.AVFilterContext)this.abuffersink_ctx) : super.getSampleFormat();
    }

    @Override
    public int getSampleRate() {
        return this.abuffersink_ctx != null ? avfilter.av_buffersink_get_sample_rate((avfilter.AVFilterContext)this.abuffersink_ctx) : super.getSampleRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws FrameFilter.Exception {
        Class<avfilter> clazz = avfilter.class;
        synchronized (avfilter.class) {
            this.image_frame = avutil.av_frame_alloc();
            this.samples_frame = avutil.av_frame_alloc();
            this.filt_frame = avutil.av_frame_alloc();
            this.image_ptr = new BytePointer[]{null};
            this.image_buf = new Buffer[]{null};
            this.samples_ptr = new BytePointer[]{null};
            this.samples_buf = new Buffer[]{null};
            this.frame = new Frame();
            if (this.image_frame == null || this.samples_frame == null || this.filt_frame == null) {
                throw new FrameFilter.Exception("Could not allocate frames");
            }
            if (this.filters != null && this.imageWidth > 0 && this.imageHeight > 0) {
                this.startVideoUnsafe();
            }
            if (this.afilters != null && this.audioChannels > 0) {
                this.startAudioUnsafe();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startVideoUnsafe() throws FrameFilter.Exception {
        avfilter.AVFilter buffersrc = avfilter.avfilter_get_by_name((String)"buffer");
        avfilter.AVFilter buffersink = avfilter.avfilter_get_by_name((String)"buffersink");
        avfilter.AVFilter setpts = avfilter.avfilter_get_by_name((String)"setpts");
        avfilter.AVFilterInOut outputs = avfilter.avfilter_inout_alloc();
        avfilter.AVFilterInOut inputs = avfilter.avfilter_inout_alloc();
        avutil.AVRational time_base = avutil.av_inv_q((avutil.AVRational)avutil.av_d2q((double)this.frameRate, (int)1001000));
        int[] pix_fmts = new int[]{this.pixelFormat, -1};
        try {
            this.filter_graph = avfilter.avfilter_graph_alloc();
            if (outputs == null || inputs == null || this.filter_graph == null) {
                throw new FrameFilter.Exception("Could not allocate video filter graph: Out of memory?");
            }
            avutil.AVRational r = avutil.av_d2q((double)(this.aspectRatio > 0.0 ? this.aspectRatio : 1.0), (int)255);
            this.buffersrc_ctx = new avfilter.AVFilterContext();
            String args = String.format("video_size=%dx%d:pix_fmt=%d:time_base=%d/%d:pixel_aspect=%d/%d", this.imageWidth, this.imageHeight, this.pixelFormat, time_base.num(), time_base.den(), r.num(), r.den());
            int ret = avfilter.avfilter_graph_create_filter((avfilter.AVFilterContext)this.buffersrc_ctx, (avfilter.AVFilter)buffersrc, (String)"in", (String)args, null, (avfilter.AVFilterGraph)this.filter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter() error " + ret + ": Cannot create video buffer source.");
            }
            this.setpts_ctx = new avfilter.AVFilterContext();
            ret = avfilter.avfilter_graph_create_filter((avfilter.AVFilterContext)this.setpts_ctx, (avfilter.AVFilter)setpts, (String)"setpts", (String)"N", null, (avfilter.AVFilterGraph)this.filter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter() error " + ret + ": Cannot create setpts filter.");
            }
            ret = avfilter.avfilter_link((avfilter.AVFilterContext)this.buffersrc_ctx, (int)0, (avfilter.AVFilterContext)this.setpts_ctx, (int)0);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter() error " + ret + ": Cannot link setpts filter.");
            }
            this.buffersink_ctx = new avfilter.AVFilterContext();
            ret = avfilter.avfilter_graph_create_filter((avfilter.AVFilterContext)this.buffersink_ctx, (avfilter.AVFilter)buffersink, (String)"out", null, null, (avfilter.AVFilterGraph)this.filter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter() error " + ret + ": Cannot create video buffer sink.");
            }
            outputs.name(avutil.av_strdup((BytePointer)new BytePointer("in")));
            outputs.filter_ctx(this.setpts_ctx);
            outputs.pad_idx(0);
            outputs.next(null);
            inputs.name(avutil.av_strdup((BytePointer)new BytePointer("out")));
            inputs.filter_ctx(this.buffersink_ctx);
            inputs.pad_idx(0);
            inputs.next(null);
            ret = avfilter.avfilter_graph_parse_ptr((avfilter.AVFilterGraph)this.filter_graph, (String)this.filters, (avfilter.AVFilterInOut)inputs, (avfilter.AVFilterInOut)outputs, null);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_parse_ptr() error " + ret);
            }
            ret = avfilter.avfilter_graph_config((avfilter.AVFilterGraph)this.filter_graph, null);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_config() error " + ret);
            }
        }
        finally {
            avfilter.avfilter_inout_free((avfilter.AVFilterInOut)inputs);
            avfilter.avfilter_inout_free((avfilter.AVFilterInOut)outputs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAudioUnsafe() throws FrameFilter.Exception {
        avfilter.AVFilter abuffersrc = avfilter.avfilter_get_by_name((String)"abuffer");
        avfilter.AVFilter abuffersink = avfilter.avfilter_get_by_name((String)"abuffersink");
        avfilter.AVFilterInOut aoutputs = avfilter.avfilter_inout_alloc();
        avfilter.AVFilterInOut ainputs = avfilter.avfilter_inout_alloc();
        int[] sample_fmts = new int[]{this.sampleFormat, -1};
        try {
            this.afilter_graph = avfilter.avfilter_graph_alloc();
            if (aoutputs == null || ainputs == null || this.afilter_graph == null) {
                throw new FrameFilter.Exception("Could not allocate audio filter graph: Out of memory?");
            }
            this.abuffersrc_ctx = new avfilter.AVFilterContext();
            String aargs = String.format("channels=%d:sample_fmt=%d:sample_rate=%d:channel_layout=%d", this.audioChannels, this.sampleFormat, this.sampleRate, avutil.av_get_default_channel_layout((int)this.audioChannels));
            int ret = avfilter.avfilter_graph_create_filter((avfilter.AVFilterContext)this.abuffersrc_ctx, (avfilter.AVFilter)abuffersrc, (String)"in", (String)aargs, null, (avfilter.AVFilterGraph)this.afilter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter() error " + ret + ": Cannot create audio buffer source.");
            }
            this.abuffersink_ctx = new avfilter.AVFilterContext();
            ret = avfilter.avfilter_graph_create_filter((avfilter.AVFilterContext)this.abuffersink_ctx, (avfilter.AVFilter)abuffersink, (String)"out", null, null, (avfilter.AVFilterGraph)this.afilter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter() error " + ret + ": Cannot create audio buffer sink.");
            }
            aoutputs.name(avutil.av_strdup((BytePointer)new BytePointer("in")));
            aoutputs.filter_ctx(this.abuffersrc_ctx);
            aoutputs.pad_idx(0);
            aoutputs.next(null);
            ainputs.name(avutil.av_strdup((BytePointer)new BytePointer("out")));
            ainputs.filter_ctx(this.abuffersink_ctx);
            ainputs.pad_idx(0);
            ainputs.next(null);
            ret = avfilter.avfilter_graph_parse_ptr((avfilter.AVFilterGraph)this.afilter_graph, (String)this.afilters, (avfilter.AVFilterInOut)ainputs, (avfilter.AVFilterInOut)aoutputs, null);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_parse_ptr() error " + ret);
            }
            ret = avfilter.avfilter_graph_config((avfilter.AVFilterGraph)this.afilter_graph, null);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_config() error " + ret);
            }
        }
        finally {
            avfilter.avfilter_inout_free((avfilter.AVFilterInOut)ainputs);
            avfilter.avfilter_inout_free((avfilter.AVFilterInOut)aoutputs);
        }
    }

    @Override
    public void stop() throws FrameFilter.Exception {
        this.release();
    }

    @Override
    public void push(Frame frame) throws FrameFilter.Exception {
        this.push(frame, -1);
    }

    public void push(Frame frame, int pixelFormat) throws FrameFilter.Exception {
        this.inframe = frame;
        if (frame != null && frame.image != null && this.buffersrc_ctx != null) {
            this.pushImage(frame.imageWidth, frame.imageHeight, frame.imageDepth, frame.imageChannels, frame.imageStride, pixelFormat, frame.image);
        }
        if (frame != null && frame.samples != null && this.abuffersrc_ctx != null) {
            this.pushSamples(frame.audioChannels, this.sampleRate, this.sampleFormat, frame.samples);
        }
        if (frame == null || frame.image == null && frame.samples == null) {
            avfilter.av_buffersrc_add_frame_flags((avfilter.AVFilterContext)this.buffersrc_ctx, null, (int)0);
        }
    }

    public void pushImage(int width, int height, int depth, int channels, int stride, int pixelFormat, Buffer ... image) throws FrameFilter.Exception {
        BytePointer data;
        int step = stride * Math.abs(depth) / 8;
        BytePointer bytePointer = data = image[0] instanceof ByteBuffer ? new BytePointer((ByteBuffer)image[0].position(0)) : new BytePointer(new Pointer(image[0].position(0)));
        if (pixelFormat == -1) {
            if ((depth == 8 || depth == -8) && channels == 3) {
                pixelFormat = 3;
            } else if ((depth == 8 || depth == -8) && channels == 1) {
                pixelFormat = 8;
            } else if ((depth == 16 || depth == -16) && channels == 1) {
                pixelFormat = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 29 : 30;
            } else if ((depth == 8 || depth == -8) && channels == 4) {
                pixelFormat = 26;
            } else if ((depth == 8 || depth == -8) && channels == 2) {
                pixelFormat = 24;
            } else {
                throw new FrameFilter.Exception("Could not guess pixel format of image: depth=" + depth + ", channels=" + channels);
            }
        }
        if (pixelFormat == 24) {
            step = width;
        }
        avutil.av_image_fill_arrays(new PointerPointer((Pointer)this.image_frame), (IntPointer)this.image_frame.linesize(), (BytePointer)data, (int)pixelFormat, (int)width, (int)height, (int)1);
        this.image_frame.linesize(0, step);
        this.image_frame.format(pixelFormat);
        this.image_frame.width(width);
        this.image_frame.height(height);
        int ret = avfilter.av_buffersrc_add_frame_flags((avfilter.AVFilterContext)this.buffersrc_ctx, (avutil.AVFrame)this.image_frame, (int)8);
        if (ret < 0) {
            throw new FrameFilter.Exception("av_buffersrc_add_frame_flags() error " + ret + ": Error while feeding the filtergraph.");
        }
    }

    public void pushSamples(int audioChannels, int sampleRate, int sampleFormat, Buffer ... samples) throws FrameFilter.Exception {
        int i;
        int sampleSize;
        Pointer[] data = new Pointer[samples.length];
        int n = samples != null ? (samples[0].limit() - samples[0].position()) / (samples.length > 1 ? 1 : audioChannels) : (sampleSize = 0);
        if (samples != null && samples[0] instanceof ByteBuffer) {
            sampleFormat = data.length > 1 ? 5 : 0;
            for (i = 0; i < data.length; ++i) {
                data[i] = new BytePointer((ByteBuffer)samples[i]);
            }
        } else if (samples != null && samples[0] instanceof ShortBuffer) {
            sampleFormat = data.length > 1 ? 6 : 1;
            for (i = 0; i < data.length; ++i) {
                data[i] = new ShortPointer((ShortBuffer)samples[i]);
            }
        } else if (samples != null && samples[0] instanceof IntBuffer) {
            sampleFormat = data.length > 1 ? 7 : 2;
            for (i = 0; i < data.length; ++i) {
                data[i] = new IntPointer((IntBuffer)samples[i]);
            }
        } else if (samples != null && samples[0] instanceof FloatBuffer) {
            sampleFormat = data.length > 1 ? 8 : 3;
            for (i = 0; i < data.length; ++i) {
                data[i] = new FloatPointer((FloatBuffer)samples[i]);
            }
        } else if (samples != null && samples[0] instanceof DoubleBuffer) {
            sampleFormat = data.length > 1 ? 9 : 4;
            for (i = 0; i < data.length; ++i) {
                data[i] = new DoublePointer((DoubleBuffer)samples[i]);
            }
        } else if (samples != null) {
            for (i = 0; i < data.length; ++i) {
                data[i] = new Pointer(samples[i]);
            }
        }
        avutil.av_samples_fill_arrays(new PointerPointer((Pointer)this.samples_frame), (IntPointer)this.samples_frame.linesize(), (BytePointer)new BytePointer(data[0]), (int)audioChannels, (int)sampleSize, (int)sampleFormat, (int)1);
        for (i = 0; i < samples.length; ++i) {
            this.samples_frame.data(i, new BytePointer(data[i]));
        }
        this.samples_frame.channels(audioChannels);
        this.samples_frame.channel_layout(avutil.av_get_default_channel_layout((int)audioChannels));
        this.samples_frame.nb_samples(sampleSize);
        this.samples_frame.format(sampleFormat);
        this.samples_frame.sample_rate(sampleRate);
        int ret = avfilter.av_buffersrc_add_frame_flags((avfilter.AVFilterContext)this.abuffersrc_ctx, (avutil.AVFrame)this.samples_frame, (int)8);
        if (ret < 0) {
            throw new FrameFilter.Exception("av_buffersrc_add_frame_flags() error " + ret + ": Error while feeding the filtergraph.");
        }
    }

    @Override
    public Frame pull() throws FrameFilter.Exception {
        this.frame.keyFrame = false;
        this.frame.imageWidth = 0;
        this.frame.imageHeight = 0;
        this.frame.imageDepth = 0;
        this.frame.imageChannels = 0;
        this.frame.imageStride = 0;
        this.frame.image = null;
        this.frame.sampleRate = 0;
        this.frame.audioChannels = 0;
        this.frame.samples = null;
        this.frame.opaque = null;
        Frame f = null;
        if (f == null && this.buffersrc_ctx != null) {
            f = this.pullImage();
        }
        if (f == null && this.abuffersrc_ctx != null) {
            f = this.pullSamples();
        }
        if (f == null) {
            f = this.inframe;
        }
        this.inframe = null;
        return f;
    }

    public Frame pullImage() throws FrameFilter.Exception {
        avutil.av_frame_unref((avutil.AVFrame)this.filt_frame);
        int ret = avfilter.av_buffersink_get_frame((avfilter.AVFilterContext)this.buffersink_ctx, (avutil.AVFrame)this.filt_frame);
        if (ret == avutil.AVERROR_EAGAIN() || ret == avutil.AVERROR_EOF()) {
            return null;
        }
        if (ret < 0) {
            throw new FrameFilter.Exception("av_buffersink_get_frame(): Error occurred: " + avutil.av_make_error_string((BytePointer)new BytePointer(256L), (long)256L, (int)ret).getString());
        }
        this.frame.imageWidth = this.filt_frame.width();
        this.frame.imageHeight = this.filt_frame.height();
        this.frame.imageDepth = 8;
        if (this.filt_frame.data(1) == null) {
            this.frame.imageStride = this.filt_frame.linesize(0);
            BytePointer ptr = this.filt_frame.data(0);
            if (ptr != null && !ptr.equals(this.image_ptr[0])) {
                this.image_ptr[0] = ptr.capacity(this.frame.imageHeight * Math.abs(this.frame.imageStride));
                this.image_buf[0] = ptr.asBuffer();
            }
            this.frame.image = this.image_buf;
            this.frame.image[0].position(0).limit(this.frame.imageHeight * Math.abs(this.frame.imageStride));
            this.frame.imageChannels = Math.abs(this.frame.imageStride) / this.frame.imageWidth;
        } else {
            this.frame.imageStride = this.frame.imageWidth;
            int size = avutil.av_image_get_buffer_size((int)this.filt_frame.format(), (int)this.frame.imageWidth, (int)this.frame.imageHeight, (int)1);
            if (this.image_buf[0] == null || this.image_buf[0].capacity() < size) {
                this.image_buf[0] = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
            }
            this.frame.image = this.image_buf;
            this.frame.image[0].position(0).limit(size);
            this.frame.imageChannels = (size + this.frame.imageWidth * this.frame.imageHeight - 1) / (this.frame.imageWidth * this.frame.imageHeight);
            ret = avutil.av_image_copy_to_buffer((BytePointer)new BytePointer((ByteBuffer)this.frame.image[0].position(0)), (int)this.frame.image[0].capacity(), new PointerPointer((Pointer)this.filt_frame), (IntPointer)this.filt_frame.linesize(), (int)this.filt_frame.format(), (int)this.frame.imageWidth, (int)this.frame.imageHeight, (int)1);
        }
        return this.frame;
    }

    public Frame pullSamples() throws FrameFilter.Exception {
        avutil.av_frame_unref((avutil.AVFrame)this.filt_frame);
        int ret = avfilter.av_buffersink_get_frame((avfilter.AVFilterContext)this.abuffersink_ctx, (avutil.AVFrame)this.filt_frame);
        if (ret == avutil.AVERROR_EAGAIN() || ret == avutil.AVERROR_EOF()) {
            return null;
        }
        if (ret < 0) {
            throw new FrameFilter.Exception("av_buffersink_get_frame(): Error occurred: " + avutil.av_make_error_string((BytePointer)new BytePointer(256L), (long)256L, (int)ret).getString());
        }
        int sample_format = this.filt_frame.format();
        int planes = avutil.av_sample_fmt_is_planar((int)sample_format) != 0 ? this.filt_frame.channels() : 1;
        int data_size = avutil.av_samples_get_buffer_size((IntPointer)null, (int)this.filt_frame.channels(), (int)this.filt_frame.nb_samples(), (int)this.filt_frame.format(), (int)1) / planes;
        if (this.samples_buf == null || this.samples_buf.length != planes) {
            this.samples_ptr = new BytePointer[planes];
            this.samples_buf = new Buffer[planes];
        }
        this.frame.audioChannels = this.filt_frame.channels();
        this.frame.sampleRate = this.filt_frame.sample_rate();
        this.frame.samples = this.samples_buf;
        int sample_size = data_size / avutil.av_get_bytes_per_sample((int)sample_format);
        for (int i = 0; i < planes; ++i) {
            BytePointer p = this.filt_frame.data(i);
            if (!p.equals(this.samples_ptr[i]) || this.samples_ptr[i].capacity() < (long)data_size) {
                this.samples_ptr[i] = p.capacity(data_size);
                ByteBuffer b = p.asBuffer();
                switch (sample_format) {
                    case 0: 
                    case 5: {
                        this.samples_buf[i] = b;
                        break;
                    }
                    case 1: 
                    case 6: {
                        this.samples_buf[i] = b.asShortBuffer();
                        break;
                    }
                    case 2: 
                    case 7: {
                        this.samples_buf[i] = b.asIntBuffer();
                        break;
                    }
                    case 3: 
                    case 8: {
                        this.samples_buf[i] = b.asFloatBuffer();
                        break;
                    }
                    case 4: 
                    case 9: {
                        this.samples_buf[i] = b.asDoubleBuffer();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            this.samples_buf[i].position(0).limit(sample_size);
        }
        return this.frame;
    }

    static {
        try {
            FFmpegFrameFilter.tryLoad();
        }
        catch (FrameFilter.Exception exception) {
            // empty catch block
        }
    }
}

