/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.format;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.ngs.ngunits.Prefix;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolMap {
    private Locale _locale;
    private Map<String, Unit<?>> _symbolToUnit;
    private Map<Unit<?>, String> _unitToSymbol;
    private Map<String, Prefix> _symbolToPrefix;
    private Map<Prefix, String> _prefixToSymbol;
    private Map<UnitConverter, Prefix> _converterToPrefix;

    public SymbolMap(ResourceBundle resourceBundle) {
        this._locale = resourceBundle.getLocale();
        this._symbolToUnit = new HashMap();
        this._unitToSymbol = new HashMap();
        this._symbolToPrefix = new HashMap<String, Prefix>();
        this._prefixToSymbol = new HashMap<Prefix, String>();
        this._converterToPrefix = new HashMap<UnitConverter, Prefix>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String[] stringArray = resourceBundle.getString(string).split(",");
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            try {
                Class<?> clazz = Class.forName(string2);
                Field field = clazz.getField(string3);
                Object object = field.get(null);
                if (object instanceof Unit) {
                    this.label((Unit)object, stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        this.alias((Unit)object, stringArray[i]);
                    }
                    continue;
                }
                if (object instanceof Prefix) {
                    this.label((Prefix)((Object)object), stringArray[0]);
                    continue;
                }
                throw new ClassCastException("unable to cast " + object + " to Unit or Prefix");
            }
            catch (Exception exception) {
                System.err.println("ERROR reading Unit names: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void label(Unit<?> unit, String string) {
        this._symbolToUnit.put(string, unit);
        if (!this._unitToSymbol.containsKey(unit)) {
            this._unitToSymbol.put(unit, string);
        }
    }

    public void alias(Unit<?> unit, String string) {
        this._symbolToUnit.put(string, unit);
    }

    public void label(Prefix prefix, String string) {
        this._symbolToPrefix.put(string, prefix);
        this._prefixToSymbol.put(prefix, string);
        this._converterToPrefix.put(prefix.converter, prefix);
    }

    public Entry lookup(String string) {
        Unit<?> unit = this._symbolToUnit.get(string);
        if (unit != null) {
            return new Entry(null, unit);
        }
        for (Map.Entry<String, Prefix> entry : this._symbolToPrefix.entrySet()) {
            if (!string.startsWith(entry.getKey()) || (unit = this._symbolToUnit.get(string.substring(entry.getKey().length()))) == null) continue;
            return new Entry(entry.getValue(), unit);
        }
        return null;
    }

    public String getSymbol(Unit<?> unit) {
        return this._unitToSymbol.get(unit);
    }

    public Prefix getPrefix(UnitConverter unitConverter) {
        return this._converterToPrefix.get(unitConverter);
    }

    public String getSymbol(Prefix prefix) {
        return this._prefixToSymbol.get((Object)prefix);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        public final Prefix prefix;
        public final Unit<?> unit;

        public Entry(Prefix prefix, Unit<?> unit) {
            this.prefix = prefix;
            this.unit = unit;
        }
    }
}

