/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import java.util.List;

class BasicPreparedGeometry
implements PreparedGeometry {
    private Geometry baseGeom;
    private List representativePts;

    public BasicPreparedGeometry(Geometry geom) {
        this.baseGeom = geom;
        this.representativePts = ComponentCoordinateExtracter.getCoordinates(geom);
    }

    public Geometry getGeometry() {
        return this.baseGeom;
    }

    public List getRepresentativePoints() {
        return this.representativePts;
    }

    public boolean isAnyTargetComponentInTest(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        for (Coordinate p : this.representativePts) {
            if (!locator.intersects(p, testGeom)) continue;
            return true;
        }
        return false;
    }

    protected boolean envelopesIntersect(Geometry g) {
        return this.baseGeom.getEnvelopeInternal().intersects(g.getEnvelopeInternal());
    }

    protected boolean envelopeCovers(Geometry g) {
        return this.baseGeom.getEnvelopeInternal().covers(g.getEnvelopeInternal());
    }

    public boolean contains(Geometry g) {
        return this.baseGeom.contains(g);
    }

    public boolean containsProperly(Geometry g) {
        if (!this.baseGeom.getEnvelopeInternal().contains(g.getEnvelopeInternal())) {
            return false;
        }
        return this.baseGeom.relate(g, "T**FF*FF*");
    }

    public boolean coveredBy(Geometry g) {
        return this.baseGeom.coveredBy(g);
    }

    public boolean covers(Geometry g) {
        return this.baseGeom.covers(g);
    }

    public boolean crosses(Geometry g) {
        return this.baseGeom.crosses(g);
    }

    public boolean disjoint(Geometry g) {
        return !this.intersects(g);
    }

    public boolean intersects(Geometry g) {
        return this.baseGeom.intersects(g);
    }

    public boolean overlaps(Geometry g) {
        return this.baseGeom.overlaps(g);
    }

    public boolean touches(Geometry g) {
        return this.baseGeom.touches(g);
    }

    public boolean within(Geometry g) {
        return this.baseGeom.within(g);
    }

    public String toString() {
        return this.baseGeom.toString();
    }
}

