/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.StyleManager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.Scene;

public class CssError {
    private static Reference<Scene> SCENE_REF;
    private final Reference<Scene> sceneRef;
    protected final String message;

    public static void setCurrentScene(Scene scene) {
        if (StyleManager.getErrors() == null) {
            return;
        }
        if (scene != null) {
            Scene oldScene;
            Scene scene2 = oldScene = SCENE_REF != null ? SCENE_REF.get() : null;
            if (oldScene != scene) {
                SCENE_REF = new WeakReference<Scene>(scene);
            }
        } else {
            SCENE_REF = null;
        }
    }

    public final String getMessage() {
        return this.message;
    }

    public CssError(String message) {
        this.message = message;
        this.sceneRef = SCENE_REF;
    }

    public Scene getScene() {
        return this.sceneRef != null ? this.sceneRef.get() : null;
    }

    public String toString() {
        return "CSS Error: " + this.message;
    }

    public static final class PropertySetError
    extends CssError {
        private final CssMetaData styleableProperty;
        private final Styleable styleable;

        public PropertySetError(CssMetaData styleableProperty, Styleable styleable, String message) {
            super(message);
            this.styleableProperty = styleableProperty;
            this.styleable = styleable;
        }

        public Styleable getStyleable() {
            return this.styleable;
        }

        public CssMetaData getProperty() {
            return this.styleableProperty;
        }
    }

    public static final class StringParsingError
    extends CssError {
        private final String style;

        public StringParsingError(String style, String message) {
            super(message);
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }

        @Override
        public String toString() {
            return "CSS Error parsing '" + this.style + ": " + this.message;
        }
    }

    public static final class InlineStyleParsingError
    extends CssError {
        private final Styleable styleable;

        public InlineStyleParsingError(Styleable styleable, String message) {
            super(message);
            this.styleable = styleable;
        }

        public Styleable getStyleable() {
            return this.styleable;
        }

        @Override
        public String toString() {
            String inlineStyle = this.styleable.getStyle();
            String source = this.styleable.toString();
            return "CSS Error parsing in-line style '" + inlineStyle + "' from " + source + ": " + this.message;
        }
    }

    public static final class StylesheetParsingError
    extends CssError {
        private final String url;

        public StylesheetParsingError(String url, String message) {
            super(message);
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }

        @Override
        public String toString() {
            String path = this.url != null ? this.url : "?";
            return "CSS Error parsing " + path + ": " + this.message;
        }
    }
}

