/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.geom.transform.TransformHelper;

public class Affine3D
extends AffineBase {
    private double mxz;
    private double myz;
    private double mzx;
    private double mzy;
    private double mzz;
    private double mzt;

    public Affine3D() {
        this.mzz = 1.0;
        this.myy = 1.0;
        this.mxx = 1.0;
    }

    public Affine3D(BaseTransform transform) {
        this.setTransform(transform);
    }

    public Affine3D(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        this.mxx = mxx;
        this.mxy = mxy;
        this.mxz = mxz;
        this.mxt = mxt;
        this.myx = myx;
        this.myy = myy;
        this.myz = myz;
        this.myt = myt;
        this.mzx = mzx;
        this.mzy = mzy;
        this.mzz = mzz;
        this.mzt = mzt;
        this.updateState();
    }

    public Affine3D(Affine3D other) {
        this.mxx = other.mxx;
        this.mxy = other.mxy;
        this.mxz = other.mxz;
        this.mxt = other.mxt;
        this.myx = other.myx;
        this.myy = other.myy;
        this.myz = other.myz;
        this.myt = other.myt;
        this.mzx = other.mzx;
        this.mzy = other.mzy;
        this.mzz = other.mzz;
        this.mzt = other.mzt;
        this.state = other.state;
        this.type = other.type;
    }

    @Override
    public BaseTransform copy() {
        return new Affine3D(this);
    }

    @Override
    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.AFFINE_3D;
    }

    @Override
    protected void reset3Delements() {
        this.mxz = 0.0;
        this.myz = 0.0;
        this.mzx = 0.0;
        this.mzy = 0.0;
        this.mzz = 1.0;
        this.mzt = 0.0;
    }

    @Override
    protected void updateState() {
        super.updateState();
        if (!(Affine3D.almostZero(this.mxz) && Affine3D.almostZero(this.myz) && Affine3D.almostZero(this.mzx) && Affine3D.almostZero(this.mzy) && Affine3D.almostOne(this.mzz) && Affine3D.almostZero(this.mzt))) {
            this.state |= 8;
            if (this.type != -1) {
                this.type |= 0x80;
            }
        }
    }

    @Override
    public double getMxz() {
        return this.mxz;
    }

    @Override
    public double getMyz() {
        return this.myz;
    }

    @Override
    public double getMzx() {
        return this.mzx;
    }

    @Override
    public double getMzy() {
        return this.mzy;
    }

    @Override
    public double getMzz() {
        return this.mzz;
    }

    @Override
    public double getMzt() {
        return this.mzt;
    }

    @Override
    public double getDeterminant() {
        if ((this.state & 8) == 0) {
            return super.getDeterminant();
        }
        return this.mxx * (this.myy * this.mzz - this.mzy * this.myz) + this.mxy * (this.myz * this.mzx - this.mzz * this.myx) + this.mxz * (this.myx * this.mzy - this.mzx * this.myy);
    }

    @Override
    public void setTransform(BaseTransform transform) {
        this.mxx = transform.getMxx();
        this.mxy = transform.getMxy();
        this.mxz = transform.getMxz();
        this.mxt = transform.getMxt();
        this.myx = transform.getMyx();
        this.myy = transform.getMyy();
        this.myz = transform.getMyz();
        this.myt = transform.getMyt();
        this.mzx = transform.getMzx();
        this.mzy = transform.getMzy();
        this.mzz = transform.getMzz();
        this.mzt = transform.getMzt();
        this.updateState();
    }

    public void setTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        this.mxx = mxx;
        this.mxy = mxy;
        this.mxz = mxz;
        this.mxt = mxt;
        this.myx = myx;
        this.myy = myy;
        this.myz = myz;
        this.myt = myt;
        this.mzx = mzx;
        this.mzy = mzy;
        this.mzz = mzz;
        this.mzt = mzt;
        this.updateState();
    }

    public void setToTranslation(double tx, double ty, double tz) {
        this.mxx = 1.0;
        this.mxy = 0.0;
        this.mxz = 0.0;
        this.mxt = tx;
        this.myx = 0.0;
        this.myy = 1.0;
        this.myz = 0.0;
        this.myt = ty;
        this.mzx = 0.0;
        this.mzy = 0.0;
        this.mzz = 1.0;
        this.mzt = tz;
        if (tz == 0.0) {
            if (tx == 0.0 && ty == 0.0) {
                this.state = 0;
                this.type = 0;
            } else {
                this.state = 1;
                this.type = 1;
            }
        } else if (tx == 0.0 && ty == 0.0) {
            this.state = 8;
            this.type = 128;
        } else {
            this.state = 9;
            this.type = 129;
        }
    }

    public void setToScale(double sx, double sy, double sz) {
        this.mxx = sx;
        this.mxy = 0.0;
        this.mxz = 0.0;
        this.mxt = 0.0;
        this.myx = 0.0;
        this.myy = sy;
        this.myz = 0.0;
        this.myt = 0.0;
        this.mzx = 0.0;
        this.mzy = 0.0;
        this.mzz = sz;
        this.mzt = 0.0;
        if (sz == 1.0) {
            if (sx == 1.0 && sy == 1.0) {
                this.state = 0;
                this.type = 0;
            } else {
                this.state = 2;
                this.type = -1;
            }
        } else if (sx == 1.0 && sy == 1.0) {
            this.state = 8;
            this.type = 128;
        } else {
            this.state = 10;
            this.type = -1;
        }
    }

    public void setToRotation(double theta, double axisX, double axisY, double axisZ, double pivotX, double pivotY, double pivotZ) {
        this.setToRotation(theta, axisX, axisY, axisZ);
        if (pivotX != 0.0 || pivotY != 0.0 || pivotZ != 0.0) {
            this.preTranslate(pivotX, pivotY, pivotZ);
            this.translate(-pivotX, -pivotY, -pivotZ);
        }
    }

    public void setToRotation(double theta, double axisX, double axisY, double axisZ) {
        double mag = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (Affine3D.almostZero(mag)) {
            this.setToIdentity();
            return;
        }
        mag = 1.0 / mag;
        double ax = axisX * mag;
        double ay = axisY * mag;
        double az = axisZ * mag;
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double t = 1.0 - cosTheta;
        double xz = ax * az;
        double xy = ax * ay;
        double yz = ay * az;
        this.mxx = t * ax * ax + cosTheta;
        this.mxy = t * xy - sinTheta * az;
        this.mxz = t * xz + sinTheta * ay;
        this.mxt = 0.0;
        this.myx = t * xy + sinTheta * az;
        this.myy = t * ay * ay + cosTheta;
        this.myz = t * yz - sinTheta * ax;
        this.myt = 0.0;
        this.mzx = t * xz - sinTheta * ay;
        this.mzy = t * yz + sinTheta * ax;
        this.mzz = t * az * az + cosTheta;
        this.mzt = 0.0;
        this.updateState();
    }

    @Override
    public BaseBounds transform(BaseBounds src, BaseBounds dst) {
        if ((this.state & 8) == 0) {
            dst = super.transform(src, dst);
            return dst;
        }
        switch (this.state) {
            default: {
                Vec3d tempV3d = new Vec3d();
                dst = TransformHelper.general3dBoundsTransform(this, src, dst, tempV3d);
                break;
            }
            case 3: {
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinX() * this.mxx + this.mxt), (float)((double)src.getMinY() * this.myy + this.myt), (float)((double)src.getMinZ() * this.mzz + this.mzt), (float)((double)src.getMaxX() * this.mxx + this.mxt), (float)((double)src.getMaxY() * this.myy + this.myt), (float)((double)src.getMaxZ() * this.mzz + this.mzt));
                break;
            }
            case 2: {
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinX() * this.mxx), (float)((double)src.getMinY() * this.myy), (float)((double)src.getMinZ() * this.mzz), (float)((double)src.getMaxX() * this.mxx), (float)((double)src.getMaxY() * this.myy), (float)((double)src.getMaxZ() * this.mzz));
                break;
            }
            case 1: {
                dst = dst.deriveWithNewBounds((float)((double)src.getMinX() + this.mxt), (float)((double)src.getMinY() + this.myt), (float)((double)src.getMinZ() + this.mzt), (float)((double)src.getMaxX() + this.mxt), (float)((double)src.getMaxY() + this.myt), (float)((double)src.getMaxZ() + this.mzt));
                break;
            }
            case 0: {
                if (src == dst) break;
                dst = dst.deriveWithNewBounds(src);
            }
        }
        return dst;
    }

    @Override
    public Vec3d transform(Vec3d src, Vec3d dst) {
        if ((this.state & 8) == 0) {
            return super.transform(src, dst);
        }
        if (dst == null) {
            dst = new Vec3d();
        }
        double x = src.x;
        double y = src.y;
        double z = src.z;
        dst.x = this.mxx * x + this.mxy * y + this.mxz * z + this.mxt;
        dst.y = this.myx * x + this.myy * y + this.myz * z + this.myt;
        dst.z = this.mzx * x + this.mzy * y + this.mzz * z + this.mzt;
        return dst;
    }

    @Override
    public Vec3d deltaTransform(Vec3d src, Vec3d dst) {
        if ((this.state & 8) == 0) {
            return super.deltaTransform(src, dst);
        }
        if (dst == null) {
            dst = new Vec3d();
        }
        double x = src.x;
        double y = src.y;
        double z = src.z;
        dst.x = this.mxx * x + this.mxy * y + this.mxz * z;
        dst.y = this.myx * x + this.myy * y + this.myz * z;
        dst.z = this.mzx * x + this.mzy * y + this.mzz * z;
        return dst;
    }

    @Override
    public void inverseTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            super.inverseTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            this.createInverse().transform(srcPts, srcOff, dstPts, dstOff, numPts);
        }
    }

    @Override
    public void inverseDeltaTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            super.inverseDeltaTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            this.createInverse().deltaTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        }
    }

    @Override
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            super.inverseTransform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            this.createInverse().transform(srcPts, srcOff, dstPts, dstOff, numPts);
        }
    }

    @Override
    public Point2D inverseTransform(Point2D src, Point2D dst) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            return super.inverseTransform(src, dst);
        }
        return this.createInverse().transform(src, dst);
    }

    @Override
    public Vec3d inverseTransform(Vec3d src, Vec3d dst) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            return super.inverseTransform(src, dst);
        }
        return this.createInverse().transform(src, dst);
    }

    @Override
    public Vec3d inverseDeltaTransform(Vec3d src, Vec3d dst) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            return super.inverseDeltaTransform(src, dst);
        }
        return this.createInverse().deltaTransform(src, dst);
    }

    @Override
    public BaseBounds inverseTransform(BaseBounds bounds, BaseBounds result) throws NoninvertibleTransformException {
        result = (this.state & 8) == 0 ? super.inverseTransform(bounds, result) : this.createInverse().transform(bounds, result);
        return result;
    }

    @Override
    public void inverseTransform(Rectangle bounds, Rectangle result) throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            super.inverseTransform(bounds, result);
        } else {
            this.createInverse().transform(bounds, result);
        }
    }

    @Override
    public BaseTransform createInverse() throws NoninvertibleTransformException {
        BaseTransform t = this.copy();
        t.invert();
        return t;
    }

    @Override
    public void invert() throws NoninvertibleTransformException {
        if ((this.state & 8) == 0) {
            super.invert();
            return;
        }
        double cxx = this.minor(0, 0);
        double cyx = -this.minor(0, 1);
        double czx = this.minor(0, 2);
        double cxy = -this.minor(1, 0);
        double cyy = this.minor(1, 1);
        double czy = -this.minor(1, 2);
        double cxz = this.minor(2, 0);
        double cyz = -this.minor(2, 1);
        double czz = this.minor(2, 2);
        double cxt = -this.minor(3, 0);
        double cyt = this.minor(3, 1);
        double czt = -this.minor(3, 2);
        double det = this.getDeterminant();
        this.mxx = cxx / det;
        this.mxy = cxy / det;
        this.mxz = cxz / det;
        this.mxt = cxt / det;
        this.myx = cyx / det;
        this.myy = cyy / det;
        this.myz = cyz / det;
        this.myt = cyt / det;
        this.mzx = czx / det;
        this.mzy = czy / det;
        this.mzz = czz / det;
        this.mzt = czt / det;
        this.updateState();
    }

    private double minor(int row, int col) {
        double m00 = this.mxx;
        double m01 = this.mxy;
        double m02 = this.mxz;
        double m10 = this.myx;
        double m11 = this.myy;
        double m12 = this.myz;
        double m20 = this.mzx;
        double m21 = this.mzy;
        double m22 = this.mzz;
        switch (col) {
            case 0: {
                m00 = m01;
                m10 = m11;
                m20 = m21;
            }
            case 1: {
                m01 = m02;
                m11 = m12;
                m21 = m22;
            }
            case 2: {
                m02 = this.mxt;
                m12 = this.myt;
                m22 = this.mzt;
            }
        }
        switch (row) {
            case 0: {
                m00 = m10;
                m01 = m11;
            }
            case 1: {
                m10 = m20;
                m11 = m21;
            }
            case 2: {
                break;
            }
            case 3: {
                return m00 * (m11 * m22 - m21 * m12) + m01 * (m12 * m20 - m22 * m10) + m02 * (m10 * m21 - m20 * m11);
            }
        }
        return m00 * m11 - m01 * m10;
    }

    @Override
    public Affine3D deriveWithNewTransform(BaseTransform tx) {
        this.setTransform(tx);
        return this;
    }

    @Override
    public Affine3D deriveWithTranslation(double tx, double ty) {
        this.translate(tx, ty, 0.0);
        return this;
    }

    @Override
    public void translate(double tx, double ty) {
        if ((this.state & 8) == 0) {
            super.translate(tx, ty);
        } else {
            this.translate(tx, ty, 0.0);
        }
    }

    public void translate(double tx, double ty, double tz) {
        if ((this.state & 8) == 0) {
            super.translate(tx, ty);
            if (tz != 0.0) {
                this.mzt = tz;
                this.state |= 8;
                if (this.type != -1) {
                    this.type |= 0x80;
                }
            }
            return;
        }
        this.mxt = tx * this.mxx + ty * this.mxy + tz * this.mxz + this.mxt;
        this.myt = tx * this.myx + ty * this.myy + tz * this.myz + this.myt;
        this.mzt = tx * this.mzx + ty * this.mzy + tz * this.mzz + this.mzt;
        this.updateState();
    }

    @Override
    public Affine3D deriveWithPreTranslation(double mxt, double myt) {
        this.preTranslate(mxt, myt, 0.0);
        return this;
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt, double mzt) {
        this.translate(mxt, myt, mzt);
        return this;
    }

    @Override
    public BaseTransform deriveWithScale(double mxx, double myy, double mzz) {
        this.scale(mxx, myy, mzz);
        return this;
    }

    @Override
    public BaseTransform deriveWithRotation(double theta, double axisX, double axisY, double axisZ) {
        this.rotate(theta, axisX, axisY, axisZ);
        return this;
    }

    public void preTranslate(double mxt, double myt, double mzt) {
        this.mxt += mxt;
        this.myt += myt;
        this.mzt += mzt;
        int clearflags = 0;
        int setflags = 0;
        if (this.mzt == 0.0) {
            if ((this.state & 8) != 0) {
                this.updateState();
                return;
            }
        } else {
            this.state |= 8;
            setflags = 128;
        }
        if (this.mxt == 0.0 && this.myt == 0.0) {
            this.state &= 0xFFFFFFFE;
            clearflags = 1;
        } else {
            this.state |= 1;
            setflags |= 1;
        }
        if (this.type != -1) {
            this.type = this.type & ~clearflags | setflags;
        }
    }

    @Override
    public void scale(double sx, double sy) {
        if ((this.state & 8) == 0) {
            super.scale(sx, sy);
        } else {
            this.scale(sx, sy, 1.0);
        }
    }

    public void scale(double sx, double sy, double sz) {
        if ((this.state & 8) == 0) {
            super.scale(sx, sy);
            if (sz != 1.0) {
                this.mzz = sz;
                this.state |= 8;
                if (this.type != -1) {
                    this.type |= 0x80;
                }
            }
            return;
        }
        this.mxx *= sx;
        this.mxy *= sy;
        this.mxz *= sz;
        this.myx *= sx;
        this.myy *= sy;
        this.myz *= sz;
        this.mzx *= sx;
        this.mzy *= sy;
        this.mzz *= sz;
        this.updateState();
    }

    @Override
    public void rotate(double theta) {
        if ((this.state & 8) == 0) {
            super.rotate(theta);
        } else {
            this.rotate(theta, 0.0, 0.0, 1.0);
        }
    }

    public void rotate(double theta, double axisX, double axisY, double axisZ) {
        if ((this.state & 8) == 0 && Affine3D.almostZero(axisX) && Affine3D.almostZero(axisY)) {
            if (axisZ > 0.0) {
                super.rotate(theta);
            } else if (axisZ < 0.0) {
                super.rotate(-theta);
            }
            return;
        }
        double mag = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (Affine3D.almostZero(mag)) {
            return;
        }
        mag = 1.0 / mag;
        double ax = axisX * mag;
        double ay = axisY * mag;
        double az = axisZ * mag;
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double t = 1.0 - cosTheta;
        double xz = ax * az;
        double xy = ax * ay;
        double yz = ay * az;
        double Txx = t * ax * ax + cosTheta;
        double Txy = t * xy - sinTheta * az;
        double Txz = t * xz + sinTheta * ay;
        double Tyx = t * xy + sinTheta * az;
        double Tyy = t * ay * ay + cosTheta;
        double Tyz = t * yz - sinTheta * ax;
        double Tzx = t * xz - sinTheta * ay;
        double Tzy = t * yz + sinTheta * ax;
        double Tzz = t * az * az + cosTheta;
        double rxx = this.mxx * Txx + this.mxy * Tyx + this.mxz * Tzx;
        double rxy = this.mxx * Txy + this.mxy * Tyy + this.mxz * Tzy;
        double rxz = this.mxx * Txz + this.mxy * Tyz + this.mxz * Tzz;
        double ryx = this.myx * Txx + this.myy * Tyx + this.myz * Tzx;
        double ryy = this.myx * Txy + this.myy * Tyy + this.myz * Tzy;
        double ryz = this.myx * Txz + this.myy * Tyz + this.myz * Tzz;
        double rzx = this.mzx * Txx + this.mzy * Tyx + this.mzz * Tzx;
        double rzy = this.mzx * Txy + this.mzy * Tyy + this.mzz * Tzy;
        double rzz = this.mzx * Txz + this.mzy * Tyz + this.mzz * Tzz;
        this.mxx = rxx;
        this.mxy = rxy;
        this.mxz = rxz;
        this.myx = ryx;
        this.myy = ryy;
        this.myz = ryz;
        this.mzx = rzx;
        this.mzy = rzy;
        this.mzz = rzz;
        this.updateState();
    }

    @Override
    public void shear(double shx, double shy) {
        if ((this.state & 8) == 0) {
            super.shear(shx, shy);
            return;
        }
        double rxx = this.mxx + this.mxy * shy;
        double rxy = this.mxy + this.mxx * shx;
        double ryx = this.myx + this.myy * shy;
        double ryy = this.myy + this.myx * shx;
        double rzx = this.mzx + this.mzy * shy;
        double rzy = this.mzy + this.mzx * shx;
        this.mxx = rxx;
        this.mxy = rxy;
        this.myx = ryx;
        this.myy = ryy;
        this.mzx = rzx;
        this.mzy = rzy;
        this.updateState();
    }

    @Override
    public Affine3D deriveWithConcatenation(BaseTransform transform) {
        this.concatenate(transform);
        return this;
    }

    @Override
    public Affine3D deriveWithPreConcatenation(BaseTransform transform) {
        this.preConcatenate(transform);
        return this;
    }

    @Override
    public void concatenate(BaseTransform transform) {
        switch (transform.getDegree()) {
            case IDENTITY: {
                return;
            }
            case TRANSLATE_2D: {
                this.translate(transform.getMxt(), transform.getMyt());
                return;
            }
            case TRANSLATE_3D: {
                this.translate(transform.getMxt(), transform.getMyt(), transform.getMzt());
                return;
            }
            case AFFINE_3D: {
                if (!transform.is2D()) break;
            }
            case AFFINE_2D: {
                if ((this.state & 8) != 0) break;
                super.concatenate(transform);
                return;
            }
        }
        double Txx = transform.getMxx();
        double Txy = transform.getMxy();
        double Txz = transform.getMxz();
        double Txt = transform.getMxt();
        double Tyx = transform.getMyx();
        double Tyy = transform.getMyy();
        double Tyz = transform.getMyz();
        double Tyt = transform.getMyt();
        double Tzx = transform.getMzx();
        double Tzy = transform.getMzy();
        double Tzz = transform.getMzz();
        double Tzt = transform.getMzt();
        double rxx = this.mxx * Txx + this.mxy * Tyx + this.mxz * Tzx;
        double rxy = this.mxx * Txy + this.mxy * Tyy + this.mxz * Tzy;
        double rxz = this.mxx * Txz + this.mxy * Tyz + this.mxz * Tzz;
        double rxt = this.mxx * Txt + this.mxy * Tyt + this.mxz * Tzt + this.mxt;
        double ryx = this.myx * Txx + this.myy * Tyx + this.myz * Tzx;
        double ryy = this.myx * Txy + this.myy * Tyy + this.myz * Tzy;
        double ryz = this.myx * Txz + this.myy * Tyz + this.myz * Tzz;
        double ryt = this.myx * Txt + this.myy * Tyt + this.myz * Tzt + this.myt;
        double rzx = this.mzx * Txx + this.mzy * Tyx + this.mzz * Tzx;
        double rzy = this.mzx * Txy + this.mzy * Tyy + this.mzz * Tzy;
        double rzz = this.mzx * Txz + this.mzy * Tyz + this.mzz * Tzz;
        double rzt = this.mzx * Txt + this.mzy * Tyt + this.mzz * Tzt + this.mzt;
        this.mxx = rxx;
        this.mxy = rxy;
        this.mxz = rxz;
        this.mxt = rxt;
        this.myx = ryx;
        this.myy = ryy;
        this.myz = ryz;
        this.myt = ryt;
        this.mzx = rzx;
        this.mzy = rzy;
        this.mzz = rzz;
        this.mzt = rzt;
        this.updateState();
    }

    public void concatenate(double Txx, double Txy, double Txz, double Txt, double Tyx, double Tyy, double Tyz, double Tyt, double Tzx, double Tzy, double Tzz, double Tzt) {
        double rxx = this.mxx * Txx + this.mxy * Tyx + this.mxz * Tzx;
        double rxy = this.mxx * Txy + this.mxy * Tyy + this.mxz * Tzy;
        double rxz = this.mxx * Txz + this.mxy * Tyz + this.mxz * Tzz;
        double rxt = this.mxx * Txt + this.mxy * Tyt + this.mxz * Tzt + this.mxt;
        double ryx = this.myx * Txx + this.myy * Tyx + this.myz * Tzx;
        double ryy = this.myx * Txy + this.myy * Tyy + this.myz * Tzy;
        double ryz = this.myx * Txz + this.myy * Tyz + this.myz * Tzz;
        double ryt = this.myx * Txt + this.myy * Tyt + this.myz * Tzt + this.myt;
        double rzx = this.mzx * Txx + this.mzy * Tyx + this.mzz * Tzx;
        double rzy = this.mzx * Txy + this.mzy * Tyy + this.mzz * Tzy;
        double rzz = this.mzx * Txz + this.mzy * Tyz + this.mzz * Tzz;
        double rzt = this.mzx * Txt + this.mzy * Tyt + this.mzz * Tzt + this.mzt;
        this.mxx = rxx;
        this.mxy = rxy;
        this.mxz = rxz;
        this.mxt = rxt;
        this.myx = ryx;
        this.myy = ryy;
        this.myz = ryz;
        this.myt = ryt;
        this.mzx = rzx;
        this.mzy = rzy;
        this.mzz = rzz;
        this.mzt = rzt;
        this.updateState();
    }

    @Override
    public Affine3D deriveWithConcatenation(double Txx, double Tyx, double Txy, double Tyy, double Txt, double Tyt) {
        double rxx = this.mxx * Txx + this.mxy * Tyx;
        double rxy = this.mxx * Txy + this.mxy * Tyy;
        double rxt = this.mxx * Txt + this.mxy * Tyt + this.mxt;
        double ryx = this.myx * Txx + this.myy * Tyx;
        double ryy = this.myx * Txy + this.myy * Tyy;
        double ryt = this.myx * Txt + this.myy * Tyt + this.myt;
        double rzx = this.mzx * Txx + this.mzy * Tyx;
        double rzy = this.mzx * Txy + this.mzy * Tyy;
        double rzt = this.mzx * Txt + this.mzy * Tyt + this.mzt;
        this.mxx = rxx;
        this.mxy = rxy;
        this.mxt = rxt;
        this.myx = ryx;
        this.myy = ryy;
        this.myt = ryt;
        this.mzx = rzx;
        this.mzy = rzy;
        this.mzt = rzt;
        this.updateState();
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        this.concatenate(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        return this;
    }

    public void preConcatenate(BaseTransform transform) {
        switch (transform.getDegree()) {
            case IDENTITY: {
                return;
            }
            case TRANSLATE_2D: {
                this.preTranslate(transform.getMxt(), transform.getMyt(), 0.0);
                return;
            }
            case TRANSLATE_3D: {
                this.preTranslate(transform.getMxt(), transform.getMyt(), transform.getMzt());
                return;
            }
        }
        double Txx = transform.getMxx();
        double Txy = transform.getMxy();
        double Txz = transform.getMxz();
        double Txt = transform.getMxt();
        double Tyx = transform.getMyx();
        double Tyy = transform.getMyy();
        double Tyz = transform.getMyz();
        double Tyt = transform.getMyt();
        double Tzx = transform.getMzx();
        double Tzy = transform.getMzy();
        double Tzz = transform.getMzz();
        double Tzt = transform.getMzt();
        double rxx = Txx * this.mxx + Txy * this.myx + Txz * this.mzx;
        double rxy = Txx * this.mxy + Txy * this.myy + Txz * this.mzy;
        double rxz = Txx * this.mxz + Txy * this.myz + Txz * this.mzz;
        double rxt = Txx * this.mxt + Txy * this.myt + Txz * this.mzt + Txt;
        double ryx = Tyx * this.mxx + Tyy * this.myx + Tyz * this.mzx;
        double ryy = Tyx * this.mxy + Tyy * this.myy + Tyz * this.mzy;
        double ryz = Tyx * this.mxz + Tyy * this.myz + Tyz * this.mzz;
        double ryt = Tyx * this.mxt + Tyy * this.myt + Tyz * this.mzt + Tyt;
        double rzx = Tzx * this.mxx + Tzy * this.myx + Tzz * this.mzx;
        double rzy = Tzx * this.mxy + Tzy * this.myy + Tzz * this.mzy;
        double rzz = Tzx * this.mxz + Tzy * this.myz + Tzz * this.mzz;
        double rzt = Tzx * this.mxt + Tzy * this.myt + Tzz * this.mzt + Tzt;
        this.mxx = rxx;
        this.mxy = rxy;
        this.mxz = rxz;
        this.mxt = rxt;
        this.myx = ryx;
        this.myy = ryy;
        this.myz = ryz;
        this.myt = ryt;
        this.mzx = rzx;
        this.mzy = rzy;
        this.mzz = rzz;
        this.mzt = rzt;
        this.updateState();
    }

    @Override
    public void restoreTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        throw new InternalError("must use Affine3D restore method to prevent loss of information");
    }

    @Override
    public void restoreTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        this.mxx = mxx;
        this.mxy = mxy;
        this.mxz = mxz;
        this.mxt = mxt;
        this.myx = myx;
        this.myy = myy;
        this.myz = myz;
        this.myt = myt;
        this.mzx = mzx;
        this.mzy = mzy;
        this.mzz = mzz;
        this.mzt = mzt;
        this.updateState();
    }

    public Affine3D lookAt(Vec3d eye, Vec3d center, Vec3d up) {
        double forwardx = eye.x - center.x;
        double forwardy = eye.y - center.y;
        double forwardz = eye.z - center.z;
        double invMag = 1.0 / Math.sqrt(forwardx * forwardx + forwardy * forwardy + forwardz * forwardz);
        forwardx *= invMag;
        forwardy *= invMag;
        forwardz *= invMag;
        invMag = 1.0 / Math.sqrt(up.x * up.x + up.y * up.y + up.z * up.z);
        double upx = up.x * invMag;
        double upy = up.y * invMag;
        double upz = up.z * invMag;
        double sidex = upy * forwardz - forwardy * upz;
        double sidey = upz * forwardx - upx * forwardz;
        double sidez = upx * forwardy - upy * forwardx;
        invMag = 1.0 / Math.sqrt(sidex * sidex + sidey * sidey + sidez * sidez);
        upx = forwardy * (sidez *= invMag) - (sidey *= invMag) * forwardz;
        upy = forwardz * (sidex *= invMag) - forwardx * sidez;
        upz = forwardx * sidey - forwardy * sidex;
        this.mxx = sidex;
        this.mxy = sidey;
        this.mxz = sidez;
        this.myx = upx;
        this.myy = upy;
        this.myz = upz;
        this.mzx = forwardx;
        this.mzy = forwardy;
        this.mzz = forwardz;
        this.mxt = -eye.x * this.mxx + -eye.y * this.mxy + -eye.z * this.mxz;
        this.myt = -eye.x * this.myx + -eye.y * this.myy + -eye.z * this.myz;
        this.mzt = -eye.x * this.mzx + -eye.y * this.mzy + -eye.z * this.mzz;
        this.updateState();
        return this;
    }

    static boolean almostOne(double a) {
        return a < 1.00001 && a > 0.99999;
    }

    private static double _matround(double matval) {
        return Math.rint(matval * 1.0E15) / 1.0E15;
    }

    @Override
    public String toString() {
        return "Affine3D[[" + Affine3D._matround(this.mxx) + ", " + Affine3D._matround(this.mxy) + ", " + Affine3D._matround(this.mxz) + ", " + Affine3D._matround(this.mxt) + "], [" + Affine3D._matround(this.myx) + ", " + Affine3D._matround(this.myy) + ", " + Affine3D._matround(this.myz) + ", " + Affine3D._matround(this.myt) + "], [" + Affine3D._matround(this.mzx) + ", " + Affine3D._matround(this.mzy) + ", " + Affine3D._matround(this.mzz) + ", " + Affine3D._matround(this.mzt) + "]]";
    }
}

