/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Window;
import javafx.util.Duration;

public class ProgressIndicatorSkin
extends BehaviorSkinBase<ProgressIndicator, BehaviorBase<ProgressIndicator>> {
    private ObjectProperty<Paint> progressColor = new StyleableObjectProperty<Paint>(null){

        @Override
        protected void invalidated() {
            Paint value = (Paint)this.get();
            if (value != null && !(value instanceof Color)) {
                if (this.isBound()) {
                    this.unbind();
                }
                this.set(null);
                throw new IllegalArgumentException("Only Color objects are supported");
            }
            if (ProgressIndicatorSkin.this.spinner != null) {
                ProgressIndicatorSkin.this.spinner.setFillOverride(value);
            }
            if (ProgressIndicatorSkin.this.determinateIndicator != null) {
                ProgressIndicatorSkin.this.determinateIndicator.setFillOverride(value);
            }
        }

        @Override
        public Object getBean() {
            return ProgressIndicatorSkin.this;
        }

        @Override
        public String getName() {
            return "progressColorProperty";
        }

        @Override
        public CssMetaData<ProgressIndicator, Paint> getCssMetaData() {
            return PROGRESS_COLOR;
        }
    };
    private IntegerProperty indeterminateSegmentCount = new StyleableIntegerProperty(8){

        @Override
        protected void invalidated() {
            if (ProgressIndicatorSkin.this.spinner != null) {
                ProgressIndicatorSkin.this.spinner.rebuild();
            }
        }

        @Override
        public Object getBean() {
            return ProgressIndicatorSkin.this;
        }

        @Override
        public String getName() {
            return "indeterminateSegmentCount";
        }

        @Override
        public CssMetaData<ProgressIndicator, Number> getCssMetaData() {
            return INDETERMINATE_SEGMENT_COUNT;
        }
    };
    private final BooleanProperty spinEnabled = new StyleableBooleanProperty(false){

        @Override
        protected void invalidated() {
            if (ProgressIndicatorSkin.this.spinner != null) {
                ProgressIndicatorSkin.this.spinner.setSpinEnabled(this.get());
            }
        }

        @Override
        public CssMetaData<ProgressIndicator, Boolean> getCssMetaData() {
            return SPIN_ENABLED;
        }

        @Override
        public Object getBean() {
            return ProgressIndicatorSkin.this;
        }

        @Override
        public String getName() {
            return "spinEnabled";
        }
    };
    private static final String DONE = ControlResources.getString("ProgressIndicator.doneString");
    private static final Text doneText = new Text(DONE);
    private IndeterminateSpinner spinner;
    private DeterminateIndicator determinateIndicator;
    private ProgressIndicator control;
    protected Animation indeterminateTransition;
    private ReadOnlyObjectProperty<Window> windowProperty = null;
    private ReadOnlyBooleanProperty windowShowingProperty = null;
    protected final Duration CLIPPED_DELAY = new Duration(300.0);
    protected final Duration UNCLIPPED_DELAY = new Duration(0.0);
    private static final CssMetaData<ProgressIndicator, Paint> PROGRESS_COLOR;
    private static final CssMetaData<ProgressIndicator, Number> INDETERMINATE_SEGMENT_COUNT;
    private static final CssMetaData<ProgressIndicator, Boolean> SPIN_ENABLED;
    public static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    Paint getProgressColor() {
        return (Paint)this.progressColor.get();
    }

    public ProgressIndicatorSkin(ProgressIndicator control) {
        super(control, new BehaviorBase<ProgressIndicator>(control, Collections.emptyList()));
        this.control = control;
        this.registerChangeListener(control.indeterminateProperty(), "INDETERMINATE");
        this.registerChangeListener(control.progressProperty(), "PROGRESS");
        this.registerChangeListener(control.visibleProperty(), "VISIBLE");
        this.registerChangeListener(control.parentProperty(), "PARENT");
        this.registerChangeListener(control.sceneProperty(), "SCENE");
        this.updateWindowListeners();
        this.initialize();
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("INDETERMINATE".equals(p)) {
            this.initialize();
        } else if ("PROGRESS".equals(p)) {
            this.updateProgress();
        } else if ("VISIBLE".equals(p)) {
            this.updateAnimation();
        } else if ("PARENT".equals(p)) {
            this.updateAnimation();
        } else if ("SCENE".equals(p)) {
            this.updateWindowListeners();
            this.updateAnimation();
        } else if ("WINDOW".equals(p)) {
            this.updateWindowListeners();
            this.updateAnimation();
        } else if ("WINDOWSHOWING".equals(p)) {
            this.updateAnimation();
        }
    }

    protected void initialize() {
        boolean isIndeterminate = this.control.isIndeterminate();
        if (isIndeterminate) {
            this.determinateIndicator = null;
            this.spinner = new IndeterminateSpinner(this.spinEnabled.get(), (Paint)this.progressColor.get());
            this.getChildren().setAll((Node[])new Node[]{this.spinner});
            if (this.control.impl_isTreeVisible() && this.indeterminateTransition != null) {
                this.indeterminateTransition.play();
            }
        } else {
            if (this.spinner != null) {
                if (this.indeterminateTransition != null) {
                    this.indeterminateTransition.stop();
                }
                this.spinner = null;
            }
            this.determinateIndicator = new DeterminateIndicator(this.control, this, (Paint)this.progressColor.get());
            this.getChildren().setAll((Node[])new Node[]{this.determinateIndicator});
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
            this.indeterminateTransition = null;
        }
        if (this.spinner != null) {
            this.spinner = null;
        }
        this.control = null;
    }

    protected void updateProgress() {
        if (this.determinateIndicator != null) {
            this.determinateIndicator.updateProgress(this.control.getProgress());
        }
    }

    protected void createIndeterminateTimeline() {
        if (this.spinner != null) {
            this.spinner.rebuildTimeline();
        }
    }

    protected void pauseTimeline(boolean pause) {
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            if (this.indeterminateTransition == null) {
                this.createIndeterminateTimeline();
            }
            if (pause) {
                this.indeterminateTransition.pause();
            } else {
                this.indeterminateTransition.play();
            }
        }
    }

    protected void updateAnimation() {
        boolean isTreeVisible;
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean bl = isTreeVisible = control.isVisible() && control.getParent() != null && control.getScene() != null && control.getScene().getWindow() != null && control.getScene().getWindow().isShowing();
        if (this.indeterminateTransition != null) {
            this.pauseTimeline(!isTreeVisible);
        } else if (isTreeVisible) {
            this.createIndeterminateTimeline();
        }
    }

    private void updateWindowListeners() {
        if (this.windowProperty != null) {
            this.unregisterChangeListener(this.windowProperty);
            this.windowProperty = null;
            this.unregisterChangeListener(this.windowShowingProperty);
            this.windowShowingProperty = null;
        }
        if (this.control.getScene() != null && this.control.getScene().getWindow() != null) {
            this.windowProperty = this.control.getScene().windowProperty();
            this.windowShowingProperty = this.control.getScene().getWindow().showingProperty();
            this.registerChangeListener(this.windowProperty, "WINDOW");
            this.registerChangeListener(this.windowShowingProperty, "WINDOWSHOWING");
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.spinner != null && this.control.isIndeterminate()) {
            this.spinner.layoutChildren();
            this.spinner.resizeRelocate(0.0, 0.0, w, h);
        } else if (this.determinateIndicator != null) {
            this.determinateIndicator.layoutChildren();
            this.determinateIndicator.resizeRelocate(0.0, 0.0, w, h);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressIndicatorSkin.getClassCssMetaData();
    }

    static {
        doneText.getStyleClass().add("text");
        PROGRESS_COLOR = new CssMetaData<ProgressIndicator, Paint>("-fx-progress-color", PaintConverter.getInstance(), null){

            @Override
            public boolean isSettable(ProgressIndicator n) {
                ProgressIndicatorSkin skin = (ProgressIndicatorSkin)n.getSkin();
                return skin.progressColor == null || !skin.progressColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(ProgressIndicator n) {
                ProgressIndicatorSkin skin = (ProgressIndicatorSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.progressColor);
            }
        };
        INDETERMINATE_SEGMENT_COUNT = new CssMetaData<ProgressIndicator, Number>("-fx-indeterminate-segment-count", SizeConverter.getInstance(), (Number)8){

            @Override
            public boolean isSettable(ProgressIndicator n) {
                ProgressIndicatorSkin skin = (ProgressIndicatorSkin)n.getSkin();
                return skin.indeterminateSegmentCount == null || !skin.indeterminateSegmentCount.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ProgressIndicator n) {
                ProgressIndicatorSkin skin = (ProgressIndicatorSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indeterminateSegmentCount);
            }
        };
        SPIN_ENABLED = new CssMetaData<ProgressIndicator, Boolean>("-fx-spin-enabled", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(ProgressIndicator node) {
                ProgressIndicatorSkin skin = (ProgressIndicatorSkin)node.getSkin();
                return skin.spinEnabled == null || !skin.spinEnabled.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ProgressIndicator node) {
                ProgressIndicatorSkin skin = (ProgressIndicatorSkin)node.getSkin();
                return (StyleableProperty)((Object)skin.spinEnabled);
            }
        };
        ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
        styleables.add(PROGRESS_COLOR);
        styleables.add(INDETERMINATE_SEGMENT_COUNT);
        styleables.add(SPIN_ENABLED);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private final class IndeterminateSpinner
    extends Region {
        private IndicatorPaths pathsG;
        private final List<Double> opacities = new ArrayList<Double>();
        private boolean spinEnabled = false;
        private Paint fillOverride = null;

        private IndeterminateSpinner(boolean spinEnabled, Paint fillOverride) {
            this.spinEnabled = spinEnabled;
            this.fillOverride = fillOverride;
            this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
            this.getStyleClass().setAll((String[])new String[]{"spinner"});
            this.pathsG = new IndicatorPaths();
            this.getChildren().add(this.pathsG);
            this.rebuild();
            this.rebuildTimeline();
        }

        public void setFillOverride(Paint fillOverride) {
            this.fillOverride = fillOverride;
            this.rebuild();
        }

        public void setSpinEnabled(boolean spinEnabled) {
            this.spinEnabled = spinEnabled;
            this.rebuildTimeline();
        }

        private void rebuildTimeline() {
            if (this.spinEnabled) {
                if (ProgressIndicatorSkin.this.indeterminateTransition == null) {
                    ProgressIndicatorSkin.this.indeterminateTransition = new Timeline();
                    ProgressIndicatorSkin.this.indeterminateTransition.setCycleCount(-1);
                    ProgressIndicatorSkin.this.indeterminateTransition.setDelay(ProgressIndicatorSkin.this.UNCLIPPED_DELAY);
                } else {
                    ProgressIndicatorSkin.this.indeterminateTransition.stop();
                    ((Timeline)ProgressIndicatorSkin.this.indeterminateTransition).getKeyFrames().clear();
                }
                ObservableList<KeyFrame> keyFrames = FXCollections.observableArrayList();
                keyFrames.add(new KeyFrame(Duration.millis(1.0), new KeyValue(this.pathsG.rotateProperty(), 360)));
                keyFrames.add(new KeyFrame(Duration.millis(3900.0), new KeyValue(this.pathsG.rotateProperty(), 0)));
                for (int i = 100; i <= 3900; i += 100) {
                    keyFrames.add(new KeyFrame(Duration.millis(i), event -> this.shiftColors(), new KeyValue[0]));
                }
                ((Timeline)ProgressIndicatorSkin.this.indeterminateTransition).getKeyFrames().setAll((Collection<KeyFrame>)keyFrames);
                ProgressIndicatorSkin.this.indeterminateTransition.playFromStart();
            } else if (ProgressIndicatorSkin.this.indeterminateTransition != null) {
                ProgressIndicatorSkin.this.indeterminateTransition.stop();
                ((Timeline)ProgressIndicatorSkin.this.indeterminateTransition).getKeyFrames().clear();
                ProgressIndicatorSkin.this.indeterminateTransition = null;
            }
        }

        @Override
        protected void layoutChildren() {
            double scaleX;
            double w = ProgressIndicatorSkin.this.control.getWidth() - ProgressIndicatorSkin.this.control.snappedLeftInset() - ProgressIndicatorSkin.this.control.snappedRightInset();
            double h = ProgressIndicatorSkin.this.control.getHeight() - ProgressIndicatorSkin.this.control.snappedTopInset() - ProgressIndicatorSkin.this.control.snappedBottomInset();
            double prefW = this.pathsG.prefWidth(-1.0);
            double prefH = this.pathsG.prefHeight(-1.0);
            double scale = scaleX = w / prefW;
            if (scaleX * prefH > h) {
                scale = h / prefH;
            }
            double indicatorW = prefW * scale;
            double indicatorH = prefH * scale;
            this.pathsG.resizeRelocate((w - indicatorW) / 2.0, (h - indicatorH) / 2.0, indicatorW, indicatorH);
        }

        private void rebuild() {
            int segments = ProgressIndicatorSkin.this.indeterminateSegmentCount.get();
            this.opacities.clear();
            this.pathsG.getChildren().clear();
            double step = 0.8 / (double)(segments - 1);
            for (int i = 0; i < segments; ++i) {
                Region region = new Region();
                region.setScaleShape(false);
                region.setCenterShape(false);
                region.getStyleClass().addAll((String[])new String[]{"segment", "segment" + i});
                if (this.fillOverride instanceof Color) {
                    Color c = (Color)this.fillOverride;
                    region.setStyle("-fx-background-color: rgba(" + (int)(255.0 * c.getRed()) + "," + (int)(255.0 * c.getGreen()) + "," + (int)(255.0 * c.getBlue()) + "," + c.getOpacity() + ");");
                } else {
                    region.setStyle(null);
                }
                this.pathsG.getChildren().add(region);
                this.opacities.add(Math.max(0.1, 1.0 - step * (double)i));
            }
        }

        private void shiftColors() {
            if (this.opacities.size() <= 0) {
                return;
            }
            int segments = ProgressIndicatorSkin.this.indeterminateSegmentCount.get();
            Collections.rotate(this.opacities, -1);
            for (int i = 0; i < segments; ++i) {
                ((Node)this.pathsG.getChildren().get(i)).setOpacity(this.opacities.get(i));
            }
        }

        private class IndicatorPaths
        extends Pane {
            private IndicatorPaths() {
            }

            @Override
            protected double computePrefWidth(double height) {
                double w = 0.0;
                for (Node child : this.getChildren()) {
                    if (!(child instanceof Region)) continue;
                    Region region = (Region)child;
                    if (region.getShape() != null) {
                        w = Math.max(w, region.getShape().getLayoutBounds().getMaxX());
                        continue;
                    }
                    w = Math.max(w, region.prefWidth(height));
                }
                return w;
            }

            @Override
            protected double computePrefHeight(double width) {
                double h = 0.0;
                for (Node child : this.getChildren()) {
                    if (!(child instanceof Region)) continue;
                    Region region = (Region)child;
                    if (region.getShape() != null) {
                        h = Math.max(h, region.getShape().getLayoutBounds().getMaxY());
                        continue;
                    }
                    h = Math.max(h, region.prefHeight(width));
                }
                return h;
            }

            @Override
            protected void layoutChildren() {
                double scale = this.getWidth() / this.computePrefWidth(-1.0);
                for (Node child : this.getChildren()) {
                    if (!(child instanceof Region)) continue;
                    Region region = (Region)child;
                    if (region.getShape() != null) {
                        region.resize(region.getShape().getLayoutBounds().getMaxX(), region.getShape().getLayoutBounds().getMaxY());
                        region.getTransforms().setAll((Transform[])new Transform[]{new Scale(scale, scale, 0.0, 0.0)});
                        continue;
                    }
                    region.autosize();
                }
            }
        }
    }

    private class DeterminateIndicator
    extends Region {
        private double textGap = 2.0;
        private int intProgress;
        private int degProgress;
        private Text text;
        private StackPane indicator;
        private StackPane progress;
        private StackPane tick;
        private Arc arcShape;
        private Circle indicatorCircle;

        public DeterminateIndicator(ProgressIndicator control, ProgressIndicatorSkin s, Paint fillOverride) {
            this.getStyleClass().add("determinate-indicator");
            this.intProgress = (int)Math.round(control.getProgress() * 100.0);
            this.degProgress = (int)(360.0 * control.getProgress());
            this.getChildren().clear();
            this.text = new Text(control.getProgress() >= 1.0 ? DONE : "" + this.intProgress + "%");
            this.text.setTextOrigin(VPos.TOP);
            this.text.getStyleClass().setAll((String[])new String[]{"text", "percentage"});
            this.indicator = new StackPane();
            this.indicator.setScaleShape(false);
            this.indicator.setCenterShape(false);
            this.indicator.getStyleClass().setAll((String[])new String[]{"indicator"});
            this.indicatorCircle = new Circle();
            this.indicator.setShape(this.indicatorCircle);
            this.arcShape = new Arc();
            this.arcShape.setType(ArcType.ROUND);
            this.arcShape.setStartAngle(90.0);
            this.progress = new StackPane();
            this.progress.getStyleClass().setAll((String[])new String[]{"progress"});
            this.progress.setScaleShape(false);
            this.progress.setCenterShape(false);
            this.progress.setShape(this.arcShape);
            this.progress.getChildren().clear();
            this.setFillOverride(fillOverride);
            this.tick = new StackPane();
            this.tick.getStyleClass().setAll((String[])new String[]{"tick"});
            this.getChildren().setAll((Node[])new Node[]{this.indicator, this.progress, this.text, this.tick});
            this.updateProgress(control.getProgress());
        }

        private void setFillOverride(Paint fillOverride) {
            if (fillOverride instanceof Color) {
                Color c = (Color)fillOverride;
                this.progress.setStyle("-fx-background-color: rgba(" + (int)(255.0 * c.getRed()) + "," + (int)(255.0 * c.getGreen()) + "," + (int)(255.0 * c.getBlue()) + "," + c.getOpacity() + ");");
            } else {
                this.progress.setStyle(null);
            }
        }

        @Override
        public boolean usesMirroring() {
            return false;
        }

        private void updateProgress(double progress) {
            this.intProgress = (int)Math.round(progress * 100.0);
            this.text.setText(progress >= 1.0 ? DONE : "" + this.intProgress + "%");
            this.degProgress = (int)(360.0 * progress);
            this.arcShape.setLength(-this.degProgress);
            this.requestLayout();
        }

        @Override
        protected void layoutChildren() {
            double doneTextHeight = doneText.getLayoutBounds().getHeight();
            double left = ProgressIndicatorSkin.this.control.snappedLeftInset();
            double right = ProgressIndicatorSkin.this.control.snappedRightInset();
            double top = ProgressIndicatorSkin.this.control.snappedTopInset();
            double bottom = ProgressIndicatorSkin.this.control.snappedBottomInset();
            double areaW = ProgressIndicatorSkin.this.control.getWidth() - left - right;
            double areaH = ProgressIndicatorSkin.this.control.getHeight() - top - bottom - this.textGap - doneTextHeight;
            double radiusW = areaW / 2.0;
            double radiusH = areaH / 2.0;
            double radius = Math.floor(Math.min(radiusW, radiusH));
            double centerX = this.snapPosition(left + radiusW);
            double centerY = this.snapPosition(top + radius);
            double iLeft = this.indicator.snappedLeftInset();
            double iRight = this.indicator.snappedRightInset();
            double iTop = this.indicator.snappedTopInset();
            double iBottom = this.indicator.snappedBottomInset();
            double progressRadius = this.snapSize(Math.min(Math.min(radius - iLeft, radius - iRight), Math.min(radius - iTop, radius - iBottom)));
            this.indicatorCircle.setRadius(radius);
            this.indicator.setLayoutX(centerX);
            this.indicator.setLayoutY(centerY);
            this.arcShape.setRadiusX(progressRadius);
            this.arcShape.setRadiusY(progressRadius);
            this.progress.setLayoutX(centerX);
            this.progress.setLayoutY(centerY);
            double pLeft = this.progress.snappedLeftInset();
            double pRight = this.progress.snappedRightInset();
            double pTop = this.progress.snappedTopInset();
            double pBottom = this.progress.snappedBottomInset();
            double indicatorRadius = this.snapSize(Math.min(Math.min(progressRadius - pLeft, progressRadius - pRight), Math.min(progressRadius - pTop, progressRadius - pBottom)));
            double squareBoxHalfWidth = Math.ceil(Math.sqrt(indicatorRadius * indicatorRadius / 2.0));
            double squareBoxHalfWidth2 = indicatorRadius * (Math.sqrt(2.0) / 2.0);
            this.tick.setLayoutX(centerX - squareBoxHalfWidth);
            this.tick.setLayoutY(centerY - squareBoxHalfWidth);
            this.tick.resize(squareBoxHalfWidth + squareBoxHalfWidth, squareBoxHalfWidth + squareBoxHalfWidth);
            this.tick.setVisible(ProgressIndicatorSkin.this.control.getProgress() >= 1.0);
            double textWidth = this.text.getLayoutBounds().getWidth();
            double textHeight = this.text.getLayoutBounds().getHeight();
            if (ProgressIndicatorSkin.this.control.getWidth() >= textWidth && ProgressIndicatorSkin.this.control.getHeight() >= textHeight) {
                if (!this.text.isVisible()) {
                    this.text.setVisible(true);
                }
                this.text.setLayoutY(this.snapPosition(centerY + radius + this.textGap));
                this.text.setLayoutX(this.snapPosition(centerX - textWidth / 2.0));
            } else if (this.text.isVisible()) {
                this.text.setVisible(false);
            }
        }

        @Override
        protected double computePrefWidth(double height) {
            double left = ProgressIndicatorSkin.this.control.snappedLeftInset();
            double right = ProgressIndicatorSkin.this.control.snappedRightInset();
            double iLeft = this.indicator.snappedLeftInset();
            double iRight = this.indicator.snappedRightInset();
            double iTop = this.indicator.snappedTopInset();
            double iBottom = this.indicator.snappedBottomInset();
            double indicatorMax = this.snapSize(Math.max(Math.max(iLeft, iRight), Math.max(iTop, iBottom)));
            double pLeft = this.progress.snappedLeftInset();
            double pRight = this.progress.snappedRightInset();
            double pTop = this.progress.snappedTopInset();
            double pBottom = this.progress.snappedBottomInset();
            double progressMax = this.snapSize(Math.max(Math.max(pLeft, pRight), Math.max(pTop, pBottom)));
            double tLeft = this.tick.snappedLeftInset();
            double tRight = this.tick.snappedRightInset();
            double indicatorWidth = indicatorMax + progressMax + tLeft + tRight + progressMax + indicatorMax;
            return left + Math.max(indicatorWidth, doneText.getLayoutBounds().getWidth()) + right;
        }

        @Override
        protected double computePrefHeight(double width) {
            double top = ProgressIndicatorSkin.this.control.snappedTopInset();
            double bottom = ProgressIndicatorSkin.this.control.snappedBottomInset();
            double iLeft = this.indicator.snappedLeftInset();
            double iRight = this.indicator.snappedRightInset();
            double iTop = this.indicator.snappedTopInset();
            double iBottom = this.indicator.snappedBottomInset();
            double indicatorMax = this.snapSize(Math.max(Math.max(iLeft, iRight), Math.max(iTop, iBottom)));
            double pLeft = this.progress.snappedLeftInset();
            double pRight = this.progress.snappedRightInset();
            double pTop = this.progress.snappedTopInset();
            double pBottom = this.progress.snappedBottomInset();
            double progressMax = this.snapSize(Math.max(Math.max(pLeft, pRight), Math.max(pTop, pBottom)));
            double tTop = this.tick.snappedTopInset();
            double tBottom = this.tick.snappedBottomInset();
            double indicatorHeight = indicatorMax + progressMax + tTop + tBottom + progressMax + indicatorMax;
            return top + indicatorHeight + this.textGap + doneText.getLayoutBounds().getHeight() + bottom;
        }

        @Override
        protected double computeMaxWidth(double height) {
            return this.computePrefWidth(height);
        }

        @Override
        protected double computeMaxHeight(double width) {
            return this.computePrefHeight(width);
        }
    }
}

